/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c.spi.properties;

import com.ibm.adapter.c.common.ICConstants;
import com.ibm.adapter.c.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CPropertyConverter {
    public static final String copyright = "Licensed Material - Property of IBM\n com.ibm.adapter.c\n(C) Copyright IBM Corp. 2004 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<String, Map<String, String>> totalPropertyMap = new HashMap<String, Map<String, String>>();

    public static String getCValue(String cKey, String uiValue) {
        String mappedValue = null;
        if (cKey != null && uiValue != null) {
            Map<String, String> propertyMap;
            if (totalPropertyMap.isEmpty()) {
                CPropertyConverter.initializeMap();
            }
            if ((propertyMap = totalPropertyMap.get(cKey)) != null && !propertyMap.isEmpty()) {
                mappedValue = propertyMap.get(uiValue);
            }
            if (mappedValue == null) {
                mappedValue = uiValue;
            }
        }
        return mappedValue;
    }

    public static String getUIValue(String cKey, String cValue) {
        String mappedValue = null;
        if (cKey != null && cKey.length() > 0 && cValue != null && cValue.length() > 0) {
            Map<String, String> propertyMap;
            if (totalPropertyMap.isEmpty()) {
                CPropertyConverter.initializeMap();
            }
            if ((propertyMap = totalPropertyMap.get(cKey)) != null && !propertyMap.isEmpty()) {
                Set<String> set = propertyMap.keySet();
                for (String currentUIValue : set) {
                    String currentCValue = propertyMap.get(currentUIValue);
                    if (!cValue.equals(currentCValue)) continue;
                    mappedValue = currentUIValue;
                    break;
                }
            }
            if (mappedValue == null) {
                mappedValue = cValue;
            }
        }
        return mappedValue;
    }

    private static void initializeMap() {
        HashMap<String, String> platformCompilerPropertyMap = new HashMap<String, String>();
        platformCompilerPropertyMap.put(Messages.getString("PLATFORM_NONE_VALUE"), "(Unspecified)");
        platformCompilerPropertyMap.put(Messages.getString("PLATFORM_AIX_GCC_VALUE"), "AIXgcc");
        platformCompilerPropertyMap.put(Messages.getString("PLATFORM_AIX_XLC_VALUE"), "AIXxlc");
        platformCompilerPropertyMap.put(Messages.getString("PLATFORM_OS390_VALUE"), "OS390");
        platformCompilerPropertyMap.put(Messages.getString("PLATFORM_WIN_ICC_VALUE"), "icc");
        platformCompilerPropertyMap.put(Messages.getString("PLATFORM_WIN_MSVC_VALUE"), "Msvc");
        totalPropertyMap.put("com.ibm.etools.c.C_COMPILER_NAME", platformCompilerPropertyMap);
        HashMap<String, String> floatingPointFormatPropertyMap = new HashMap<String, String>();
        floatingPointFormatPropertyMap.put(Messages.getString("FLOATING_POINT_FORMAT_IBM_390_HEX_VALUE"), "IBM 390 Hexadecimal");
        floatingPointFormatPropertyMap.put(Messages.getString("FLOATING_POINT_FORMAT_IEEE_EXTENDED_AIX_VALUE"), "IEEE Extended AIX");
        floatingPointFormatPropertyMap.put(Messages.getString("FLOATING_POINT_FORMAT_IEEE_EXTENDED_INTEL_VALUE"), "IEEE Extended INTEL");
        floatingPointFormatPropertyMap.put(Messages.getString("FLOATING_POINT_FORMAT_IEEE_EXTENDED_OS390_VALUE"), "IEEE Extended OS/390");
        floatingPointFormatPropertyMap.put(Messages.getString("FLOATING_POINT_FORMAT_IEEE_NON_EXTENDED_VALUE"), "IEEE Non-Extended");
        totalPropertyMap.put("com.ibm.etools.c.C_FLOATING_POINT_FORMAT", floatingPointFormatPropertyMap);
        HashMap<String, String> treatUnsignedShortArraysAsStringsPropertyMap = new HashMap<String, String>();
        treatUnsignedShortArraysAsStringsPropertyMap.put(Messages.getString("US_SHORT_ARRAYS_DBCS_TRUE_VALUE"), "TRUE");
        treatUnsignedShortArraysAsStringsPropertyMap.put(Messages.getString("US_SHORT_ARRAYS_DBCS_FALSE_VALUE"), "FALSE");
        totalPropertyMap.put("com.ibm.etools.c.C_US_SHORT_ARRAYS_DBCS", treatUnsignedShortArraysAsStringsPropertyMap);
        HashMap<String, String> stringEncodingPropertyMap = new HashMap<String, String>();
        stringEncodingPropertyMap.put(Messages.getString("STRING_ENCODING_NULL_VALUE"), "NULL");
        stringEncodingPropertyMap.put(Messages.getString("STRING_ENCODING_SPACE_VALUE"), "SPACE");
        totalPropertyMap.put("com.ibm.etools.c.C_STRING_ENCODING", stringEncodingPropertyMap);
        HashMap<String, String> byteOrderPropertyMap = new HashMap<String, String>();
        byteOrderPropertyMap.put(Messages.getString("ENDIAN_LITTLE_VALUE"), "Little Endian");
        byteOrderPropertyMap.put(Messages.getString("ENDIAN_BIG_VALUE"), "Big Endian");
        totalPropertyMap.put("com.ibm.etools.c.C_BYTE_ORDER", byteOrderPropertyMap);
        HashMap<String, String> addressSizePropertyMap = new HashMap<String, String>();
        addressSizePropertyMap.put(Messages.getString("ADDRESS_SIZE_MODE_32_VALUE"), "32");
        addressSizePropertyMap.put(Messages.getString("ADDRESS_SIZE_MODE_64_VALUE"), "64");
        totalPropertyMap.put("com.ibm.etools.c.C_ADDRESS_SIZE", addressSizePropertyMap);
        HashMap<String, String> SizeOfLongDoublePropertyMap = new HashMap<String, String>();
        SizeOfLongDoublePropertyMap.put(Messages.getString("SIZE_OF_LONG_DOUBLE_64_BIT_VALUE"), "64");
        SizeOfLongDoublePropertyMap.put(Messages.getString("SIZE_OF_LONG_DOUBLE_128_BIT_VALUE"), "128");
        totalPropertyMap.put("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE", SizeOfLongDoublePropertyMap);
        HashMap<String, String> alignmentRulePropertyMap = new HashMap<String, String>();
        alignmentRulePropertyMap.put(Messages.getString("ALIGNMENT_RULE_NATURAL_VALUE"), "Natural");
        alignmentRulePropertyMap.put(Messages.getString("ALIGNMENT_RULE_POWER_VALUE"), "Power");
        alignmentRulePropertyMap.put(Messages.getString("ALIGNMENT_RULE_PACKED_VALUE"), "Packed");
        totalPropertyMap.put("com.ibm.etools.c.C_ALIGNMENT_RULE", alignmentRulePropertyMap);
        HashMap<String, String> packLevelPropertyMap = new HashMap<String, String>();
        packLevelPropertyMap.put(Messages.getString("PACK_LEVEL_1_VALUE"), "1");
        packLevelPropertyMap.put(Messages.getString("PACK_LEVEL_2_VALUE"), "2");
        packLevelPropertyMap.put(Messages.getString("PACK_LEVEL_4_VALUE"), "4");
        packLevelPropertyMap.put(Messages.getString("PACK_LEVEL_8_VALUE"), "8");
        packLevelPropertyMap.put(Messages.getString("PACK_LEVEL_16_VALUE"), "16");
        totalPropertyMap.put("com.ibm.etools.c.C_PACK_LEVEL", packLevelPropertyMap);
        HashMap<String, String> sizeOfEnumerationConstantPropertyMap = new HashMap<String, String>();
        sizeOfEnumerationConstantPropertyMap.put(Messages.getString("SIZE_OF_ENUM_1_VALUE"), "1");
        sizeOfEnumerationConstantPropertyMap.put(Messages.getString("SIZE_OF_ENUM_2_VALUE"), "2");
        sizeOfEnumerationConstantPropertyMap.put(Messages.getString("SIZE_OF_ENUM_4_VALUE"), "4");
        sizeOfEnumerationConstantPropertyMap.put(Messages.getString("SIZE_OF_ENUM_5_VALUE"), "5");
        totalPropertyMap.put("com.ibm.etools.c.C_SIZE_OF_ENUM", sizeOfEnumerationConstantPropertyMap);
        HashMap<String, String> wcharSizePropertyMap = new HashMap<String, String>();
        wcharSizePropertyMap.put(Messages.getString("SIZE_OF_WCHAR_2_BYTES_VALUE"), "2");
        wcharSizePropertyMap.put(Messages.getString("SIZE_OF_WCHAR_4_BYTES_VALUE"), "4");
        totalPropertyMap.put("com.ibm.etools.c.C_SIZE_OF_WCHAR", wcharSizePropertyMap);
    }

    public static String list2String(List<Object> list) {
        String string = "";
        if (list != null && list.size() > 0) {
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof String) {
                    string = string.concat((String)object);
                } else if (object instanceof File) {
                    try {
                        string = string.concat(((File)object).getCanonicalPath());
                    }
                    catch (IOException iOException) {}
                } else {
                    string = string.concat(object.toString());
                }
                if (!iterator.hasNext()) continue;
                string = string.concat(ICConstants.INCLUDE_PATH_SEPARATOR);
            }
        }
        return string;
    }
}

