/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c;

import com.ibm.adapter.c.CDiscoveryAgent;
import com.ibm.adapter.c.CImportResult;
import com.ibm.adapter.c.MPOCDiscoveryAgentMetaData;
import com.ibm.adapter.c.MPOCImportResult;
import com.ibm.adapter.c.messages.Messages;
import com.ibm.adapter.c.spi.properties.CFileProperty;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IDiscoveryAgentMetaData;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.etools.c.CStructured;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class MPOCDiscoveryAgent
extends BaseDiscoveryAgent {
    private URI filePathURI;
    private File filePath;
    private MPOCImportResult importResult;
    private CDiscoveryAgent discoveryAgent;
    private boolean isJava = false;
    private boolean isInitialized = false;
    private static String[] cFileExt = new String[]{"c", "ccs", "h", "java"};

    public MPOCDiscoveryAgent() {
        this.setMetaData((IDiscoveryAgentMetaData)new MPOCDiscoveryAgentMetaData());
    }

    public String[] getConfiguration() {
        return new String[]{"SUPPORTS_ITERATION"};
    }

    public IDiscoveryAgent newInstance() {
        return new MPOCDiscoveryAgent();
    }

    private void resetState() {
        if (this.discoveryAgent == null) {
            this.discoveryAgent = new CDiscoveryAgent();
        }
        this.filePathURI = null;
        this.filePath = null;
        this.isJava = false;
        this.importResult = null;
        this.isInitialized = false;
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        this.resetState();
        if (this.initializeProperties == null) {
            BasePropertyGroup propertyGroup = null;
            CFileProperty cfile = null;
            try {
                propertyGroup = new BasePropertyGroup("CFileGroupName", Messages.getString("C_FILE_PROP_GROUP_DISPLAY_NAME"), Messages.getString("C_FILE_PROP_GROUP_DESCRIPTION"));
                cfile = new CFileProperty("CFileName", Messages.getString("MPO_FILE_DISPLAY_NAME"), Messages.getString("MPO_FILE_DESCRIPTION"), propertyGroup, cFileExt);
            }
            catch (CoreException ex) {
                throw new BaseException(ex.getStatus());
            }
            cfile.setRequired(true);
            this.initializeProperties = propertyGroup;
        }
        this.discoveryAgent.setInitializeProperties(this.initializeProperties);
        this.isInitialized = true;
        return this.discoveryAgent.getInitializeProperties();
    }

    public void initializeContext(Object[] context) throws BaseException {
        this.importResult = (MPOCImportResult)((Object)context[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        if (!this.isInitialized) {
            this.throwException();
        }
        CFileProperty fileProperty = (CFileProperty)initializeProperties.getProperty("CFileName");
        this.filePathURI = (URI)fileProperty.getValue();
        if (this.filePathURI.toFileString().toLowerCase().endsWith(".java")) {
            if (this.filePathURI.toFileString().endsWith(".java")) {
                this.filePath = new File(this.filePathURI.toFileString());
                if (this.filePath != null && this.filePath.exists()) {
                    this.isJava = true;
                } else {
                    this.isJava = false;
                    String message = Messages.getString("FILE_NOT_FOUND", new String[]{this.filePathURI.toString()});
                    Status newStatus = new Status(4, "com.ibm.adapter.c", 4, message, null);
                    throw new BaseException((IStatus)newStatus);
                }
            }
        } else {
            this.isJava = false;
        }
        this.discoveryAgent.initialize(environment, initializeProperties);
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties, IImportResult previousResult) throws BaseException {
        Status newStatus = new Status(4, "com.ibm.adapter.c", 4, Messages.getString("FUNCTION_NOT_SUPPORTED"), null);
        throw new BaseException((IStatus)newStatus);
    }

    public ISearchTree getSearchTree() throws BaseException {
        if (!this.isInitialized) {
            this.throwException();
        }
        return this.discoveryAgent.getSearchTree();
    }

    public IImportResult performImport(IEnvironment environment, IResultNodeSelection selectedNodes) throws BaseException {
        CImportResult newResult;
        if (!this.isInitialized) {
            this.throwException();
        }
        if (this.isJava) {
            newResult = new CImportResult(this.filePathURI);
            newResult.setImportFile(this.filePath);
        } else {
            newResult = (CImportResult)this.discoveryAgent.performImport(environment, selectedNodes);
        }
        if (this.importResult == null) {
            this.importResult = new MPOCImportResult();
        }
        this.checkIfImported(newResult);
        this.importResult.setImportData(newResult);
        return this.importResult;
    }

    public void close() throws BaseException {
        this.discoveryAgent = null;
        this.isInitialized = false;
    }

    private void throwException() throws BaseException {
        BaseException importException = BaseException.createException((String)((Object)((Object)this)).getClass().getName(), (String)Messages.getString("INITIALIZATION_REQUIRED"), (int)4, null);
        if (importException != null) {
            throw importException;
        }
    }

    private void checkIfImported(CImportResult newResult) throws BaseException {
        Object newImportData = newResult.getImportData();
        ArrayList resultList = (ArrayList)this.importResult.getImportData();
        int i = 0;
        while (i < resultList.size()) {
            File newFile;
            boolean theSameImportFile = false;
            boolean theSameSelectedElement = false;
            CImportResult oldResult = (CImportResult)((Object)resultList.get(i));
            File oldFile = oldResult.getImportFile();
            if (oldFile.compareTo(newFile = newResult.getImportFile()) == 0) {
                theSameImportFile = true;
            }
            Object oldImportData = oldResult.getImportData();
            if (newImportData instanceof URI && oldImportData instanceof URI) {
                if (theSameImportFile) {
                    String message = Messages.getString("RESOURCE_ALREADY_IMPORTED", new String[]{oldFile.getName()});
                    BaseException importException = BaseException.createException((String)((Object)((Object)this)).getClass().getName(), (String)message, (int)4, null);
                    if (importException != null) {
                        throw importException;
                    }
                }
            } else if (newImportData instanceof CStructured && oldImportData instanceof CStructured) {
                String newElementName;
                String oldElementName = ((CStructured)oldImportData).getName();
                if (oldElementName.equals(newElementName = ((CStructured)newImportData).getName())) {
                    theSameSelectedElement = true;
                }
                if (theSameImportFile && theSameSelectedElement) {
                    String message = Messages.getString("TYPE_ALREADY_IMPORTED", new String[]{oldElementName});
                    BaseException importException = BaseException.createException((String)((Object)((Object)this)).getClass().getName(), (String)message, (int)4, null);
                    if (importException != null) {
                        throw importException;
                    }
                }
            }
            ++i;
        }
    }
}

