/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c;

import com.ibm.adapter.c.CQueryResultNode;
import com.ibm.adapter.c.CResultSelection;
import com.ibm.adapter.c.messages.Messages;
import com.ibm.adapter.c.spi.properties.CBaseSingleValuedProperty;
import com.ibm.adapter.c.spi.properties.CDiscoveryAgentPropertyGroup;
import com.ibm.adapter.c.spi.properties.CFolderMultiValuedProperty;
import com.ibm.adapter.c.spi.properties.CPropertyConverter;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.spi.BaseResultNodeResponse;
import com.ibm.adapter.framework.spi.BaseSearchTree;
import com.ibm.etools.c.CField;
import com.ibm.etools.c.CStructured;
import com.ibm.etools.c.CTypedef;
import com.ibm.etools.c.importer.CImporterResource;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class CSearchTree
extends BaseSearchTree {
    public static final String copyright = "Licensed Material - Property of IBM\n com.ibm.adapter.c\n(C) Copyright IBM Corp. 2005 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean isJava = false;
    private Resource importerResource;
    private List<CQueryResultNode> searchResult;

    public CSearchTree(Resource resource) throws BaseException {
        try {
            this.importerResource = resource;
            if (resource.getURI().toFileString().toLowerCase().endsWith(".java")) {
                this.isJava = true;
            }
            CDiscoveryAgentPropertyGroup group = null;
            group = this.isJava ? new BasePropertyGroup(Messages.getString("CAgentName"), Messages.getString("C_AGENT_PROP_GROUP_DISPLAY_NAME"), Messages.getString("C_AGENT_PROP_GROUP_DESCRIPTION")) : new CDiscoveryAgentPropertyGroup();
            this.setFilterProperties((IPropertyGroup)group);
            this.setSelectionStyle(0);
        }
        catch (CoreException e) {
            throw new BaseException(e.getStatus());
        }
    }

    public IResultNodeSelection createResultNodeSelection() {
        return new CResultSelection();
    }

    public IResultNode getResultNode(String location, IEnvironment environment) throws BaseException {
        return null;
    }

    public IResultNodeResponse performQuery(IPropertyGroup searchParameters, IEnvironment environment) throws BaseException {
        if (this.isJava) {
            this.convertJavaFile2QueryResultNodeTree();
        } else {
            Map<String, String> importProperties = this.convertSerachParams2HashMap(searchParameters);
            this.importC(importProperties);
            this.convertCModel2QueryResultNodeTree();
        }
        return new BaseResultNodeResponse(this.searchResult, "");
    }

    private void convertCModel2QueryResultNodeTree() throws BaseException {
        this.searchResult = new ArrayList<CQueryResultNode>();
        List<Object> elements = this.getCTopElements();
        Iterator<Object> i = elements.iterator();
        while (i.hasNext()) {
            String name = "";
            Object obj = i.next();
            if (obj instanceof CStructured) {
                name = ((CStructured)obj).getName();
            } else if (obj instanceof CTypedef) {
                name = ((CTypedef)obj).getName();
            }
            if (name == null || name.equals("")) continue;
            this.setRefIDs(obj);
            CQueryResultNode node = new CQueryResultNode();
            node.setData(this.getID(obj));
            node.setName(name);
            node.setDescription(name);
            node.setSelectable(true);
            this.searchResult.add(node);
            this.visitCElement(obj, node);
        }
    }

    private Map<String, String> convertSerachParams2HashMap(IPropertyGroup searchParameters) {
        HashMap<String, String> importProperties = new HashMap<String, String>();
        this.convertSerachParams2HashMap(searchParameters, importProperties);
        return importProperties;
    }

    private void convertSerachParams2HashMap(IPropertyGroup searchParameters, Map<String, String> importProperties) {
        String cKey = null;
        String cValue = null;
        List<Object> cValueList = null;
        if (searchParameters != null && searchParameters.getProperties() != null) {
            IPropertyDescriptor[] searchParametersArg = searchParameters.getProperties();
            int arraySize = searchParametersArg.length;
            int i = 0;
            while (i < arraySize) {
                IPropertyDescriptor obj = searchParametersArg[i];
                if (obj != null) {
                    if (obj instanceof IPropertyGroup) {
                        this.convertSerachParams2HashMap((IPropertyGroup)obj);
                    } else if (obj instanceof CBaseSingleValuedProperty) {
                        cKey = ((CBaseSingleValuedProperty)obj).getCKey();
                        cValue = (String)((CBaseSingleValuedProperty)obj).getValue();
                        importProperties.put(cKey, CPropertyConverter.getCValue(((CBaseSingleValuedProperty)obj).getCKey(), cValue));
                    } else if (obj instanceof CFolderMultiValuedProperty) {
                        cKey = ((CFolderMultiValuedProperty)obj).getCKey();
                        cValueList = this.array2List(((CFolderMultiValuedProperty)obj).getValuesAsStrings());
                        importProperties.put(cKey, CPropertyConverter.list2String(cValueList));
                    }
                }
                ++i;
            }
        }
    }

    private void importC(Map<String, String> importProperties) throws BaseException {
        block2: {
            try {
                this.importerResource.unload();
                this.importerResource.load(importProperties);
            }
            catch (IOException e) {
                String message = Messages.getString("ERROR_IMPORTING_C_FILE", new Object[]{this.importerResource.getURI().toFileString()});
                BaseException importException = BaseException.createException((String)((Object)((Object)this)).getClass().getName(), (String)(String.valueOf(message) + "\n\n" + e.getMessage()), (int)4, (Throwable)e);
                if (importException == null) break block2;
                throw importException;
            }
        }
    }

    private void visitCElement(Object cElement, CQueryResultNode parentNode) {
        if (cElement instanceof CStructured || cElement instanceof CTypedef) {
            EList elements = null;
            if (cElement instanceof CStructured) {
                elements = ((CStructured)cElement).getContains();
            } else if (cElement instanceof CTypedef) {
                elements = ((CTypedef)cElement).getTdLangTypedElement();
            }
            int i = 0;
            while (elements != null && i < elements.size()) {
                Object childElement = elements.get(i);
                if (childElement != null && childElement instanceof CField) {
                    String name = "";
                    if (((CField)childElement).getType() instanceof CStructured) {
                        name = ((CStructured)((CField)childElement).getType()).getName();
                    } else if (((CField)childElement).getType() instanceof CTypedef) {
                        name = ((CTypedef)((CField)childElement).getType()).getName();
                    }
                    if (name != null && name.length() > 0) {
                        CQueryResultNode childNode = new CQueryResultNode();
                        childNode.setData(name);
                        childNode.setName(name);
                        childNode.setDescription(name);
                        childNode.setSelectable(false);
                        parentNode.addChild((IResultNode)childNode);
                        this.visitCElement(childElement, childNode);
                    }
                }
                ++i;
            }
        }
    }

    private void convertJavaFile2QueryResultNodeTree() {
        this.searchResult = new ArrayList<CQueryResultNode>();
        File file = new File(this.importerResource.getURI().toFileString());
        CQueryResultNode node = new CQueryResultNode();
        node.setName(file.getName());
        node.setSelectable(true);
        this.searchResult.add(node);
    }

    private List<Object> getCTopElements() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.importerResource != null) {
            for (Object possibleType : this.importerResource.getContents()) {
                if (!(possibleType instanceof CStructured) && (!(possibleType instanceof CTypedef) || ((CTypedef)possibleType).getDerives() == null)) continue;
                list.add(possibleType);
            }
        }
        return list;
    }

    public void setRefIDs(Object obj) {
        ((CImporterResource)this.importerResource).setRefIDs(obj);
    }

    public String getID(Object obj) {
        String uriFragment = null;
        if (this.importerResource != null && obj instanceof EObject) {
            uriFragment = this.importerResource.getURIFragment((EObject)obj);
        }
        return uriFragment;
    }

    private List<Object> array2List(Object[] objectArray) {
        ArrayList<Object> list = new ArrayList<Object>(5);
        if (objectArray != null) {
            int i = 0;
            while (i < objectArray.length) {
                list.add(objectArray[i]);
                ++i;
            }
        }
        return list;
    }
}

