/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c;

import com.ibm.adapter.c.CDiscoveryAgentMetaData;
import com.ibm.adapter.c.CImportResult;
import com.ibm.adapter.c.CSearchTree;
import com.ibm.adapter.c.messages.Messages;
import com.ibm.adapter.c.spi.properties.CFileProperty;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IDiscoveryAgentMetaData;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.common.FileProperty;
import java.io.File;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;

public class CDiscoveryAgent
extends BaseDiscoveryAgent {
    public static final String copyright = "Licensed Material - Property of IBM\n com.ibm.adapter.c\n(C) Copyright IBM Corp. 2004 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Resource importerResource;
    private String cFilePath = null;
    private String[] cFileExt = new String[]{"c", "ccs", "h"};
    private boolean isInitialized = false;

    public CDiscoveryAgent() {
        this.setMetaData((IDiscoveryAgentMetaData)new CDiscoveryAgentMetaData());
    }

    public IDiscoveryAgent newInstance() {
        return new CDiscoveryAgent();
    }

    private void validateCFile(URI cFilePathURI) throws BaseException {
        BaseException importException;
        IWorkspaceRoot workspaceRoot;
        boolean isFileValid = false;
        this.cFilePath = cFilePathURI.toFileString();
        File cFile = new File(this.cFilePath);
        if (!cFile.exists() && (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getFile((IPath)new Path(this.cFilePath)).getLocation() != null) {
            this.cFilePath = workspaceRoot.getFile((IPath)new Path(this.cFilePath)).getLocation().toOSString();
            cFile = new File(this.cFilePath);
        }
        if (cFile.exists()) {
            String fileName = cFile.getName().toLowerCase();
            int i = 0;
            while (i < this.cFileExt.length) {
                if (fileName.endsWith(this.cFileExt[i]) && cFile.canRead() && cFile.length() != 0L) {
                    isFileValid = true;
                    break;
                }
                ++i;
            }
        }
        if (!isFileValid && (importException = BaseException.createException((String)((Object)((Object)this)).getClass().getName(), (String)Messages.getString("INVALID_C_FILE"), (int)4, null)) != null) {
            throw importException;
        }
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        if (this.initializeProperties == null) {
            BasePropertyGroup propertyGroup = null;
            CFileProperty cfile = null;
            try {
                propertyGroup = new BasePropertyGroup("CFileGroupName", Messages.getString("C_FILE_PROP_GROUP_DISPLAY_NAME"), Messages.getString("C_FILE_PROP_GROUP_DESCRIPTION"));
                cfile = new CFileProperty("CFileName", Messages.getString("C_FILE_DISPLAY_NAME"), Messages.getString("C_FILE_DESCRIPTION"), propertyGroup, this.cFileExt);
            }
            catch (CoreException ex) {
                throw new BaseException(ex.getStatus());
            }
            cfile.setRequired(true);
            this.initializeProperties = propertyGroup;
        }
        return this.initializeProperties;
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        FileProperty cFileProperty;
        if (environment != null && initializeProperties != null && (cFileProperty = (FileProperty)initializeProperties.getProperty("CFileName")) != null && cFileProperty.getValue() != null) {
            URI cFilePathURI = (URI)cFileProperty.getValue();
            this.cFileExt = cFileProperty.getFileExtensions();
            this.validateCFile(cFilePathURI);
            this.isInitialized = true;
        }
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties, IImportResult importResult) throws BaseException {
        BaseException importException = BaseException.createException((String)((Object)((Object)this)).getClass().getName(), (String)Messages.getString("FUNCTION_NOT_SUPPORTED"), (int)4, null);
        if (importException != null) {
            throw importException;
        }
    }

    public void close() throws BaseException {
        this.isInitialized = false;
    }

    public ISearchTree getSearchTree() throws BaseException {
        BaseException importException;
        if (!this.isInitialized && (importException = BaseException.createException((String)((Object)((Object)this)).getClass().getName(), (String)Messages.getString("INITIALIZATION_REQUIRED"), (int)4, null)) != null) {
            throw importException;
        }
        URI cFileURI = URI.createFileURI((String)this.cFilePath);
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(cFileURI);
        this.importerResource = factory.createResource(cFileURI);
        return new CSearchTree(this.importerResource);
    }

    public IImportResult performImport(IEnvironment environment, IResultNodeSelection selection) throws BaseException {
        BaseException importException;
        CImportResult importResult = null;
        if (!this.isInitialized && (importException = BaseException.createException((String)((Object)((Object)this)).getClass().getName(), (String)Messages.getString("INITIALIZATION_REQUIRED"), (int)4, null)) != null) {
            throw importException;
        }
        IResultNode[] selectedNodes = selection.getSelection();
        if (selectedNodes.length != 1) {
            Status newStatus = new Status(4, "com.ibm.adapter.c", 4, Messages.getString("ERROR_ONLY_ONE_SELECTION_ALLOWED"), null);
            throw new BaseException((IStatus)newStatus);
        }
        String uriFragment = (String)selectedNodes[0].getData();
        EObject cElement = this.importerResource.getEObject(uriFragment);
        importResult = new CImportResult(cElement);
        importResult.setImportFile(new File(this.cFilePath));
        return importResult;
    }
}

