/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.walkers;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.controllers.walkers.ISwaggerModelVisitor;
import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.util.Map;

public class SwaggerModelWalker {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TEMP_OBJECT_PROPERTY_NAME = "$TEMP$";

    public void accept(ISwaggerModelVisitor visitor, Model model) {
        boolean useTempTopObjectProperty;
        if (model == null || model.getProperties() == null || model.getProperties().isEmpty()) {
            ZCeeUILogger.info((String)"Supplied model is either null or empty, aborting walk...", (Object[])new Object[0]);
            return;
        }
        Map properties = model.getProperties();
        ObjectProperty topObjectProperty = null;
        int topPropertyCount = 0;
        int topObjectPropertyCount = 0;
        for (String currKey : properties.keySet()) {
            Property currProperty = (Property)properties.get(currKey);
            if (currProperty instanceof ObjectProperty) {
                topObjectProperty = (ObjectProperty)currProperty;
                currProperty.setName(currKey);
                ++topObjectPropertyCount;
            }
            ++topPropertyCount;
        }
        boolean bl = useTempTopObjectProperty = topObjectPropertyCount == 0 || topPropertyCount > 1;
        if (useTempTopObjectProperty) {
            topObjectProperty = new ObjectProperty();
            topObjectProperty.setName(TEMP_OBJECT_PROPERTY_NAME);
            visitor.setFakeRootPropertyName(TEMP_OBJECT_PROPERTY_NAME);
            topObjectProperty.setProperties(properties);
        }
        this.walkProperty((Property)topObjectProperty, visitor);
    }

    private void walkProperty(Property property, ISwaggerModelVisitor visitor) {
        if (property instanceof ObjectProperty) {
            visitor.enterObjectProperty(property);
            Map objectContent = ((ObjectProperty)property).getProperties();
            for (String currKey : objectContent.keySet()) {
                Property currProperty = (Property)objectContent.get(currKey);
                currProperty.setName(currKey);
                this.walkProperty(currProperty, visitor);
            }
            visitor.exitObjectProperty(property);
        } else if (property instanceof ArrayProperty) {
            visitor.enterArrayProperty(property);
            ArrayProperty array = (ArrayProperty)property;
            Property items = array.getItems();
            this.walkProperty(items, visitor);
            visitor.exitArrayProperty(property);
        } else {
            visitor.leafProperty(property);
        }
    }
}

