/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.walkers;

import com.ibm.zosconnect.ui.controllers.walkers.ISwaggerModelVisitor;
import io.swagger.models.properties.Property;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class ModelLeafPropertyVisitor
implements ISwaggerModelVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String currentPath = "";
    private int arrayDepth = 0;
    private String fakeRootPropertyName = null;
    private LinkedHashMap<String, Property> leafProperties = new LinkedHashMap();
    private String pathSeparator = "/";

    public ModelLeafPropertyVisitor() {
    }

    public ModelLeafPropertyVisitor(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    @Override
    public void enterObjectProperty(Property property) {
        if (this.arrayDepth == 0) {
            this.currentPath = this.currentPath.isEmpty() ? String.valueOf(this.currentPath) + property.getName() : String.valueOf(this.currentPath) + this.pathSeparator + property.getName();
        }
    }

    @Override
    public void exitObjectProperty(Property property) {
        int lastSeparatorIndex;
        if (this.arrayDepth == 0 && (lastSeparatorIndex = this.currentPath.lastIndexOf(this.pathSeparator)) > 0) {
            this.currentPath = this.currentPath.substring(0, lastSeparatorIndex);
        }
    }

    @Override
    public void enterArrayProperty(Property property) {
        ++this.arrayDepth;
    }

    @Override
    public void exitArrayProperty(Property property) {
        --this.arrayDepth;
    }

    @Override
    public void leafProperty(Property property) {
        if (this.arrayDepth == 0) {
            Object actualPath = this.currentPath + this.pathSeparator + property.getName();
            if (this.fakeRootPropertyName != null) {
                actualPath = StringUtils.removeStart((String)actualPath, (String)(this.fakeRootPropertyName + this.pathSeparator));
            }
            this.leafProperties.put((String)actualPath, property);
        }
    }

    public LinkedHashMap<String, Property> getLeafProperties() {
        return this.leafProperties;
    }

    @Override
    public void setFakeRootPropertyName(String name) {
        this.fakeRootPropertyName = name;
    }

    public String getFakeRootPropertyName() {
        return this.fakeRootPropertyName;
    }
}

