/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.validation;

import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.api.rules.BooleanExpression;
import com.ibm.zosconnect.api.rules.BooleanOperator;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.common.validation.ApiResponseValidationProblem;
import com.ibm.zosconnect.ui.common.validation.IMappingProblemProvider;
import com.ibm.zosconnect.ui.common.validation.MappingProblemTypes;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.controllers.util.ResponseCodeRulesUtil;
import io.swagger.models.Model;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ApiResponseValidator
implements IMappingProblemProvider {
    private List<MappingValidationProblem2> errorProblems = new ArrayList<MappingValidationProblem2>();
    private List<MappingValidationProblem2> warningProblems = new ArrayList<MappingValidationProblem2>();
    private List<MappingValidationProblem2> otherProblems = new ArrayList<MappingValidationProblem2>();
    private LinkedHashMap<String, Property> leafProperties;
    private List<BooleanExpression> leafExpressions;
    private BooleanExpression rootExpression;
    private String fileTypeString;
    private IFile packageXmlFile;
    private IPath packageXmlFileLocation;
    private String operationId;
    private Integer responseCode;

    public ApiResponseValidator(String operationId, ResponseMessageType responseMessage, LinkedHashMap<String, Property> leafProperties, IFile packageXmlFile) {
        this.operationId = operationId;
        if (responseMessage != null) {
            this.responseCode = responseMessage.getCode();
            this.fileTypeString = Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_RESPONSE", (Object[])new Object[]{this.responseCode});
        }
        if (leafProperties != null) {
            this.leafProperties = leafProperties;
        } else {
            leafProperties = new LinkedHashMap();
        }
        if (responseMessage != null && responseMessage.getBooleanExpression() != null) {
            this.rootExpression = responseMessage.getBooleanExpression();
            this.leafExpressions = ResponseCodeRulesUtil.getLeafExpressions(this.rootExpression);
        } else {
            this.leafExpressions = new ArrayList<BooleanExpression>();
        }
        if (packageXmlFile != null) {
            this.packageXmlFile = packageXmlFile;
            this.packageXmlFileLocation = packageXmlFile.getLocation();
        }
    }

    public boolean canValidate() {
        return this.rootExpression != null && !this.leafExpressions.isEmpty();
    }

    public boolean validate() {
        if (!this.canValidate()) {
            return false;
        }
        this.errorProblems.clear();
        this.warningProblems.clear();
        this.otherProblems.clear();
        for (BooleanExpression leafExpression : this.leafExpressions) {
            this.validateExpression(leafExpression);
        }
        return true;
    }

    public boolean validateAndCreateMarkers() throws CoreException {
        boolean validate = this.validate();
        if (validate) {
            this.createMarkers();
        }
        return validate;
    }

    private void validateExpression(BooleanExpression leafExpression) {
        String serviceFieldPath = leafExpression.getLeft();
        String comparisonValue = leafExpression.getRight();
        Property leafProperty = this.leafProperties.get(serviceFieldPath);
        BooleanOperator operator = ResponseCodeRulesUtil.getBooleanOperatorFromString(leafExpression.getOp());
        boolean operatorIsExists = ResponseCodeRulesUtil.expressionHasOperator(leafExpression, BooleanOperator.EXISTS);
        if (StringUtils.isBlank((CharSequence)serviceFieldPath)) {
            this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_SERVICE_FIELD_EMPTY", (String[])new String[]{leafExpression.getId()}), MappingProblemTypes.BROKEN_RULE, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
        } else if (leafProperty == null) {
            this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_SERVICE_FIELD_NOT_FOUND", (String[])new String[]{serviceFieldPath, leafExpression.getId()}), MappingProblemTypes.BROKEN_RULE, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
        } else if (!ResponseCodeRulesUtil.isOperatorCompatible(leafProperty, operator)) {
            String operatorUIStr = ResponseCodeRulesUtil.getUIStringFromBooleanOperator(operator);
            this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_COMPARISON_OPERATOR_INCOMPAT", (String[])new String[]{operatorUIStr, serviceFieldPath}), MappingProblemTypes.INCOMPATIBLE_COMPARATOR, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
        } else if (!operatorIsExists && StringUtils.isBlank((CharSequence)comparisonValue)) {
            this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_COMPARSION_VALUE_EMPTY", (String[])new String[]{serviceFieldPath, leafExpression.getId()}), MappingProblemTypes.INVALID_COMPARISON_VALUE, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
        } else if (!operatorIsExists && leafProperty instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)leafProperty;
            if (!NumberUtils.isNumber((String)comparisonValue)) {
                this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_COMPARISON_VALUE_NOT_NUMERIC", (String[])new String[]{comparisonValue, serviceFieldPath}), MappingProblemTypes.INVALID_COMPARISON_VALUE, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
            } else if (OpenApi2xUtil.isValueTooSmall((AbstractNumericProperty)numericProperty, (String)comparisonValue)) {
                this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_COMPARISON_VALUE_MIN_QUANTITY", (String[])new String[]{comparisonValue, serviceFieldPath, OpenApi2xUtil.getMinimum((AbstractNumericProperty)numericProperty).toPlainString()}), MappingProblemTypes.INVALID_COMPARISON_VALUE, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
            } else if (OpenApi2xUtil.isValueTooBig((AbstractNumericProperty)numericProperty, (String)comparisonValue)) {
                this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_COMPARISON_VALUE_MAX_QUANTITY", (String[])new String[]{comparisonValue, serviceFieldPath, OpenApi2xUtil.getMaximum((AbstractNumericProperty)numericProperty).toPlainString()}), MappingProblemTypes.INVALID_COMPARISON_VALUE, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
            }
        } else if (!operatorIsExists && leafProperty instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)leafProperty;
            if (OpenApi2xUtil.isValueTooShort((StringProperty)stringProperty, (String)comparisonValue)) {
                this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_COMPARISON_VALUE_MIN_LENGTH", (Object[])new Object[]{comparisonValue, serviceFieldPath, OpenApi2xUtil.getMinLength((StringProperty)stringProperty)}), MappingProblemTypes.INVALID_COMPARISON_VALUE, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
            } else if (OpenApi2xUtil.isValueTooLong((StringProperty)stringProperty, (String)comparisonValue)) {
                this.errorProblems.add((MappingValidationProblem2)new ApiResponseValidationProblem(2, Xlat.error((String)"RULES_COMPARISON_VALUE_MAX_LENGTH", (Object[])new Object[]{comparisonValue, serviceFieldPath, OpenApi2xUtil.getMaxLength((StringProperty)stringProperty)}), MappingProblemTypes.INVALID_COMPARISON_VALUE, this.packageXmlFileLocation, this.fileTypeString, this.operationId, this.responseCode));
            }
        }
    }

    public void createMarkers() throws CoreException {
        for (MappingValidationProblem2 problem : this.errorProblems) {
            if (problem instanceof ApiResponseValidationProblem) {
                ((ApiResponseValidationProblem)problem).createMarker();
                continue;
            }
            problem.createMarker();
        }
        for (MappingValidationProblem2 problem : this.warningProblems) {
            if (problem instanceof ApiResponseValidationProblem) {
                ((ApiResponseValidationProblem)problem).createMarker();
                continue;
            }
            problem.createMarker();
        }
        for (MappingValidationProblem2 problem : this.otherProblems) {
            if (problem instanceof ApiResponseValidationProblem) {
                ((ApiResponseValidationProblem)problem).createMarker();
                continue;
            }
            problem.createMarker();
        }
    }

    public static void validateAndCreateMarkers(ApiProjectController apiProjectController, IFile packageXmlFile) throws Exception {
        ApiResponseValidationProblem.deleteFileMarkers((IFile)packageXmlFile);
        for (ServiceMappingController servMapCtrl : apiProjectController.getAllServiceMappingControllers()) {
            Model responseSchemaModel;
            String operationId = servMapCtrl.getOperationId();
            Integer defaultResponseCode = servMapCtrl.getDefaultResponseCode();
            ServiceArchiveController srvArchCtrl = servMapCtrl.getServiceArchiveController();
            if (srvArchCtrl == null || (responseSchemaModel = srvArchCtrl.getResponseSchemaModel()) == null) continue;
            LinkedHashMap<String, Property> leafProperties = ServiceArchiveController.getLeafProperties(responseSchemaModel);
            for (ResponseMessageType responseMessage : servMapCtrl.getResponseMessages()) {
                Integer responseCode = responseMessage.getCode();
                if (responseCode == null || responseCode.equals(defaultResponseCode)) continue;
                new ApiResponseValidator(operationId, responseMessage, leafProperties, packageXmlFile).validateAndCreateMarkers();
            }
        }
    }

    public List<MappingValidationProblem2> getErrorProblems() {
        return this.errorProblems;
    }

    public List<MappingValidationProblem2> getWarningProblems() {
        return this.warningProblems;
    }

    public List<MappingValidationProblem2> getOtherProblems() {
        return this.otherProblems;
    }

    public IFile getPackageXmlFile() {
        return this.packageXmlFile;
    }

    public IPath getPackageXmlFileLocation() {
        return this.packageXmlFileLocation;
    }
}

