/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.validation;

import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ApiDuplicatePathsProblem;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class ApiDuplicatePathsValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void validateAndCreateMarkers(String projName, ApiModelController apiModelController, IFile packageXmlFile) throws CoreException {
        ApiDuplicatePathsProblem.deleteFileMarkers((IFile)packageXmlFile);
        HashMap<String, String> duplicatePaths = ApiDuplicatePathsValidator.findDuplicateApiPaths(apiModelController);
        for (String path : duplicatePaths.values()) {
            new ApiDuplicatePathsProblem(projName, path, Xlat.error((String)"DUPLICATE_API_PATH_ERROR_MARKER", (String[])new String[]{path}), packageXmlFile).createMarker();
        }
    }

    private static HashMap<String, String> findDuplicateApiPaths(ApiModelController apiModelController) {
        HashMap<String, String> duplicatePaths = new HashMap<String, String>();
        List<PathType> paths = apiModelController.getApiPaths();
        HashMap<String, String> allComparePaths = new HashMap<String, String>();
        int i = 0;
        while (i < paths.size()) {
            String relativePath = paths.get(i).getRelativePath();
            String comparePath = ApiDuplicatePathsValidator.getPathToCompare(relativePath);
            if (allComparePaths.containsKey(comparePath)) {
                if (!duplicatePaths.containsKey(comparePath)) {
                    String firstOccuranceOfRelativePath = (String)allComparePaths.get(comparePath);
                    duplicatePaths.put(comparePath, firstOccuranceOfRelativePath);
                }
            } else {
                allComparePaths.put(comparePath, relativePath);
            }
            ++i;
        }
        return duplicatePaths;
    }

    private static String getPathToCompare(String path) {
        int questionMark = path.indexOf(63);
        if (questionMark != -1) {
            path = path.substring(0, questionMark);
        }
        if (path.indexOf("{") != -1) {
            path = StringUtils.replacePattern((String)path, (String)"\\{[^\\}\\/]+\\}", (String)"{PP}");
        }
        return path;
    }
}

