/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.util;

import com.ibm.zosconnect.api.rules.BooleanExpression;
import com.ibm.zosconnect.api.rules.BooleanOperator;
import com.ibm.zosconnect.ui.common.util.Xlat;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ResponseCodeRulesUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Map<BooleanOperator, String> boolOp2UIStr = new HashMap<BooleanOperator, String>();
    private static final Map<String, BooleanOperator> uiStr2BoolOp;
    private static final Map<String, BooleanOperator> str2BoolOp;
    private static final List<String> allOpUIStr;
    private static final List<String> charOpUIStr;
    private static final List<String> logOpUIStr;
    private static final List<String> numericOpUIStr;
    private static final List<BooleanOperator> numericOps;
    private static final List<BooleanOperator> charOps;

    static {
        boolOp2UIStr.put(BooleanOperator.AND, "AND");
        boolOp2UIStr.put(BooleanOperator.OR, "OR");
        boolOp2UIStr.put(BooleanOperator.CONTAINS, Xlat.label((String)"APIDLG_LABEL_CONTAINS"));
        boolOp2UIStr.put(BooleanOperator.NOT_CONTAINS, Xlat.label((String)"APIDLG_LABEL_NOTCONTAINS"));
        boolOp2UIStr.put(BooleanOperator.STARTSWITH, Xlat.label((String)"APIDLG_LABEL_STARTSWITH"));
        boolOp2UIStr.put(BooleanOperator.ENDSWITH, Xlat.label((String)"APIDLG_LABEL_ENDSWITH"));
        boolOp2UIStr.put(BooleanOperator.EQUAL, "=");
        boolOp2UIStr.put(BooleanOperator.NOT_EQUAL, Xlat.noXlatLabel((String)"NOT_EQUAL"));
        boolOp2UIStr.put(BooleanOperator.LESS_THAN, "<");
        boolOp2UIStr.put(BooleanOperator.LESS_THAN_OR_EQUAL, "<=");
        boolOp2UIStr.put(BooleanOperator.GREATER_THAN, ">");
        boolOp2UIStr.put(BooleanOperator.GREATER_THAN_OR_EQUAL, ">=");
        uiStr2BoolOp = new HashMap<String, BooleanOperator>();
        uiStr2BoolOp.put("AND", BooleanOperator.AND);
        uiStr2BoolOp.put("OR", BooleanOperator.OR);
        uiStr2BoolOp.put(Xlat.label((String)"APIDLG_LABEL_CONTAINS"), BooleanOperator.CONTAINS);
        uiStr2BoolOp.put(Xlat.label((String)"APIDLG_LABEL_NOTCONTAINS"), BooleanOperator.NOT_CONTAINS);
        uiStr2BoolOp.put(Xlat.label((String)"APIDLG_LABEL_STARTSWITH"), BooleanOperator.STARTSWITH);
        uiStr2BoolOp.put(Xlat.label((String)"APIDLG_LABEL_ENDSWITH"), BooleanOperator.ENDSWITH);
        uiStr2BoolOp.put("=", BooleanOperator.EQUAL);
        uiStr2BoolOp.put(Xlat.noXlatLabel((String)"NOT_EQUAL"), BooleanOperator.NOT_EQUAL);
        uiStr2BoolOp.put("<", BooleanOperator.LESS_THAN);
        uiStr2BoolOp.put("<=", BooleanOperator.LESS_THAN_OR_EQUAL);
        uiStr2BoolOp.put(">", BooleanOperator.GREATER_THAN);
        uiStr2BoolOp.put(">=", BooleanOperator.GREATER_THAN_OR_EQUAL);
        str2BoolOp = new HashMap<String, BooleanOperator>();
        BooleanOperator[] booleanOperatorArray = BooleanOperator.values();
        int n = booleanOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanOperator boolOp = booleanOperatorArray[n2];
            str2BoolOp.put(boolOp.toString(), boolOp);
            ++n2;
        }
        allOpUIStr = new ArrayList<String>();
        charOpUIStr = new ArrayList<String>();
        logOpUIStr = new ArrayList<String>();
        numericOpUIStr = new ArrayList<String>();
        numericOps = new ArrayList<BooleanOperator>();
        charOps = new ArrayList<BooleanOperator>();
    }

    public static BooleanOperator getBooleanOperatorFromUIString(String operator) {
        BooleanOperator retVal = null;
        if (StringUtils.isNotBlank((CharSequence)operator)) {
            retVal = uiStr2BoolOp.get(operator);
        }
        return retVal;
    }

    public static String getUIStringFromBooleanOperator(BooleanOperator operator) {
        String retVal = "";
        if (operator != null) {
            retVal = boolOp2UIStr.get(operator);
        }
        return retVal;
    }

    public static BooleanOperator getBooleanOperatorFromString(String operator) {
        BooleanOperator retVal = null;
        if (StringUtils.isNotBlank((CharSequence)operator)) {
            retVal = str2BoolOp.get(operator);
        }
        return retVal;
    }

    public static boolean expressionHasOperator(BooleanExpression expression, BooleanOperator operator) {
        boolean hasOperator = false;
        if (expression != null && operator != null && operator.equals((Object)ResponseCodeRulesUtil.getBooleanOperatorFromString(expression.getOp()))) {
            hasOperator = true;
        }
        return hasOperator;
    }

    public static List<String> getPropertyOperatorUIStrings(Property property) {
        if (property instanceof AbstractNumericProperty) {
            if (numericOpUIStr.isEmpty()) {
                numericOpUIStr.add(boolOp2UIStr.get(BooleanOperator.EQUAL));
                numericOpUIStr.add(boolOp2UIStr.get(BooleanOperator.NOT_EQUAL));
                numericOpUIStr.add(boolOp2UIStr.get(BooleanOperator.LESS_THAN));
                numericOpUIStr.add(boolOp2UIStr.get(BooleanOperator.LESS_THAN_OR_EQUAL));
                numericOpUIStr.add(boolOp2UIStr.get(BooleanOperator.GREATER_THAN));
                numericOpUIStr.add(boolOp2UIStr.get(BooleanOperator.GREATER_THAN_OR_EQUAL));
            }
            return numericOpUIStr;
        }
        if (charOpUIStr.isEmpty()) {
            charOpUIStr.add(boolOp2UIStr.get(BooleanOperator.EQUAL));
            charOpUIStr.add(boolOp2UIStr.get(BooleanOperator.NOT_EQUAL));
            charOpUIStr.add(boolOp2UIStr.get(BooleanOperator.CONTAINS));
            charOpUIStr.add(boolOp2UIStr.get(BooleanOperator.NOT_CONTAINS));
            charOpUIStr.add(boolOp2UIStr.get(BooleanOperator.STARTSWITH));
            charOpUIStr.add(boolOp2UIStr.get(BooleanOperator.ENDSWITH));
        }
        return charOpUIStr;
    }

    public static List<BooleanOperator> getPropertyOperators(Property property) {
        if (property instanceof AbstractNumericProperty) {
            if (numericOps.isEmpty()) {
                numericOps.add(BooleanOperator.EQUAL);
                numericOps.add(BooleanOperator.NOT_EQUAL);
                numericOps.add(BooleanOperator.LESS_THAN);
                numericOps.add(BooleanOperator.LESS_THAN_OR_EQUAL);
                numericOps.add(BooleanOperator.GREATER_THAN);
                numericOps.add(BooleanOperator.GREATER_THAN_OR_EQUAL);
            }
            return numericOps;
        }
        if (charOps.isEmpty()) {
            charOps.add(BooleanOperator.EQUAL);
            charOps.add(BooleanOperator.NOT_EQUAL);
            charOps.add(BooleanOperator.CONTAINS);
            charOps.add(BooleanOperator.NOT_CONTAINS);
            charOps.add(BooleanOperator.STARTSWITH);
            charOps.add(BooleanOperator.ENDSWITH);
        }
        return charOps;
    }

    public static boolean isOperatorCompatible(Property property, BooleanOperator operator) {
        return ResponseCodeRulesUtil.getPropertyOperators(property).contains(operator);
    }

    public static List<String> getAllBooleanOperatorUIStrings() {
        if (allOpUIStr.isEmpty()) {
            allOpUIStr.addAll(boolOp2UIStr.values());
        }
        return allOpUIStr;
    }

    public static List<String> getLogicalOperatorUIStrings() {
        if (logOpUIStr.isEmpty()) {
            logOpUIStr.add(boolOp2UIStr.get(BooleanOperator.AND));
            logOpUIStr.add(boolOp2UIStr.get(BooleanOperator.OR));
        }
        return logOpUIStr;
    }

    public static List<BooleanExpression> getLeafExpressions(BooleanExpression rootExp) {
        ArrayList<BooleanExpression> allExp = new ArrayList<BooleanExpression>();
        ResponseCodeRulesUtil._getLeafExpressions(rootExp, allExp);
        return allExp;
    }

    private static void _getLeafExpressions(BooleanExpression exp, List<BooleanExpression> allExp) {
        if (StringUtils.isNotBlank((CharSequence)exp.getLeft()) || StringUtils.isNotBlank((CharSequence)exp.getRight())) {
            allExp.add(exp);
        }
        if (exp.getBooleanExpression() != null && !exp.getBooleanExpression().isEmpty()) {
            for (BooleanExpression nextExpr : exp.getBooleanExpression()) {
                ResponseCodeRulesUtil._getLeafExpressions(nextExpr, allExp);
            }
        }
    }
}

