/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.jetty;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.FileUtilz;
import com.ibm.zosconnect.ui.common.util.SWTBrowserFormEditor;
import com.ibm.zosconnect.ui.common.util.SWTBrowserFormEditorInput;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swagger.SwaggerUI2xConstants;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApi;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiDetail;
import com.ibm.zosconnect.ui.resources.ZCeeUIResourcePlugin;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.ApiException;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.service.prefs.BackingStoreException;

public class SwaggerUIController
implements SwaggerUI2xConstants,
IPartListener2 {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Server jettyServer;
    private File jettyResourceBase;
    private File jettyApiDocsDir;
    private ServerConnector jettyConnector;
    private ResourceHandler jettyResourceHandler;
    private Handler.Sequence jettyHandlers;
    private static SwaggerUIController instance;
    private static HashMap<String, BrowserModel> browserIdToModel;

    private SwaggerUIController() {
        browserIdToModel = new HashMap();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                ZCeeUILogger.entering((String)this.getClass().getName(), (String)"preShutdown", (Object[])new Object[0]);
                if (browserIdToModel != null) {
                    for (BrowserModel model : browserIdToModel.values()) {
                        if (model.getBrowser() == null) continue;
                        model.getBrowser().close();
                    }
                    browserIdToModel.clear();
                }
                ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"preShutdown", (Object[])new Object[0]);
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public static SwaggerUIController getSingletonInstance() {
        if (instance == null) {
            instance = new SwaggerUIController();
        }
        return instance;
    }

    public static boolean isSetSingletonInstance() {
        return instance != null;
    }

    public void openSwaggerUI(final ZosConnectApi api, final IZCeeAdminApiConnection connection) throws Exception {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"openSwaggerUI", (Object[])new Object[0]);
        Job job = new Job(Xlat.description((String)"STATUS_OPENING_SWAGGER_UI", (String[])new String[]{api.getName()})){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    final ZosConnectApiDetail apiDetail = connection.getApi(api);
                    final BrowserModel model = SwaggerUIController.this.downloadSwagger(apiDetail, connection);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwaggerUIController.this.openSwaggerUiInBrowser(apiDetail, connection, model);
                            }
                            catch (IOException | PartInitException e) {
                                ZCeeUILogger.error((Throwable)e);
                                ZCeeErrorDialog.openError((Exception)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                    result = new Status(4, "com.ibm.zosconnect.ui.controllers", e.getMessage(), (Throwable)e);
                }
                return result;
            }
        };
        job.schedule();
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"openSwaggerUI", (Object[])new Object[0]);
    }

    public void openSwaggerUI(final ZosConnectApiDetail apiDetail, final IZCeeAdminApiConnection connection) throws Exception {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"openSwaggerUI", (Object[])new Object[0]);
        Job job = new Job(Xlat.description((String)"STATUS_OPENING_SWAGGER_UI", (String[])new String[]{apiDetail.getName()})){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    final BrowserModel model = SwaggerUIController.this.downloadSwagger(apiDetail, connection);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwaggerUIController.this.openSwaggerUiInBrowser(apiDetail, connection, model);
                            }
                            catch (IOException | PartInitException e) {
                                ZCeeUILogger.error((Throwable)e);
                                ZCeeErrorDialog.openError((Exception)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                    result = new Status(4, "com.ibm.zosconnect.ui.controllers", e.getMessage(), (Throwable)e);
                }
                return result;
            }
        };
        job.schedule();
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"openSwaggerUI", (Object[])new Object[0]);
    }

    public void openApiExplorer(final ZosConnectApiDetail apiDetail, final IZCeeAdminApiConnection connection) throws Exception {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"openApiExplorer", (Object[])new Object[0]);
        Job job = new Job(Xlat.description((String)"STATUS_OPENING_API_EXPLORER", (String[])new String[]{apiDetail.getName()})){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    boolean isApiDiscoveryFeatureEnabled = true;
                    try {
                        isApiDiscoveryFeatureEnabled = connection.isApiDiscoveryFeatureEnabled();
                    }
                    catch (ApiException apiException) {
                        isApiDiscoveryFeatureEnabled = false;
                    }
                    if (!isApiDiscoveryFeatureEnabled) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                String dialogTitle = Xlat.label((String)"POPUP_DIALOG_INFORMATION");
                                String errorMsg = Xlat.description((String)"API_DISCOVERY_NOT_ENABLED");
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)dialogTitle, (String)errorMsg);
                            }
                        });
                        return result;
                    }
                    String apiUrl = apiDetail.getApiUrl();
                    final BrowserModel model = new BrowserModel();
                    model.setApiExplorer(true);
                    String patterStr = ".+://.+:\\d+/";
                    Pattern pattern = Pattern.compile(patterStr);
                    Matcher matcher = pattern.matcher(apiUrl);
                    if (matcher.find()) {
                        model.setApiBasePath(apiUrl.substring(matcher.end() - 1));
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwaggerUIController.this.openApiExplorerInBrowser(apiDetail, connection, model);
                            }
                            catch (IOException | PartInitException e) {
                                ZCeeUILogger.error((Throwable)e);
                                ZCeeErrorDialog.openError((Exception)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                    result = new Status(4, "com.ibm.zosconnect.ui.controllers", e.getMessage(), (Throwable)e);
                }
                return result;
            }
        };
        job.schedule();
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"openApiExplorer", (Object[])new Object[0]);
    }

    private String getConnectionDirName(IZCeeAdminApiConnection connection) {
        ConnectionConfiguration config = connection.getConfiguration();
        return config.getHost() + "_" + config.getPort();
    }

    private File getApiDocsDirForConnection(IZCeeAdminApiConnection connection) {
        String connApiDocsDirPath = this.jettyApiDocsDir.getAbsolutePath() + File.separator + this.getConnectionDirName(connection);
        File connApiDocsDir = new File(connApiDocsDirPath);
        if (!connApiDocsDir.exists()) {
            connApiDocsDir.mkdirs();
        }
        return connApiDocsDir;
    }

    private BrowserModel downloadSwagger(ZosConnectApiDetail apiDetail, IZCeeAdminApiConnection connection) throws ZosConnectUIException, IOException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"downloadSwagger", (Object[])new Object[0]);
        BrowserModel model = new BrowserModel();
        model.setApiName(apiDetail.getName());
        model.setApiUrl(apiDetail.getApiUrl());
        String swaggerJson = connection.getApiDocs(apiDetail);
        Swagger swagger = (Swagger)Json.mapper().readValue(swaggerJson, Swagger.class);
        if (connection.getConfiguration().getSecureHint()) {
            swagger.setSchemes(Arrays.asList(Scheme.HTTPS));
        } else {
            swagger.setSchemes(Arrays.asList(Scheme.HTTP));
        }
        ConnectionConfiguration configuration = connection.getConfiguration();
        swagger.setHost(configuration.getHost() + ":" + configuration.getPort());
        File swaggerFile = FileUtilz.getUniqueFile((File)this.getApiDocsDirForConnection(connection), (String)".json");
        Json.pretty().writeValue(swaggerFile, (Object)swagger);
        model.setSwaggerFile(swaggerFile);
        model.setSwaggerFileName(swaggerFile.getName());
        model.setApiBasePath(swagger.getBasePath());
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"downloadSwagger", (Object[])new Object[0]);
        return model;
    }

    private String generateBrowserUrl() {
        StringBuilder launchURI = new StringBuilder();
        launchURI.append("http://");
        launchURI.append(this.jettyConnector.getHost());
        launchURI.append(":");
        launchURI.append(this.jettyConnector.getLocalPort());
        launchURI.append("/");
        launchURI.append("index.html");
        return launchURI.toString();
    }

    private void updateSwaggerDocUrl(IZCeeAdminApiConnection connection, String swaggerFileName) {
        ConnectionConfiguration config = connection.getConfiguration();
        String connUriSeg = config.getHost() + "_" + config.getPort();
        StringBuilder swaggerURI = new StringBuilder();
        swaggerURI.append("http://");
        swaggerURI.append(this.jettyConnector.getHost());
        swaggerURI.append(":");
        swaggerURI.append(this.jettyConnector.getLocalPort());
        swaggerURI.append("/");
        swaggerURI.append(this.jettyApiDocsDir.getName());
        swaggerURI.append("/");
        swaggerURI.append(connUriSeg);
        swaggerURI.append("/");
        swaggerURI.append(swaggerFileName);
        File initFile = FileUtils.getFile((File)this.jettyResourceBase, (String[])new String[]{"swagger-initializer.js"});
        try {
            String content = FileUtils.readFileToString((File)initFile, (String)"UTF-8");
            String pattern = "url:.*,";
            content = content.replaceAll(pattern, "url: \"" + swaggerURI.toString() + "\",");
            FileUtils.writeStringToFile((File)initFile, (String)content, (String)"UTF-8", (boolean)false);
        }
        catch (IOException iOException) {}
    }

    private String generateApiExplorerBrowserUrl(IZCeeAdminApiConnection connection, BrowserModel model) {
        ConnectionConfiguration config = connection.getConfiguration();
        StringBuilder launchURI = new StringBuilder();
        if (config.getSecureHint()) {
            launchURI.append("https://");
        } else {
            launchURI.append("http://");
        }
        launchURI.append(config.getHost());
        launchURI.append(":");
        launchURI.append(config.getPort());
        launchURI.append("/api/explorer?root=");
        launchURI.append(model.getApiBasePath());
        return launchURI.toString();
    }

    private String generateBrowserId(ZosConnectApiDetail apiDetail, IZCeeAdminApiConnection connection) {
        ConnectionConfiguration config = connection.getConfiguration();
        StringBuilder uid = new StringBuilder();
        uid.append(config.getHost());
        uid.append(":");
        uid.append(config.getPort());
        uid.append(":");
        uid.append(config.getID());
        uid.append(":");
        uid.append(apiDetail.getName());
        return uid.toString();
    }

    private void openSwaggerUiInBrowser(ZosConnectApiDetail apiDetail, IZCeeAdminApiConnection connection, BrowserModel model) throws PartInitException, IOException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"openSwaggerUiInBrowser", (Object[])new Object[0]);
        String browserId = this.generateBrowserId(apiDetail, connection);
        String browserUrl = this.generateBrowserUrl();
        this.updateSwaggerDocUrl(connection, model.getSwaggerFileName());
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        IEclipsePreferences browserPreferences = null;
        int browserChoice = -1;
        try {
            browserPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.browser");
            browserPreferences.sync();
            browserChoice = browserPreferences.getInt("browser-choice", 1);
        }
        catch (BackingStoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
        ZCeeUILogger.info((String)"browseChoice={0}", (Object[])new Object[]{browserChoice});
        if (browserChoice == 0 && browserSupport.isInternalWebBrowserAvailable()) {
            ZCeeUILogger.info((String)"opening {0}, name={1},url={2},tooltip={3}", (Object[])new Object[]{SWTBrowserFormEditor.TAG, apiDetail.getName(), browserUrl, apiDetail.getApiUrl()});
            IEditorPart browser = XSwt.getActivePage().openEditor((IEditorInput)new SWTBrowserFormEditorInput(apiDetail.getName(), browserUrl, apiDetail.getApiUrl()), "com.ibm.zosconnect.ui.swtbrowser");
            model.setBrowserEditorPart(browser);
            model.setBrowserId(browserId);
            browserIdToModel.put(browserId, model);
            ZCeeUILogger.info((String)"added {0} to cache, browserId={1}", (Object[])new Object[]{SWTBrowserFormEditor.TAG, model.getBrowserId()});
        } else {
            ZCeeUILogger.info((String)"opening external browser id={0}...", (Object[])new Object[]{browserUrl});
            IWebBrowser browser = browserSupport.getExternalBrowser();
            browser.openURL(URI.create(browserUrl).toURL());
            model.setBrowser(browser);
            model.setBrowserId(browserId);
            browserIdToModel.put(browserId, model);
            ZCeeUILogger.info((String)"added external browser to cache, browserId={0}", (Object[])new Object[]{model.getBrowserId()});
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"openSwaggerUiInBrowser", (Object[])new Object[0]);
    }

    private void openApiExplorerInBrowser(ZosConnectApiDetail apiDetail, IZCeeAdminApiConnection connection, BrowserModel model) throws PartInitException, IOException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"openApiExplorerInBrowser", (Object[])new Object[0]);
        String browserId = this.generateBrowserId(apiDetail, connection);
        String browserUrl = this.generateApiExplorerBrowserUrl(connection, model);
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        IEclipsePreferences browserPreferences = null;
        int browserChoice = -1;
        try {
            browserPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.browser");
            browserPreferences.sync();
            browserChoice = browserPreferences.getInt("browser-choice", 1);
        }
        catch (BackingStoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
        ZCeeUILogger.info((String)"browseChoice={0}", (Object[])new Object[]{browserChoice});
        if (browserChoice == 0 && browserSupport.isInternalWebBrowserAvailable()) {
            ZCeeUILogger.info((String)"opening {0}, name={1},url={2},tooltip={3}", (Object[])new Object[]{SWTBrowserFormEditor.TAG, apiDetail.getName(), browserUrl, apiDetail.getApiUrl()});
            IEditorPart browser = XSwt.getActivePage().openEditor((IEditorInput)new SWTBrowserFormEditorInput(apiDetail.getName(), browserUrl, browserUrl), "com.ibm.zosconnect.ui.swtbrowser");
            model.setBrowserEditorPart(browser);
            model.setBrowserId(browserId);
            browserIdToModel.put(browserId, model);
            ZCeeUILogger.info((String)"added {0} to cache, browserId={1}", (Object[])new Object[]{SWTBrowserFormEditor.TAG, model.getBrowserId()});
        } else {
            ZCeeUILogger.info((String)"opening external browser id={0}...", (Object[])new Object[]{browserUrl});
            IWebBrowser browser = browserSupport.getExternalBrowser();
            browser.openURL(URI.create(browserUrl).toURL());
            model.setBrowser(browser);
            model.setBrowserId(browserId);
            browserIdToModel.put(browserId, model);
            ZCeeUILogger.info((String)"added external browser to cache, browserId={0}", (Object[])new Object[]{model.getBrowserId()});
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"openApiExplorerInBrowser", (Object[])new Object[0]);
    }

    public void startServer() throws Exception {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"startServer", (Object[])new Object[0]);
        Job job = new Job(Xlat.description((String)"STATUS_STARTING_SWAGGER_UI")){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    SwaggerUIController.this.setupServer();
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                    result = new Status(4, "com.ibm.zosconnect.ui.controllers", e.getMessage(), (Throwable)e);
                }
                return result;
            }
        };
        job.schedule();
        job.join();
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"startServer", (Object[])new Object[0]);
    }

    public void stopServer() throws Exception {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"stopServer", (Object[])new Object[0]);
        Job job = new Job(Xlat.description((String)"STATUS_STOPPING_SWAGGER_UI")){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    SwaggerUIController.this.tearDownServer();
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                    result = new Status(4, "com.ibm.zosconnect.ui.controllers", e.getMessage(), (Throwable)e);
                }
                return result;
            }
        };
        job.schedule();
        job.join();
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"stopServer", (Object[])new Object[0]);
    }

    private void setupServer() throws Exception {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"setupServer", (Object[])new Object[0]);
        if (this.jettyServer != null && (this.jettyServer.isRunning() || this.jettyServer.isStarted())) {
            return;
        }
        this.tearDownServer();
        this.jettyServer = new Server();
        this.jettyConnector = new ServerConnector(this.jettyServer);
        this.jettyConnector.setHost("localhost");
        this.jettyConnector.setPort(0);
        this.jettyServer.addConnector((Connector)this.jettyConnector);
        this.jettyServer.setStopAtShutdown(true);
        this.jettyResourceHandler = new ResourceHandler();
        this.jettyResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        File swaggerDistDir = ZCeeUIResourcePlugin.getBundleContent((String)"swagger-ui");
        this.jettyResourceBase = FileUtilz.getTempDir();
        this.jettyResourceHandler.setBaseResourceAsString(this.jettyResourceBase.getAbsolutePath());
        FileUtils.copyDirectory((File)swaggerDistDir, (File)this.jettyResourceBase);
        this.jettyApiDocsDir = FileUtilz.getUniqueDirectory((File)this.jettyResourceBase, (String)"api-docs");
        this.jettyHandlers = new Handler.Sequence(new Handler[0]);
        this.jettyHandlers.setHandlers(new Handler[]{this.jettyResourceHandler, new DefaultHandler()});
        this.jettyServer.setHandler((Handler)this.jettyHandlers);
        this.jettyServer.start();
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"setupServer", (Object[])new Object[0]);
    }

    private void tearDownServer() throws Exception {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"tearDownServer", (Object[])new Object[0]);
        if (this.jettyServer != null) {
            this.jettyServer.stop();
            this.jettyServer = null;
            this.jettyConnector = null;
            this.jettyResourceHandler = null;
            FileUtils.deleteDirectory((File)this.jettyResourceBase);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"tearDownServer", (Object[])new Object[0]);
    }

    public boolean closeBrowser(ZosConnectApiDetail apiDetail, IZCeeAdminApiConnection connection) {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"closeBrowser", (Object[])new Object[0]);
        final String browserId = this.generateBrowserId(apiDetail, connection);
        final BrowserModel model = browserIdToModel.get(browserId);
        if (model == null) {
            ZCeeUILogger.info((String)"no browser instance to close, browserId={0}", (Object[])new Object[]{browserId});
            return false;
        }
        final boolean[] closed = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWebBrowser browser;
                    IWorkbenchPage workbenchPage;
                    IEditorSite editorSite;
                    IEditorPart editorPart = model.getBrowserEditorPart();
                    if (editorPart != null && (editorSite = editorPart.getEditorSite()) != null && (workbenchPage = editorSite.getPage()) != null) {
                        ZCeeUILogger.info((String)"closing {0}, browserId={1}", (Object[])new Object[]{SWTBrowserFormEditor.TAG, model.getBrowserId()});
                        closed[0] = workbenchPage.closeEditor(editorPart, true);
                    }
                    if ((browser = model.getBrowser()) != null) {
                        ZCeeUILogger.info((String)"closing external browser, browserId={0}...", (Object[])new Object[]{browserId});
                        closed[0] = model.getBrowser().close();
                    }
                    FileUtils.deleteQuietly((File)model.getSwaggerFile());
                    browserIdToModel.remove(browserId);
                    ZCeeUILogger.info((String)"{0} removed from cache, browserId={1}", (Object[])new Object[]{SWTBrowserFormEditor.TAG, browserId});
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                }
            }
        });
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"closeBrowser", (Object[])new Object[0]);
        return closed[0];
    }

    public boolean updateBrowser(ZosConnectApiDetail apiDetail, IZCeeAdminApiConnection connection) throws Exception {
        boolean isApiExplorer;
        boolean retVal = false;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"updateBrowser", (Object[])new Object[0]);
        String browserId = this.generateBrowserId(apiDetail, connection);
        BrowserModel model = browserIdToModel.get(browserId);
        boolean bl = isApiExplorer = model != null ? model.isApiExplorer : false;
        if (this.closeBrowser(apiDetail, connection)) {
            if (isApiExplorer) {
                this.openApiExplorer(apiDetail, connection);
            } else {
                this.openSwaggerUI(apiDetail, connection);
            }
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"updateBrowser", (Object[])new Object[0]);
        return retVal;
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if ("com.ibm.zosconnect.ui.swtbrowser".equals(partRef.getId())) {
            ArrayList<BrowserModel> removeFromCache = new ArrayList<BrowserModel>();
            for (BrowserModel model : browserIdToModel.values()) {
                if (!StringUtils.equals((CharSequence)model.getApiName(), (CharSequence)partRef.getTitle()) || !StringUtils.equals((CharSequence)model.getApiUrl(), (CharSequence)partRef.getTitleToolTip())) continue;
                removeFromCache.add(model);
                ZCeeUILogger.info((String)"{0} closed manually, browserId={1}", (Object[])new Object[]{SWTBrowserFormEditor.TAG, model.getBrowserId()});
            }
            for (BrowserModel model : removeFromCache) {
                browserIdToModel.remove(model.getBrowserId());
                ZCeeUILogger.info((String)"{0} removed from cache, browserId={1}", (Object[])new Object[]{SWTBrowserFormEditor.TAG, model.getBrowserId()});
            }
        }
    }

    public void partActivated(IWorkbenchPartReference arg0) {
    }

    public void partBroughtToTop(IWorkbenchPartReference arg0) {
    }

    public void partDeactivated(IWorkbenchPartReference arg0) {
    }

    public void partHidden(IWorkbenchPartReference arg0) {
    }

    public void partInputChanged(IWorkbenchPartReference arg0) {
    }

    public void partOpened(IWorkbenchPartReference arg0) {
    }

    public void partVisible(IWorkbenchPartReference arg0) {
    }

    public class BrowserModel {
        private String browserId = "";
        private boolean isApiExplorer;
        private IWebBrowser browser;
        private IEditorPart browserEditorPart;
        private String apiName = "";
        private String apiUrl = "";
        private String swaggerFileName = "";
        private File swaggerFile;
        private String apiBasePath = "";

        public IWebBrowser getBrowser() {
            return this.browser;
        }

        public void setBrowser(IWebBrowser browser) {
            this.browser = browser;
        }

        public IEditorPart getBrowserEditorPart() {
            return this.browserEditorPart;
        }

        public void setBrowserEditorPart(IEditorPart browserEditorPart) {
            this.browserEditorPart = browserEditorPart;
        }

        public String getBrowserId() {
            return this.browserId;
        }

        public void setBrowserId(String browserId) {
            this.browserId = browserId;
        }

        public String getApiName() {
            return this.apiName;
        }

        public void setApiName(String apiName) {
            this.apiName = apiName;
        }

        public String getApiUrl() {
            return this.apiUrl;
        }

        public void setApiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
        }

        public String getSwaggerFileName() {
            return this.swaggerFileName;
        }

        public void setSwaggerFileName(String swaggerFileName) {
            this.swaggerFileName = swaggerFileName;
        }

        public File getSwaggerFile() {
            return this.swaggerFile;
        }

        public void setSwaggerFile(File swaggerFile) {
            this.swaggerFile = swaggerFile;
        }

        public String getApiBasePath() {
            return this.apiBasePath;
        }

        public void setApiBasePath(String apiBasePath) {
            this.apiBasePath = apiBasePath;
        }

        public boolean isApiExplorer() {
            return this.isApiExplorer;
        }

        public void setApiExplorer(boolean isApiExplorer) {
            this.isApiExplorer = isApiExplorer;
        }
    }
}

