/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.dom.wrappers;

import com.ibm.zosconnect.ui.controllers.dom.ParserWrapper;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class Xerces
implements ParserWrapper,
ParserWrapper.DocumentInfo,
ErrorHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DOMParser parser = new DOMParser();

    public Xerces() {
        this.parser.setErrorHandler((ErrorHandler)this);
    }

    @Override
    public Document parse(String uri) throws Exception {
        this.parser.parse(uri);
        return this.parser.getDocument();
    }

    @Override
    public Document parse(InputSource input) throws Exception {
        this.parser.parse(input);
        return this.parser.getDocument();
    }

    @Override
    public void setFeature(String featureId, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setFeature(featureId, state);
    }

    @Override
    public ParserWrapper.DocumentInfo getDocumentInfo() {
        return this;
    }

    @Override
    public boolean isIgnorableWhitespace(Text text) {
        return ((TextImpl)text).isIgnorableWhitespace();
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
        throw ex;
    }

    protected void printError(String type, SAXParseException ex) {
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(ex.getLineNumber());
        System.err.print(':');
        System.err.print(ex.getColumnNumber());
        System.err.print(": ");
        System.err.print(ex.getMessage());
        System.err.println();
        System.err.flush();
    }
}

