/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.dom;

import com.ibm.zosconnect.ui.controllers.api.EditedParmsBean;
import com.ibm.zosconnect.ui.controllers.dom.ParserWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Writer {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String DEFAULT_PARSER_NAME = "com.ibm.zosconnect.ui.controllers.dom.wrappers.Xerces";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected static final boolean DEFAULT_CANONICAL = false;
    private boolean cdataNodeIsHttpInput = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected boolean fXML11;
    private EditedParmsBean editedPathParms;
    private EditedParmsBean editedQueryParms;
    private boolean shouldUpdatePathParms;
    private boolean shouldUpdateQueryParms;
    private String resourceId;
    private Document document;

    public Writer(EditedParmsBean editedPathParms, EditedParmsBean editedQueryParms, String resourceId) {
        this.cdataNodeIsHttpInput = false;
        this.editedPathParms = editedPathParms;
        this.editedQueryParms = editedQueryParms;
        this.resourceId = resourceId;
        if (editedPathParms != null) {
            this.shouldUpdatePathParms = editedPathParms.addedParms != null && editedPathParms.addedParms.size() > 0 || editedPathParms.removedParms != null && editedPathParms.removedParms.size() > 0;
        }
        if (editedQueryParms != null) {
            this.shouldUpdateQueryParms = editedQueryParms.addedParms != null && editedQueryParms.addedParms.size() > 0 || editedQueryParms.removedParms != null && editedQueryParms.removedParms.size() > 0;
        }
    }

    public Writer(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setCanonical(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setOutput(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, encoding);
        this.fOut = new PrintWriter(writer);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void write(Node node) throws Exception {
        String nodeName;
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.document = (Document)node;
                this.fXML11 = "1.1".equals(this.getVersion(this.document));
                if (!this.fCanonical) {
                    if (this.fXML11) {
                        this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                    } else {
                        this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    this.fOut.flush();
                    this.write(this.document.getDoctype());
                }
                this.write(this.document.getDocumentElement());
                break;
            }
            case 10: {
                DocumentType doctype = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(doctype.getName());
                String publicId = doctype.getPublicId();
                String systemId = doctype.getSystemId();
                if (publicId != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(publicId);
                    this.fOut.print("' '");
                    this.fOut.print(systemId);
                    this.fOut.print('\'');
                } else if (systemId != null) {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(systemId);
                    this.fOut.print('\'');
                }
                String internalSubset = doctype.getInternalSubset();
                if (internalSubset != null) {
                    this.fOut.println(" [");
                    this.fOut.print(internalSubset);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                this.fOut.print('<');
                nodeName = node.getNodeName();
                this.fOut.print(nodeName);
                if (this.shouldUpdatePathParms && this.nodeIsPathParmsSequence(node)) {
                    this.updatePathParmsUnderSequence(node);
                }
                if (this.shouldUpdateQueryParms && this.nodeIsQueryParmsSequence(node)) {
                    this.updateQueryParmsUnderSequence(node);
                }
                if (this.nodeIsHttpInputSchema(node)) {
                    this.cdataNodeIsHttpInput = true;
                }
                if (this.nodeIsMappingDeclaration(node)) {
                    ((Element)node).setAttribute("name", this.resourceId);
                }
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    this.fOut.print(' ');
                    this.fOut.print(attr.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(attr.getNodeValue(), true);
                    this.fOut.print('\"');
                    ++i;
                }
                this.fOut.print('>');
                this.fOut.flush();
                Node child = node.getFirstChild();
                while (child != null) {
                    this.write(child);
                    child = child.getNextSibling();
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    Node child = node.getFirstChild();
                    while (child != null) {
                        this.write(child);
                        child = child.getNextSibling();
                    }
                    break;
                }
                this.fOut.print('&');
                nodeName = node.getNodeName();
                this.fOut.print(nodeName);
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue(), false);
                } else {
                    this.fOut.print("<![CDATA[");
                    Object cdataValue = node.getNodeValue();
                    if (this.cdataNodeIsHttpInput) {
                        cdataValue = ((String)cdataValue).trim();
                        cdataValue = this.editParmsInHttpInputSchema((String)cdataValue);
                        cdataValue = "\n\n" + (String)cdataValue;
                        this.cdataNodeIsHttpInput = false;
                    }
                    this.fOut.print((String)cdataValue);
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue(), false);
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                nodeName = node.getNodeName();
                this.fOut.print(nodeName);
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(data);
                }
                this.fOut.print("?>");
                this.fOut.flush();
                break;
            }
            case 8: {
                if (this.fCanonical) break;
                this.fOut.print("<!--");
                String comment = node.getNodeValue();
                if (comment != null && comment.length() > 0) {
                    this.fOut.print(comment);
                }
                this.fOut.print("-->");
                this.fOut.flush();
            }
        }
        if (type == 1) {
            this.fOut.print("</");
            nodeName = node.getNodeName();
            this.fOut.print(nodeName);
            this.fOut.print('>');
            this.fOut.flush();
        }
    }

    private boolean nodeIsHttpInputSchema(Node node) {
        boolean retVal = false;
        NamedNodeMap nodeAttrs = node.getAttributes();
        Node tnsNode = nodeAttrs.getNamedItem("targetNamespace");
        if (tnsNode != null) {
            String tnsValue;
            short tnsNodeType = tnsNode.getNodeType();
            if (node.getNodeName().equals("inlinedXMLSchema") && tnsNodeType == 2 && (tnsValue = tnsNode.getNodeValue()).startsWith("http://www.ibm.com/zosConnect/2.0/mapping/HTTP/input/")) {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean nodeIsMappingDeclaration(Node node) {
        boolean retVal = false;
        String nodeName = node.getNodeName();
        if (nodeName.equals("mappingDeclaration")) {
            retVal = true;
        }
        return retVal;
    }

    private boolean nodeIsPathParmsSequence(Node node) {
        NamedNodeMap parentNodeAttrs;
        Node attrNode;
        String parentNameValue;
        Node parentNode;
        String parentNodeName;
        boolean retVal = false;
        String nodeName = node.getNodeName();
        if (nodeName.equals("xsd:sequence") && (parentNodeName = (parentNode = node.getParentNode()).getNodeName()).equals("xsd:complexType") && (parentNameValue = (attrNode = (parentNodeAttrs = parentNode.getAttributes()).getNamedItem("name")).getNodeValue()) != null && parentNameValue.equals("PathParametersType")) {
            retVal = true;
        }
        return retVal;
    }

    private boolean nodeIsQueryParmsSequence(Node node) {
        NamedNodeMap parentNodeAttrs;
        Node attrNode;
        String parentNameValue;
        Node parentNode;
        String parentNodeName;
        boolean retVal = false;
        String nodeName = node.getNodeName();
        if (nodeName.equals("xsd:sequence") && (parentNodeName = (parentNode = node.getParentNode()).getNodeName()).equals("xsd:complexType") && (parentNameValue = (attrNode = (parentNodeAttrs = parentNode.getAttributes()).getNamedItem("name")).getNodeValue()) != null && parentNameValue.equals("QueryParametersType")) {
            retVal = true;
        }
        return retVal;
    }

    private void updatePathParmsUnderSequence(Node sequenceNode) {
        if (this.editedPathParms.removedParms != null && this.editedPathParms.removedParms.size() > 0) {
            block0: for (String currRemovedParm : this.editedPathParms.removedParms) {
                Node currChildNode = sequenceNode.getFirstChild();
                while (currChildNode != null) {
                    NamedNodeMap nodeAttrs;
                    Node nameNode;
                    String nameAttr;
                    String currNodeName = currChildNode.getNodeName();
                    if (currNodeName != null && currNodeName.equals("xsd:element") && (nameAttr = (nameNode = (nodeAttrs = currChildNode.getAttributes()).getNamedItem("name")).getNodeValue()).equals(currRemovedParm)) {
                        sequenceNode.removeChild(currChildNode);
                        continue block0;
                    }
                    currChildNode = currChildNode.getNextSibling();
                }
            }
        }
        if (this.editedPathParms.addedParms != null && this.editedPathParms.addedParms.size() > 0) {
            for (String currAddedParm : this.editedPathParms.addedParms) {
                Element newChild = this.document.createElement("xsd:element");
                newChild.setAttribute("name", currAddedParm);
                newChild.setAttribute("type", "xsd:string");
                newChild.setAttribute("minOccurs", "1");
                newChild.setAttribute("maxOccurs", "1");
                sequenceNode.appendChild(newChild);
            }
        }
    }

    private void updateQueryParmsUnderSequence(Node sequenceNode) {
        if (this.editedQueryParms.removedParms != null && this.editedQueryParms.removedParms.size() > 0) {
            block0: for (String currRemovedParm : this.editedQueryParms.removedParms) {
                Node currChildNode = sequenceNode.getFirstChild();
                while (currChildNode != null) {
                    NamedNodeMap nodeAttrs;
                    Node nameNode;
                    String nameAttr;
                    String currNodeName = currChildNode.getNodeName();
                    if (currNodeName != null && currNodeName.equals("xsd:element") && (nameAttr = (nameNode = (nodeAttrs = currChildNode.getAttributes()).getNamedItem("name")).getNodeValue()).equals(currRemovedParm)) {
                        sequenceNode.removeChild(currChildNode);
                        continue block0;
                    }
                    currChildNode = currChildNode.getNextSibling();
                }
            }
        }
        if (this.editedQueryParms.addedParms != null && this.editedQueryParms.addedParms.size() > 0) {
            List<String> existingQueryParamNames = this.getChildXsdElementNames(sequenceNode);
            for (String currAddedParm : this.editedQueryParms.addedParms) {
                if (existingQueryParamNames.contains(currAddedParm)) continue;
                Element newChild = this.document.createElement("xsd:element");
                newChild.setAttribute("name", currAddedParm);
                newChild.setAttribute("type", "xsd:string");
                sequenceNode.appendChild(newChild);
            }
        }
    }

    private String editParmsInHttpInputSchema(String schemaStr) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(schemaStr.getBytes());
        InputSource parseInput = new InputSource(bais);
        ParserWrapper parser = (ParserWrapper)Class.forName(DEFAULT_PARSER_NAME).newInstance();
        Document document = parser.parse(parseInput);
        Writer writer = new Writer(this.editedPathParms, this.editedQueryParms, this.resourceId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.setOutput(baos, "UTF8");
        writer.write(document);
        return baos.toString();
    }

    private List<String> getChildXsdElementNames(Node sequenceNode) {
        ArrayList<String> retVal = new ArrayList<String>();
        NodeList sequenceContent = sequenceNode.getChildNodes();
        int index = 0;
        while (index < sequenceContent.getLength()) {
            String elementName;
            Node node = sequenceContent.item(index);
            if (node instanceof Element && "xsd:element".equals(node.getNodeName()) && StringUtils.isNotBlank((CharSequence)(elementName = ((Element)node).getAttribute("name")))) {
                retVal.add(elementName);
            }
            ++index;
        }
        return retVal;
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        i = 0;
        while (i < len - 1) {
            String name = array[i].getNodeName();
            int index = i;
            int j = i + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i) {
                Attr temp = array[i];
                array[i] = array[index];
                array[index] = temp;
            }
            ++i;
        }
        return array;
    }

    protected void normalizeAndPrint(String s, boolean isAttValue) {
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c, isAttValue);
            ++i;
        }
    }

    protected void normalizeAndPrint(char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected String getVersion(Document document) {
        if (document == null) {
            return null;
        }
        String version = null;
        Method getXMLVersion = null;
        try {
            getXMLVersion = document.getClass().getMethod("getXmlVersion", new Class[0]);
            if (getXMLVersion != null) {
                version = (String)getXMLVersion.invoke((Object)document, null);
            }
        }
        catch (Exception exception) {}
        return version;
    }
}

