/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.api;

import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.mapping.service.MappingContextType;
import com.ibm.zosconnect.api.mapping.service.MappingMessageType;
import com.ibm.zosconnect.api.mapping.service.MappingModelType;
import com.ibm.zosconnect.api.mapping.service.MappingModelTypeValues;
import com.ibm.zosconnect.api.mapping.service.ObjectFactory;
import com.ibm.zosconnect.api.mapping.service.RequestMessageType;
import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.api.mapping.service.ZosConnectServiceMapping;
import com.ibm.zosconnect.api.rules.BooleanExpression;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.FileUtilz;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.URIUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.api.ZosConnectJAXBModelUtil;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.MappingRootController;
import com.ibm.zosconnect.ui.controllers.api.OpenApi2xController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.jet.msl.RequestMSLWithInlinedXMLSchema;
import com.ibm.zosconnect.ui.jet.msl.ResponseMSLWithInlinedXMLSchema;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.IJsd2XsdConverterVisitor;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.Jsd2XsdConverter;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.Jsd2XsdConverterFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ServiceMappingController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ObjectFactory factory = ZosConnectJAXBModelUtil.getFactory_ZosConnectServiceMapping();
    public static final String MAPPING_MODEL_VERSION = "1.0";
    private PathType pathType;
    private MethodType methodType;
    private ApiProjectController apiProjectController;
    private ApiModelController apiModelController;
    private ServiceArchiveController serviceArchiveController;
    private OpenApi2xController apiDocsController;
    private ZosConnectServiceMapping serviceMapping;
    private List<ResponseMessageType> removedResponseMessages = new ArrayList<ResponseMessageType>();
    private boolean dirty = false;

    public ServiceMappingController(PathType pathType, MethodType methodType, ApiProjectController apiProjectController, ApiModelController apiModelController) throws Exception {
        this.pathType = pathType;
        this.methodType = methodType;
        this.apiProjectController = apiProjectController;
        this.apiModelController = apiModelController;
        this.apiDocsController = new OpenApi2xController(apiProjectController, apiModelController);
        this.initServiceMapping();
    }

    public ServiceMappingController(PathType pathType, MethodType methodType, ApiProjectController apiProjectController, ApiModelController apiModelController, ServiceArchiveController serviceArchiveController) throws Exception {
        this(pathType, methodType, apiProjectController, apiModelController);
        this.serviceArchiveController = serviceArchiveController;
    }

    public ServiceMappingController() {
    }

    private void initServiceMapping() throws Exception {
        ServiceMappingController.generateResourceId(this.pathType);
        this.serviceMapping = this.unmarshall();
        this.updateServiceMapping();
    }

    public void updateServiceMapping(boolean marshall) throws Exception {
        this.updateServiceMapping();
        if (marshall) {
            this.marshall();
        }
    }

    private void updateServiceMapping() throws Exception {
        if (this.serviceMapping != null) {
            this.updateServiceMapping(this.apiModelController.getApiBasePath(), this.pathType.getRelativePath(), this.methodType.getType(), this.getServiceName());
        } else {
            this.serviceMapping = ServiceMappingController.createDefaultServiceMapping(this.apiModelController.getApiBasePath(), this.pathType.getRelativePath(), this.methodType.getType(), this.getServiceName());
            this.dirty = true;
        }
        if (this.getDefaultResponseCode() == null) {
            ResponseMessageType responseMessage = (ResponseMessageType)ListUtilz.getLastMember((List)this.serviceMapping.getResponseMessages());
            if (responseMessage == null) {
                responseMessage = factory.createResponseMessageType();
                responseMessage.setCode(Integer.valueOf(HttpStatusCodes.OK.getCode()));
                responseMessage.setDescription(HttpStatusCodes.OK.getDescription());
                this.addResponseMessage(responseMessage);
            }
            this.setDefaultResponseCode(responseMessage.getCode());
        }
    }

    private void updateServiceMapping(String apiBasePath, String relativePath, MethodValues methodValue, String serviceName) throws Exception {
        this.setMappingSpecVersion(MAPPING_MODEL_VERSION);
        if (this.serviceMapping.getMappingContext() != null) {
            this.setBasePath(apiBasePath);
            this.setRelativePath(relativePath);
            this.setMethod(methodValue.toString());
            this.setServiceName(serviceName);
        } else {
            this.serviceMapping.setMappingContext(ServiceMappingController.createMappingContext(apiBasePath, relativePath, methodValue, serviceName));
            this.dirty = true;
        }
    }

    public void setMappingSpecVersion(String mappingSpecVersion) {
        if (this.serviceMapping != null && !StringUtils.equals((CharSequence)this.serviceMapping.getMappingSpecVersion(), (CharSequence)mappingSpecVersion)) {
            this.serviceMapping.setMappingSpecVersion(StringUtils.trimToEmpty((String)mappingSpecVersion));
            this.dirty = true;
        }
    }

    public String getMappingSpecVersion() {
        String mappingSpecVersion = null;
        if (this.serviceMapping != null) {
            mappingSpecVersion = this.serviceMapping.getMappingSpecVersion();
        }
        return mappingSpecVersion;
    }

    public void setBasePath(String basePath) {
        MappingContextType mappingContext;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null && !StringUtils.equals((CharSequence)(mappingContext = this.serviceMapping.getMappingContext()).getBasePath(), (CharSequence)basePath)) {
            mappingContext.setBasePath(StringUtils.trimToEmpty((String)basePath));
            this.dirty = true;
        }
    }

    public String getBasePath() {
        String basePath = null;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null) {
            MappingContextType mappingContext = this.serviceMapping.getMappingContext();
            basePath = mappingContext.getBasePath();
        }
        return basePath;
    }

    public void setMethod(String method) {
        MappingContextType mappingContext;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null && !StringUtils.equals((CharSequence)(mappingContext = this.serviceMapping.getMappingContext()).getMethod(), (CharSequence)method)) {
            mappingContext.setMethod(method);
            this.dirty = true;
        }
    }

    public String getMethod() {
        String method = null;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null) {
            MappingContextType mappingContext = this.serviceMapping.getMappingContext();
            method = mappingContext.getMethod();
        }
        return method;
    }

    public void setServiceName(String serviceName) {
        MappingContextType mappingContext;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null && !StringUtils.equals((CharSequence)(mappingContext = this.serviceMapping.getMappingContext()).getServiceName(), (CharSequence)serviceName)) {
            mappingContext.setServiceName(serviceName);
            this.dirty = true;
        }
    }

    public String getServiceName() {
        String serviceName = null;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null) {
            MappingContextType mappingContext = this.serviceMapping.getMappingContext();
            serviceName = mappingContext.getServiceName();
        }
        return serviceName;
    }

    public void deleteServiceMapping() throws Exception {
        IFolder mappingFolder = this.apiProjectController.getMappingFolderWithoutCreate(this.pathType, this.methodType.getType());
        if (mappingFolder != null && mappingFolder.exists()) {
            mappingFolder.delete(2, (IProgressMonitor)new NullProgressMonitor());
        }
        this.methodType.setHttpXformFile(null);
        this.serviceMapping = null;
    }

    public boolean hasMappings() throws Exception {
        boolean hasRequestMapping = this.hasRequestMapping();
        boolean hasResponseMapping = false;
        if (this.serviceMapping != null) {
            Iterator<ResponseMessageType> responsesIt = this.getResponseMessages().iterator();
            while (!hasResponseMapping && responsesIt.hasNext()) {
                hasResponseMapping = this.hasMapping((MappingMessageType)responsesIt.next());
            }
        }
        return hasRequestMapping || hasResponseMapping;
    }

    public boolean hasMapping(MappingMessageType messageType) throws Exception {
        MappingModelType mappingModel;
        boolean hasMapping = false;
        if (messageType != null && messageType.getMappingRootModel() != null && (mappingModel = messageType.getMappingRootModel()) != null) {
            hasMapping = this.mappingFileExists(mappingModel);
        }
        return hasMapping;
    }

    public boolean hasDefaultResponseMapping() throws Exception {
        return this.hasMapping((MappingMessageType)this.getDefaultResponseMessage());
    }

    public IFile getDefaultResponseMappingFile() throws Exception {
        return this.getResponseMappingFile(this.getDefaultResponseMessage());
    }

    public boolean hasRequestMapping() throws Exception {
        RequestMessageType requestMsgType;
        MappingModelType mappingModel;
        boolean hasMapping = false;
        if (this.serviceMapping != null && this.serviceMapping.getRequestMessage() != null && this.serviceMapping.getRequestMessage().getMappingRootModel() != null && (mappingModel = (requestMsgType = this.serviceMapping.getRequestMessage()).getMappingRootModel()) != null) {
            hasMapping = this.mappingFileExists(mappingModel);
        }
        return hasMapping;
    }

    public boolean generateRequestMapFile() throws Exception {
        IFile requestMappingFile;
        RequestMessageType requestMessageType = this.serviceMapping.getRequestMessage();
        if (requestMessageType == null) {
            requestMessageType = new RequestMessageType();
            this.serviceMapping.setRequestMessage(requestMessageType);
        }
        if ((requestMappingFile = this.getRequestMappingFile()).exists()) {
            requestMessageType.setMappingRootModel(ServiceMappingController.generateMappingModelType(requestMappingFile, MappingModelTypeValues.MSL));
            this.updateServiceMapping(true);
            return false;
        }
        RequestMSLWithInlinedXMLSchema jetMapEmitter = new RequestMSLWithInlinedXMLSchema();
        HashMap<String, Object> subs = new HashMap<String, Object>();
        Object tnsResourceId = null;
        String qNamePrefix = "xsd";
        String methodStr = this.methodType.getType().toString();
        String resourceId = ServiceMappingController.generateResourceId(this.pathType);
        tnsResourceId = resourceId.isEmpty() ? "" : "." + resourceId;
        String targetNamespace = "http://www.ibm.com/zosConnect/2.0/mapping/JSON/output/" + methodStr;
        String targetNamespacePrefix = "tns";
        Jsd2XsdConverterFactory factory = new Jsd2XsdConverterFactory();
        factory.setQNamePrefix(qNamePrefix);
        factory.setTargetNamespace(targetNamespace);
        factory.setTargetNamespacePrefix(targetNamespacePrefix);
        IFolder serviceFolder = this.apiProjectController.getServiceFolder(this.serviceArchiveController.getServiceName(), false);
        IFile requestSchemaFile = serviceFolder.getFile(this.serviceArchiveController.getRequestSchema());
        if (requestSchemaFile.exists()) {
            String filePathStr = requestSchemaFile.getRawLocation().toOSString();
            factory.setJsonFromFilePath(filePathStr);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            factory.setOutputStream(bos);
            final String serviceName = this.serviceArchiveController.getEncodedServiceName();
            factory.setVisitor(new IJsd2XsdConverterVisitor(){

                public String getWrapperObjectName() {
                    return serviceName;
                }
            });
            Jsd2XsdConverter js2xsd = factory.create();
            js2xsd.run();
            String genXsd = bos.toString("UTF-8");
            subs.put("METHOD_KEY", methodStr);
            subs.put("RESOURCE_ID_KEY", tnsResourceId);
            subs.put("JSON_TO_XSD_REQUEST_KEY", genXsd);
            subs.put("TNS_PFX_MAPPING_KEY", "http://www.ibm.com/zosConnect/2.0/mapping/");
            subs.put("TNS_PFX_JSON_OUTPUT_KEY", "http://www.ibm.com/zosConnect/2.0/mapping/JSON/output/");
            subs.put("TNS_PFX_HTTP_INPUT_KEY", "http://www.ibm.com/zosConnect/2.0/mapping/HTTP/input/");
            subs.put("JSON_ROOT_FIELD_NAME_KEY", js2xsd.getGlobalElementName());
            subs.put("JSON_ROOT_FIELD_GENERATED_KEY", js2xsd.isGlobalElementGenerated());
            Set<String> pathParmList = this.getPathParamNames();
            subs.put("PATH_PARM_LIST_KEY", pathParmList);
            Set<String> queryParmList = this.getQueryParamNames();
            subs.put("QUERY_PARM_LIST_KEY", queryParmList);
            String mappingFileContents = jetMapEmitter.generate(subs);
            File mappingFile = new File(requestMappingFile.getRawLocation().toOSString());
            try (FileOutputStream mappingFileOS = new FileOutputStream(mappingFile);){
                mappingFileOS.write(mappingFileContents.getBytes("UTF-8"));
                mappingFileOS.flush();
            }
            this.getMappingFolder().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            requestMessageType.setMappingRootModel(ServiceMappingController.generateMappingModelType(requestMappingFile, MappingModelTypeValues.MSL));
            this.dirty = true;
            return true;
        }
        return false;
    }

    public boolean generateResponseMappingFile(ResponseMessageType responseMessageType) throws Exception {
        IFile responseMappingFile = this.getResponseMappingFile(responseMessageType.getCode());
        if (responseMappingFile.exists()) {
            responseMessageType.setMappingRootModel(ServiceMappingController.generateMappingModelType(responseMappingFile, MappingModelTypeValues.MSL));
            this.updateServiceMapping(true);
            return false;
        }
        ResponseMSLWithInlinedXMLSchema jetMapEmitter = new ResponseMSLWithInlinedXMLSchema();
        HashMap<String, Object> subs = new HashMap<String, Object>();
        Object tnsResourceId = null;
        String qNamePrefix = "xsd";
        String methodStr = this.methodType.getType().toString();
        String resourceId = ServiceMappingController.generateResourceId(this.pathType);
        tnsResourceId = resourceId.isEmpty() ? "" : "." + resourceId;
        String targetNamespace = "http://www.ibm.com/zosConnect/2.0/mapping/JSON/input/" + methodStr;
        String targetNamespacePrefix = "tns";
        Jsd2XsdConverterFactory factory = new Jsd2XsdConverterFactory();
        factory.setQNamePrefix(qNamePrefix);
        factory.setTargetNamespace(targetNamespace);
        factory.setTargetNamespacePrefix(targetNamespacePrefix);
        IFolder serviceFolder = this.apiProjectController.getServiceFolder(this.serviceArchiveController.getServiceName(), false);
        IFile responseSchemaFile = serviceFolder.getFile(this.serviceArchiveController.getResponseSchema());
        String filePathStr = responseSchemaFile.getRawLocation().toOSString();
        factory.setJsonFromFilePath(filePathStr);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        factory.setOutputStream(bos);
        final String serviceName = this.serviceArchiveController.getEncodedServiceName();
        factory.setVisitor(new IJsd2XsdConverterVisitor(){

            public String getWrapperObjectName() {
                return serviceName;
            }
        });
        Jsd2XsdConverter js2xsd = factory.create();
        js2xsd.run();
        String genXsd = bos.toString("UTF-8");
        subs.put("METHOD_KEY", methodStr);
        subs.put("RESOURCE_ID_KEY", tnsResourceId);
        subs.put("JSON_TO_XSD_RESPONSE_KEY", genXsd);
        subs.put("TNS_PFX_MAPPING_KEY", "http://www.ibm.com/zosConnect/2.0/mapping/");
        subs.put("TNS_PFX_JSON_INPUT_KEY", "http://www.ibm.com/zosConnect/2.0/mapping/JSON/input/");
        subs.put("TNS_PFX_HTTP_OUTPUT_KEY", "http://www.ibm.com/zosConnect/2.0/mapping/HTTP/output/");
        subs.put("JSON_ROOT_FIELD_NAME_KEY", js2xsd.getGlobalElementName());
        subs.put("JSON_ROOT_FIELD_GENERATED_KEY", js2xsd.isGlobalElementGenerated());
        String mappingFileContents = jetMapEmitter.generate(subs);
        File mappingFile = new File(responseMappingFile.getRawLocation().toOSString());
        try (FileOutputStream mappingFileOS = new FileOutputStream(mappingFile);){
            mappingFileOS.write(mappingFileContents.getBytes("UTF-8"));
            mappingFileOS.flush();
        }
        this.getMappingFolder().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        responseMessageType.setMappingRootModel(ServiceMappingController.generateMappingModelType(responseMappingFile, MappingModelTypeValues.MSL));
        this.dirty = true;
        return true;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public MethodValues getMethodValue() {
        return this.methodType.getType();
    }

    public Set<String> getPathParamNames() {
        return URIUtilz.getPathParamNamesFromPath((String)this.pathType.getRelativePath());
    }

    public Set<String> getQueryParamNames() {
        return URIUtilz.getQueryParamNamesFromPath((String)this.pathType.getRelativePath());
    }

    private ZosConnectServiceMapping unmarshall(IFile serviceMappingFile, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Xlat.description((String)"STATUS_LOADING_MAPPING"), -1);
        this.serviceMapping = null;
        if (FileUtilz.exists((IFile)serviceMappingFile)) {
            serviceMappingFile.refreshLocal(2, monitor);
            this.serviceMapping = ZosConnectJAXBModelUtil.unmarshall_ZosConnectServiceMapping((IFile)serviceMappingFile);
        }
        return this.serviceMapping;
    }

    private ZosConnectServiceMapping unmarshall(IProgressMonitor monitor) throws Exception {
        return this.unmarshall(this.getServiceMappingFileWithoutCreate(), monitor);
    }

    public ZosConnectServiceMapping unmarshall() throws Exception {
        return this.unmarshall((IProgressMonitor)new NullProgressMonitor());
    }

    private void marshall(IFile serviceMappingFile, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Xlat.description((String)"STATUS_SAVING_MAPPING"), -1);
        ZosConnectJAXBModelUtil.marshall_ZosConnectServiceMapping((ZosConnectServiceMapping)this.serviceMapping, (IFile)serviceMappingFile);
        serviceMappingFile.refreshLocal(2, monitor);
        monitor.done();
    }

    private void marshall(IProgressMonitor monitor) throws Exception {
        this.marshall(this.getServiceMappingFile(), monitor);
    }

    public void marshall() throws Exception {
        this.handleRemovedResponseMessages();
        String httpXformFile = null;
        this.marshall((IProgressMonitor)new NullProgressMonitor());
        IFile serviceMappingFile = this.getServiceMappingFileWithoutCreate();
        if (serviceMappingFile != null && serviceMappingFile.exists()) {
            httpXformFile = serviceMappingFile.getProjectRelativePath().toString();
        }
        this.methodType.setHttpXformFile(httpXformFile);
        this.dirty = false;
    }

    private void handleRemovedResponseMessages() {
        for (ResponseMessageType deletedRespMsg : this.removedResponseMessages) {
            try {
                IFile mapFile;
                String mapFileLocation;
                if (deletedRespMsg.getMappingRootModel() == null || !StringUtils.isNotBlank((CharSequence)(mapFileLocation = deletedRespMsg.getMappingRootModel().getLocation())) || !(mapFile = this.apiProjectController.getProject().getFile(mapFileLocation)).exists()) continue;
                mapFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }
        this.removedResponseMessages.clear();
    }

    public List<ResponseMessageType> getResponseMessages() {
        List<Object> responseMessages = new ArrayList<ResponseMessageType>();
        if (this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null) {
            responseMessages = this.serviceMapping.getResponseMessages();
        }
        return responseMessages;
    }

    public ResponseMessageType getDefaultResponseMessage() {
        return this.getResponseMessage(this.getDefaultResponseCode());
    }

    public ResponseMessageType getResponseMessage(Integer code) {
        if (code != null && this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null) {
            for (ResponseMessageType responseMessageType : this.serviceMapping.getResponseMessages()) {
                if (responseMessageType.getCode() == null || !responseMessageType.getCode().equals(code)) continue;
                return responseMessageType;
            }
        }
        return null;
    }

    public void addResponseMessage(ResponseMessageType responseMessageType) {
        if (this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null) {
            List responseMessageTypes = this.serviceMapping.getResponseMessages();
            responseMessageTypes.add(responseMessageType);
            if (this.serviceMapping.getMappingContext() != null && this.serviceMapping.getMappingContext().getDefaultResponseCode() == null) {
                MappingContextType context = this.serviceMapping.getMappingContext();
                context.setDefaultResponseCode(responseMessageType.getCode());
            }
            this.dirty = true;
        }
    }

    public void removeResponseMessage(ResponseMessageType responseMessageType) {
        if (this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null && this.serviceMapping.getResponseMessages().size() > 0) {
            List responseMessageTypes = this.serviceMapping.getResponseMessages();
            this.removedResponseMessages.add(responseMessageType);
            responseMessageTypes.remove(responseMessageType);
            this.dirty = true;
        }
    }

    public void moveResponseUp(ResponseMessageType sourceresponseMessageType) {
        if (this.isFirstResponse(sourceresponseMessageType)) {
            return;
        }
        List responses = this.serviceMapping.getResponseMessages();
        int sourceMethodTypeIndex = responses.indexOf(sourceresponseMessageType);
        int targetMethodTypeIndex = sourceMethodTypeIndex - 1;
        if (sourceMethodTypeIndex == -1 || targetMethodTypeIndex < 0) {
            return;
        }
        ResponseMessageType targetMethodType = (ResponseMessageType)responses.get(targetMethodTypeIndex);
        responses.set(sourceMethodTypeIndex, targetMethodType);
        responses.set(targetMethodTypeIndex, sourceresponseMessageType);
        this.dirty = true;
    }

    public void moveResponseDown(ResponseMessageType sourceresponseMessageType) {
        if (this.isLastResponse(sourceresponseMessageType)) {
            return;
        }
        List responses = this.serviceMapping.getResponseMessages();
        int sourceMethodTypeIndex = responses.indexOf(sourceresponseMessageType);
        int targetMethodTypeIndex = sourceMethodTypeIndex + 1;
        if (sourceMethodTypeIndex == -1 || targetMethodTypeIndex >= responses.size()) {
            return;
        }
        ResponseMessageType targetMethodType = (ResponseMessageType)responses.get(targetMethodTypeIndex);
        responses.set(sourceMethodTypeIndex, targetMethodType);
        responses.set(targetMethodTypeIndex, sourceresponseMessageType);
        this.dirty = true;
    }

    public IFolder getMappingFolder() throws Exception {
        IFolder mappingFolder = null;
        if (this.apiProjectController != null) {
            mappingFolder = this.apiProjectController.getMappingFolder(this.pathType, this.methodType.getType());
        }
        return mappingFolder;
    }

    public IFolder getMappingFolderWithoutCreate() throws Exception {
        IFolder mappingFolder = null;
        if (this.apiProjectController != null) {
            mappingFolder = this.apiProjectController.getMappingFolderWithoutCreate(this.pathType, this.methodType.getType());
        }
        return mappingFolder;
    }

    public IFile getServiceMappingFile() throws Exception {
        IFile serviceMappingFile = null;
        IFolder mappingFolder = this.getMappingFolder();
        if (mappingFolder != null) {
            serviceMappingFile = mappingFolder.getFile("mapping.xml");
        }
        return serviceMappingFile;
    }

    public IFile getServiceMappingFileWithoutCreate() throws Exception {
        IFile serviceMappingFile = null;
        IFolder mappingFolder = this.getMappingFolderWithoutCreate();
        if (mappingFolder != null) {
            serviceMappingFile = mappingFolder.getFile("mapping.xml");
        }
        return serviceMappingFile;
    }

    public IFile getRequestMappingFile() throws Exception {
        IFile requestMappingFile = null;
        IFolder mappingFolder = this.getMappingFolder();
        if (mappingFolder != null) {
            requestMappingFile = mappingFolder.getFile("request.map");
        }
        return requestMappingFile;
    }

    public IFile getResponseMappingFile(Integer code) throws Exception {
        IFolder mappingFolder;
        IFile responseMappingFile = null;
        if (code != null && (mappingFolder = this.getMappingFolder()) != null) {
            responseMappingFile = mappingFolder.getFile(ServiceMappingController.getResponseMappingFileName(code));
        }
        return responseMappingFile;
    }

    public IFile getResponseMappingFile(ResponseMessageType responseMessageType) throws Exception {
        String mapFileLocation;
        IFile responseMappingFile = null;
        if (responseMessageType.getMappingRootModel() != null && StringUtils.isNotBlank((CharSequence)(mapFileLocation = responseMessageType.getMappingRootModel().getLocation()))) {
            responseMappingFile = this.apiProjectController.getProject().getFile(mapFileLocation);
        }
        return responseMappingFile;
    }

    public String getRelativePath() {
        String relativePath = null;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null) {
            MappingContextType context = this.serviceMapping.getMappingContext();
            relativePath = context.getRelativePath();
        }
        return relativePath;
    }

    public void setRelativePath(String relativePath) {
        MappingContextType context;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null && !StringUtils.equals((CharSequence)(context = this.serviceMapping.getMappingContext()).getRelativePath(), (CharSequence)relativePath)) {
            context.setRelativePath(relativePath);
            this.dirty = true;
        }
    }

    public Integer getDefaultResponseCode() {
        Integer defaultResponseCode = null;
        if (this.serviceMapping != null && this.serviceMapping.getMappingContext() != null) {
            MappingContextType context = this.serviceMapping.getMappingContext();
            defaultResponseCode = context.getDefaultResponseCode();
        }
        return defaultResponseCode;
    }

    public boolean setDefaultResponseCode(Integer defaultResponseCode) {
        boolean isSet = false;
        if (defaultResponseCode != null && this.serviceMapping != null && this.serviceMapping.getMappingContext() != null) {
            MappingContextType context = this.serviceMapping.getMappingContext();
            context.setDefaultResponseCode(defaultResponseCode);
            isSet = true;
            this.dirty = true;
        }
        return isSet;
    }

    public boolean isDefaultResponseCode(Integer responseCode) {
        boolean isDefaultResponseCode = false;
        Integer defaultResponseCode = this.getDefaultResponseCode();
        if (defaultResponseCode == null && responseCode != null) {
            isDefaultResponseCode = true;
        } else if (defaultResponseCode != null && responseCode != null) {
            isDefaultResponseCode = responseCode.equals(defaultResponseCode);
        }
        return isDefaultResponseCode;
    }

    public List<Integer> getDefinedResponseCodes() {
        ArrayList<Integer> responseCodes = new ArrayList<Integer>();
        if (this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null) {
            for (ResponseMessageType responseMessageType : this.serviceMapping.getResponseMessages()) {
                Integer code = responseMessageType.getCode();
                if (code == null) continue;
                responseCodes.add(code);
            }
        }
        return responseCodes;
    }

    public void deleteRequestMapping() throws Exception {
        IFile requestMappingFile = this.getRequestMappingFile();
        if (requestMappingFile.exists()) {
            requestMappingFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.serviceMapping.setRequestMessage(null);
        this.dirty = true;
        this.updateServiceMapping(true);
    }

    public void deleteResponseMapping(ResponseMessageType responseMessageType) throws Exception {
        try {
            try {
                IFile mappingFile;
                MappingModelType mappingModel;
                String mapFileLocation;
                if (responseMessageType != null && responseMessageType.getMappingRootModel() != null && StringUtils.isNotBlank((CharSequence)(mapFileLocation = (mappingModel = responseMessageType.getMappingRootModel()).getLocation())) && (mappingFile = this.apiProjectController.getProject().getFile(mapFileLocation)) != null && mappingFile.exists()) {
                    mappingFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
                responseMessageType.setMappingRootModel(null);
                this.dirty = true;
                this.updateServiceMapping(true);
            }
        }
        finally {
            responseMessageType.setMappingRootModel(null);
            this.dirty = true;
            this.updateServiceMapping(true);
        }
    }

    public void deleteDefaultResponseMapping() throws Exception {
        this.deleteResponseMapping(this.getDefaultResponseMessage());
    }

    public boolean isFirstResponse(ResponseMessageType responseMessageType) {
        boolean isFirst = false;
        if (responseMessageType != null && this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null) {
            isFirst = ListUtilz.isFirstMember((List)this.serviceMapping.getResponseMessages(), (Object)responseMessageType);
        }
        return isFirst;
    }

    public boolean isLastResponse(ResponseMessageType responseMessageType) {
        boolean isLast = false;
        if (responseMessageType != null && this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null) {
            isLast = ListUtilz.isLastMember((List)this.serviceMapping.getResponseMessages(), (Object)responseMessageType);
        }
        return isLast;
    }

    public void reloadRequestMapping() throws Exception {
        IFile requestMappingFile = this.getRequestMappingFile();
        if (requestMappingFile != null && requestMappingFile.exists()) {
            MappingRootController.reloadMappingFile(requestMappingFile);
        }
    }

    public void reloadResponseMapping(ResponseMessageType responseMessageType) throws Exception {
        IFile responseMappingFile = this.getResponseMappingFile(responseMessageType.getCode());
        if (responseMappingFile != null && responseMappingFile.exists()) {
            MappingRootController.reloadMappingFile(responseMappingFile);
        }
    }

    public static String getMappingFileLocation(MappingMessageType messageType) {
        String mapFileLocation;
        String location = null;
        MappingModelType mappingModel = messageType.getMappingRootModel();
        if (mappingModel != null && !(mapFileLocation = StringUtils.trimToEmpty((String)mappingModel.getLocation())).isEmpty()) {
            location = mapFileLocation;
        }
        return location;
    }

    public void setMappingFileLocation(MappingMessageType messageType, String mapFileLocation) {
        MappingModelType mappingModel;
        boolean ownedByThis = false;
        if (messageType != null && this.serviceMapping != null) {
            if (messageType == this.serviceMapping.getRequestMessage()) {
                ownedByThis = true;
            } else if (this.serviceMapping.getResponseMessages() != null && this.serviceMapping.getResponseMessages().contains(messageType)) {
                ownedByThis = true;
            }
        }
        if (ownedByThis && (mappingModel = messageType.getMappingRootModel()) != null && !StringUtils.equals((CharSequence)mappingModel.getLocation(), (CharSequence)mapFileLocation)) {
            mappingModel.setLocation(mapFileLocation);
            this.dirty = true;
        }
    }

    public static String getDescription(ResponseMessageType messageType) {
        String description = null;
        if (messageType != null) {
            description = messageType.getDescription();
        }
        return description;
    }

    public void setDescription(ResponseMessageType responseMessageType, String description) {
        boolean ownedByThis = false;
        if (responseMessageType != null && this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null && this.serviceMapping.getResponseMessages().contains(responseMessageType)) {
            ownedByThis = true;
        }
        if (ownedByThis && !StringUtils.equals((CharSequence)responseMessageType.getDescription(), (CharSequence)description)) {
            responseMessageType.setDescription(description);
            this.dirty = true;
        }
    }

    public void setBooleanExpression(ResponseMessageType responseMessageType, BooleanExpression expression) {
        boolean ownedByThis = false;
        if (responseMessageType != null && this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null && this.serviceMapping.getResponseMessages().contains(responseMessageType)) {
            ownedByThis = true;
        }
        if (ownedByThis) {
            responseMessageType.setBooleanExpression(expression);
            this.dirty = true;
        }
    }

    public static Integer getCode(ResponseMessageType messageType) {
        Integer code = null;
        if (messageType != null) {
            code = messageType.getCode();
        }
        return code;
    }

    public void setCode(ResponseMessageType responseMessageType, Integer code) {
        boolean ownedByThis = false;
        if (responseMessageType != null && this.serviceMapping != null && this.serviceMapping.getResponseMessages() != null && this.serviceMapping.getResponseMessages().contains(responseMessageType)) {
            ownedByThis = true;
        }
        if (ownedByThis && code != null && !code.equals(responseMessageType.getCode())) {
            responseMessageType.setCode(code);
            this.dirty = true;
        }
    }

    public static String getResponseMappingFileName(Integer responseCode) throws Exception {
        String mappingFileName = null;
        if (responseCode != null) {
            mappingFileName = responseCode != 200 ? String.format("response_%d.map", responseCode) : String.format("response.map", new Object[0]);
        }
        return mappingFileName;
    }

    public static ZosConnectServiceMapping createDefaultServiceMapping(String apiBasePath, String relativePath, MethodValues methodValue, String serviceName) throws Exception {
        ZosConnectServiceMapping serviceMapping = factory.createZosConnectServiceMapping();
        serviceMapping.setMappingSpecVersion(MAPPING_MODEL_VERSION);
        MappingContextType context = ServiceMappingController.createMappingContext(apiBasePath, relativePath, methodValue, serviceName);
        serviceMapping.setMappingContext(context);
        ResponseMessageType responseMsg = new ResponseMessageType();
        responseMsg.setCode(Integer.valueOf(HttpStatusCodes.OK.getCode()));
        responseMsg.setDescription(HttpStatusCodes.OK.getDescription());
        serviceMapping.getResponseMessages().add(responseMsg);
        context.setDefaultResponseCode(Integer.valueOf(HttpStatusCodes.OK.getCode()));
        return serviceMapping;
    }

    public static MappingContextType createMappingContext(String apiBasePath, String relativePath, MethodValues methodValue, String serviceName) throws Exception {
        MappingContextType context = factory.createMappingContextType();
        context.setBasePath(apiBasePath);
        context.setRelativePath(relativePath);
        context.setMethod(methodValue.toString());
        context.setServiceName(serviceName);
        return context;
    }

    public static MappingModelType generateMappingModelType(IFile mappingFile, MappingModelTypeValues modelTypeValue) throws Exception {
        MappingModelType mappingModelType = new MappingModelType();
        if (mappingFile != null) {
            mappingModelType.setLocation(mappingFile.getProjectRelativePath().toString());
            mappingModelType.setType(modelTypeValue);
        } else {
            mappingModelType.setLocation(null);
            mappingModelType.setType(null);
        }
        return mappingModelType;
    }

    public static String generateResourceId(PathType pathType) {
        Object resourceId = "";
        String path = StringUtils.trimToEmpty((String)pathType.getRelativePath());
        path = StringUtils.removePattern((String)path, (String)"\\s+");
        path = StringUtils.removePattern((String)path, (String)"\\?.+");
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSegment = stringArray[n2];
            if (!pathSegment.isEmpty()) {
                resourceId = ((String)resourceId).isEmpty() ? pathSegment : (String)resourceId + "." + pathSegment;
            }
            ++n2;
        }
        return resourceId;
    }

    public boolean mappingFileExists(MappingModelType mappingModel) {
        boolean mappingFileExists = false;
        if (mappingModel != null && mappingModel.getLocation() != null && this.apiProjectController != null && this.apiProjectController.getProject() != null) {
            String mappingFileLocation = StringUtils.trimToEmpty((String)mappingModel.getLocation());
            IFile mappingFile = null;
            if (!mappingFileLocation.isEmpty()) {
                IProject project = this.apiProjectController.getProject();
                mappingFile = project.getFile(mappingFileLocation);
            }
            if (mappingFile != null && mappingFile.exists()) {
                mappingFileExists = true;
            }
        }
        return mappingFileExists;
    }

    public ZosConnectServiceMapping getServiceMapping() {
        return this.serviceMapping;
    }

    public ServiceArchiveController getServiceArchiveController() {
        return this.serviceArchiveController;
    }

    public void setServiceArchiveController(ServiceArchiveController serviceArchiveController) {
        this.serviceArchiveController = serviceArchiveController;
        if (serviceArchiveController != null) {
            try {
                this.setServiceName(serviceArchiveController.getServiceName());
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }
    }

    public String getOperationId() {
        String operationId = null;
        if (this.methodType != null) {
            operationId = this.methodType.getOperationId();
        }
        return operationId;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public ApiProjectController getApiProjectController() {
        return this.apiProjectController;
    }

    public ApiModelController getApiModelController() {
        return this.apiModelController;
    }

    public OpenApi2xController getApiDocsController() {
        return this.apiDocsController;
    }
}

