/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.api;

import com.ibm.zosconnect.sar.ZosConnectServiceArchiveManifest;
import com.ibm.zosconnect.sar.ZosConnectServiceArchiveObject;
import com.ibm.zosconnect.ui.common.util.URIUtilz;
import com.ibm.zosconnect.ui.controllers.ZCeeUIControllersPlugin;
import com.ibm.zosconnect.ui.controllers.walkers.ModelLeafPropertyVisitor;
import com.ibm.zosconnect.ui.controllers.walkers.SwaggerModelWalker;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ServiceArchiveController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static Pattern SERVICE_NAME_REGEX = Pattern.compile("[A-Za-z0-9 \\-\\._~:/?#\\[\\]@!$&'()*+,;=]+");
    private File sarResource;
    private File currentLocation;
    private ZosConnectServiceArchiveManifest manifest;

    public ServiceArchiveController(File sarResource) throws Exception {
        this.sarResource = sarResource;
        if (sarResource.isDirectory()) {
            this.currentLocation = sarResource;
        }
    }

    public ServiceArchiveController(IResource sarResource) throws Exception {
        this(sarResource.getLocation().toFile());
    }

    public File extractToStateLocation() throws Exception {
        if (this.sarResource.isFile()) {
            ZipFile zip = new ZipFile(this.sarResource);
            this.currentLocation = ZCeeUIControllersPlugin.getTempDir();
            zip.extractAll(this.currentLocation.getAbsolutePath());
        } else if (this.sarResource.isDirectory()) {
            this.currentLocation = this.sarResource;
        }
        return this.currentLocation;
    }

    public void deleteFromStateLocation() throws Exception {
        if (this.sarResource instanceof IFile) {
            if (this.currentLocation != null) {
                FileUtils.deleteDirectory((File)this.currentLocation);
                this.currentLocation = null;
            }
        } else {
            boolean cfr_ignored_0 = this.sarResource instanceof IContainer;
        }
    }

    private File getManifestFile() throws Exception {
        IPath manifestPath = new Path(this.currentLocation.getAbsolutePath()).append("manifest.yml");
        return manifestPath.toFile();
    }

    public ZosConnectServiceArchiveManifest getManifest() throws Exception {
        if (this.manifest != null) {
            return this.manifest;
        }
        this.manifest = (ZosConnectServiceArchiveManifest)Yaml.mapper().readValue(this.getManifestFile(), ZosConnectServiceArchiveManifest.class);
        return this.manifest;
    }

    public String getServiceName() throws Exception {
        return this.getManifest().getName();
    }

    public String getEncodedServiceName() throws Exception {
        return URIUtilz.encodeResourceName((String)this.getManifest().getName());
    }

    public String getServiceDescription() throws Exception {
        return this.getManifest().getDescription();
    }

    public String getProviderName() throws Exception {
        return this.getManifest().getProvider();
    }

    public Model getRequestSchemaModel() throws Exception {
        Model retVal = null;
        IPath absPath = new Path(this.currentLocation.getAbsolutePath()).append(this.getRequestSchema());
        File schemaFile = absPath.toFile();
        if (schemaFile.exists()) {
            retVal = (Model)Json.mapper().readValue(absPath.toFile(), Model.class);
        }
        return retVal;
    }

    public Model getResponseSchemaModel() throws Exception {
        Model retVal = null;
        IPath absPath = new Path(this.currentLocation.getAbsolutePath()).append(this.getResponseSchema());
        File schemaFile = absPath.toFile();
        if (schemaFile.exists()) {
            retVal = (Model)Json.mapper().readValue(absPath.toFile(), Model.class);
        }
        return retVal;
    }

    public IPath getRequestSchema() throws Exception {
        String Value = this.getManifest().getRequestSchema().getValue();
        if (StringUtils.startsWith((CharSequence)Value, (CharSequence)"file:")) {
            Value = StringUtils.removeStart((String)Value, (String)"file:");
        }
        return new Path(Value);
    }

    public File getRequestSchemaFile() throws Exception {
        IPath manifestPath = new Path(this.currentLocation.getAbsolutePath()).append(this.getRequestSchema());
        return manifestPath.toFile();
    }

    public IPath getResponseSchema() throws Exception {
        String value = this.getManifest().getResponseSchema().getValue();
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"file:")) {
            value = StringUtils.removeStart((String)value, (String)"file:");
        }
        return new Path(value);
    }

    public File getResponseSchemaFile() throws Exception {
        IPath manifestPath = new Path(this.currentLocation.getAbsolutePath()).append(this.getResponseSchema());
        return manifestPath.toFile();
    }

    public List<ZosConnectServiceArchiveObject> getProviderObjects() throws Exception {
        return this.getManifest().getProviderObjects();
    }

    public File getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(File currentLocation) {
        this.currentLocation = currentLocation;
    }

    public static boolean isValidServiceName(String serviceName) {
        return SERVICE_NAME_REGEX.matcher(serviceName).matches();
    }

    public static LinkedHashMap<String, Property> getLeafProperties(Model model) {
        SwaggerModelWalker walker = new SwaggerModelWalker();
        ModelLeafPropertyVisitor visitor = new ModelLeafPropertyVisitor();
        walker.accept(visitor, model);
        return visitor.getLeafProperties();
    }
}

