/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.api;

import com.ibm.zosconnect.api.ApiSpecType;
import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.mapping.service.MappingMessageType;
import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.api.mapping.service.ZosConnectServiceMapping;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.MapUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.controllers.visitors.OpenApi2xVisitor;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.io.File;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class OpenApi2xController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ApiProjectController apiProjectController;
    private ApiModelController apiModelController;

    public OpenApi2xController(ApiProjectController apiProjectController, ApiModelController apiModelController) {
        this.apiProjectController = apiProjectController;
        this.apiModelController = apiModelController;
    }

    public IFile generateSwagger(OpenApi2xVisitor swaggerVisitor, Map<String, String> newPathToOldPath, Map<String, String> newOpIdToOldOpId, Map<String, Map<Integer, Integer>> opIdToNewCodeToOldCode, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Xlat.description((String)"STATUS_GENERATING_SWAGGER"), -1);
        IFile swaggerFile = null;
        IFolder apiDocsFolder = this.apiProjectController.getApiDocsFolder(monitor);
        String swaggerFileName = "swagger.json";
        swaggerFile = apiDocsFolder.getFile(swaggerFileName);
        Swagger swagger = null;
        swagger = swaggerFile.exists() ? this.unmarshallSwagger(swaggerFile, false) : new Swagger();
        swagger = this.generateSwagger(swagger, swaggerVisitor, newPathToOldPath, newOpIdToOldOpId, opIdToNewCodeToOldCode);
        this.marshallSwagger(swagger, swaggerFile);
        monitor.done();
        return swaggerFile;
    }

    public IFile generateSwagger(OpenApi2xVisitor swaggerVisitor) throws Exception {
        return this.generateSwagger(swaggerVisitor, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Map<Integer, Integer>>(), (IProgressMonitor)new NullProgressMonitor());
    }

    private void setContact(Info info) {
        ApiSpecType apiSpec = this.apiModelController.getApiSpecType();
        String name = apiSpec.getContactName();
        String url = apiSpec.getContactURL();
        String email = apiSpec.getContactEmail();
        boolean contactExist = false;
        Contact contact = new Contact();
        if (name != null && !name.isEmpty()) {
            contact.setName(name);
            contactExist = true;
        }
        if (url != null && !url.isEmpty()) {
            contact.setUrl(url);
            contactExist = true;
        }
        if (email != null && !email.isEmpty()) {
            contact.setEmail(email);
            contactExist = true;
        }
        if (contactExist) {
            info.setContact(contact);
        }
    }

    private Swagger generateSwagger(Swagger swagger, OpenApi2xVisitor swaggerVisitor, Map<String, String> newPathToOldPath, Map<String, String> newOpIdToOldOpId, Map<String, Map<Integer, Integer>> opIdToNewCodeToOldCode) throws Exception {
        if (swagger == null) {
            swagger = new Swagger();
        }
        ApiSpecType apiSpec = this.apiModelController.getApiSpecType();
        Info info = new Info();
        info.setTitle(apiSpec.getTitle());
        info.setDescription(apiSpec.getDescription());
        info.setVersion(apiSpec.getVersion());
        this.setContact(info);
        swagger.setInfo(info);
        swaggerVisitor.updateInfo(info, apiSpec);
        if (StringUtils.isBlank((CharSequence)swagger.getHost())) {
            swagger.setHost(Xlat.noXlatLabel((String)"SWAGGER_DFLT_HOST"));
        }
        swagger.setBasePath(apiSpec.getBasePath());
        if (ListUtilz.isEmpty((List)swagger.getSchemes())) {
            swagger.setSchemes(Arrays.asList(Scheme.HTTPS, Scheme.HTTP));
        }
        if (ListUtilz.isEmpty((List)swagger.getConsumes())) {
            swagger.setConsumes(Arrays.asList("application/json"));
        }
        if (ListUtilz.isEmpty((List)swagger.getProduces())) {
            swagger.setProduces(Arrays.asList("application/json"));
        }
        LinkedHashMap<String, Path> definedPaths = new LinkedHashMap<String, Path>();
        LinkedHashMap<String, Model> definedSchemas = new LinkedHashMap<String, Model>();
        for (PathType pathType : apiSpec.getPath()) {
            String apiPathVal = OpenApi2xUtil.stripQueryParameters((String)pathType.getRelativePath());
            Path path = null;
            if (newPathToOldPath.containsKey(apiPathVal)) {
                String oldApiPath = newPathToOldPath.get(apiPathVal);
                path = swagger.getPath(oldApiPath);
                swagger.path(apiPathVal, path);
            } else {
                path = swagger.getPath(apiPathVal);
            }
            if (path == null) {
                path = new Path();
                swagger.path(apiPathVal, path);
            }
            definedPaths.put(apiPathVal, path);
            ArrayList definedPathScopeParameters = path.getParameters();
            if (definedPathScopeParameters == null) {
                definedPathScopeParameters = new ArrayList();
                path.setParameters(definedPathScopeParameters);
            }
            if (definedPathScopeParameters.isEmpty()) {
                path.setParameters(null);
            }
            ArrayList<MethodValues> undefinedMethods = new ArrayList<MethodValues>();
            undefinedMethods.addAll(Arrays.asList(MethodValues.values()));
            for (MethodType methodType : pathType.getMethod()) {
                Operation operation = null;
                LinkedHashMap<String, Response> definedResponses = new LinkedHashMap<String, Response>();
                undefinedMethods.remove(methodType.getType());
                switch (methodType.getType()) {
                    case POST: {
                        operation = path.getPost();
                        break;
                    }
                    case DELETE: {
                        operation = path.getDelete();
                        break;
                    }
                    case GET: {
                        operation = path.getGet();
                        break;
                    }
                    case PUT: {
                        operation = path.getPut();
                        break;
                    }
                    case HEAD: {
                        operation = path.getHead();
                        break;
                    }
                    case OPTIONS: {
                        operation = path.getOptions();
                        break;
                    }
                    case PATCH: {
                        operation = path.getPatch();
                    }
                }
                if (operation == null) {
                    operation = new Operation();
                }
                operation.operationId(methodType.getOperationId());
                operation.description(methodType.getDescription());
                operation.summary(methodType.getSummary());
                operation.setTags(Arrays.asList(info.getTitle()));
                ServiceArchiveController serviceArchiveController = null;
                String serviceName = methodType.getZosConnectServiceRef();
                if (serviceName != null && !serviceName.isEmpty()) {
                    serviceArchiveController = this.apiProjectController.getServiceArchiveController(serviceName);
                }
                ServiceMappingController serviceMappingController = this.apiProjectController.getServiceMappingController(pathType, methodType, serviceArchiveController);
                ZosConnectServiceMapping serviceMapping = serviceMappingController.getServiceMapping();
                boolean hasRequestMapping = serviceMappingController.hasRequestMapping();
                ArrayList<Parameter> definedMethodScopeParameters = operation.getParameters();
                if (definedMethodScopeParameters == null) {
                    definedMethodScopeParameters = new ArrayList<Parameter>();
                    operation.setParameters(definedMethodScopeParameters);
                }
                if (!hasRequestMapping) {
                    ArrayList<Parameter> toRemove = new ArrayList<Parameter>();
                    for (Parameter parameter : definedMethodScopeParameters) {
                        if (!(parameter instanceof HeaderParameter) && !(parameter instanceof PathParameter) && !(parameter instanceof QueryParameter)) continue;
                        toRemove.add(parameter);
                    }
                    definedMethodScopeParameters.removeAll(toRemove);
                    definedMethodScopeParameters.addAll(OpenApi2xUtil.getPathParametersFromPath((String)pathType.getRelativePath()));
                    definedMethodScopeParameters.addAll(OpenApi2xUtil.getQueryParametersFromPath((String)pathType.getRelativePath()));
                }
                swaggerVisitor.updateMethodScopeInputParameters(definedMethodScopeParameters, operation, methodType, path, pathType);
                if (serviceArchiveController != null) {
                    Model origInputSchemaModel = serviceArchiveController.getRequestSchemaModel();
                    String operationId = methodType.getOperationId();
                    String oldRequestSchemaName = null;
                    if (newOpIdToOldOpId.containsKey(operationId)) {
                        String oldOperationId = newOpIdToOldOpId.get(operationId);
                        oldRequestSchemaName = OpenApi2xController.getRequestBodySchemaName(serviceName, methodType, oldOperationId);
                        Model oldRequestSchema = (Model)swagger.getDefinitions().get(oldRequestSchemaName);
                        if (oldRequestSchema != null) {
                            swagger.getDefinitions().remove(oldRequestSchemaName);
                            String newRequestSchemaName = OpenApi2xController.getRequestBodySchemaName(serviceName, methodType, null);
                            swagger.getDefinitions().put(newRequestSchemaName, oldRequestSchema);
                        }
                    }
                    String requestSchemaName = OpenApi2xController.getRequestBodySchemaName(serviceName, methodType, null);
                    Model currInputSchemaModel = null;
                    if (MapUtilz.notEmpty((Map)swagger.getDefinitions())) {
                        currInputSchemaModel = (Model)swagger.getDefinitions().get(requestSchemaName);
                    }
                    if (!hasRequestMapping || swaggerVisitor.isInputMappingVisitorFor(operation, methodType, path, pathType)) {
                        currInputSchemaModel = origInputSchemaModel;
                    }
                    boolean isInputSchemaEmpty = true;
                    if (currInputSchemaModel != null) {
                        currInputSchemaModel = swaggerVisitor.updateInputBodyParameterSchema(origInputSchemaModel, currInputSchemaModel, operation, methodType, path, pathType);
                        isInputSchemaEmpty = MapUtilz.isEmpty((Map)currInputSchemaModel.getProperties());
                    }
                    if (!isInputSchemaEmpty) {
                        definedSchemas.put(requestSchemaName, currInputSchemaModel);
                        bodyParameter = null;
                        bodyParameter = oldRequestSchemaName == null ? OpenApi2xUtil.getBodyParameter((List)operation.getParameters(), (String)requestSchemaName) : OpenApi2xUtil.getBodyParameter((List)operation.getParameters(), (String)oldRequestSchemaName);
                        if (bodyParameter == null) {
                            bodyParameter = new BodyParameter();
                            bodyParameter.setName(requestSchemaName);
                            bodyParameter.setDescription(Xlat.noXlatLabel((String)"SWAGGER_DFLT_BODY_PARM_DESC"));
                            bodyParameter.setRequired(true);
                            definedMethodScopeParameters.add((Parameter)bodyParameter);
                        } else {
                            bodyParameter.setName(requestSchemaName);
                        }
                        ListUtilz.makeLastMember(definedMethodScopeParameters, (Object)bodyParameter);
                        bodyParameter.schema((Model)new RefModel("#/definitions/" + StringUtils.replace((String)requestSchemaName, (String)"/", (String)"~1")));
                    } else {
                        bodyParameter = null;
                        bodyParameter = oldRequestSchemaName == null ? OpenApi2xUtil.getBodyParameter((List)operation.getParameters(), (String)requestSchemaName) : OpenApi2xUtil.getBodyParameter((List)operation.getParameters(), (String)oldRequestSchemaName);
                        if (bodyParameter != null) {
                            operation.getParameters().remove(bodyParameter);
                        }
                    }
                    for (ResponseMessageType responseMessageType : serviceMapping.getResponseMessages()) {
                        String description;
                        Response response;
                        boolean hasResponseMapping = serviceMappingController.hasMapping((MappingMessageType)responseMessageType);
                        Integer responseCode = responseMessageType.getCode();
                        if (responseCode == null) {
                            responseCode = 200;
                        }
                        String responseCodeStr = String.valueOf(responseCode);
                        String oldResponseSchemaName = null;
                        boolean operationIdChanged = newOpIdToOldOpId.containsKey(operationId);
                        boolean responseCodeChanged = false;
                        if (opIdToNewCodeToOldCode.containsKey(operationId) && opIdToNewCodeToOldCode.get(operationId).get(responseCode) != null) {
                            responseCodeChanged = true;
                        }
                        if (operationIdChanged || responseCodeChanged) {
                            String oldOperationId = null;
                            oldOperationId = operationIdChanged ? newOpIdToOldOpId.get(operationId) : operationId;
                            Integer oldResponseCode = null;
                            oldResponseCode = responseCodeChanged ? opIdToNewCodeToOldCode.get(operationId).get(responseCode) : responseCode;
                            oldResponseSchemaName = OpenApi2xController.getResponseSchemaName(serviceName, methodType, oldOperationId, oldResponseCode.toString());
                            Model oldResponseSchema = (Model)swagger.getDefinitions().get(oldResponseSchemaName);
                            if (oldResponseSchema != null) {
                                swagger.getDefinitions().remove(oldResponseSchemaName);
                                String newResponseSchemaName = OpenApi2xController.getResponseSchemaName(serviceName, methodType, null, responseCodeStr);
                                swagger.getDefinitions().put(newResponseSchemaName, oldResponseSchema);
                            }
                        }
                        String responseSchemaName = OpenApi2xController.getResponseSchemaName(serviceName, methodType, null, responseCodeStr);
                        Model currOutputSchemaModel = null;
                        if (MapUtilz.notEmpty((Map)swagger.getDefinitions())) {
                            currOutputSchemaModel = (Model)swagger.getDefinitions().get(responseSchemaName);
                        }
                        Model origOutputSchemaModel = serviceArchiveController.getResponseSchemaModel();
                        if (!hasResponseMapping || swaggerVisitor.isOutputMappingVisitorFor(operation, methodType, path, pathType, responseMessageType)) {
                            currOutputSchemaModel = origOutputSchemaModel;
                        }
                        if (!hasResponseMapping) {
                            currOutputSchemaModel = origOutputSchemaModel;
                        }
                        if (operation.getResponses() == null) {
                            operation.setResponses(new HashMap());
                        }
                        if ((response = (Response)operation.getResponses().get(responseCodeStr)) == null) {
                            response = new Response();
                        }
                        if ((description = StringUtils.trimToEmpty((String)responseMessageType.getDescription())).isEmpty()) {
                            HttpStatusCodes statusCode = HttpStatusCodes.fromCode((Integer)responseCode);
                            description = statusCode != null ? statusCode.getDescription() : HttpStatusCodes.getRangeDescription((int)responseCode);
                        }
                        response.setDescription(description);
                        definedResponses.put(responseCodeStr, response);
                        boolean isOutputSchemaEmpty = true;
                        if (currOutputSchemaModel != null) {
                            isOutputSchemaEmpty = MapUtilz.isEmpty((Map)(currOutputSchemaModel = swaggerVisitor.updateOutputBodyParameterSchema(origOutputSchemaModel, currOutputSchemaModel, operation, methodType, path, pathType, responseMessageType)).getProperties());
                            if (!isOutputSchemaEmpty) {
                                definedSchemas.put(responseSchemaName, currOutputSchemaModel);
                                response.schema((Property)new RefProperty("#/definitions/" + StringUtils.replace((String)responseSchemaName, (String)"/", (String)"~1")));
                            } else {
                                response.schema(null);
                            }
                        } else {
                            response.schema(null);
                        }
                        LinkedHashMap<String, Property> headers = response.getHeaders();
                        if (headers == null) {
                            headers = new LinkedHashMap<String, Property>();
                            response.setHeaders(headers);
                        }
                        if (!hasResponseMapping) {
                            headers.clear();
                        }
                        swaggerVisitor.updateMethodScopeOutputHeaders(headers, operation, methodType, path, pathType, responseMessageType);
                        if (!headers.isEmpty()) continue;
                        response.setHeaders(null);
                    }
                }
                if (!definedMethodScopeParameters.isEmpty()) {
                    operation.setParameters(definedMethodScopeParameters);
                } else {
                    operation.setParameters(null);
                }
                if (!definedResponses.isEmpty()) {
                    operation.setResponses(definedResponses);
                } else {
                    operation.setResponses(null);
                }
                switch (methodType.getType()) {
                    case POST: {
                        path.post(operation);
                        break;
                    }
                    case DELETE: {
                        path.delete(operation);
                        break;
                    }
                    case GET: {
                        path.get(operation);
                        break;
                    }
                    case PUT: {
                        path.put(operation);
                        break;
                    }
                    case HEAD: {
                        path.head(operation);
                        break;
                    }
                    case OPTIONS: {
                        path.options(operation);
                        break;
                    }
                    case PATCH: {
                        path.patch(operation);
                    }
                }
                if (!ListUtilz.isEmpty((List)operation.getParameters()) || !MapUtilz.isEmpty((Map)operation.getResponses())) continue;
                undefinedMethods.add(methodType.getType());
            }
            for (MethodValues removeMethodType : undefinedMethods) {
                switch (removeMethodType) {
                    case POST: {
                        path.post(null);
                        break;
                    }
                    case DELETE: {
                        path.delete(null);
                        break;
                    }
                    case GET: {
                        path.get(null);
                        break;
                    }
                    case PUT: {
                        path.put(null);
                        break;
                    }
                    case HEAD: {
                        path.head(null);
                        break;
                    }
                    case OPTIONS: {
                        path.options(null);
                        break;
                    }
                    case PATCH: {
                        path.patch(null);
                    }
                }
            }
        }
        swagger.paths(definedPaths);
        swagger.setDefinitions(definedSchemas);
        return swagger;
    }

    public void marshallSwagger(Swagger swagger, IFile swaggerIFile) throws Exception {
        String swaggerFileContent = Json.pretty((Object)swagger);
        File swaggerFile = new File(swaggerIFile.getRawLocation().toOSString());
        try (FileOutputStream swaggerFileOS = new FileOutputStream(swaggerFile);){
            swaggerFileOS.write(swaggerFileContent.getBytes("UTF-8"));
            swaggerFileOS.flush();
        }
        swaggerIFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    public Swagger unmarshallSwagger(IFile swaggerFile, boolean yaml) throws Exception {
        Swagger swagger = null;
        File swaggerNativeFile = new File(swaggerFile.getRawLocation().toOSString());
        swagger = (Swagger)Json.mapper().readValue(swaggerNativeFile, Swagger.class);
        return swagger;
    }

    public void setApiProjectController(ApiProjectController apiProjectController) {
        this.apiProjectController = apiProjectController;
    }

    public void setApiModelController(ApiModelController apiModelController) {
        this.apiModelController = apiModelController;
    }

    public static String getRequestBodySchemaName(String serviceName, MethodType methodType, String oldOperationId) {
        String operationId = StringUtils.trimToEmpty((String)methodType.getOperationId());
        if (oldOperationId != null) {
            operationId = StringUtils.trim((String)oldOperationId);
        }
        if (operationId.isEmpty()) {
            return MessageFormat.format("{0}_{1}_{2}", serviceName, methodType.getType(), Xlat.noXlatLabel((String)"SWAGGER_DFLT_BODY_PARM_SCHEMA_SFX"));
        }
        return MessageFormat.format("{0}_{1}", operationId, Xlat.noXlatLabel((String)"SWAGGER_DFLT_BODY_PARM_SCHEMA_SFX"));
    }

    public static String getResponseSchemaName(String serviceName, MethodType methodType, String oldOperationId, String code) {
        String operationId = StringUtils.trimToEmpty((String)methodType.getOperationId());
        if (oldOperationId != null) {
            operationId = StringUtils.trim((String)oldOperationId);
        }
        if (operationId.isEmpty()) {
            return MessageFormat.format("{0}_{1}_{2}_{3}", serviceName, methodType.getType(), Xlat.noXlatLabel((String)"SWAGGER_DFLT_NORMAL_RESP_SCHEMA_SFX"), code);
        }
        return MessageFormat.format("{0}_{1}_{2}", operationId, Xlat.noXlatLabel((String)"SWAGGER_DFLT_NORMAL_RESP_SCHEMA_SFX"), code);
    }
}

