/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.api;

import com.ibm.msl.mapping.FunctionRefinement;
import com.ibm.msl.mapping.InlinedXMLSchema;
import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.SemanticRefinement;
import com.ibm.msl.mapping.util.EclipseResourceUtils;
import com.ibm.msl.mapping.util.MappingResourceImpl;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.xml.util.XSDUtils;
import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.mapping.annotations.HttpIn;
import com.ibm.zosconnect.api.mapping.annotations.ZosConnectMappingAnnotations;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.api.mapping.service.ZosConnectServiceMapping;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectMappingException;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ZosConnectApiProjectNature;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.MapUtilz;
import com.ibm.zosconnect.ui.common.util.MappingFileUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.api.ZosConnectJAXBModelUtil;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.OpenApi2xController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.controllers.visitors.OpenApi2xVisitor;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import com.ibm.zosconnect.ui.mapping.util.msl.model.ZCeeInputMappingModel;
import com.ibm.zosconnect.ui.mapping.util.msl.model.ZCeeMappingModel;
import com.ibm.zosconnect.ui.mapping.util.msl.model.ZCeeOutputMappingModel;
import com.ibm.zosconnect.ui.mapping.util.msl.walker.IMappingRootVisitor;
import com.ibm.zosconnect.ui.mapping.util.msl.walker.MappingRootWalker;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class MappingRootController
extends OpenApi2xVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = MappingRootController.class.getName();
    private static final String TEMP_OBJECT_PROPERTY_NAME = "$TEMP$";
    private ApiProjectController apiProjectController;
    private ApiModelController apiModelController;
    private OpenApi2xController apiDocsController;
    private ServiceArchiveController serviceArchiveController;
    private ZosConnectServiceMapping serviceMapping;
    private MappingRoot mappingRoot;
    private boolean isInputMapping;
    private IProject apiProject;
    private IFile mappingFile;
    private IFile serviceMappingFile;
    private IFolder serviceMappingFolder;
    private InlinedXMLSchema jsonInlinedXmlSchema;
    private InlinedXMLSchema httpInlinedXmlSchema;
    private XSDSchema jsonXmlSchema;
    private XSDSchema httpXmlSchema;
    private MethodValues mappingMethod;
    private String mappingRelativePath;
    private ZCeeMappingModel mappingModel;

    public MappingRootController(MappingRoot mappingRoot) throws Exception {
        this.mappingRoot = mappingRoot;
        this.initEclipseResources();
        this.initSchemas();
        this.initApiProjectController();
        this.initApiModelController();
        this.initApiDocsController();
        this.initServiceArchiveController();
    }

    public void doSave() throws Exception {
        ZCeeUILogger.entering((String)TAG, (String)"doSave()", (Object[])new Object[0]);
        if (this.isInputMapping) {
            this.mappingModel = new ZCeeInputMappingModel();
            walker = new MappingRootWalker(this.mappingRoot);
            walker.accept((IMappingRootVisitor)this.mappingModel);
            this.initInputHeaderParameters();
            this.initInputPathParameters();
            this.initInputQueryParameters();
        } else {
            this.mappingModel = new ZCeeOutputMappingModel();
            walker = new MappingRootWalker(this.mappingRoot);
            walker.accept((IMappingRootVisitor)this.mappingModel);
            this.initOutputHeaderParameters();
        }
        String mappingFileName = this.mappingFile.getName();
        if (!StringUtils.endsWith((CharSequence)mappingFileName, (CharSequence)"_New.map")) {
            ZCeeUILogger.info((String)"Generating Swagger as mapping file {0} is not temporary", (Object[])new Object[]{mappingFileName});
            this.apiDocsController.generateSwagger(this);
        } else {
            ZCeeUILogger.info((String)"Skipped Swagger generation as mapping file {0} is temporary", (Object[])new Object[]{mappingFileName});
        }
        ZCeeUILogger.exiting((String)TAG, (String)"doSave()", (Object[])new Object[0]);
    }

    public static void reloadMappingFile(IFile mappingFile) throws Exception {
        ZCeeUILogger.entering((String)TAG, (String)"reloadMappingFile(mappingFile={0})", (Object[])new Object[]{mappingFile});
        MappingResourceImpl mappingResource = ZCeeMappingUtil.loadMappingFile((IFile)mappingFile);
        MappingRoot mappingRoot = ZCeeMappingUtil.findMappingRoot((MappingResourceImpl)mappingResource);
        MappingRootController mappingRootCtrl = new MappingRootController(mappingRoot);
        mappingRootCtrl.doSave();
        ZCeeUILogger.exiting((String)TAG, (String)"reloadMappingFile(IFile)", (Object[])new Object[0]);
    }

    private void initEclipseResources() throws Exception {
        this.apiProject = EclipseResourceUtils.getProject((MappingRoot)this.mappingRoot);
        this.mappingFile = EclipseResourceUtils.getIFile((MappingRoot)this.mappingRoot);
        if (!ZosConnectApiProjectNature.hasNature((IProject)this.apiProject)) {
            throw new ZosConnectMappingException(Xlat.error((String)"API_PROJECT_INVALID_MAPPING_SAVE_ERROR", (String[])new String[]{this.apiProject.getName(), this.mappingFile.getFullPath().toPortableString()}));
        }
        this.serviceMappingFolder = (IFolder)this.mappingFile.getParent();
        this.serviceMappingFile = this.serviceMappingFolder.getFile("mapping.xml");
        IPath mappingFolderPath = this.serviceMappingFolder.getProjectRelativePath();
        if (mappingFolderPath.segmentCount() > 1) {
            mappingFolderPath = mappingFolderPath.removeFirstSegments(1);
            mappingFolderPath = mappingFolderPath.removeLastSegments(1);
        }
        this.mappingRelativePath = mappingFolderPath.segmentCount() > 0 ? "/" + mappingFolderPath.toPortableString() : "/";
    }

    private void initSchemas() throws Exception {
        EList inlineSchemas = this.mappingRoot.getInlinedXMLSchemas();
        if (inlineSchemas == null || inlineSchemas.size() < 2) {
            throw new ZosConnectMappingException(Xlat.error((String)"MSL_MISSING_INLINE_SCHEMA_ERROR", (String[])new String[]{this.mappingFile.getFullPath().toOSString()}));
        }
        InlinedXMLSchema schema_0 = (InlinedXMLSchema)inlineSchemas.get(0);
        InlinedXMLSchema schema_1 = (InlinedXMLSchema)inlineSchemas.get(1);
        if (StringUtils.startsWith((CharSequence)schema_0.getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/JSON")) {
            this.jsonInlinedXmlSchema = schema_0;
            this.jsonXmlSchema = schema_0.getInlinedSchema();
        } else if (StringUtils.startsWith((CharSequence)schema_0.getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP")) {
            this.httpInlinedXmlSchema = schema_0;
            this.httpXmlSchema = schema_0.getInlinedSchema();
            this.mappingMethod = ZCeeMappingUtil.getHttpMethodNameFromInlineSchema((InlinedXMLSchema)schema_0);
        } else {
            throw new ZosConnectMappingException(Xlat.error((String)"MSL_INLINE_SCHEMA_BAD_TNS_ERROR", (String[])new String[]{this.mappingFile.getFullPath().toOSString(), schema_0.getTargetNamespace()}));
        }
        if (StringUtils.startsWith((CharSequence)schema_1.getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/JSON")) {
            this.jsonInlinedXmlSchema = schema_1;
            this.jsonXmlSchema = schema_1.getInlinedSchema();
        } else if (StringUtils.startsWith((CharSequence)schema_1.getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP")) {
            this.httpInlinedXmlSchema = schema_1;
            this.httpXmlSchema = schema_1.getInlinedSchema();
            this.mappingMethod = ZCeeMappingUtil.getHttpMethodNameFromInlineSchema((InlinedXMLSchema)schema_1);
        } else {
            throw new ZosConnectMappingException(Xlat.error((String)"MSL_INLINE_SCHEMA_BAD_TNS_ERROR", (String[])new String[]{this.mappingFile.getFullPath().toOSString(), schema_1.getTargetNamespace()}));
        }
        if (ZosConnectXsdUtil.isHttpInputTns((String)this.httpXmlSchema.getTargetNamespace())) {
            this.isInputMapping = true;
        }
    }

    private void initInputHeaderParameters() {
        ZCeeInputMappingModel inputMappingModel = (ZCeeInputMappingModel)this.mappingModel;
        XSDTypeDefinition headerParamsType = XSDUtils.getTypeDef((XSDSchema)this.httpXmlSchema, (String)"HeadersType");
        if (headerParamsType == null) {
            return;
        }
        List headerParamEles = XSDUtils.getAllElements((XSDTypeDefinition)headerParamsType);
        if (ListUtilz.isEmpty((List)headerParamEles)) {
            return;
        }
        for (XSDParticleContent particleContent : headerParamEles) {
            if (!(particleContent instanceof XSDElementDeclaration)) continue;
            XSDElementDeclaration headerParamElement = (XSDElementDeclaration)particleContent;
            headerParamElement = headerParamElement.getResolvedElementDeclaration();
            HeaderParameter headerParameter = new HeaderParameter();
            headerParameter.setName(headerParamElement.getName());
            headerParameter.setIn(HttpIn.HEADER.value());
            headerParameter.setRequired(ZosConnectXsdUtil.isRequired((XSDComponent)headerParamElement));
            if (ZosConnectXsdUtil.isArray((XSDComponent)headerParamElement)) {
                headerParameter.setType(JsonSchemaPrimitiveType.ARRAY.value());
                ArrayProperty arrayProperty = new ArrayProperty();
                arrayProperty.items(OpenApi2xUtil.getSwaggerPropertyFromXsdSimpleType((XSDElementDeclaration)headerParamElement));
                headerParameter.setProperty((Property)arrayProperty);
            } else {
                JsonSchemaPrimitiveType jsonType = OpenApi2xUtil.getJsonPrimitiveTypeFromXsdSimpleType((XSDElementDeclaration)headerParamElement);
                headerParameter.setType(jsonType.value());
            }
            OpenApi2xUtil.setParameterAppInfo((AbstractSerializableParameter)headerParameter, (XSDElementDeclaration)headerParamElement);
            inputMappingModel.setHeaderParameter(headerParameter);
        }
    }

    private void initInputPathParameters() {
        ZCeeInputMappingModel inputMappingModel = (ZCeeInputMappingModel)this.mappingModel;
        XSDTypeDefinition pathParamsType = XSDUtils.getTypeDef((XSDSchema)this.httpXmlSchema, (String)"PathParametersType");
        if (pathParamsType == null) {
            return;
        }
        List pathParamElements = XSDUtils.getAllElements((XSDTypeDefinition)pathParamsType);
        if (ListUtilz.isEmpty((List)pathParamElements)) {
            return;
        }
        for (XSDParticleContent particleContent : pathParamElements) {
            if (!(particleContent instanceof XSDElementDeclaration)) continue;
            XSDElementDeclaration pathParamElement = (XSDElementDeclaration)particleContent;
            pathParamElement = pathParamElement.getResolvedElementDeclaration();
            PathParameter pathParameter = new PathParameter();
            pathParameter.setName(pathParamElement.getName());
            pathParameter.setIn(HttpIn.PATH.value());
            pathParameter.setRequired(ZosConnectXsdUtil.isRequired((XSDComponent)pathParamElement));
            if (ZosConnectXsdUtil.isArray((XSDComponent)pathParamElement)) {
                pathParameter.setType(JsonSchemaPrimitiveType.ARRAY.value());
                ArrayProperty arrayProperty = new ArrayProperty();
                arrayProperty.items(OpenApi2xUtil.getSwaggerPropertyFromXsdSimpleType((XSDElementDeclaration)pathParamElement));
                pathParameter.setProperty((Property)arrayProperty);
            } else {
                JsonSchemaPrimitiveType jsonType = OpenApi2xUtil.getJsonPrimitiveTypeFromXsdSimpleType((XSDElementDeclaration)pathParamElement);
                pathParameter.setType(jsonType.value());
            }
            OpenApi2xUtil.setParameterAppInfo((AbstractSerializableParameter)pathParameter, (XSDElementDeclaration)pathParamElement);
            inputMappingModel.setPathParameter(pathParameter);
        }
    }

    private void initInputQueryParameters() {
        ZCeeInputMappingModel inputMappingModel = (ZCeeInputMappingModel)this.mappingModel;
        XSDTypeDefinition queryParamsType = XSDUtils.getTypeDef((XSDSchema)this.httpXmlSchema, (String)"QueryParametersType");
        if (queryParamsType == null) {
            return;
        }
        List queryParamElements = XSDUtils.getAllElements((XSDTypeDefinition)queryParamsType);
        if (ListUtilz.isEmpty((List)queryParamElements)) {
            return;
        }
        for (XSDParticleContent particleContent : queryParamElements) {
            if (!(particleContent instanceof XSDElementDeclaration)) continue;
            XSDElementDeclaration queryParamElement = (XSDElementDeclaration)particleContent;
            queryParamElement = queryParamElement.getResolvedElementDeclaration();
            QueryParameter queryParameter = new QueryParameter();
            queryParameter.setName(queryParamElement.getName());
            queryParameter.setIn(HttpIn.QUERY.value());
            queryParameter.setRequired(ZosConnectXsdUtil.isRequired((XSDComponent)queryParamElement));
            if (ZosConnectXsdUtil.isArray((XSDComponent)queryParamElement)) {
                queryParameter.setType(JsonSchemaPrimitiveType.ARRAY.value());
                ArrayProperty arrayProperty = new ArrayProperty();
                arrayProperty.items(OpenApi2xUtil.getSwaggerPropertyFromXsdSimpleType((XSDElementDeclaration)queryParamElement));
                queryParameter.setProperty((Property)arrayProperty);
            } else {
                JsonSchemaPrimitiveType jsonType = OpenApi2xUtil.getJsonPrimitiveTypeFromXsdSimpleType((XSDElementDeclaration)queryParamElement);
                queryParameter.setType(jsonType.value());
            }
            OpenApi2xUtil.setParameterAppInfo((AbstractSerializableParameter)queryParameter, (XSDElementDeclaration)queryParamElement);
            inputMappingModel.setQueryParameter(queryParameter);
        }
    }

    private void initOutputHeaderParameters() {
        ZCeeOutputMappingModel outputMappingModel = (ZCeeOutputMappingModel)this.mappingModel;
        XSDTypeDefinition headerParamsType = XSDUtils.getTypeDef((XSDSchema)this.httpXmlSchema, (String)"HeadersType");
        if (headerParamsType == null) {
            return;
        }
        List headerParamEles = XSDUtils.getAllElements((XSDTypeDefinition)headerParamsType);
        if (ListUtilz.isEmpty((List)headerParamEles)) {
            return;
        }
        for (XSDParticleContent particleContent : headerParamEles) {
            if (!(particleContent instanceof XSDElementDeclaration)) continue;
            XSDElementDeclaration headerParamElement = (XSDElementDeclaration)particleContent;
            headerParamElement = headerParamElement.getResolvedElementDeclaration();
            Property headerProperty = null;
            if (ZosConnectXsdUtil.isArray((XSDComponent)headerParamElement)) {
                ArrayProperty arrayProperty = new ArrayProperty();
                arrayProperty.setName(headerParamElement.getName());
                arrayProperty.items(OpenApi2xUtil.getSwaggerPropertyFromXsdSimpleType((XSDElementDeclaration)headerParamElement));
                arrayProperty.setRequired(ZosConnectXsdUtil.isRequired((XSDComponent)headerParamElement));
                headerProperty = arrayProperty;
            } else {
                headerProperty = OpenApi2xUtil.getSwaggerPropertyFromXsdSimpleType((XSDElementDeclaration)headerParamElement);
                headerProperty.setName(headerParamElement.getName());
                headerProperty.setRequired(ZosConnectXsdUtil.isRequired((XSDComponent)headerParamElement));
            }
            OpenApi2xUtil.setPropertyAppInfo((Property)headerProperty, (XSDElementDeclaration)headerParamElement);
            outputMappingModel.setHeaderProperty(headerProperty);
        }
    }

    private void initApiProjectController() throws Exception {
        this.apiProjectController = new ApiProjectController(this.apiProject);
    }

    private void initApiModelController() throws Exception {
        IFile packageXmlFile = this.apiProjectController.getProject().getFile("package.xml");
        if (packageXmlFile == null) {
            throw new ZosConnectMappingException(Xlat.error((String)"PROJECT_FILE_MISSING_ERROR", (String[])new String[]{"package.xml", this.apiProject.getName()}));
        }
        this.apiModelController = new ApiModelController(packageXmlFile, this.apiProjectController);
        this.apiProjectController.setApiModelController(this.apiModelController);
    }

    private void initApiDocsController() throws Exception {
        IFolder apiDocsFolder = this.apiProjectController.getApiDocsFolder();
        IFile swaggerFile = apiDocsFolder.getFile("swagger.json");
        if (swaggerFile == null) {
            throw new ZosConnectMappingException(Xlat.error((String)"PROJECT_FILE_MISSING_ERROR", (String[])new String[]{"swagger.json", this.apiProject.getName()}));
        }
        this.apiDocsController = new OpenApi2xController(this.apiProjectController, this.apiModelController);
    }

    private void initServiceArchiveController() throws Exception {
        if (!this.serviceMappingFile.exists()) {
            throw new ZosConnectMappingException(Xlat.error((String)"PROJECT_FILE_MISSING_ERROR", (String[])new String[]{"mapping.xml", this.apiProject.getName()}));
        }
        this.serviceMapping = ZosConnectJAXBModelUtil.unmarshall_ZosConnectServiceMapping((IFile)this.serviceMappingFile);
        String serviceName = this.serviceMapping.getMappingContext().getServiceName();
        this.serviceArchiveController = this.apiProjectController.getServiceArchiveController(serviceName);
    }

    public ApiProjectController getApiProjectController() {
        return this.apiProjectController;
    }

    public ApiModelController getApiModelController() {
        return this.apiModelController;
    }

    public OpenApi2xController getApiDocsController() {
        return this.apiDocsController;
    }

    public MappingRoot getMappingRoot() {
        return this.mappingRoot;
    }

    public IProject getApiProject() {
        return this.apiProject;
    }

    public IFile getMapFile() {
        return this.mappingFile;
    }

    public XSDSchema getBodySchema() {
        return this.jsonXmlSchema;
    }

    public XSDSchema getHttpSchema() {
        return this.httpXmlSchema;
    }

    public ServiceArchiveController getServiceArchiveController() {
        return this.serviceArchiveController;
    }

    @Override
    public boolean isMappingVisitor() {
        return true;
    }

    @Override
    public boolean isInputMappingVisitorFor(Operation operation, MethodType methodType, Path path, PathType pathType) {
        ZCeeUILogger.entering((String)TAG, (String)"isInputMappingVisitorFor(operation={0},methodType={1},path={2},pathType={3})", (Object[])new Object[]{operation, methodType, path, pathType});
        boolean retVal = false;
        String apiPathVal = OpenApi2xUtil.stripQueryParameters((String)pathType.getRelativePath());
        if (apiPathVal.length() > 1 && apiPathVal.endsWith("/")) {
            apiPathVal = apiPathVal.substring(0, apiPathVal.length() - 1);
        }
        if (this.isInputMapping && StringUtils.equals((CharSequence)this.mappingRelativePath, (CharSequence)apiPathVal) && StringUtils.equals((CharSequence)this.mappingMethod.value(), (CharSequence)methodType.getType().value())) {
            retVal = true;
        }
        ZCeeUILogger.exiting((String)TAG, (String)"isInputMappingVisitorFor(Operation,MethodType,Path,PathType):{0}", (Object[])new Object[]{retVal});
        return retVal;
    }

    @Override
    public boolean isOutputMappingVisitorFor(Operation operation, MethodType methodType, Path path, PathType pathType, ResponseMessageType responseMessageType) {
        ZCeeUILogger.entering((String)TAG, (String)"isOutputMappingVisitorFor(operation={0},methodType={1},path={2},pathType={3})", (Object[])new Object[]{operation, methodType, path, pathType});
        boolean retVal = false;
        String apiPathVal = OpenApi2xUtil.stripQueryParameters((String)pathType.getRelativePath());
        if (apiPathVal.length() > 1 && apiPathVal.endsWith("/")) {
            apiPathVal = apiPathVal.substring(0, apiPathVal.length() - 1);
        }
        int visitorResponseCode = MappingFileUtilz.getResponseCodeFromMappingFileName((IFile)this.mappingFile);
        if (!this.isInputMapping && StringUtils.equals((CharSequence)this.mappingRelativePath, (CharSequence)apiPathVal) && StringUtils.equals((CharSequence)this.mappingMethod.value(), (CharSequence)methodType.getType().value()) && visitorResponseCode == responseMessageType.getCode()) {
            retVal = true;
        }
        ZCeeUILogger.exiting((String)TAG, (String)"isOutputMappingVisitorFor(Operation,MethodType,Path,PathType):{0}", (Object[])new Object[]{retVal});
        return retVal;
    }

    @Override
    public void updateMethodScopeInputParameters(List<Parameter> parameters, Operation operation, MethodType methodType, Path path, PathType pathType) {
        ZCeeUILogger.entering((String)TAG, (String)"updateMethodScopeInputParameters(parameters={0},operation={1},methodType={2},path={3},pathType={4})", (Object[])new Object[]{parameters, operation, methodType, path, pathType});
        if (!this.isInputMappingVisitorFor(operation, methodType, path, pathType)) {
            return;
        }
        this.updateMethodScopeInputHeaderParameters(parameters, operation, methodType, path, pathType);
        this.updateMethodScopePathParameters(parameters, operation, methodType, path, pathType);
        this.updateMethodScopeQueryParameters(parameters, operation, methodType, path, pathType);
        ZCeeUILogger.exiting((String)TAG, (String)"updateMethodScopeInputParameters(List<Parameter>,Operation,MethodType,Path,PathType)", (Object[])new Object[0]);
    }

    @Override
    public void updateMethodScopeOutputHeaders(Map<String, Property> headers, Operation operation, MethodType methodType, Path path, PathType pathType, ResponseMessageType responseMessageType) {
        ZCeeUILogger.entering((String)TAG, (String)"updateMethodScopeOutputHeaders(headers={0},operation={1},methodType={2},path={3},pathType={4})", (Object[])new Object[]{headers, operation, methodType, path, pathType});
        if (!this.isOutputMappingVisitorFor(operation, methodType, path, pathType, responseMessageType)) {
            return;
        }
        this.updateMethodScopeOutputHeadersMap(headers, operation, methodType, path, pathType);
        this.updateMethodScopeOutputHeadersFromAssignMappings(headers, operation, methodType, path, pathType);
        ZCeeUILogger.exiting((String)TAG, (String)"updateMethodScopeOutputHeaders(Map<String, Property>,Operation,MethodType,Path,PathType)", (Object[])new Object[0]);
    }

    @Override
    public Model updateInputBodyParameterSchema(Model origModel, Model currModel, Operation operation, MethodType methodType, Path path, PathType pathType) {
        ZCeeUILogger.entering((String)TAG, (String)"updateInputBodyParameterSchema(origModel={0},currModel={1},operation={2},methodType={3},path={4},pathType={5})", (Object[])new Object[]{origModel, currModel, operation, methodType, path, pathType});
        if (!this.isInputMappingVisitorFor(operation, methodType, path, pathType)) {
            return currModel;
        }
        this.updateBodyParameterSchemaFromAssignMappings(origModel, operation, methodType, path, pathType);
        this.updateBodyParameterSchemaFromRemoveMappings(origModel, operation, methodType, path, pathType);
        this.updateBodyParameterSchemaFromMoveMappings(origModel, operation, methodType, path, pathType);
        ZCeeUILogger.exiting((String)TAG, (String)"updateInputBodyParameterSchema(Model,Model,Operation,MethodType,Path,PathType)", (Object[])new Object[0]);
        return origModel;
    }

    @Override
    public Model updateOutputBodyParameterSchema(Model origModel, Model currModel, Operation operation, MethodType methodType, Path path, PathType pathType, ResponseMessageType responseMessageType) {
        ZCeeUILogger.entering((String)TAG, (String)"updateOutputBodyParameterSchema(origModel={0},currModel={1},operation={2},methodType={3},path={4},pathType={5})", (Object[])new Object[]{origModel, currModel, operation, methodType, path, pathType});
        if (!this.isOutputMappingVisitorFor(operation, methodType, path, pathType, responseMessageType)) {
            return currModel;
        }
        this.updateBodyParameterSchemaFromAssignMappings(origModel, operation, methodType, path, pathType);
        this.updateBodyParameterSchemaFromRemoveMappings(origModel, operation, methodType, path, pathType);
        this.updateBodyParameterSchemaFromMoveMappings(origModel, operation, methodType, path, pathType);
        ZCeeUILogger.exiting((String)TAG, (String)"updateOutputBodyParameterSchema(Model,Model,Operation,MethodType,Path,PathType)", (Object[])new Object[0]);
        return origModel;
    }

    private void updateMethodScopeInputHeaderParameters(List<Parameter> parameters, Operation operation, MethodType methodType, Path path, PathType pathType) {
        ZCeeInputMappingModel inputMappingModel = (ZCeeInputMappingModel)this.mappingModel;
        ArrayList<Parameter> removeParams = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            HeaderParameter mappingHeaderParam;
            if (!(parameter instanceof HeaderParameter) || (mappingHeaderParam = inputMappingModel.getHeaderParameter(parameter.getName())) != null) continue;
            removeParams.add(parameter);
        }
        parameters.removeAll(removeParams);
        ArrayList<HeaderParameter> orderedSwaggerHeaderParams = new ArrayList<HeaderParameter>();
        for (HeaderParameter mappingHeaderParam : inputMappingModel.getHeaderParameters()) {
            HeaderParameter swaggerHeaderParam = OpenApi2xUtil.getHeaderParameter(parameters, (String)mappingHeaderParam.getName());
            if (swaggerHeaderParam == null) {
                swaggerHeaderParam = mappingHeaderParam;
            } else {
                parameters.remove(swaggerHeaderParam);
            }
            orderedSwaggerHeaderParams.add(swaggerHeaderParam);
            swaggerHeaderParam.setIn(mappingHeaderParam.getIn());
            swaggerHeaderParam.setRequired(mappingHeaderParam.getRequired());
            String collectionFormat = mappingHeaderParam.getCollectionFormat();
            swaggerHeaderParam.setType(mappingHeaderParam.getType());
            if (mappingHeaderParam.getItems() != null) {
                swaggerHeaderParam.items(mappingHeaderParam.getItems());
                swaggerHeaderParam.setCollectionFormat(collectionFormat);
            } else {
                swaggerHeaderParam.items(null);
                swaggerHeaderParam.setCollectionFormat(null);
            }
            MappingDesignator headerParamTargetDesignator = inputMappingModel.getHeaderParameterTargetDesignator(swaggerHeaderParam.getName());
            if (headerParamTargetDesignator != null) {
                XSDElementDeclaration headerParamTargetElement = inputMappingModel.getHeaderParamTargetXsdElement(swaggerHeaderParam.getName());
                XSDSimpleTypeDefinition headerParamTargetType = inputMappingModel.getHeaderParamTargetXsdType(swaggerHeaderParam.getName());
                ZCeeMappingUtil.setParameterArrayFacets((AbstractSerializableParameter)swaggerHeaderParam, (MappingDesignator)headerParamTargetDesignator);
                OpenApi2xUtil.setSimpleTypeFacets((AbstractSerializableParameter)swaggerHeaderParam, (XSDElementDeclaration)headerParamTargetElement, (XSDSimpleTypeDefinition)headerParamTargetType);
                continue;
            }
            ZCeeMappingUtil.clearParameterArrayFacets((AbstractSerializableParameter)swaggerHeaderParam);
            OpenApi2xUtil.clearSimpleTypeFacets((AbstractSerializableParameter)swaggerHeaderParam);
        }
        parameters.addAll(orderedSwaggerHeaderParams);
    }

    private void updateMethodScopePathParameters(List<Parameter> parameters, Operation operation, MethodType methodType, Path path, PathType pathType) {
        ZCeeInputMappingModel inputMappingModel = (ZCeeInputMappingModel)this.mappingModel;
        ArrayList<Parameter> removeParams = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            PathParameter mappingPathParam;
            if (!(parameter instanceof PathParameter) || (mappingPathParam = inputMappingModel.getPathParameter(parameter.getName())) != null) continue;
            removeParams.add(parameter);
        }
        parameters.removeAll(removeParams);
        ArrayList<PathParameter> orderedPathParams = new ArrayList<PathParameter>();
        for (PathParameter mappingPathParam : inputMappingModel.getPathParameters()) {
            PathParameter swaggerPathParam = OpenApi2xUtil.getPathParameter(parameters, (String)mappingPathParam.getName());
            if (swaggerPathParam == null) {
                swaggerPathParam = mappingPathParam;
            } else {
                parameters.remove(swaggerPathParam);
            }
            orderedPathParams.add(swaggerPathParam);
            swaggerPathParam.setIn(mappingPathParam.getIn());
            swaggerPathParam.setRequired(mappingPathParam.getRequired());
            String collectionFormat = mappingPathParam.getCollectionFormat();
            swaggerPathParam.setType(mappingPathParam.getType());
            if (mappingPathParam.getItems() != null) {
                swaggerPathParam.items(mappingPathParam.getItems());
                swaggerPathParam.setCollectionFormat(collectionFormat);
            } else {
                swaggerPathParam.items(null);
                swaggerPathParam.setCollectionFormat(null);
            }
            MappingDesignator pathParamTargetDesignator = inputMappingModel.getPathParameterTargetDesignator(swaggerPathParam.getName());
            if (pathParamTargetDesignator != null) {
                XSDElementDeclaration pathParamTargetElement = inputMappingModel.getPathParamTargetXsdElement(swaggerPathParam.getName());
                XSDSimpleTypeDefinition pathParamTargetType = inputMappingModel.getPathParamTargetXsdType(swaggerPathParam.getName());
                ZCeeMappingUtil.setParameterArrayFacets((AbstractSerializableParameter)swaggerPathParam, (MappingDesignator)pathParamTargetDesignator);
                OpenApi2xUtil.setSimpleTypeFacets((AbstractSerializableParameter)swaggerPathParam, (XSDElementDeclaration)pathParamTargetElement, (XSDSimpleTypeDefinition)pathParamTargetType);
                continue;
            }
            ZCeeMappingUtil.clearParameterArrayFacets((AbstractSerializableParameter)swaggerPathParam);
            OpenApi2xUtil.clearSimpleTypeFacets((AbstractSerializableParameter)swaggerPathParam);
        }
        parameters.addAll(orderedPathParams);
    }

    private void updateMethodScopeQueryParameters(List<Parameter> parameters, Operation operation, MethodType methodType, Path path, PathType pathType) {
        ZCeeInputMappingModel inputMappingModel = (ZCeeInputMappingModel)this.mappingModel;
        ArrayList<Parameter> removeParams = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            QueryParameter mappingQueryParam;
            if (!(parameter instanceof QueryParameter) || (mappingQueryParam = inputMappingModel.getQueryParameter(parameter.getName())) != null) continue;
            removeParams.add(parameter);
        }
        parameters.removeAll(removeParams);
        ArrayList<QueryParameter> orderedQueryParams = new ArrayList<QueryParameter>();
        for (QueryParameter mappingQueryParam : inputMappingModel.getQueryParameters()) {
            QueryParameter swaggerQueryParam = OpenApi2xUtil.getQueryParameter(parameters, (String)mappingQueryParam.getName());
            if (swaggerQueryParam == null) {
                swaggerQueryParam = mappingQueryParam;
            } else {
                parameters.remove(swaggerQueryParam);
            }
            orderedQueryParams.add(swaggerQueryParam);
            swaggerQueryParam.setIn(mappingQueryParam.getIn());
            swaggerQueryParam.setRequired(mappingQueryParam.getRequired());
            String collectionFormat = mappingQueryParam.getCollectionFormat();
            swaggerQueryParam.setType(mappingQueryParam.getType());
            if (mappingQueryParam.getItems() != null) {
                swaggerQueryParam.items(mappingQueryParam.getItems());
                swaggerQueryParam.setCollectionFormat(collectionFormat);
            } else {
                swaggerQueryParam.items(null);
                swaggerQueryParam.setCollectionFormat(null);
            }
            MappingDesignator queryParamTargetDesignator = inputMappingModel.getQueryParameterTargetDesignator(swaggerQueryParam.getName());
            if (queryParamTargetDesignator != null) {
                XSDElementDeclaration queryParamTargetElement = inputMappingModel.getQueryParamTargetXsdElement(swaggerQueryParam.getName());
                XSDSimpleTypeDefinition queryParamTargetType = inputMappingModel.getQueryParamTargetXsdType(swaggerQueryParam.getName());
                ZCeeMappingUtil.setParameterArrayFacets((AbstractSerializableParameter)swaggerQueryParam, (MappingDesignator)queryParamTargetDesignator);
                OpenApi2xUtil.setSimpleTypeFacets((AbstractSerializableParameter)swaggerQueryParam, (XSDElementDeclaration)queryParamTargetElement, (XSDSimpleTypeDefinition)queryParamTargetType);
                continue;
            }
            ZCeeMappingUtil.clearParameterArrayFacets((AbstractSerializableParameter)swaggerQueryParam);
            OpenApi2xUtil.clearSimpleTypeFacets((AbstractSerializableParameter)swaggerQueryParam);
        }
        parameters.addAll(orderedQueryParams);
    }

    private void updateMethodScopeOutputHeadersMap(Map<String, Property> headers, Operation operation, MethodType methodType, Path path, PathType pathType) {
        ZCeeOutputMappingModel outputMappingModel = (ZCeeOutputMappingModel)this.mappingModel;
        ArrayList<Object> removeHeaders = new ArrayList<Object>();
        for (Map.Entry<String, Property> entry : headers.entrySet()) {
            String swaggerHeaderName = entry.getKey();
            Property mappingHeaderProp = outputMappingModel.getHeaderProperty(swaggerHeaderName);
            if (mappingHeaderProp != null) continue;
            removeHeaders.add(swaggerHeaderName);
        }
        for (String string : removeHeaders) {
            headers.remove(string);
        }
        Iterator iterator = outputMappingModel.getHeaderParamNameToProperty().entrySet().iterator();
        LinkedHashMap<String, Property> orderedHeaderParams = new LinkedHashMap<String, Property>();
        while (iterator.hasNext()) {
            Map.Entry mappingHeaderEntry = iterator.next();
            String mappingHeaderName = (String)mappingHeaderEntry.getKey();
            Property mappingHeaderProp = (Property)mappingHeaderEntry.getValue();
            Property swaggerHeaderProp = headers.get(mappingHeaderName);
            if (swaggerHeaderProp != null) {
                mappingHeaderProp.setAccess(swaggerHeaderProp.getAccess());
                mappingHeaderProp.setDescription(swaggerHeaderProp.getDescription());
                mappingHeaderProp.setExample(swaggerHeaderProp.getExample());
                mappingHeaderProp.setPosition(swaggerHeaderProp.getPosition());
                mappingHeaderProp.setReadOnly(swaggerHeaderProp.getReadOnly());
                mappingHeaderProp.setRequired(swaggerHeaderProp.getRequired());
                mappingHeaderProp.setTitle(swaggerHeaderProp.getTitle());
                headers.remove(mappingHeaderName);
            }
            orderedHeaderParams.put(mappingHeaderName, mappingHeaderProp);
            MappingDesignator headerParamSourceDesignator = outputMappingModel.getHeaderPropertySourceDesignator(mappingHeaderProp.getName());
            if (headerParamSourceDesignator != null) {
                XSDElementDeclaration headerParamSourceElement = outputMappingModel.getHeaderParamSourceXsdElement(mappingHeaderProp.getName());
                XSDSimpleTypeDefinition headerParamSourceType = outputMappingModel.getHeaderParamSourceXsdType(mappingHeaderProp.getName());
                ZCeeMappingUtil.setPropertyArrayFacets((Property)mappingHeaderProp, (MappingDesignator)headerParamSourceDesignator);
                OpenApi2xUtil.setSimpleTypeFacets((Property)mappingHeaderProp, (XSDElementDeclaration)headerParamSourceElement, (XSDSimpleTypeDefinition)headerParamSourceType);
                continue;
            }
            ZCeeMappingUtil.clearPropertyArrayFacets((Property)mappingHeaderProp);
            OpenApi2xUtil.clearSimpleTypeFacets((Property)mappingHeaderProp);
        }
        headers.putAll(orderedHeaderParams);
    }

    private void updateMethodScopeOutputHeadersFromAssignMappings(Map<String, Property> headers, Operation operation, MethodType methodType, Path path, PathType pathType) {
        Collection assignMappings = ((ZCeeOutputMappingModel)this.mappingModel).getHeaderParamNameToAssignMapping().values();
        for (Mapping assignMapping : assignMappings) {
            String headerName;
            Property header;
            MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)assignMapping.getOutputs());
            if (output == null) continue;
            SemanticRefinement refinement = (SemanticRefinement)ListUtilz.getFirstMember((List)assignMapping.getRefinements());
            String assignValue = ModelUtils.getAssignValue((FunctionRefinement)((FunctionRefinement)refinement));
            boolean omitFromInterface = false;
            if (MapUtilz.notEmpty((EMap)output.getAnnotations())) {
                omitFromInterface = BooleanUtils.toBoolean((String)((String)output.getAnnotations().get((Object)ZosConnectMappingAnnotations.OMIT_FROM_INTERFACE.value())));
            }
            if ((header = headers.get(headerName = ZCeeMappingUtil.getDesignatorLocalName((MappingDesignator)output))) == null) continue;
            if (omitFromInterface) {
                headers.remove(headerName);
                continue;
            }
            header.setDefault(assignValue);
        }
    }

    private void updateBodyParameterSchemaFromMoveMappings(Model model, Operation operation, MethodType methodType, Path path, PathType pathType) {
        Map properties = model.getProperties();
        if (MapUtilz.isEmpty((Map)properties)) {
            return;
        }
        List moveMappings = null;
        moveMappings = this.isInputMapping ? ((ZCeeInputMappingModel)this.mappingModel).getMoveMappings() : ((ZCeeOutputMappingModel)this.mappingModel).getMoveMappings();
        for (Mapping moveMapping : moveMappings) {
            MappingDesignator input = (MappingDesignator)ListUtilz.getFirstMember((List)moveMapping.getInputs());
            MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)moveMapping.getOutputs());
            if (input == null || output == null) continue;
            MappingDesignator moveDesignator = null;
            moveDesignator = ZCeeMappingUtil.isHttpInputDesignator((MappingDesignator)input) ? output : input;
            String propertyPath = ZCeeMappingUtil.getDesignatorFullPath((MappingDesignator)moveDesignator, (String)"/");
            this.removePropertyFromBodyParameterSchema(model, propertyPath);
        }
    }

    private void updateBodyParameterSchemaFromRemoveMappings(Model model, Operation operation, MethodType methodType, Path path, PathType pathType) {
        Map properties = model.getProperties();
        if (MapUtilz.isEmpty((Map)properties)) {
            return;
        }
        List removeMappings = null;
        removeMappings = this.isInputMapping ? ((ZCeeInputMappingModel)this.mappingModel).getRemoveMappings() : ((ZCeeOutputMappingModel)this.mappingModel).getRemoveMappings();
        for (Mapping removeMapping : removeMappings) {
            MappingDesignator removeDesignator = (MappingDesignator)ListUtilz.getFirstMember((List)removeMapping.getOutputs());
            if (removeDesignator == null) continue;
            String propertyPath = ZCeeMappingUtil.getDesignatorFullPath((MappingDesignator)removeDesignator, (String)"/");
            this.removePropertyFromBodyParameterSchema(model, propertyPath);
        }
    }

    private void updateBodyParameterSchemaFromAssignMappings(Model model, Operation operation, MethodType methodType, Path path, PathType pathType) {
        Map properties = model.getProperties();
        if (MapUtilz.isEmpty((Map)properties)) {
            return;
        }
        List assignMappings = null;
        assignMappings = this.isInputMapping ? ((ZCeeInputMappingModel)this.mappingModel).getAssignMappings() : ((ZCeeOutputMappingModel)this.mappingModel).getAssignMappings();
        for (Mapping assignMapping : assignMappings) {
            boolean useTempTopObjectProperty;
            String outputPath;
            String[] segments;
            MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)assignMapping.getOutputs());
            if (output == null || (segments = (outputPath = ZCeeMappingUtil.getDesignatorFullPath((MappingDesignator)output, (String)"/")).split("/")).length == 0) continue;
            SemanticRefinement refinement = (SemanticRefinement)ListUtilz.getFirstMember((List)assignMapping.getRefinements());
            String assignValue = ModelUtils.getAssignValue((FunctionRefinement)((FunctionRefinement)refinement));
            boolean omitFromInterface = false;
            if (MapUtilz.notEmpty((EMap)output.getAnnotations())) {
                omitFromInterface = BooleanUtils.toBoolean((String)((String)output.getAnnotations().get((Object)ZosConnectMappingAnnotations.OMIT_FROM_INTERFACE.value())));
            }
            int topPropertyCount = 0;
            int topObjectPropertyCount = 0;
            for (Property property : properties.values()) {
                if (property instanceof ObjectProperty) {
                    ++topObjectPropertyCount;
                }
                ++topPropertyCount;
            }
            ObjectProperty topObjectProperty = null;
            boolean bl = useTempTopObjectProperty = topObjectPropertyCount == 0 || topPropertyCount > 1 || properties.get(segments[0]) == null;
            if (useTempTopObjectProperty) {
                topObjectProperty = new ObjectProperty();
                topObjectProperty.setName(TEMP_OBJECT_PROPERTY_NAME);
                topObjectProperty.setProperties(properties);
            } else if (properties.get(segments[0]) instanceof ObjectProperty) {
                topObjectProperty = (ObjectProperty)properties.get(segments[0]);
                topObjectProperty.setName(segments[0]);
            }
            Map topObjectContent = topObjectProperty.getProperties();
            if (MapUtilz.isEmpty((Map)topObjectContent) && !useTempTopObjectProperty) {
                properties.remove(topObjectProperty.getName());
                continue;
            }
            ObjectProperty currProperty = topObjectProperty;
            String currObjectPropertyName = topObjectProperty.getName();
            Map currObjectContent = topObjectContent;
            Stack<Pair> pathObjectStack = new Stack<Pair>();
            pathObjectStack.push(Pair.of((Object)currObjectPropertyName, (Object)currObjectContent));
            int i = 1;
            while (i < segments.length) {
                boolean isLastSegment;
                boolean bl2 = isLastSegment = i + 1 >= segments.length;
                if (!isLastSegment && currProperty instanceof ObjectProperty) {
                    currObjectContent = currProperty.getProperties();
                    if (!MapUtilz.isEmpty((Map)currObjectContent)) {
                        ArrayProperty array;
                        Property items;
                        currObjectPropertyName = segments[i];
                        currProperty = (Property)currObjectContent.get(segments[i]);
                        if (currProperty instanceof ObjectProperty) {
                            currObjectContent = currProperty.getProperties();
                            pathObjectStack.push(Pair.of((Object)currObjectPropertyName, (Object)currObjectContent));
                        } else if (currProperty instanceof ArrayProperty && (items = (array = (ArrayProperty)currProperty).getItems()) instanceof ObjectProperty) {
                            ObjectProperty nestedObjectProperty = (ObjectProperty)items;
                            currObjectContent = nestedObjectProperty.getProperties();
                            pathObjectStack.push(Pair.of((Object)currObjectPropertyName, (Object)currObjectContent));
                        }
                    }
                } else if (isLastSegment && !MapUtilz.isEmpty((Map)currObjectContent) && (currProperty = (Property)currObjectContent.get(segments[i])) != null) {
                    if (!omitFromInterface) {
                        currProperty.setDefault(assignValue);
                        currProperty.setRequired(false);
                    } else {
                        currObjectContent.remove(segments[i]);
                    }
                }
                ++i;
            }
            while (pathObjectStack.size() > 1) {
                Pair childPathObject = (Pair)pathObjectStack.pop();
                Pair parentPathObject = (Pair)pathObjectStack.peek();
                if (!MapUtilz.isEmpty((Map)((Map)childPathObject.getValue()))) continue;
                ((Map)parentPathObject.getValue()).remove(childPathObject.getKey());
            }
            if (!MapUtilz.isEmpty((Map)topObjectContent) || useTempTopObjectProperty) continue;
            properties.remove(topObjectProperty.getName());
        }
    }

    private void removePropertyFromBodyParameterSchema(Model model, String propertyPath) {
        boolean useTempTopObjectProperty;
        Map properties = model.getProperties();
        if (MapUtilz.isEmpty((Map)properties)) {
            return;
        }
        String[] segments = propertyPath.split("/");
        if (segments.length == 0) {
            return;
        }
        int topPropertyCount = 0;
        int topObjectPropertyCount = 0;
        for (Property property : properties.values()) {
            if (property instanceof ObjectProperty) {
                ++topObjectPropertyCount;
            }
            ++topPropertyCount;
        }
        ObjectProperty topObjectProperty = null;
        boolean bl = useTempTopObjectProperty = topObjectPropertyCount == 0 || topPropertyCount > 1 || properties.get(segments[0]) == null;
        if (useTempTopObjectProperty) {
            topObjectProperty = new ObjectProperty();
            topObjectProperty.setName(TEMP_OBJECT_PROPERTY_NAME);
            topObjectProperty.setProperties(properties);
        } else if (properties.get(segments[0]) instanceof ObjectProperty) {
            topObjectProperty = (ObjectProperty)properties.get(segments[0]);
            topObjectProperty.setName(segments[0]);
        }
        Map<String, Property> topObjectContent = topObjectProperty.getProperties();
        if (MapUtilz.isEmpty((Map)topObjectContent) && !useTempTopObjectProperty) {
            properties.remove(topObjectProperty.getName());
            return;
        }
        ObjectProperty currProperty = topObjectProperty;
        String currObjectPropertyName = topObjectProperty.getName();
        Map<String, Property> currObjectContent = topObjectContent;
        Stack<Pair> pathObjectStack = new Stack<Pair>();
        pathObjectStack.push(Pair.of((Object)currObjectPropertyName, (Object)currObjectContent));
        int i = 1;
        while (i < segments.length) {
            boolean isLastSegment;
            boolean bl2 = isLastSegment = i + 1 >= segments.length;
            if (!isLastSegment && this.isObjectOrArrayOfObject((Property)currProperty)) {
                currObjectContent = this.getObjectOrArrayOfObjectContent((Property)currProperty);
                if (!MapUtilz.isEmpty(currObjectContent)) {
                    currObjectPropertyName = segments[i];
                    currProperty = currObjectContent.get(segments[i]);
                    if (this.isObjectOrArrayOfObject((Property)currProperty)) {
                        currObjectContent = this.getObjectOrArrayOfObjectContent((Property)currProperty);
                        pathObjectStack.push(Pair.of((Object)currObjectPropertyName, currObjectContent));
                    }
                }
            } else if (isLastSegment && MapUtilz.notEmpty((Map)currObjectContent)) {
                currObjectContent.remove(segments[i]);
            }
            ++i;
        }
        while (pathObjectStack.size() > 1) {
            Pair childPathObject = (Pair)pathObjectStack.pop();
            Pair parentPathObject = (Pair)pathObjectStack.peek();
            if (!MapUtilz.isEmpty((Map)((Map)childPathObject.getValue()))) continue;
            ((Map)parentPathObject.getValue()).remove(childPathObject.getKey());
        }
        if (MapUtilz.isEmpty((Map)topObjectContent) && !useTempTopObjectProperty) {
            properties.remove(topObjectProperty.getName());
        }
    }

    private boolean isObjectOrArrayOfObject(Property property) {
        ArrayProperty array;
        Property items;
        boolean hasContent = false;
        if (property instanceof ObjectProperty) {
            hasContent = true;
        } else if (property instanceof ArrayProperty && (items = (array = (ArrayProperty)property).getItems()) instanceof ObjectProperty) {
            hasContent = true;
        }
        return hasContent;
    }

    private Map<String, Property> getObjectOrArrayOfObjectContent(Property property) {
        ArrayProperty array;
        Property items;
        Map objectContent = null;
        if (property instanceof ObjectProperty) {
            ObjectProperty object = (ObjectProperty)property;
            objectContent = object.getProperties();
        } else if (property instanceof ArrayProperty && (items = (array = (ArrayProperty)property).getItems()) instanceof ObjectProperty) {
            ObjectProperty object = (ObjectProperty)items;
            objectContent = object.getProperties();
        }
        return objectContent;
    }
}

