/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.api;

import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.mapping.service.MappingMessageType;
import com.ibm.zosconnect.api.mapping.service.MappingModelType;
import com.ibm.zosconnect.api.mapping.service.RequestMessageType;
import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.api.mapping.service.ZosConnectServiceMapping;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ZosConnectApiProjectNature;
import com.ibm.zosconnect.ui.common.util.FileUtilz;
import com.ibm.zosconnect.ui.common.util.MappingFileUtilz;
import com.ibm.zosconnect.ui.common.util.URIUtilz;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.common.validation.IMappingProblemProvider;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.controllers.api.ApiCapabilityExtension;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.EditedParmsBean;
import com.ibm.zosconnect.ui.controllers.api.RelativePathBean;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.controllers.dom.ParserWrapper;
import com.ibm.zosconnect.ui.controllers.dom.Writer;
import com.ibm.zosconnect.ui.controllers.validation.ApiResponseValidator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeInlineXmlSchemaUtil;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingComparator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingValidatorUtil;
import com.ibm.zosconnect.ui.mapping.util.ZCeeXsdComparator;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;

public class ApiProjectController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ApiProjectController.class.getName();
    private IProject project;
    private IFolder apiFolder;
    private IFolder apiDocsFolder;
    private IFolder servicesFolder;
    private ApiModelController apiModelController;
    private List<MappingValidationProblem2> errorProblems = new ArrayList<MappingValidationProblem2>();
    private List<MappingValidationProblem2> warningProblems = new ArrayList<MappingValidationProblem2>();
    private List<MappingValidationProblem2> otherProblems = new ArrayList<MappingValidationProblem2>();
    protected static final String DEFAULT_PARSER_NAME = "com.ibm.zosconnect.ui.controllers.dom.wrappers.Xerces";
    private Map<PathType, Map<MethodType, ServiceMappingController>> serviceMappingControllers;

    public ApiProjectController(IProject project) {
        this.project = project;
        this.apiDocsFolder = this.project.getFolder("api-docs");
        this.servicesFolder = this.project.getFolder("services");
        this.apiFolder = this.project.getFolder("api");
        this.serviceMappingControllers = new HashMap<PathType, Map<MethodType, ServiceMappingController>>();
    }

    public static ApiProjectController createNewApiProject(String projectName, IProgressMonitor monitor) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        project.create(monitor);
        project.open(monitor);
        ZosConnectApiProjectNature.appendNature((IProject)project);
        return new ApiProjectController(project);
    }

    public static ApiProjectController createNewApiProject(String projectName) throws Exception {
        return ApiProjectController.createNewApiProject(projectName, (IProgressMonitor)new NullProgressMonitor());
    }

    public List<ServiceArchiveController> getServiceArchives() throws Exception {
        IFolder folder = this.getServicesFolder();
        ArrayList<ServiceArchiveController> retVal = new ArrayList<ServiceArchiveController>();
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource service = iResourceArray[n2];
            if (service instanceof IFolder) {
                retVal.add(new ServiceArchiveController(service));
            }
            ++n2;
        }
        return retVal;
    }

    public IFolder getApiDocsFolder(IProgressMonitor monitor) throws Exception {
        if (!this.apiDocsFolder.exists()) {
            monitor.beginTask(Xlat.description((String)"STATUS_CREATING_FOLDER", (String[])new String[]{Xlat.label((String)"APIPROJ_API_DOCS_FOLDER")}), -1);
            this.apiDocsFolder.create(false, true, monitor);
            monitor.done();
        }
        return this.apiDocsFolder;
    }

    public IFolder getApiDocsFolder() throws Exception {
        return this.getApiDocsFolder((IProgressMonitor)new NullProgressMonitor());
    }

    public IFolder getServicesFolder(IProgressMonitor monitor) throws Exception {
        if (!this.servicesFolder.exists()) {
            monitor.beginTask(Xlat.description((String)"STATUS_CREATING_FOLDER", (String[])new String[]{Xlat.label((String)"APIPROJ_SERVICES_FOLDER")}), -1);
            this.servicesFolder.create(false, true, monitor);
            monitor.done();
        }
        return this.servicesFolder;
    }

    public IFolder getServicesFolder() throws Exception {
        return this.getServicesFolder((IProgressMonitor)new NullProgressMonitor());
    }

    public IFolder getServiceFolder(String serviceName, boolean clean, IProgressMonitor monitor) throws Exception {
        ZCeeUILogger.entering((String)TAG, (String)"getServiceFolder(serviceName={0},clean={1},monitor={2})", (Object[])new Object[]{serviceName, clean, monitor});
        IFolder servicesFolder = this.getServicesFolder(monitor);
        IFolder serviceFolder = servicesFolder.getFolder(serviceName);
        String encodedServiceName = URIUtilz.encodeResourceName((String)serviceName);
        IFolder encodedServiceFolder = servicesFolder.getFolder(encodedServiceName);
        if (!StringUtils.equals((CharSequence)serviceName, (CharSequence)encodedServiceName) && serviceFolder.exists() && !encodedServiceFolder.exists()) {
            ZCeeUILogger.info((String)"migrating service folder name from \"{0}\" to escaped form \"{1}\"", (Object[])new Object[]{serviceName, encodedServiceName});
            serviceFolder.move(encodedServiceFolder.getFullPath(), true, monitor);
        }
        if (!encodedServiceFolder.exists()) {
            monitor.beginTask(Xlat.description((String)"STATUS_CREATING_FOLDER", (String[])new String[]{encodedServiceName}), -1);
            encodedServiceFolder.create(false, true, monitor);
            monitor.done();
        } else if (clean) {
            monitor.beginTask(Xlat.description((String)"STATUS_CLEANING_FOLDER", (String[])new String[]{encodedServiceName}), -1);
            FileUtils.cleanDirectory((File)encodedServiceFolder.getLocation().toFile());
            encodedServiceFolder.refreshLocal(2, monitor);
            monitor.done();
        }
        ZCeeUILogger.exiting((String)TAG, (String)"getServiceFolder(final String,boolean,IProgressMonitor)", (Object[])new Object[0]);
        return encodedServiceFolder;
    }

    public IFolder getServiceFolder(String serviceName, boolean clean) throws Exception {
        return this.getServiceFolder(serviceName, clean, (IProgressMonitor)new NullProgressMonitor());
    }

    public IFolder getApiFolder(IProgressMonitor monitor) throws CoreException {
        if (!this.apiFolder.exists()) {
            monitor.beginTask(Xlat.description((String)"STATUS_CREATING_FOLDER", (String[])new String[]{Xlat.label((String)"APIPROJ_API_FOLDER")}), -1);
            this.apiFolder.create(false, true, monitor);
            monitor.done();
        }
        return this.apiFolder;
    }

    public IFolder getApiFolder() throws CoreException {
        return this.getApiFolder((IProgressMonitor)new NullProgressMonitor());
    }

    public IPath getMappingFolderPath(PathType pathType, MethodValues methodValue) {
        String[] pathSegments;
        Path mappingFolderPath = new Path("");
        String path = pathType.getRelativePath();
        path = StringUtils.removePattern((String)path, (String)"\\s+");
        path = OpenApi2xUtil.stripQueryParameters((String)path);
        String[] stringArray = pathSegments = path.split("/");
        int n = pathSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSegment = stringArray[n2];
            mappingFolderPath = mappingFolderPath.append(WorkspaceUtil.getValidFileName((String)pathSegment));
            ++n2;
        }
        mappingFolderPath = mappingFolderPath.append(methodValue.name());
        return mappingFolderPath;
    }

    public IFolder getMappingFolder(PathType pathType, MethodValues methodValue, IProgressMonitor monitor) throws Exception {
        IPath mappingFolderPath = this.getMappingFolderPath(pathType, methodValue);
        IFolder mappingFolder = this.getApiFolder().getFolder(mappingFolderPath);
        if (!mappingFolder.exists()) {
            monitor.beginTask(Xlat.description((String)"STATUS_CREATING_FOLDER", (String[])new String[]{mappingFolderPath.toPortableString()}), -1);
            FileUtils.forceMkdir((File)mappingFolder.getLocation().toFile());
            mappingFolder.refreshLocal(2, monitor);
            monitor.done();
        }
        return mappingFolder;
    }

    public IFolder getMappingFolder(PathType pathType, MethodValues methodValue) throws Exception {
        return this.getMappingFolder(pathType, methodValue, (IProgressMonitor)new NullProgressMonitor());
    }

    public IFolder getMappingFolderWithoutCreate(PathType pathType, MethodValues methodValue) throws Exception {
        IPath mappingFolderPath = this.getMappingFolderPath(pathType, methodValue);
        IFolder mappingFolder = this.getApiFolder().getFolder(mappingFolderPath);
        return mappingFolder;
    }

    public void importServiceArchive(ServiceArchiveController serviceArchiveController, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Xlat.description((String)"STATUS_IMPORTING_SAR", (String[])new String[]{this.project.getName()}), -1);
        File stateLocation = serviceArchiveController.extractToStateLocation();
        IFolder serviceFolder = this.getServiceFolder(serviceArchiveController.getServiceName(), true, monitor);
        File serviceFolderLocation = serviceFolder.getLocation().toFile();
        FileUtils.copyDirectory((File)stateLocation, (File)serviceFolderLocation);
        serviceFolder.refreshLocal(2, monitor);
        serviceArchiveController.deleteFromStateLocation();
        serviceArchiveController.setCurrentLocation(serviceFolderLocation);
        monitor.done();
    }

    public void updateMappingFiles(ServiceArchiveController serviceArchiveController, IProgressMonitor monitor) throws Exception {
        String serviceName = serviceArchiveController.getServiceName();
        File requestSchemaFile = serviceArchiveController.getRequestSchemaFile();
        File responseSchemaFile = serviceArchiveController.getResponseSchemaFile();
        for (ServiceMappingController servMapCtrl : this.getServiceRefMappingControllers(serviceName)) {
            if (FileUtilz.exists((IFile)servMapCtrl.getRequestMappingFile())) {
                IFile mappingFile = null;
                String mappingFilePath = null;
                try {
                    try {
                        mappingFile = servMapCtrl.getRequestMappingFile();
                        mappingFilePath = mappingFile.getFullPath().toOSString();
                        monitor.beginTask(Xlat.description((String)"STATUS_UPDATING_MAPPING_FILE", (String[])new String[]{mappingFilePath}), -1);
                        ZCeeInlineXmlSchemaUtil.updateJsonOutputInlineXmlSchema((IFile)mappingFile, (File)requestSchemaFile, (String)serviceName);
                        monitor.beginTask(Xlat.description((String)"STATUS_UPDATING_PROBLEMS_VIEW", (String[])new String[]{mappingFilePath}), -1);
                        MappingValidationProblem2.deleteFileMarkers((IPath)mappingFile.getLocation());
                        for (MappingValidationProblem2 problem : this.getErrorProblems(mappingFile)) {
                            problem.createMarker();
                        }
                        for (MappingValidationProblem2 problem : this.getWarningProblems(mappingFile)) {
                            problem.createMarker();
                        }
                        for (MappingValidationProblem2 problem : this.getOtherProblems(mappingFile)) {
                            problem.createMarker();
                        }
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((Throwable)e);
                        String msg = Xlat.error((String)"MSL_SERVICE_UPDATE_ERROR", (String[])new String[]{mappingFilePath, serviceName, e.getMessage()});
                        throw new ZosConnectUIException(msg, (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        mappingFile.refreshLocal(2, monitor);
                        monitor.done();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    mappingFile.refreshLocal(2, monitor);
                    monitor.done();
                }
                catch (Exception exception) {}
            }
            for (ResponseMessageType responseMessage : servMapCtrl.getResponseMessages()) {
                if (!servMapCtrl.hasMapping((MappingMessageType)responseMessage)) continue;
                IFile mappingFile = null;
                String mappingFilePath = null;
                try {
                    try {
                        mappingFile = servMapCtrl.getResponseMappingFile(responseMessage);
                        mappingFilePath = mappingFile.getFullPath().toOSString();
                        monitor.beginTask(Xlat.description((String)"STATUS_UPDATING_MAPPING_FILE", (String[])new String[]{mappingFilePath}), -1);
                        ZCeeInlineXmlSchemaUtil.updateJsonInputInlineXmlSchema((IFile)mappingFile, (File)responseSchemaFile, (String)serviceName);
                        monitor.beginTask(Xlat.description((String)"STATUS_UPDATING_PROBLEMS_VIEW", (String[])new String[]{mappingFilePath}), -1);
                        MappingValidationProblem2.deleteFileMarkers((IPath)mappingFile.getLocation());
                        for (MappingValidationProblem2 problem : this.getErrorProblems(mappingFile)) {
                            problem.createMarker();
                        }
                        for (MappingValidationProblem2 problem : this.getWarningProblems(mappingFile)) {
                            problem.createMarker();
                        }
                        for (MappingValidationProblem2 problem : this.getOtherProblems(mappingFile)) {
                            problem.createMarker();
                        }
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((Throwable)e);
                        String msg = Xlat.error((String)"MSL_SERVICE_UPDATE_ERROR", (String[])new String[]{mappingFilePath, serviceName, e.getMessage()});
                        throw new ZosConnectUIException(msg, (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        mappingFile.refreshLocal(2, monitor);
                        monitor.done();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    mappingFile.refreshLocal(2, monitor);
                    monitor.done();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void updateClonedMappingFiles(ServiceArchiveController newServiceArchiveController, IProgressMonitor monitor) throws Exception {
        IFile packageXmlFile = this.apiModelController.getPackageXmlFile();
        String serviceName = newServiceArchiveController.getServiceName();
        File newRequestSchemaFile = newServiceArchiveController.getRequestSchemaFile();
        File newResponseSchemaFile = newServiceArchiveController.getResponseSchemaFile();
        Model responseSchemaModel = newServiceArchiveController.getResponseSchemaModel();
        LinkedHashMap<String, Property> responseLeafProperties = null;
        for (ServiceMappingController servMapCtrl : this.getServiceRefMappingControllers(serviceName)) {
            IFile requestMappingFile = servMapCtrl.getRequestMappingFile();
            if (FileUtilz.exists((IFile)requestMappingFile)) {
                String mappingFilePath = null;
                IFile newTempMappingFile = null;
                try {
                    try {
                        mappingFilePath = requestMappingFile.getFullPath().toOSString();
                        newTempMappingFile = this.getTempMappingFile(requestMappingFile, mappingFilePath, true, monitor);
                        ZCeeInlineXmlSchemaUtil.updateJsonOutputInlineXmlSchema((IFile)newTempMappingFile, (File)newRequestSchemaFile, (String)serviceName);
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((Throwable)e);
                        String msg = Xlat.error((String)"MSL_SERVICE_UPDATE_ERROR", (String[])new String[]{mappingFilePath, serviceName, e.getMessage()});
                        throw new ZosConnectUIException(msg, (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        newTempMappingFile.refreshLocal(2, monitor);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    newTempMappingFile.refreshLocal(2, monitor);
                }
                catch (Exception exception) {}
                ZCeeMappingComparator comparator = new ZCeeMappingComparator(requestMappingFile, newTempMappingFile);
                comparator.compare();
                this.updateAndCacheProblems(serviceName, (IMappingProblemProvider)comparator, servMapCtrl);
                newTempMappingFile.delete(false, monitor);
            } else {
                ServiceArchiveController existingServiceArchiveController = this.getServiceArchiveController(serviceName);
                IFolder serviceFolder = this.getServiceFolder(serviceName, false);
                IFile existingRequestSchemaFile = serviceFolder.getFile(existingServiceArchiveController.getRequestSchema());
                XSDSchema existingXsdSchema = ZCeeInlineXmlSchemaUtil.getXmlSchemaFromJsonSchema((String)existingRequestSchemaFile.getRawLocation().toOSString(), (String)serviceName);
                XSDSchema newXsdSchema = ZCeeInlineXmlSchemaUtil.getXmlSchemaFromJsonSchema((String)newRequestSchemaFile.getAbsolutePath(), (String)serviceName);
                ZCeeXsdComparator comparator = new ZCeeXsdComparator(existingXsdSchema, newXsdSchema, Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_REQUEST"));
                comparator.compare();
                this.updateAndCacheProblems(serviceName, (IMappingProblemProvider)comparator, servMapCtrl);
            }
            for (ResponseMessageType responseMessage : servMapCtrl.getResponseMessages()) {
                if (servMapCtrl.hasMapping((MappingMessageType)responseMessage)) {
                    ApiResponseValidator validator;
                    ZCeeMappingComparator comparator;
                    IFile mappingFile = null;
                    String mappingFilePath = null;
                    IFile newTempMappingFile = null;
                    try {
                        try {
                            mappingFile = servMapCtrl.getResponseMappingFile(responseMessage);
                            mappingFilePath = mappingFile.getFullPath().toOSString();
                            newTempMappingFile = this.getTempMappingFile(mappingFile, mappingFilePath, false, monitor);
                            ZCeeInlineXmlSchemaUtil.updateJsonInputInlineXmlSchema((IFile)newTempMappingFile, (File)newResponseSchemaFile, (String)serviceName);
                        }
                        catch (Exception e) {
                            ZCeeUILogger.error((Throwable)e);
                            String msg = Xlat.error((String)"MSL_SERVICE_UPDATE_ERROR", (String[])new String[]{mappingFilePath, serviceName, e.getMessage()});
                            throw new ZosConnectUIException(msg, (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            newTempMappingFile.refreshLocal(2, monitor);
                        }
                        catch (Exception exception) {}
                        comparator = new ZCeeMappingComparator(mappingFile, newTempMappingFile, responseMessage.getCode());
                        comparator.compare();
                        this.updateAndCacheProblems(serviceName, (IMappingProblemProvider)comparator, servMapCtrl);
                        if (responseLeafProperties == null) {
                            responseLeafProperties = ServiceArchiveController.getLeafProperties(responseSchemaModel);
                        }
                        validator = new ApiResponseValidator(servMapCtrl.getOperationId(), responseMessage, responseLeafProperties, packageXmlFile);
                        validator.validate();
                        this.updateAndCacheProblems(serviceName, validator, servMapCtrl);
                        newTempMappingFile.delete(false, monitor);
                        throw throwable;
                    }
                    try {
                        newTempMappingFile.refreshLocal(2, monitor);
                    }
                    catch (Exception exception) {}
                    comparator = new ZCeeMappingComparator(mappingFile, newTempMappingFile, responseMessage.getCode());
                    comparator.compare();
                    this.updateAndCacheProblems(serviceName, (IMappingProblemProvider)comparator, servMapCtrl);
                    if (responseLeafProperties == null) {
                        responseLeafProperties = ServiceArchiveController.getLeafProperties(responseSchemaModel);
                    }
                    validator = new ApiResponseValidator(servMapCtrl.getOperationId(), responseMessage, responseLeafProperties, packageXmlFile);
                    validator.validate();
                    this.updateAndCacheProblems(serviceName, validator, servMapCtrl);
                    newTempMappingFile.delete(false, monitor);
                    continue;
                }
                ServiceArchiveController existingServiceArchiveController = this.getServiceArchiveController(serviceName);
                IFolder serviceFolder = this.getServiceFolder(serviceName, false);
                IFile existingResponseSchemaFile = serviceFolder.getFile(existingServiceArchiveController.getResponseSchema());
                XSDSchema existingXsdSchema = ZCeeInlineXmlSchemaUtil.getXmlSchemaFromJsonSchema((String)existingResponseSchemaFile.getRawLocation().toOSString(), (String)serviceName);
                XSDSchema newXsdSchema = ZCeeInlineXmlSchemaUtil.getXmlSchemaFromJsonSchema((String)newResponseSchemaFile.getAbsolutePath(), (String)serviceName);
                ZCeeXsdComparator comparator = new ZCeeXsdComparator(existingXsdSchema, newXsdSchema, Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_RESPONSE", (Object[])new Object[]{responseMessage.getCode()}));
                comparator.compare();
                this.updateAndCacheProblems(serviceName, (IMappingProblemProvider)comparator, servMapCtrl);
                if (responseLeafProperties == null) {
                    responseLeafProperties = ServiceArchiveController.getLeafProperties(responseSchemaModel);
                }
                ApiResponseValidator validator = new ApiResponseValidator(servMapCtrl.getOperationId(), responseMessage, responseLeafProperties, packageXmlFile);
                validator.validate();
                this.updateAndCacheProblems(serviceName, validator, servMapCtrl);
            }
        }
    }

    private void updateAndCacheProblems(String serviceName, IMappingProblemProvider provider, ServiceMappingController servMapCtrl) {
        String method = servMapCtrl.getMethodType().getType().name();
        String opid = servMapCtrl.getMethodType().getOperationId();
        String path = servMapCtrl.getPathType().getRelativePath();
        path = OpenApi2xUtil.stripQueryParameters((String)path);
        for (MappingValidationProblem2 msg : provider.getErrorProblems()) {
            msg.setMethod(method);
            msg.setOperationId(opid);
            msg.setPath(path);
            msg.setService(serviceName);
            this.errorProblems.add(msg);
        }
        for (MappingValidationProblem2 msg : provider.getWarningProblems()) {
            msg.setMethod(method);
            msg.setOperationId(opid);
            msg.setPath(path);
            msg.setService(serviceName);
            this.warningProblems.add(msg);
        }
        for (MappingValidationProblem2 msg : provider.getOtherProblems()) {
            msg.setMethod(method);
            msg.setOperationId(opid);
            msg.setPath(path);
            msg.setService(serviceName);
            this.otherProblems.add(msg);
        }
    }

    public void clearProblemsCache() {
        this.errorProblems.clear();
        this.warningProblems.clear();
        this.otherProblems.clear();
    }

    public List<MappingValidationProblem2> getErrorProblems() {
        return this.errorProblems;
    }

    public List<MappingValidationProblem2> getErrorProblems(IFile mappingFile) {
        ArrayList<MappingValidationProblem2> problems = new ArrayList<MappingValidationProblem2>();
        for (MappingValidationProblem2 problem : this.errorProblems) {
            if (problem.getResourceLocation() == null || !problem.getResourceLocation().equals((Object)mappingFile.getLocation())) continue;
            problems.add(problem);
        }
        return problems;
    }

    public List<MappingValidationProblem2> getWarningProblems() {
        return this.warningProblems;
    }

    public List<MappingValidationProblem2> getWarningProblems(IFile mappingFile) {
        ArrayList<MappingValidationProblem2> problems = new ArrayList<MappingValidationProblem2>();
        for (MappingValidationProblem2 problem : this.warningProblems) {
            if (problem.getResourceLocation() == null || !problem.getResourceLocation().equals((Object)mappingFile.getLocation())) continue;
            problems.add(problem);
        }
        return problems;
    }

    public List<MappingValidationProblem2> getOtherProblems() {
        return this.otherProblems;
    }

    public List<MappingValidationProblem2> getOtherProblems(IFile mappingFile) {
        ArrayList<MappingValidationProblem2> problems = new ArrayList<MappingValidationProblem2>();
        for (MappingValidationProblem2 problem : this.otherProblems) {
            if (problem.getResourceLocation() == null || !problem.getResourceLocation().equals((Object)mappingFile.getLocation())) continue;
            problems.add(problem);
        }
        return problems;
    }

    private IFile getTempMappingFile(IFile mappingFile, String mappingFilePath, boolean isRequest, IProgressMonitor monitor) throws Exception {
        Object newMappingFileName;
        String oldMappingFileName;
        if (isRequest) {
            oldMappingFileName = "request.map";
            newMappingFileName = "request_New.map";
        } else {
            int responseCode = MappingFileUtilz.getResponseCodeFromMappingFileName((IFile)mappingFile);
            oldMappingFileName = ServiceMappingController.getResponseMappingFileName(responseCode);
            newMappingFileName = StringUtils.substringBeforeLast((String)oldMappingFileName, (String)".") + "_New.map";
        }
        int lengthWithoutFile = mappingFilePath.length() - oldMappingFileName.length();
        Object newMappingFilePath = mappingFilePath.substring(0, lengthWithoutFile);
        newMappingFilePath = (String)newMappingFilePath + (String)newMappingFileName;
        Path newMappingPath = new Path((String)newMappingFilePath);
        mappingFile.copy((IPath)newMappingPath, false, monitor);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)newMappingPath);
    }

    public void handleMethodDeleted(PathType savedPathType, PathType currPathType, MethodType methodType) throws Exception {
        String savedRelPath = savedPathType.getRelativePath();
        String currRelPath = currPathType.getRelativePath();
        ServiceMappingController serviceMappingController = null;
        if (!StringUtils.equals((CharSequence)savedRelPath, (CharSequence)currRelPath)) {
            currPathType.setRelativePath(savedRelPath);
            serviceMappingController = this.getServiceMappingController(currPathType, methodType);
            serviceMappingController.deleteServiceMapping();
            currPathType.setRelativePath(currRelPath);
        } else {
            serviceMappingController = this.getServiceMappingController(currPathType, methodType);
            serviceMappingController.deleteServiceMapping();
        }
        this.removeServiceMappingController(currPathType, methodType);
    }

    public void checkForEditedPaths(List<RelativePathBean> pathBeans, IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < pathBeans.size()) {
            String newRelPath;
            RelativePathBean currPathBean = pathBeans.get(i);
            String oldRelPath = StringUtils.trimToEmpty((String)currPathBean.lastSavedPathType.getRelativePath());
            if (!StringUtils.equals((CharSequence)oldRelPath, (CharSequence)(newRelPath = StringUtils.trimToEmpty((String)currPathBean.pathType.getRelativePath())))) {
                this.updateAndMoveMappingFiles(currPathBean);
            }
            ++i;
        }
    }

    private void updateAndMoveMappingFiles(RelativePathBean relPathBean) throws Exception {
        String oldResourceId = ServiceMappingController.generateResourceId(relPathBean.lastSavedPathType);
        Set oldPathParms = URIUtilz.getPathParamNamesFromPath((String)relPathBean.lastSavedPathType.getRelativePath());
        Set oldQueryParms = URIUtilz.getQueryParamNamesFromPath((String)relPathBean.lastSavedPathType.getRelativePath());
        String newResourceId = ServiceMappingController.generateResourceId(relPathBean.pathType);
        Set newPathParms = URIUtilz.getPathParamNamesFromPath((String)relPathBean.pathType.getRelativePath());
        Set newQueryParams = URIUtilz.getQueryParamNamesFromPath((String)relPathBean.pathType.getRelativePath());
        EditedParmsBean editedPathParms = this.discoverEditedParms(oldPathParms, newPathParms);
        EditedParmsBean editedQueryParms = this.discoverEditedParms(oldQueryParms, newQueryParams);
        if (oldResourceId.equals(newResourceId)) {
            relPathBean.pathChanged = false;
            for (MethodType methodType : relPathBean.pathType.getMethod()) {
                ServiceMappingController serviceMappingController = this.getServiceMappingController(relPathBean.pathType, methodType);
                ZosConnectServiceMapping serviceMapping = serviceMappingController.getServiceMapping();
                RequestMessageType requestMessageType = serviceMapping.getRequestMessage();
                IFile requestMappingFile = serviceMappingController.getRequestMappingFile();
                if (requestMessageType == null || requestMappingFile == null || !requestMappingFile.exists()) continue;
                Object rawPath = requestMappingFile.getRawLocation().toOSString();
                rawPath = "file:" + ((String)rawPath).replace("\\", "/");
                ParserWrapper parser = (ParserWrapper)Class.forName(DEFAULT_PARSER_NAME).newInstance();
                Document document = parser.parse((String)rawPath);
                requestMappingFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                String method = methodType.getType().name();
                Writer writer = new Writer(editedPathParms, editedQueryParms, method + "." + newResourceId);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                writer.setOutput(baos, "UTF8");
                writer.write(document);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                requestMappingFile.create((InputStream)bais, true, (IProgressMonitor)new NullProgressMonitor());
                relPathBean.editedMessageMappings.add((MappingMessageType)requestMessageType);
                ZCeeMappingValidatorUtil.validateMappingFile((IFile)requestMappingFile);
            }
        } else {
            relPathBean.pathChanged = true;
            IFolder parentFolder = null;
            for (MethodType methodType : relPathBean.pathType.getMethod()) {
                ServiceMappingController serviceMappingController = this.getServiceMappingController(relPathBean.pathType, methodType);
                ZosConnectServiceMapping serviceMapping = serviceMappingController.getServiceMapping();
                IFolder oldMappingFolder = this.getMappingFolderWithoutCreate(relPathBean.lastSavedPathType, methodType.getType());
                if (oldMappingFolder == null || !oldMappingFolder.exists()) continue;
                IFolder newMappingFolder = this.getMappingFolderWithoutCreate(relPathBean.pathType, methodType.getType());
                IFile newRequestMappingFile = null;
                IFile newResponseMappingFile = null;
                if (oldMappingFolder == null || !oldMappingFolder.exists()) continue;
                if (parentFolder == null) {
                    parentFolder = (IFolder)oldMappingFolder.getParent();
                }
                IFile oldServiceMappingFile = oldMappingFolder.getFile("mapping.xml");
                IFile newServiceMappingFile = null;
                if (serviceMapping == null || !oldServiceMappingFile.exists()) continue;
                newMappingFolder = serviceMappingController.getMappingFolder();
                newServiceMappingFile = serviceMappingController.getServiceMappingFile();
                serviceMappingController.setRelativePath(OpenApi2xUtil.stripQueryParameters((String)relPathBean.pathType.getRelativePath()));
                methodType.setHttpXformFile(newServiceMappingFile.getProjectRelativePath().toString());
                oldServiceMappingFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                RequestMessageType requestMessageType = serviceMapping.getRequestMessage();
                IFile oldRequestMappingFile = null;
                if (requestMessageType != null && requestMessageType.getMappingRootModel() != null && requestMessageType.getMappingRootModel().getLocation() != null) {
                    MappingModelType mappingModel = requestMessageType.getMappingRootModel();
                    Path oldRequestMappingFilePath = new Path(StringUtils.trimToEmpty((String)mappingModel.getLocation()));
                    oldRequestMappingFile = this.project.getFile((IPath)oldRequestMappingFilePath);
                }
                if (oldRequestMappingFile != null && oldRequestMappingFile.exists()) {
                    Object rawPath = oldRequestMappingFile.getRawLocation().toOSString();
                    rawPath = "file:" + ((String)rawPath).replace("\\", "/");
                    ParserWrapper parser = (ParserWrapper)Class.forName(DEFAULT_PARSER_NAME).newInstance();
                    Document document = parser.parse((String)rawPath);
                    String method = methodType.getType().name();
                    Writer writer = new Writer(editedPathParms, editedQueryParms, method + "." + newResourceId);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    writer.setOutput(baos, "UTF8");
                    writer.write(document);
                    newRequestMappingFile = serviceMappingController.getRequestMappingFile();
                    requestMessageType.getMappingRootModel().setLocation(newRequestMappingFile.getProjectRelativePath().toString());
                    newRequestMappingFile.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
                    oldRequestMappingFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    relPathBean.editedMessageMappings.add((MappingMessageType)requestMessageType);
                    ZCeeMappingValidatorUtil.validateMappingFile((IFile)newRequestMappingFile);
                }
                for (ResponseMessageType responseMessageType : serviceMapping.getResponseMessages()) {
                    IFile oldResponseMappingFile = null;
                    if (responseMessageType != null && responseMessageType.getMappingRootModel() != null && responseMessageType.getMappingRootModel().getLocation() != null) {
                        MappingModelType mappingModel = responseMessageType.getMappingRootModel();
                        Path oldResponseMappingFilePath = new Path(StringUtils.trimToEmpty((String)mappingModel.getLocation()));
                        oldResponseMappingFile = this.project.getFile((IPath)oldResponseMappingFilePath);
                    }
                    if (oldResponseMappingFile == null || !oldResponseMappingFile.exists()) continue;
                    Object rawPath = oldResponseMappingFile.getRawLocation().toOSString();
                    rawPath = "file:" + ((String)rawPath).replace("\\", "/");
                    ParserWrapper parser = (ParserWrapper)Class.forName(DEFAULT_PARSER_NAME).newInstance();
                    Document document = parser.parse((String)rawPath);
                    String method = methodType.getType().name();
                    Writer writer = new Writer(null, null, method + "." + newResourceId);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    writer.setOutput(baos, "UTF8");
                    writer.write(document);
                    newResponseMappingFile = newMappingFolder.getFile(oldResponseMappingFile.getName());
                    responseMessageType.getMappingRootModel().setLocation(newResponseMappingFile.getProjectRelativePath().toString());
                    newResponseMappingFile.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
                    oldResponseMappingFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    relPathBean.editedMessageMappings.add((MappingMessageType)responseMessageType);
                }
                try {
                    oldMappingFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ZCeeUILogger.error((Throwable)e);
                }
                try {
                    if (oldMappingFolder.members().length != 0) continue;
                    oldMappingFolder.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ZCeeUILogger.error((Throwable)e);
                }
            }
            if (parentFolder != null) {
                this.pruneEmptyFolders(parentFolder);
            }
        }
    }

    public EditedParmsBean discoverEditedParms(Set<String> origParms, Set<String> newParms) {
        EditedParmsBean retVal = new EditedParmsBean();
        Hashtable<String, String> removedParms = new Hashtable<String, String>();
        if (origParms != null && !origParms.isEmpty()) {
            for (String currParm : origParms) {
                removedParms.put(currParm, currParm);
            }
        }
        for (String currParm : newParms) {
            if (removedParms.containsKey(currParm)) {
                removedParms.remove(currParm);
                continue;
            }
            if (retVal.addedParms == null) {
                retVal.addedParms = new HashSet<String>();
            }
            retVal.addedParms.add(currParm);
        }
        if (removedParms != null && removedParms.size() > 0) {
            retVal.removedParms = new HashSet<String>();
            Enumeration keys = removedParms.keys();
            while (keys.hasMoreElements()) {
                String currKey = (String)keys.nextElement();
                retVal.removedParms.add(currKey);
            }
        }
        return retVal;
    }

    public void pruneEmptyFolders(IFolder topFolder) throws CoreException {
        final ArrayList toDelete = new ArrayList();
        if (topFolder != null && topFolder.exists()) {
            topFolder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFolder nestedFolder;
                    if (resource instanceof IFolder && (nestedFolder = (IFolder)resource).exists() && nestedFolder.members().length == 0) {
                        toDelete.add(0, nestedFolder);
                    }
                    return true;
                }
            });
        }
        for (IFolder folder : toDelete) {
            folder.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void pruneEmptyFolders() throws CoreException {
        this.pruneEmptyFolders(this.getApiFolder());
    }

    public String[] getImportedServiceNames() throws Exception {
        ArrayList<String> retVal = new ArrayList<String>();
        IFolder servicesFolder = this.getServicesFolder();
        IResource[] iResourceArray = servicesFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource serviceFolder = iResourceArray[n2];
            if (serviceFolder instanceof IFolder) {
                String serviceName = URIUtilz.decodeResourceName((String)serviceFolder.getName());
                retVal.add(serviceName);
            }
            ++n2;
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    public ServiceArchiveController getServiceArchiveController(String serviceName) throws Exception {
        return new ServiceArchiveController((IResource)this.getServiceFolder(serviceName, false));
    }

    public IProject getProject() {
        return this.project;
    }

    public ApiCapabilityExtension getApiCapabilityExtension() {
        return ApiCapabilityExtension.getApiCapabilityExtension();
    }

    public void setApiModelController(ApiModelController apiModelController) {
        this.apiModelController = apiModelController;
        this.initServiceMappingControllers();
    }

    public List<ServiceMappingController> getServiceRefMappingControllers(String serviceName) throws Exception {
        ArrayList<ServiceMappingController> controllers = new ArrayList<ServiceMappingController>();
        for (Map.Entry<PathType, Map<MethodType, ServiceMappingController>> pathEntry : this.serviceMappingControllers.entrySet()) {
            for (Map.Entry<MethodType, ServiceMappingController> methodEntry : pathEntry.getValue().entrySet()) {
                if (!StringUtils.equals((CharSequence)methodEntry.getKey().getZosConnectServiceRef(), (CharSequence)serviceName)) continue;
                controllers.add(methodEntry.getValue());
            }
        }
        return controllers;
    }

    public List<MethodType> getServiceMethods(String serviceName) throws Exception {
        ArrayList<MethodType> serviceMethods = new ArrayList<MethodType>();
        for (PathType pathType : this.apiModelController.getApiPaths()) {
            for (MethodType methodType : pathType.getMethod()) {
                if (!StringUtils.equals((CharSequence)methodType.getZosConnectServiceRef(), (CharSequence)serviceName)) continue;
                serviceMethods.add(methodType);
            }
        }
        return serviceMethods;
    }

    public void initServiceMappingControllers() {
        if (this.apiModelController != null) {
            for (PathType pathType : this.apiModelController.getApiPaths()) {
                for (MethodType methodType : pathType.getMethod()) {
                    ServiceArchiveController serviceArchiveController = null;
                    try {
                        String serviceName = methodType.getZosConnectServiceRef();
                        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                            serviceArchiveController = this.getServiceArchiveController(serviceName);
                        }
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((Throwable)e);
                    }
                    this.getServiceMappingController(pathType, methodType, serviceArchiveController);
                }
            }
        }
    }

    public Map<PathType, Map<MethodType, ServiceMappingController>> getServiceMappingControllers() {
        return this.serviceMappingControllers;
    }

    public ServiceMappingController getServiceMappingController(PathType pathType, MethodType methodType) {
        return this.getServiceMappingController(pathType, methodType, null);
    }

    public ServiceMappingController getServiceMappingController(PathType pathType, MethodType methodType, ServiceArchiveController serviceArchiveController) {
        ServiceMappingController controller = null;
        Map<Object, Object> controllers = null;
        if (!this.serviceMappingControllers.containsKey(pathType)) {
            controllers = new HashMap();
            this.serviceMappingControllers.put(pathType, controllers);
        } else {
            controllers = this.serviceMappingControllers.get(pathType);
        }
        if (controllers == null) {
            controllers = new HashMap();
        }
        if ((controller = (ServiceMappingController)controllers.get(methodType)) == null) {
            try {
                controller = new ServiceMappingController(pathType, methodType, this, this.apiModelController);
                controllers.put(methodType, controller);
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }
        if (serviceArchiveController != null) {
            controller.setServiceArchiveController(serviceArchiveController);
        }
        return controller;
    }

    public List<ServiceMappingController> getAllServiceMappingControllers() {
        ArrayList<ServiceMappingController> allServMapCtrls = new ArrayList<ServiceMappingController>();
        for (Map<MethodType, ServiceMappingController> servMapCtrls : this.serviceMappingControllers.values()) {
            for (ServiceMappingController servMapCtrl : servMapCtrls.values()) {
                allServMapCtrls.add(servMapCtrl);
            }
        }
        return allServMapCtrls;
    }

    public boolean removeServiceMappingController(PathType pathType, MethodType methodType) {
        boolean removed = false;
        Map<MethodType, ServiceMappingController> controllers = this.serviceMappingControllers.get(pathType);
        if (controllers != null) {
            boolean bl = removed = controllers.remove(methodType) != null;
        }
        if (controllers.size() == 0) {
            this.serviceMappingControllers.remove(pathType);
        }
        return removed;
    }

    public void createFileInProject(String fileName, IProgressMonitor monitor) throws CoreException {
        IFile newFile = this.project.getFile(fileName);
        if (!newFile.exists()) {
            monitor.beginTask(Xlat.description((String)"STATUS_CREATING_FILE", (String[])new String[]{fileName}), -1);
            ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());
            newFile.create((InputStream)is, true, monitor);
            newFile.refreshLocal(2, monitor);
            monitor.done();
        }
    }

    public void createFileInProject(String fileName) throws CoreException {
        this.createFileInProject(fileName, (IProgressMonitor)new NullProgressMonitor());
    }
}

