/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.api;

import com.ibm.zosconnect.api.ApiDocType;
import com.ibm.zosconnect.api.ApiSpecType;
import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.ObjectFactory;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.ZosConnectApi;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.api.ZosConnectJAXBModelUtil;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ApiModelController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ObjectFactory factory = ZosConnectJAXBModelUtil.getFactory_ZosConnectApi();
    private IFile packageXmlFile;
    private ZosConnectApi apiModel;
    private ApiProjectController apiProjectController;

    public ApiModelController(IFile apiFile, ApiProjectController apiProjectController) throws Exception {
        this.apiModel = this.unmarshall(apiFile);
        this.apiProjectController = apiProjectController;
        this.packageXmlFile = apiFile;
    }

    public ApiModelController(ZosConnectApi apiModel, ApiProjectController apiProjectController) {
        this.apiModel = apiModel;
        this.apiProjectController = apiProjectController;
    }

    public void setApiTitle(String title) {
        this.apiModel.setId(title);
        ApiSpecType apiSpecType = this.getApiSpecType();
        apiSpecType.setTitle(title);
    }

    public String getApiTitle() {
        String retVal = "";
        ApiSpecType apiSpecType = this.getApiSpecType();
        if (apiSpecType != null) {
            retVal = apiSpecType.getTitle();
        }
        return retVal;
    }

    public void setApiBasePath(String basePath) {
        ApiSpecType apiSpecType = this.getApiSpecType();
        apiSpecType.setBasePath(basePath);
    }

    public String getApiBasePath() {
        String retVal = "";
        ApiSpecType apiSpecType = this.getApiSpecType();
        if (apiSpecType != null) {
            retVal = apiSpecType.getBasePath();
        }
        return retVal;
    }

    public void setApiDescription(String description) {
        ApiSpecType apiSpecType = this.getApiSpecType();
        apiSpecType.setDescription(description);
    }

    public String getApiDescription() {
        String retVal = "";
        ApiSpecType apiSpecType = this.getApiSpecType();
        if (apiSpecType != null) {
            retVal = apiSpecType.getDescription();
        }
        return retVal;
    }

    public void setApiVersion(String version) {
        ApiSpecType apiSpecType = this.getApiSpecType();
        apiSpecType.setVersion(version);
    }

    public String getApiVersion() {
        String retVal = "";
        ApiSpecType apiSpecType = this.getApiSpecType();
        if (apiSpecType != null) {
            retVal = apiSpecType.getVersion();
        }
        return retVal;
    }

    public void setContactName(String contactName) {
        ApiSpecType apiSpecType = this.getApiSpecType();
        apiSpecType.setContactName(contactName);
    }

    public String getContactName() {
        String retVal = "";
        ApiSpecType apiSpecType = this.getApiSpecType();
        if (apiSpecType != null) {
            retVal = apiSpecType.getContactName();
        }
        return retVal;
    }

    public void setContactURL(String contactURL) {
        ApiSpecType apiSpecType = this.getApiSpecType();
        apiSpecType.setContactURL(contactURL);
    }

    public String getContactURL() {
        String retVal = "";
        ApiSpecType apiSpecType = this.getApiSpecType();
        if (apiSpecType != null) {
            retVal = apiSpecType.getContactURL();
        }
        return retVal;
    }

    public void setContactEmail(String contactEmail) {
        ApiSpecType apiSpecType = this.getApiSpecType();
        apiSpecType.setContactEmail(contactEmail);
    }

    public String getContactEmail() {
        String retVal = "";
        ApiSpecType apiSpecType = this.getApiSpecType();
        if (apiSpecType != null) {
            retVal = apiSpecType.getContactEmail();
        }
        return retVal;
    }

    public void addApiPathAfter(PathType addPath, PathType afterPath) {
        List<PathType> apiPaths = this.getApiPaths();
        int afterPathIndex = apiPaths.indexOf(afterPath) + 1;
        apiPaths.add(afterPathIndex, addPath);
    }

    public void removeApiPath(PathType apiPath) {
        this.getApiPaths().remove(apiPath);
    }

    public List<PathType> getApiPaths() {
        List retVal = Collections.emptyList();
        ApiSpecType apiSpecType = this.getApiSpecType();
        if (apiSpecType != null) {
            retVal = apiSpecType.getPath();
        }
        return retVal;
    }

    public MethodType getPathMethod(PathType pathType, MethodValues type, boolean create) {
        MethodType retVal = null;
        List methods = pathType.getMethod();
        int i = 0;
        while (i < methods.size() && retVal == null) {
            MethodType nextMethod = (MethodType)methods.get(i);
            MethodValues nextType = nextMethod.getType();
            if (nextType != null && nextType.equals((Object)type)) {
                retVal = nextMethod;
            }
            ++i;
        }
        if (retVal == null && create) {
            retVal = ApiModelController.createNewPathMethod(type);
        }
        return retVal;
    }

    public MethodType addPathMethod(PathType pathType, MethodValues type) {
        MethodType addVal = ApiModelController.createNewPathMethod(type);
        List methods = pathType.getMethod();
        methods.add(addVal);
        return addVal;
    }

    public void removePathMethod(PathType pathType, MethodValues type) {
        MethodType remVal = null;
        List methods = pathType.getMethod();
        int i = 0;
        while (i < methods.size() && remVal == null) {
            MethodType nextMethod = (MethodType)methods.get(i);
            MethodValues nextType = nextMethod.getType();
            if (nextType != null && nextType.equals((Object)type)) {
                remVal = nextMethod;
            }
            ++i;
        }
        if (remVal != null) {
            methods.remove(remVal);
        }
    }

    public boolean isFirstPath(PathType pathType) {
        ApiSpecType apiSpecType = this.getApiSpecType();
        List paths = apiSpecType.getPath();
        return ListUtilz.isFirstMember((List)paths, (Object)pathType);
    }

    public boolean isLastPath(PathType pathType) {
        ApiSpecType apiSpecType = this.getApiSpecType();
        List paths = apiSpecType.getPath();
        return ListUtilz.isLastMember((List)paths, (Object)pathType);
    }

    public boolean isFirstMethod(PathType pathType, MethodType methodType) {
        List methods = pathType.getMethod();
        return ListUtilz.isFirstMember((List)methods, (Object)methodType);
    }

    public boolean isLastMethod(PathType pathType, MethodType methodType) {
        List methods = pathType.getMethod();
        return ListUtilz.isLastMember((List)methods, (Object)methodType);
    }

    public void movePathUp(PathType sourcePathType) {
        if (this.isFirstPath(sourcePathType)) {
            return;
        }
        ApiSpecType apiSpecType = this.getApiSpecType();
        List paths = apiSpecType.getPath();
        int sourcePathTypeIndex = paths.indexOf(sourcePathType);
        int targetPathTypeIndex = sourcePathTypeIndex - 1;
        if (sourcePathTypeIndex == -1 || targetPathTypeIndex < 0) {
            return;
        }
        PathType targetPathType = (PathType)paths.get(targetPathTypeIndex);
        paths.set(sourcePathTypeIndex, targetPathType);
        paths.set(targetPathTypeIndex, sourcePathType);
    }

    public void movePathDown(PathType sourcePathType) {
        if (this.isLastPath(sourcePathType)) {
            return;
        }
        ApiSpecType apiSpecType = this.getApiSpecType();
        List paths = apiSpecType.getPath();
        int sourcePathTypeIndex = paths.indexOf(sourcePathType);
        int targetPathTypeIndex = sourcePathTypeIndex + 1;
        if (sourcePathTypeIndex == -1 || targetPathTypeIndex >= paths.size()) {
            return;
        }
        PathType targetPathType = (PathType)paths.get(targetPathTypeIndex);
        paths.set(sourcePathTypeIndex, targetPathType);
        paths.set(targetPathTypeIndex, sourcePathType);
    }

    public void moveMethodUp(PathType sourcePathType, MethodType sourceMethodType) {
        if (this.isFirstMethod(sourcePathType, sourceMethodType)) {
            return;
        }
        List methods = sourcePathType.getMethod();
        int sourceMethodTypeIndex = methods.indexOf(sourceMethodType);
        int targetMethodTypeIndex = sourceMethodTypeIndex - 1;
        if (sourceMethodTypeIndex == -1 || targetMethodTypeIndex < 0) {
            return;
        }
        MethodType targetMethodType = (MethodType)methods.get(targetMethodTypeIndex);
        methods.set(sourceMethodTypeIndex, targetMethodType);
        methods.set(targetMethodTypeIndex, sourceMethodType);
    }

    public void moveMethodDown(PathType sourcePathType, MethodType sourceMethodType) {
        if (this.isLastMethod(sourcePathType, sourceMethodType)) {
            return;
        }
        List methods = sourcePathType.getMethod();
        int sourceMethodTypeIndex = methods.indexOf(sourceMethodType);
        int targetMethodTypeIndex = sourceMethodTypeIndex + 1;
        if (sourceMethodTypeIndex == -1 || targetMethodTypeIndex >= methods.size()) {
            return;
        }
        MethodType targetMethodType = (MethodType)methods.get(targetMethodTypeIndex);
        methods.set(sourceMethodTypeIndex, targetMethodType);
        methods.set(targetMethodTypeIndex, sourceMethodType);
    }

    public ZosConnectApi getApiModel() {
        return this.apiModel;
    }

    public ApiSpecType getApiSpecType() {
        ApiSpecType retVal = null;
        JAXBElement apiSpecTypeEle = null;
        int i = 0;
        while (i < this.apiModel.getContent().size() && retVal == null) {
            JAXBElement element;
            Class declaredType;
            Serializable content = (Serializable)this.apiModel.getContent().get(i);
            if (content instanceof JAXBElement && (declaredType = (element = (JAXBElement)content).getDeclaredType()) == ApiSpecType.class) {
                apiSpecTypeEle = element;
                retVal = (ApiSpecType)apiSpecTypeEle.getValue();
            }
            ++i;
        }
        return retVal;
    }

    public static MethodType createNewPathMethod(MethodValues type) {
        MethodType retVal = null;
        retVal = factory.createMethodType();
        retVal.setType(type);
        return retVal;
    }

    public static PathType createNewApiPath() {
        PathType retVal = factory.createPathType();
        retVal.setRelativePath("/newPath1");
        MethodType postMethod = factory.createMethodType();
        postMethod.setType(MethodValues.POST);
        retVal.getMethod().add(postMethod);
        MethodType getMethod = factory.createMethodType();
        getMethod.setType(MethodValues.GET);
        retVal.getMethod().add(getMethod);
        MethodType putMethod = factory.createMethodType();
        putMethod.setType(MethodValues.PUT);
        retVal.getMethod().add(putMethod);
        MethodType deleteMethod = factory.createMethodType();
        deleteMethod.setType(MethodValues.DELETE);
        retVal.getMethod().add(deleteMethod);
        return retVal;
    }

    public ApiSpecType.ApiDoc addOrUpdateApiDoc(ApiDocType apiDocType, IFile apiDocFile) {
        ApiSpecType.ApiDoc retVal = null;
        ApiSpecType apiSpec = this.getApiSpecType();
        boolean update = false;
        for (ApiSpecType.ApiDoc apiDoc : apiSpec.getApiDoc()) {
            if (apiDoc.getDocType() == null || !apiDoc.getDocType().equals((Object)apiDocType)) continue;
            retVal = apiDoc;
            update = true;
            break;
        }
        if (!update) {
            retVal = factory.createApiSpecTypeApiDoc();
        }
        retVal.setDocType(apiDocType);
        retVal.setValue(apiDocFile.getProjectRelativePath().toPortableString());
        if (!update) {
            apiSpec.getApiDoc().add(retVal);
        }
        return retVal;
    }

    public static ZosConnectApi createNewApi(String title, String basePath, String description) {
        ZosConnectApi retVal = factory.createZosConnectApi();
        retVal.setId(title);
        ApiSpecType apiSpec = factory.createApiSpecType();
        apiSpec.setTitle(title);
        apiSpec.setBasePath(basePath);
        apiSpec.setDescription(description);
        apiSpec.setVersion("1.0.0");
        ApiSpecType.ApiDoc apidoc = new ApiSpecType.ApiDoc();
        apidoc.setDocType(ApiDocType.SWAGGER);
        apiSpec.getApiDoc().add(apidoc);
        PathType pathType = ApiModelController.createNewApiPath();
        apiSpec.getPath().add(pathType);
        JAXBElement apiSpecEle = factory.createZosConnectApiApiSpec(apiSpec);
        retVal.getContent().add(apiSpecEle);
        return retVal;
    }

    public void setPackageXmlFile(IFile apiFile) {
        this.packageXmlFile = apiFile;
    }

    public IFile getPackageXmlFile() {
        return this.packageXmlFile;
    }

    public String getUniqueOperationId(MethodType methodType) {
        String serviceName;
        String newOpId = "";
        StringBuilder newOpIdBuf = new StringBuilder();
        String methodName = methodType.getType().toString();
        if (!StringUtils.isBlank((CharSequence)methodName)) {
            newOpIdBuf.append(methodName.toLowerCase());
        }
        if (!StringUtils.isBlank((CharSequence)(serviceName = methodType.getZosConnectServiceRef()))) {
            newOpIdBuf.append(StringUtils.capitalize((String)serviceName));
        }
        newOpId = newOpIdBuf.toString();
        List<String> opIds = this.getOperationIds();
        Object uniqueOpId = newOpId;
        int i = 0;
        while (opIds.contains(uniqueOpId)) {
            uniqueOpId = newOpId + ++i;
        }
        newOpId = uniqueOpId;
        return newOpId;
    }

    public List<String> getOperationIds() {
        ArrayList<String> retVal = new ArrayList<String>();
        for (PathType pathType : this.getApiPaths()) {
            for (MethodType methodType : pathType.getMethod()) {
                String nextOpId = methodType.getOperationId();
                if (StringUtils.isBlank((CharSequence)nextOpId)) continue;
                retVal.add(nextOpId);
            }
        }
        return retVal;
    }

    public Map<String, Pair<PathType, MethodType>> getOperationIdMappings() {
        HashMap<String, Pair<PathType, MethodType>> retVal = new HashMap<String, Pair<PathType, MethodType>>();
        for (PathType pathType : this.getApiPaths()) {
            for (MethodType methodType : pathType.getMethod()) {
                if (StringUtils.isBlank((CharSequence)methodType.getOperationId())) continue;
                String operationId = methodType.getOperationId().trim();
                retVal.put(operationId, (Pair<PathType, MethodType>)Pair.of((Object)pathType, (Object)methodType));
            }
        }
        return retVal;
    }

    public IProject getApiProject() {
        return this.apiProjectController.getProject();
    }

    public ZosConnectApi unmarshall(IFile apiFile, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Xlat.description((String)"STATUS_LOADING_API"), -1);
        ZosConnectApi zosConnectApi = ZosConnectJAXBModelUtil.unmarshall_ZosConnectApi((IFile)apiFile);
        this.packageXmlFile = apiFile;
        apiFile.refreshLocal(2, monitor);
        return zosConnectApi;
    }

    public ZosConnectApi unmarshall(IFile apiFile) throws Exception {
        return this.unmarshall(apiFile, (IProgressMonitor)new NullProgressMonitor());
    }

    public ZosConnectApi unmarshall(IProgressMonitor monitor) throws Exception {
        return this.unmarshall(this.packageXmlFile, monitor);
    }

    public ZosConnectApi unmarshall() throws Exception {
        return this.unmarshall((IProgressMonitor)new NullProgressMonitor());
    }

    public void marshall(IFile apiFile, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Xlat.description((String)"STATUS_SAVING_API"), -1);
        ZosConnectJAXBModelUtil.marshall_ZosConnectApi((ZosConnectApi)this.apiModel, (IFile)apiFile);
        this.packageXmlFile = apiFile;
        apiFile.refreshLocal(2, monitor);
        monitor.done();
    }

    public void marshall(IFile apiFile) throws Exception {
        this.marshall(apiFile, (IProgressMonitor)new NullProgressMonitor());
    }

    public void marshall(IProgressMonitor monitor) throws Exception {
        this.marshall(this.packageXmlFile, monitor);
    }

    public void marshall() throws Exception {
        this.marshall((IProgressMonitor)new NullProgressMonitor());
    }
}

