/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.api;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ApiDeployController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<IProject> projects;

    public ApiDeployController(List<IProject> projects) {
        this.projects = projects;
    }

    public List<IProject> getProjects() {
        return this.projects;
    }

    public ArrayList<ApiModelController> getApiModelControllers() {
        ArrayList<ApiModelController> retVal = new ArrayList<ApiModelController>();
        int i = 0;
        while (i < this.projects.size()) {
            IProject proj = this.projects.get(i);
            ApiProjectController projController = new ApiProjectController(proj);
            IFile packageXmlFile = proj.getFile("package.xml");
            try {
                retVal.add(new ApiModelController(packageXmlFile, projController));
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            ++i;
        }
        return retVal;
    }

    public HashMap<String, ApiModelController> getApiModelControllersMap() {
        HashMap<String, ApiModelController> retVal = new HashMap<String, ApiModelController>();
        int i = 0;
        while (i < this.projects.size()) {
            IProject proj = this.projects.get(i);
            ApiProjectController projController = new ApiProjectController(proj);
            IFile packageXmlFile = proj.getFile("package.xml");
            try {
                retVal.put(proj.getName(), new ApiModelController(packageXmlFile, projController));
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            ++i;
        }
        return retVal;
    }
}

