/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers.api;

import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.ZosConnectApi;
import com.ibm.zosconnect.buildtoolkit.AARGenerator;
import com.ibm.zosconnect.buildtoolkit.GenerateAarException;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.api.ZosConnectJAXBModelUtil;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.controllers.ZCeeUIControllersPlugin;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ApiArchiveExportController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IProject inputProject;
    private String outputZipFilePath;
    private File outputZipFile;
    private String inputProjectPath;

    public ApiArchiveExportController(IProject project) {
        this.inputProject = project;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputZipFilePath = outputFileName;
    }

    public Pair<Boolean, File> postProcessPackageXml() throws Exception {
        File processedPackageXmlFile = null;
        boolean methodsRemoved = false;
        ApiProjectController projController = new ApiProjectController(this.inputProject);
        IFile packageXmlFile = this.inputProject.getFile("package.xml");
        ApiModelController modelController = new ApiModelController(packageXmlFile, projController);
        ZosConnectApi tempModel = modelController.unmarshall();
        ApiModelController tempModelController = new ApiModelController(tempModel, projController);
        List<PathType> pathList = tempModelController.getApiPaths();
        int i = 0;
        while (i < pathList.size()) {
            PathType currPath = pathList.get(i);
            List methodList = currPath.getMethod();
            String relativePath = currPath.getRelativePath();
            relativePath = OpenApi2xUtil.stripQueryParameters((String)relativePath);
            currPath.setRelativePath(relativePath);
            int j = 0;
            while (j < methodList.size()) {
                MethodType currMethod = (MethodType)methodList.get(j);
                if (currMethod.getZosConnectServiceRef() == null) {
                    methodsRemoved = true;
                    tempModelController.removePathMethod(currPath, currMethod.getType());
                    continue;
                }
                ++j;
            }
            if (currPath.getMethod().isEmpty()) {
                tempModelController.removeApiPath(currPath);
                continue;
            }
            ++i;
        }
        if (tempModelController.getApiPaths().isEmpty()) {
            throw new ZosConnectUIException(Xlat.error((String)"API_NO_PATHS_ERROR"));
        }
        File tempDir = ZCeeUIControllersPlugin.getTempDir();
        File tempPackageXmlFile = new File(tempDir.getAbsolutePath() + File.separator + "package.xml");
        tempPackageXmlFile.createNewFile();
        ZosConnectJAXBModelUtil.marshall_ZosConnectApi((ZosConnectApi)tempModel, (File)tempPackageXmlFile);
        processedPackageXmlFile = tempPackageXmlFile;
        return Pair.of((Object)methodsRemoved, (Object)processedPackageXmlFile);
    }

    public boolean createZipFile() throws Exception {
        boolean methodsRemoved = false;
        this.inputProjectPath = this.inputProject.getLocation().toOSString();
        this.outputZipFile = new File(this.outputZipFilePath);
        try {
            AARGenerator aarGenerator = new AARGenerator(this.inputProjectPath, this.outputZipFilePath);
            methodsRemoved = aarGenerator.createAARFile();
        }
        catch (GenerateAarException e) {
            throw new ZosConnectUIException(e.getMessage(), (Throwable)e);
        }
        return methodsRemoved;
    }

    public byte[] getZipFileBytes() {
        byte[] fileBytes = null;
        if (this.outputZipFile != null) {
            File file = this.outputZipFile;
            try {
                FileInputStream fin = new FileInputStream(file);
                fileBytes = new byte[(int)file.length()];
                fin.read(fileBytes);
                fin.close();
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }
        return fileBytes;
    }

    public String getApiName() throws Exception {
        ApiProjectController projController = new ApiProjectController(this.inputProject);
        IFile packageXmlFile = this.inputProject.getFile("package.xml");
        ApiModelController modelController = new ApiModelController(packageXmlFile, projController);
        ZosConnectApi tempModel = modelController.unmarshall();
        return tempModel.getId();
    }

    public IProject getProject() {
        return this.inputProject;
    }
}

