/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.controllers;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.controllers.jetty.SwaggerUIController;
import java.io.File;
import java.security.SecureRandom;
import org.apache.commons.io.FileUtils;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ZCeeUIControllersPlugin
extends AbstractUIPlugin {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PLUGIN_ID = "com.ibm.zosconnect.ui.controllers";
    private static ZCeeUIControllersPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            FileUtils.cleanDirectory((File)plugin.getStateLocation().toFile());
        }
        catch (Exception exception) {}
    }

    public void stop(BundleContext context) throws Exception {
        if (SwaggerUIController.isSetSingletonInstance()) {
            SwaggerUIController serverController = SwaggerUIController.getSingletonInstance();
            serverController.stopServer();
        }
        try {
            FileUtils.cleanDirectory((File)plugin.getStateLocation().toFile());
        }
        catch (Exception exception) {}
        plugin = null;
        super.stop(context);
    }

    public static ZCeeUIControllersPlugin getDefault() {
        return plugin;
    }

    public static File getTempFile(String extension) {
        File retVal = null;
        SecureRandom random = new SecureRandom();
        String path = plugin.getStateLocation().toOSString() + File.separator;
        while (retVal == null) {
            String nextFileName = path + "tmp_" + Math.abs(random.nextLong()) + extension;
            try {
                File nextFile = new File(nextFileName);
                if (nextFile.exists()) continue;
                nextFile.createNewFile();
                retVal = nextFile;
            }
            catch (Exception e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
        }
        return retVal;
    }

    public static File getTempDir() {
        File retVal = null;
        SecureRandom random = new SecureRandom();
        String path = plugin.getStateLocation().toOSString() + File.separator;
        while (retVal == null) {
            String nextFileName = path + "tmp_" + Math.abs(random.nextLong());
            try {
                File nextFile = new File(nextFileName);
                if (nextFile.exists()) continue;
                nextFile.mkdirs();
                retVal = nextFile;
            }
            catch (Exception e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
        }
        return retVal;
    }

    public static File getTempDir(String subDirName) {
        File retVal = null;
        SecureRandom random = new SecureRandom();
        String path = plugin.getStateLocation().toOSString() + File.separator;
        while (retVal == null) {
            String nextFileName = path + "tmp_" + Math.abs(random.nextLong()) + File.separator + subDirName;
            try {
                File nextFile = new File(nextFileName);
                if (nextFile.exists()) continue;
                nextFile.mkdirs();
                retVal = nextFile;
            }
            catch (Exception e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
        }
        return retVal;
    }
}

