/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.importer.CobolException;
import com.ibm.etools.cobol.importer.MissingLibrariesLinuxMessageDialog;
import com.ibm.etools.cobol.importer.RunCommand;
import com.ibm.etools.cobol.plugin.CobolPlugin;
import com.ibm.etools.cobol.plugin.Messages;
import com.ibm.etools.cobol.util.ProcessWatcher;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RunCommandLinux
extends RunCommand {
    public RunCommandLinux(String path, String workingDir) {
        super(path, workingDir);
    }

    private void runCommand() {
        Runtime r = Runtime.getRuntime();
        try {
            String[] cmd = new String[]{String.valueOf(this.cobolimporterLocation) + "/IGYCCOB2", this.command, this.filePath};
            String[] envp = new String[]{"LD_LIBRARY_PATH=:" + this.cobolimporterLocation, "NLSPATH=:" + this.cobolimporterLocation + "/%L/%N", "SYSLIB=:" + this.syslib, "LC_ALL=" + this.compileTimeLocale, "LANG=" + this.errorMsgLang};
            this.turnExecutionBitOn();
            Process proc = r.exec(cmd, envp, new File(this.workingDir));
            ProcessWatcher pw = new ProcessWatcher(proc);
            int rc = pw.waitFor();
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.runCommand(..): The exit value of the xmi gen process : Exit value = " + rc);
        }
        catch (IOException e) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandLinux.runCommand(..): " + e.getMessage(), e);
            if (e.getMessage().toUpperCase().contains("NO SUCH FILE OR DIRECTORY")) {
                CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandLinux.runCommand(..): " + Messages._Linux_32Bit_Libraries_Not_Found_Message);
                CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandLinux.runCommand(..): " + MissingLibrariesLinuxMessageDialog.techNoteLinkString);
                if (PlatformUI.isWorkbenchRunning()) {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    if (display != null) {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        MissingLibrariesLinuxMessageDialog dialog = new MissingLibrariesLinuxMessageDialog(shell, Messages._Linux_32Bit_Libraries_Not_Found_Title, Messages._Linux_32Bit_Libraries_Not_Found_Message);
                        dialog.open();
                    }
                } else {
                    System.err.println(Messages._Linux_32Bit_Libraries_Not_Found_Message);
                    System.err.println(MissingLibrariesLinuxMessageDialog.techNoteLinkString);
                }
            }
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandLinux.runCommand(..): " + e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private void turnExecutionBitOn() {
        Runtime r = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = r.exec("chmod +x " + this.cobolimporterLocation + "/IGYCCOB2");
        }
        catch (IOException e) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandLinux.turnExecutionBitOn(): " + e.getMessage(), e);
            e.printStackTrace();
        }
        ProcessWatcher pw = new ProcessWatcher(proc);
        int rc = 0;
        try {
            rc = pw.waitFor();
        }
        catch (InterruptedException e) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandLinux.turnExecutionBitOn(): " + e.getMessage(), e);
            e.printStackTrace();
        }
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.turnExecutionBitOn(..): The exit value of the changing the execution bit process : Exit value = " + rc);
    }

    @Override
    public void getCOBOLCompilerComponentLocations() {
        this.cobolimporterLocation = String.valueOf(CobolPlugin.getPluginLocation("com.ibm.etools.cobol.linux")) + "importer";
        this.exitRoutinesLocation = String.valueOf(CobolPlugin.getPluginLocation("com.ibm.etools.cobol.linux")) + "importer/exit_routines";
        this.localePathLocation = String.valueOf(CobolPlugin.getPluginLocation("com.ibm.etools.cobol.linux")) + "importer/locale";
    }

    @Override
    public void createAndRunCommand() throws CobolException {
        this.filePath = this.path;
        this.path = this.path.replace('\\', '/');
        String fileName = this.path.substring(this.path.lastIndexOf(47) + 1, this.path.length());
        String fileNameWOX = fileName.substring(0, fileName.lastIndexOf(46));
        this.path = this.path.substring(0, this.path.lastIndexOf(47));
        this.syslib = String.valueOf(this.path) + PATH_SEPARATOR + additionalCOPYBookLocations + this.syslib;
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.createXMI(Hashmap): filename =" + fileName);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.createXMI(Hashmap): filename w/o extension =" + fileNameWOX);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.createXMI(Hashmap): path(current dir)=" + this.path);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.createXMI(Hashmap): workingDir=" + this.workingDir);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.createXMI(Hashmap): cobolimporterLocation=" + this.cobolimporterLocation);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.createXMI(Hashmap): syslib=" + this.syslib);
        if (this.xmiOptions.endsWith(",")) {
            this.xmiOptions = this.xmiOptions.substring(0, this.xmiOptions.length() - 1);
        }
        String ext = fileName.substring(fileName.lastIndexOf(46), fileName.length()).toLowerCase();
        String prtExit = ",prtexit(iwzprtx)";
        if (CobolPlugin.getDefault().isDEBUG_FINE()) {
            prtExit = "";
        }
        if (this.extensionSupportMap.get(ext).equals("DS")) {
            this.filePath = this.getWrappedProgramFilePath(fileName);
        }
        this.command = "-q\"XMI('" + this.xmiOptions + "'),ADATA,exit(xmiexit('cobol.xmi',iwzxmix),adexit(iwzadx)" + prtExit + ")," + this.otherOptions + "\"";
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.createXMI(Hashmap): command=" + this.command);
        if (this.command == null) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandLinux.createXMI(Hashmap): " + Messages._File_Extension_Not_Supported);
            throw new CobolException(Messages._File_Extension_Not_Supported);
        }
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandLinux.createXMI(Hashmap): command=" + this.command);
        this.runCommand();
    }
}

