/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.importer.COBOLLocaleRelatedConstants;
import com.ibm.etools.cobol.importer.CobolException;
import com.ibm.etools.cobol.importer.ICobolPreferenceConstants;
import com.ibm.etools.cobol.plugin.CobolPlugin;
import com.ibm.etools.cobol.plugin.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;

public abstract class RunCommand
implements ICobolPreferenceConstants {
    protected HashMap fpfs = new HashMap();
    protected HashMap eds = new HashMap();
    protected String path;
    protected String filePath;
    protected String workingDir;
    protected String command;
    protected String cobolimporterLocation;
    protected String exitRoutinesLocation;
    protected String localePathLocation;
    protected String platform;
    protected String codePageSelection;
    protected String floatingPointFormat;
    protected String bigEndian;
    protected String remoteIntegerEndian;
    protected String externalDecimalSign;
    protected String quote;
    protected String trunc;
    protected String nsymbol;
    protected String xmiOptions;
    protected String otherOptions;
    protected String compileTimeLocale;
    protected String asciiCodepage;
    protected String errorMsgLang;
    protected String currencySign;
    protected String collseq;
    protected String ncollseq;
    protected String pgmname;
    protected String compat;
    protected String syslib;
    protected HashMap extensionSupportMap = new HashMap();
    protected static String additionalCOPYBookLocations = "";
    private static final String WRAPPER_TEMPLATE_FILE = "wrapper.template";
    private static final String WRAPPER_DUMMY_NAME = "wrapper";
    private static final String WRAPPER_DUMMY_EXT = "cbl";
    private static final String REPLACE_STRING = "{0}";

    public RunCommand(String path, String workingDir) {
        this.path = path;
        this.workingDir = workingDir;
        this.fpfs.put(new Integer(0), "ieeeNonExtended");
        this.fpfs.put(new Integer(1), "ibm390Hex");
        this.eds.put("ASCII", "ascii");
        this.eds.put("EBCDIC", "ebcdic");
        this.eds.put("EBCDIC Custom", "ebcdicCustom");
        this.quote = "QUOTE";
        this.trunc = "STD";
        this.nsymbol = "NATIONAL";
        this.collseq = "BIN";
        this.ncollseq = "BIN";
        this.pgmname = "LU";
        this.xmiOptions = "";
        this.otherOptions = "NOXREF,NOMAP,NOLIST,NOSOURCE,NOCOMPILE,NOSEQ,NONUM,FLAG(W),NOTERM,arith(extend),NOSQL,NOCICS";
        additionalCOPYBookLocations = CobolPlugin.getAdditionalCOPYBookLocations();
        CobolPlugin.getDefault().writeMsg(Level.FINE, "additionalCOPYBookLocations = " + additionalCOPYBookLocations);
        this.getCOBOLCompilerComponentLocations();
    }

    public abstract void getCOBOLCompilerComponentLocations();

    public abstract void createAndRunCommand() throws CobolException;

    public void createXMI(HashMap props) throws CobolException {
        this.getImporterOptions(props);
        this.createAndRunCommand();
    }

    private void getImporterOptions(HashMap props) {
        int asciiCodepageIndex = 0;
        COBOLLocaleRelatedConstants clrc = new COBOLLocaleRelatedConstants();
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommand.createXMI(Hashmap): cobol options = " + props);
        if (props != null) {
            for (String key : props.keySet()) {
                if (key.equals("com.ibm.etools.cobol.COBOL_PLATFORM_SELECTION")) {
                    this.platform = ((Integer)props.get(key)).toString();
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_CODEPAGE")) {
                    this.codePageSelection = (String)props.get(key);
                    this.xmiOptions = this.xmiOptions.concat("CodePage=" + this.codePageSelection + ",");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_FLOATING_POINT_FORMAT")) {
                    this.floatingPointFormat = (String)this.fpfs.get((Integer)props.get(key));
                    this.xmiOptions = this.xmiOptions.concat("FloatingPoint=" + this.floatingPointFormat + ",");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_ENDIAN")) {
                    this.bigEndian = ((String)props.get(key)).equals("Big") ? "true" : "false";
                    this.xmiOptions = this.xmiOptions.concat("BigEndian=" + this.bigEndian + ",");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_REMOTE_ENDIAN")) {
                    this.remoteIntegerEndian = (String)props.get(key);
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_EXT_DECIMAL_SIGN")) {
                    this.externalDecimalSign = (String)this.eds.get((String)props.get(key));
                    this.xmiOptions = this.xmiOptions.concat("EDSign=" + this.externalDecimalSign + ",");
                    if (!((String)props.get(key)).equals("EBCDIC Custom") || ((String)props.get("com.ibm.etools.cobol.COBOL_HOST_CODEPAGE_EC")).equals("IBM-1047")) continue;
                    this.xmiOptions = this.xmiOptions.concat("HostCodePage=" + (String)props.get("com.ibm.etools.cobol.COBOL_HOST_CODEPAGE_EC") + ",");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_COMPAT")) {
                    if (((Boolean)props.get(key)).booleanValue()) continue;
                    this.compat = "no";
                    this.xmiOptions = this.xmiOptions.concat("Compat=" + this.compat + ",");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_QUOTE")) {
                    if (((String)props.get(key)).equals("SINGLE")) {
                        this.quote = "APOST";
                    }
                    this.otherOptions = this.otherOptions.concat("," + this.quote);
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_TRUNC")) {
                    if (((String)props.get(key)).equals("OPT")) {
                        this.trunc = "OPT";
                    } else if (((String)props.get(key)).equals("BIN")) {
                        this.trunc = "BIN";
                    }
                    this.otherOptions = this.otherOptions.concat(",TRUNC(" + this.trunc + ")");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_NSYMBOL")) {
                    if (((String)props.get(key)).equals("DBCS")) {
                        this.nsymbol = "DBCS";
                    }
                    this.otherOptions = this.otherOptions.concat(",NSYMBOL(" + this.nsymbol + ")");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE")) {
                    this.compileTimeLocale = (String)clrc.getLocaleNames().get((Integer)props.get(key));
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_ASCII_CODEPAGE")) {
                    asciiCodepageIndex = (Integer)props.get(key);
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_ERROR_MSGS_LANG")) {
                    this.errorMsgLang = (String)clrc.getErrorMessagesLanguage().get((Integer)props.get(key));
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_CURRENCY")) {
                    this.currencySign = (String)props.get(key);
                    this.currencySign = this.currencySign.replace('\"', '\'');
                    this.otherOptions = this.otherOptions.concat(",CURRENCY(" + this.currencySign + ")");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_SOSI")) {
                    if (!((Boolean)props.get(key)).booleanValue()) continue;
                    this.otherOptions = this.otherOptions.concat(",SOSI");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_COLLSEQ")) {
                    if (((String)props.get(key)).equals("EBCDIC")) {
                        this.collseq = "EBCDIC";
                    } else if (((String)props.get(key)).equals("LOCALE")) {
                        this.collseq = "LOCALE";
                    }
                    this.otherOptions = this.otherOptions.concat(",COLLSEQ(" + this.collseq + ")");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_NCOLLSEQ")) {
                    if (((String)props.get(key)).equals("LOCALE")) {
                        this.ncollseq = "LOCALE";
                    }
                    this.otherOptions = this.otherOptions.concat(",NCOLLSEQ(" + this.ncollseq + ")");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_PGMNAME")) {
                    if (((String)props.get(key)).equals("LM")) {
                        this.pgmname = "LM";
                    }
                    this.otherOptions = this.otherOptions.concat(",PGMNAME(" + this.pgmname + ")");
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_EXTENSION_CBL")) {
                    this.extensionSupportMap.put(".cbl", (String)props.get(key));
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_EXTENSION_CCP")) {
                    this.extensionSupportMap.put(".ccp", (String)props.get(key));
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_EXTENSION_COB")) {
                    this.extensionSupportMap.put(".cob", (String)props.get(key));
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_EXTENSION_CPY")) {
                    this.extensionSupportMap.put(".cpy", (String)props.get(key));
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_SYSLIB")) {
                    this.syslib = (String)props.get(key);
                    continue;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_ADDITIONAL_OPTIONS")) {
                    String s = (String)props.get(key);
                    if (s == null || s == "") continue;
                    this.otherOptions = this.otherOptions.concat(",").concat(s.toUpperCase());
                    continue;
                }
                CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommand.createXMI(Hashmap): Ignored Key:Value = " + key + ":" + props.get(key));
            }
            if (CobolPlugin.isWindows()) {
                this.asciiCodepage = (String)clrc.getASCIICodePages(this.compileTimeLocale).get(asciiCodepageIndex);
            }
        }
    }

    protected String getWrappedProgramFilePath(String copyBookFileName) throws CobolException {
        String lineSeparator = System.getProperty("line.separator");
        File wrapperTemplate = new File(this.cobolimporterLocation, WRAPPER_TEMPLATE_FILE);
        if (!wrapperTemplate.exists()) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommand.getWrappedProgramFilePath(...): Missing template file.");
            throw new CobolException(Messages._EXC_DESC_MISSING_TEMPLATE_FILE);
        }
        File wrapper = new File(this.workingDir, "wrapper.cbl");
        if (wrapper.exists()) {
            wrapper.delete();
        }
        try {
            BufferedReader rd = new BufferedReader(new FileReader(wrapperTemplate));
            BufferedWriter wr = new BufferedWriter(new FileWriter(wrapper));
            while (rd.ready()) {
                String line = rd.readLine();
                int idx = line.indexOf(REPLACE_STRING);
                if (idx >= 0) {
                    wr.write(line.substring(0, idx));
                    wr.write(copyBookFileName);
                    wr.write(line.substring(idx + REPLACE_STRING.length()));
                } else {
                    wr.write(line);
                }
                wr.write(lineSeparator);
            }
            wr.flush();
            rd.close();
            wr.close();
        }
        catch (IOException ioe) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommand.getWrappedProgramFilePath(...): Problems creating wrapper program: " + ioe.getMessage(), ioe);
            throw new CobolException(Messages._EXC_CREATING_WRAPPER_PROGRAM);
        }
        return wrapper.getAbsolutePath();
    }

    public HashMap getExtensionSupportMap() {
        return this.extensionSupportMap;
    }
}

