/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.plugin.Messages;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class CobolTypeUtilities {
    public static final String copyright = "(c) Copyright IBM Corporation 2001,2004.";

    public static boolean contains(String s, char c) {
        return s.indexOf(c) != -1;
    }

    public static String expandPic(String pic) {
        StringBuffer ePic = new StringBuffer();
        int picLength = pic.length();
        int i = 0;
        while (i < picLength) {
            char nextChar = pic.charAt(i);
            if (nextChar == '(') {
                char charToRepeat = pic.charAt(i - 1);
                int index = pic.indexOf(41, i);
                if (index == -1) {
                    return pic;
                }
                int repetitions = new Integer(pic.substring(i + 1, index));
                i = index;
                --repetitions;
                while (repetitions > 0) {
                    ePic.append(charToRepeat);
                    --repetitions;
                }
            } else {
                ePic.append(nextChar);
            }
            ++i;
        }
        return ePic.toString();
    }

    public static int getNumericFieldWidth(String sPicString, String sAugString, int nUsage) {
        int nWidth = 0;
        int numberOfNines = CobolTypeUtilities.getNumberOfNines(sPicString);
        switch (nUsage) {
            case 4: {
                nWidth = 4;
                break;
            }
            case 2: {
                nWidth = 8;
                break;
            }
            case 0: {
                if (numberOfNines > 9) {
                    nWidth = 8;
                    break;
                }
                if (numberOfNines > 4) {
                    nWidth = 4;
                    break;
                }
                nWidth = 2;
                break;
            }
            case 8: {
                nWidth = numberOfNines / 2 + 1;
                break;
            }
            case 3: {
                if (sAugString.indexOf("SEPARATE") != -1) {
                    nWidth = numberOfNines + 1;
                    break;
                }
                nWidth = numberOfNines;
                break;
            }
            default: {
                nWidth = numberOfNines;
            }
        }
        return nWidth;
    }

    public static int getNumberOfNines(String sPicString) {
        int numberOfNines = 0;
        int i = 0;
        while (i < sPicString.length()) {
            if (sPicString.charAt(i) == '9') {
                ++numberOfNines;
            }
            ++i;
        }
        return numberOfNines;
    }

    public static int getVirtualDecimalPointLocation(String sPicString) {
        int virtualDecimalLocation = 0;
        if (sPicString.indexOf(80) == -1) {
            int virtualDecimalIndex = sPicString.indexOf(86);
            virtualDecimalLocation = virtualDecimalIndex == -1 ? 0 : sPicString.length() - virtualDecimalIndex - 1;
        } else {
            int firstCharacter = 32;
            int numberOfNines = 0;
            int numberOfPs = 0;
            int i = 0;
            while (i < sPicString.length()) {
                if (sPicString.charAt(i) == '9') {
                    if (firstCharacter == 32) {
                        firstCharacter = 57;
                    }
                    ++numberOfNines;
                } else if (sPicString.charAt(i) == 'P') {
                    if (firstCharacter == 32) {
                        firstCharacter = 80;
                    }
                    ++numberOfPs;
                }
                ++i;
            }
            virtualDecimalLocation = firstCharacter == 80 ? numberOfNines + numberOfPs : numberOfPs * -1;
        }
        return virtualDecimalLocation;
    }

    public static int getPackingBytes(String positionString, int alignmentFactor) {
        int positionNumber;
        try {
            positionNumber = Integer.valueOf(positionString);
        }
        catch (Exception exception) {
            positionNumber = CobolTypeUtilities.evaluateFormula(positionString);
        }
        int positionRemainder = positionNumber % alignmentFactor;
        int packingBytes = positionRemainder > 0 ? alignmentFactor - positionRemainder : 0;
        return packingBytes;
    }

    public static String createOffset(String parentOffsetFormula, int parentOffsetNumber, String relativeOffsetFormula, int relativeOffsetNumber) {
        String stringOffset;
        int totalOffsetNumber = parentOffsetNumber + relativeOffsetNumber;
        String totalOffsetFormula = CobolTypeUtilities.addOffsetFormulas(parentOffsetFormula, relativeOffsetFormula);
        try {
            int formulaOffset = totalOffsetFormula.length() == 0 ? 0 : Integer.valueOf(totalOffsetFormula);
            stringOffset = new Integer(formulaOffset + totalOffsetNumber).toString();
        }
        catch (Exception exception) {
            stringOffset = totalOffsetNumber > 0 ? "add(" + totalOffsetFormula + "," + totalOffsetNumber + ")" : totalOffsetFormula;
        }
        return stringOffset;
    }

    public static String addOffsetFormulas(String currentOffsetFormula, String relativeOffsetFormula) {
        String stringFormula;
        try {
            if (currentOffsetFormula.length() == 0 || currentOffsetFormula.compareTo("0") == 0) {
                return relativeOffsetFormula;
            }
            if (relativeOffsetFormula.length() == 0 || relativeOffsetFormula.compareTo("0") == 0) {
                return currentOffsetFormula;
            }
            int currentOffsetNumber = Integer.valueOf(currentOffsetFormula);
            int relativeOffsetNumber = Integer.valueOf(relativeOffsetFormula);
            stringFormula = new Integer(currentOffsetNumber + relativeOffsetNumber).toString();
        }
        catch (Exception exception) {
            stringFormula = "add(" + currentOffsetFormula + "," + relativeOffsetFormula + ")";
        }
        return stringFormula;
    }

    public static String multiplyOffsetFormulas(String strideFormula, String dimensionString) {
        String stringFormula;
        try {
            int strideNumber = strideFormula.length() == 0 ? 0 : Integer.valueOf(strideFormula);
            int dimensionNumber = Integer.valueOf(dimensionString);
            stringFormula = new Integer(strideNumber * dimensionNumber).toString();
        }
        catch (Exception exception) {
            stringFormula = "mpy(" + strideFormula + "," + dimensionString + ")";
        }
        return stringFormula;
    }

    public static String createSize(String relativeOffsetFormula, int relativeOffsetNumber) {
        try {
            if (relativeOffsetFormula.length() == 0) {
                return new Integer(relativeOffsetNumber).toString();
            }
            if (relativeOffsetNumber == 0) {
                return relativeOffsetFormula;
            }
            int formulaNumber = Integer.valueOf(relativeOffsetFormula);
            return new Integer(formulaNumber + relativeOffsetNumber).toString();
        }
        catch (Exception exception) {
            return "add(" + relativeOffsetFormula + "," + relativeOffsetNumber + ")";
        }
    }

    public static String createODOValExpression(Vector fieldPositionVector, int relativePosition) {
        String valExpression = "val(1";
        int i = 0;
        while (i < fieldPositionVector.size()) {
            if (fieldPositionVector.elementAt(i) != null) {
                valExpression = String.valueOf(valExpression) + "," + ((Integer)fieldPositionVector.elementAt(i)).toString();
            }
            ++i;
        }
        valExpression = String.valueOf(valExpression) + "," + relativePosition;
        valExpression = String.valueOf(valExpression) + ")";
        return valExpression;
    }

    private static int evaluateFormula(String formula) {
        int result = 0;
        int index = formula.indexOf("(");
        if (index == -1) {
            return Integer.parseInt(formula);
        }
        String function = formula.substring(0, index);
        if (function.equalsIgnoreCase("val")) {
            result = 1;
        } else if (function.equalsIgnoreCase("neg")) {
            formula = formula.substring(index + 1, formula.length() - 1);
            result = -1 * CobolTypeUtilities.evaluateFormula(formula);
        } else {
            formula = formula.substring(index + 1, formula.length() - 1);
            char[] formulaChars = formula.toCharArray();
            int brackets = 0;
            int i = 0;
            while (i < formulaChars.length) {
                if (formulaChars[i] == '(') {
                    ++brackets;
                } else if (formulaChars[i] == ')') {
                    --brackets;
                } else if (formulaChars[i] == ',' && brackets == 0) break;
                ++i;
            }
            String leftSide = "0";
            String rightSide = "0";
            leftSide = formula.substring(0, i);
            rightSide = formula.substring(i + 1);
            if (function.equalsIgnoreCase("add")) {
                result = CobolTypeUtilities.evaluateFormula(leftSide) + CobolTypeUtilities.evaluateFormula(rightSide);
            } else if (function.equalsIgnoreCase("mpy")) {
                result = CobolTypeUtilities.evaluateFormula(leftSide) * CobolTypeUtilities.evaluateFormula(rightSide);
            } else if (function.equalsIgnoreCase("sub")) {
                result = CobolTypeUtilities.evaluateFormula(leftSide) - CobolTypeUtilities.evaluateFormula(rightSide);
            } else if (function.equalsIgnoreCase("div")) {
                result = CobolTypeUtilities.evaluateFormula(leftSide) / CobolTypeUtilities.evaluateFormula(rightSide);
            } else if (function.equalsIgnoreCase("max")) {
                result = Math.max(CobolTypeUtilities.evaluateFormula(leftSide), CobolTypeUtilities.evaluateFormula(rightSide));
            } else if (function.equalsIgnoreCase("min")) {
                result = Math.min(CobolTypeUtilities.evaluateFormula(leftSide), CobolTypeUtilities.evaluateFormula(rightSide));
            } else if (function.equalsIgnoreCase("mod")) {
                result = CobolTypeUtilities.evaluateFormula(leftSide) % CobolTypeUtilities.evaluateFormula(rightSide);
            }
        }
        return result;
    }

    public static boolean isAlphabetic(String pic) {
        int picLength = pic.length();
        int i = 0;
        while (i < picLength) {
            char c = pic.charAt(i);
            if (c != 'A') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String pic) {
        int picLength = pic.length();
        int i = 0;
        while (i < picLength) {
            char c = pic.charAt(i);
            if (c != 'A' && c != '9' && c != 'X') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphaNumericEdited(String pic) {
        int picLength = pic.length();
        int i = 0;
        while (i < picLength) {
            char c = pic.charAt(i);
            if (c != 'A' && c != '9' && c != 'X' && c != 'B' && c != '0' && c != '/') {
                return false;
            }
            ++i;
        }
        return !(!CobolTypeUtilities.contains(pic, 'A') && !CobolTypeUtilities.contains(pic, 'X') || !CobolTypeUtilities.contains(pic, 'B') && !CobolTypeUtilities.contains(pic, '0') && !CobolTypeUtilities.contains(pic, '/'));
    }

    public static boolean isDBCS(String pic) {
        int picLength = pic.length();
        int i = 0;
        while (i < picLength) {
            char c = pic.charAt(i);
            if (c != 'G' && c != 'B' && c != 'N') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isExternalFloatingPoint(String pic) {
        boolean externalFloatingPoint = true;
        int picLength = pic.length();
        int i = 0;
        while (i < picLength) {
            char c = pic.charAt(i);
            if (c != '9' && c != '+' && c != '-' && c != 'E' && c != 'V' && c != '.') {
                externalFloatingPoint = false;
            }
            ++i;
        }
        if (externalFloatingPoint) {
            externalFloatingPoint = CobolTypeUtilities.contains(pic, 'E');
        }
        return externalFloatingPoint;
    }

    public static boolean isNumeric(String picString) {
        int i = 0;
        while (i < picString.length()) {
            char c = picString.charAt(i);
            if (c == '(') {
                ++i;
                while (i < picString.length()) {
                    c = picString.charAt(i);
                    if (c != ')') {
                        if (!Character.isDigit(c)) {
                            return false;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (c != 'S' && c != 'V' && c != '9' && c != 'P') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumericEdited(String pic) {
        int picLength = pic.length();
        int i = 0;
        while (i < picLength) {
            char c = pic.charAt(i);
            if (c != 'B' && c != 'P' && c != 'V' && c != 'Z' && c != '9' && c != '0' && c != '/' && c != ',' && c != '.' && c != '+' && c != '-' && c != '*' && c != '$' && c != 'C' && c != 'R' && c != 'D') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void validateCodepage(String codepage) throws Exception {
        try {
            byte[] byteArray = new byte[]{12, 34};
            new String(byteArray, codepage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Exception(Messages._EXC_Invalid_codepage);
        }
    }

    public static void validateCurrency(String text) throws Exception {
        boolean isValid = false;
        char[] textArray = new char[5];
        if (text.startsWith("x") || text.startsWith("X") || text.startsWith("'") || text.startsWith("\"")) {
            text.getChars(0, text.length(), textArray, 0);
            if (textArray[0] == '\'' || textArray[0] == '\"') {
                if (text.length() == 3 && textArray[0] == textArray[2]) {
                    isValid = true;
                }
            } else if (!(textArray[0] != 'X' && textArray[0] != 'x' || textArray[1] != '\'' && textArray[1] != '\"' || text.length() != 5 || textArray[1] != textArray[4])) {
                isValid = true;
            }
        }
        if (!isValid) {
            throw new Exception(Messages._EXC_Invalid_Currency);
        }
    }

    public static String expandPictureString(String compressed) {
        while (true) {
            String expandStr = "";
            int startIndex = compressed.indexOf("(");
            if (startIndex == -1) break;
            String expandChar = compressed.substring(startIndex - 1, startIndex);
            int endIndex = compressed.indexOf(")");
            int numberOfChars = new Integer(compressed.substring(startIndex + 1, endIndex));
            int i = 0;
            while (i < numberOfChars) {
                expandStr = String.valueOf(expandStr) + expandChar;
                ++i;
            }
            compressed = String.valueOf(compressed.substring(0, startIndex - 1)) + expandStr + compressed.substring(endIndex + 1);
        }
        return compressed;
    }

    public static String normalizePictureString(String pic) {
        String out = "";
        char[] work = CobolTypeUtilities.expandPictureString(pic).toCharArray();
        int inLen = work.length;
        int i = 0;
        while (i < inLen) {
            if (i + 1 < inLen && work[i] == work[i + 1]) {
                out = String.valueOf(out) + work[i] + "(";
                int j = i;
                while (j + 1 < inLen && work[j] == work[j + 1]) {
                    ++j;
                }
                out = String.valueOf(out) + String.valueOf(j - i + 1) + ")";
                i = j + 1;
                continue;
            }
            out = String.valueOf(out) + work[i];
            ++i;
        }
        return out;
    }
}

