/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class COBOLTruncValue
extends AbstractEnumerator {
    public static final String copyright = "Licensed Materials - Property of IBM com.ibm.etools.cobol Copyright IBM Corporation 2004, 2007. All Rights Reserved. Note to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int STD = 0;
    public static final int OPT = 1;
    public static final int BIN = 2;
    public static final COBOLTruncValue STD_LITERAL = new COBOLTruncValue(0, "STD", "STD");
    public static final COBOLTruncValue OPT_LITERAL = new COBOLTruncValue(1, "OPT", "OPT");
    public static final COBOLTruncValue BIN_LITERAL = new COBOLTruncValue(2, "BIN", "BIN");
    private static final COBOLTruncValue[] VALUES_ARRAY = new COBOLTruncValue[]{STD_LITERAL, OPT_LITERAL, BIN_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static COBOLTruncValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            COBOLTruncValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static COBOLTruncValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            COBOLTruncValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static COBOLTruncValue get(int value) {
        switch (value) {
            case 0: {
                return STD_LITERAL;
            }
            case 1: {
                return OPT_LITERAL;
            }
            case 2: {
                return BIN_LITERAL;
            }
        }
        return null;
    }

    private COBOLTruncValue(int value, String name, String literal) {
        super(value, name, literal);
    }
}

