/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.j2c.util.walkers.util;

import com.ibm.ccl.pli.PLIElement;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.tdlang.TDLangElement;
import com.ibm.etools.typedescriptor.LanguageType;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.COBOLModelSerializer;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.COBOLModelWalker;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.COBOLModelWalkerException;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.ICOBOLModelConstants;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.ICOBOLModelVisitor;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.IPLIModelVisitor;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.PLIModelSerializer;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.PLIModelWalker;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.PLIModelWalkerException;

public class DataStructureContainer {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String name = null;
    private String source = null;
    private TDLangElement model = null;
    private LanguageType language = null;
    private boolean isTopLevel = false;
    private String fileName = null;

    public DataStructureContainer() {
    }

    public DataStructureContainer(String name, String source, TDLangElement model, LanguageType language, String fileName) {
        this.name = name;
        this.source = source;
        this.model = model;
        this.language = language;
        this.setFileName(fileName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public TDLangElement getModel() {
        return this.model;
    }

    public void setModel(TDLangElement model) {
        this.model = model;
    }

    public LanguageType getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageType language) {
        this.language = language;
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public void setTopLevel(boolean isTopLevel) {
        this.isTopLevel = isTopLevel;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void makeTopLevel() {
        if (!this.isTopLevel) {
            if (this.language == LanguageType.COBOL_LITERAL) {
                this.source = "       01 " + this.name + "." + ICOBOLModelConstants.EOL + this.source;
                this.isTopLevel = true;
            } else if (this.language == LanguageType.PLI_LITERAL) {
                this.source = " dummy: proc;\n DCL 1 " + this.name + "," + this.source + ";\n end;\n";
                this.isTopLevel = true;
            }
        }
    }

    public static DataStructureContainer generate(TDLangElement langElement, boolean makeTopLevel) throws COBOLModelWalkerException, PLIModelWalkerException {
        DataStructureContainer dsContainer = null;
        if (langElement instanceof COBOLElement) {
            COBOLElement cobolElement = (COBOLElement)langElement;
            COBOLModelSerializer visitor = new COBOLModelSerializer();
            COBOLModelWalker walker = new COBOLModelWalker();
            walker.accept((ICOBOLModelVisitor)visitor, cobolElement);
            dsContainer = visitor.getAllStructs().get(0);
        } else if (langElement instanceof PLIElement) {
            PLIElement pliElement = (PLIElement)langElement;
            PLIModelSerializer visitor = new PLIModelSerializer();
            PLIModelWalker walker = new PLIModelWalker();
            walker.accept((IPLIModelVisitor)visitor, pliElement);
            dsContainer = visitor.getAllStructs().get(0);
        }
        if (makeTopLevel && !dsContainer.isTopLevel()) {
            dsContainer.makeTopLevel();
            dsContainer.setTopLevel(true);
        }
        return dsContainer;
    }

    public static boolean isTopLevel(TDLangElement langElement) {
        boolean retVal = false;
        if (langElement instanceof COBOLElement) {
            COBOLElement cobolElement = (COBOLElement)langElement;
            retVal = Integer.valueOf(cobolElement.getLevel()) == 1;
        } else if (langElement instanceof PLIElement) {
            PLIElement pliElement = (PLIElement)langElement;
            retVal = Integer.valueOf(pliElement.getLevel()) == 1;
        }
        return retVal;
    }
}

