/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.j2c.util.walkers.pli;

import com.ibm.ccl.pli.BaseValues;
import com.ibm.ccl.pli.LengthType;
import com.ibm.ccl.pli.ModeValues;
import com.ibm.ccl.pli.PLIComposedType;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.ccl.pli.PLIFixedLengthString;
import com.ibm.ccl.pli.PLIFloatType;
import com.ibm.ccl.pli.PLIIntegerType;
import com.ibm.ccl.pli.PLIPackedType;
import com.ibm.ccl.pli.PLIPictureStringType;
import com.ibm.ccl.pli.PLIPictureType;
import com.ibm.ccl.pli.PLIPointerType;
import com.ibm.ccl.pli.PLISimpleType;
import com.ibm.ccl.pli.PLIVariableLengthString;
import com.ibm.ccl.pli.StringTypeValues;
import com.ibm.etools.tdlang.TDLangElement;
import com.ibm.etools.typedescriptor.LanguageType;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.IPLIModelConstants;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.PLIModelWalker;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.PLIModelWalkerException;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.SimplePLIVisitor;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.util.IPliImportPreferencesWrapper;
import com.ibm.zosconnect.ui.j2c.util.walkers.pli.util.PliImportPreferencesWrapper;
import com.ibm.zosconnect.ui.j2c.util.walkers.util.DataStructureContainer;
import com.ibm.zosconnect.ui.j2c.util.walkers.util.FieldPath;
import com.ibm.zosconnect.ui.j2c.util.walkers.util.WrappingOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.resource.Resource;

public class PLIModelSerializer
extends SimplePLIVisitor
implements IPLIModelConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IPliImportPreferencesWrapper importPrefs = new PliImportPreferencesWrapper(null);
    private List<DataStructureContainer> allStructs = new ArrayList<DataStructureContainer>();
    private WrappingOutputStream currStruct;

    @Override
    public Object startOfImportResource(Resource importResource, Object state) throws PLIModelWalkerException {
        return state;
    }

    @Override
    public Object endOfImportResource(Resource importResource, Object state) throws PLIModelWalkerException {
        return state;
    }

    @Override
    public Object leafField(PLIElement field, PLISimpleType fieldType, FieldPath fieldPath, Stack<PLIElement> fieldParents, Object state) throws PLIModelWalkerException {
        if (!fieldParents.isEmpty()) {
            this.currStruct.write(", ", 0, 1);
        }
        this.currStruct.write(field.getLevel() + " " + PLIModelWalker.getFieldName(field), 0, 0);
        this.writeSimpleTypeSpecification(fieldType);
        return state;
    }

    @Override
    public Object leafArrayField(PLIElement field, PLISimpleType fieldType, FieldPath fieldPath, Stack<PLIElement> fieldParents, Object state) throws PLIModelWalkerException {
        if (!fieldParents.isEmpty()) {
            this.currStruct.write(", ", 0, 1);
        }
        this.currStruct.write(field.getLevel() + " " + PLIModelWalker.getFieldName(field), 0, 0);
        this.writeArraySpecification(field);
        this.writeSimpleTypeSpecification(fieldType);
        return state;
    }

    @Override
    public Object startOfCompositeField(PLIElement field, PLIComposedType fieldType, FieldPath fieldPath, List<PLIElement> fieldChildren, Stack<PLIElement> fieldParents, Object state) throws PLIModelWalkerException {
        if (fieldParents.isEmpty()) {
            this.currStruct = new WrappingOutputStream(this.importPrefs.leftMargin(), this.importPrefs.rightMargin());
        }
        if (DataStructureContainer.isTopLevel((TDLangElement)field)) {
            boolean makeBased = false;
            try {
                Integer.parseInt(field.getInstanceTDBase().getContentSize());
            }
            catch (NumberFormatException numberFormatException) {
                makeBased = true;
            }
            if (!makeBased) {
                this.currStruct.write("DCL " + field.getLevel() + " " + PLIModelWalker.getFieldName(field), 1, 0);
            } else {
                this.currStruct.write("DCL " + field.getLevel() + " " + PLIModelWalker.getFieldName(field) + " BASED", 1, 0);
            }
        } else {
            this.currStruct.write(", ", 0, 1);
            this.currStruct.write(field.getLevel() + " " + PLIModelWalker.getFieldName(field), 0, 0);
        }
        return state;
    }

    @Override
    public Object endOfCompositeField(PLIElement field, PLIComposedType fieldType, FieldPath fieldPath, List<PLIElement> fieldChildren, Stack<PLIElement> fieldParents, Object state) throws PLIModelWalkerException {
        if (fieldParents.isEmpty()) {
            this.currStruct.write(";", 0, 1);
            DataStructureContainer newStruct = new DataStructureContainer();
            newStruct.setName(field.getName());
            newStruct.setSource(this.currStruct.toString());
            newStruct.setModel((TDLangElement)field);
            newStruct.setLanguage(LanguageType.PLI_LITERAL);
            newStruct.setTopLevel(Integer.valueOf(field.getLevel()) == 1);
            this.allStructs.add(newStruct);
        }
        return state;
    }

    @Override
    public Object startOfCompositeArrayField(PLIElement field, PLIComposedType fieldType, FieldPath fieldPath, List<PLIElement> fieldChildren, Stack<PLIElement> fieldParents, Object state) throws PLIModelWalkerException {
        if (!fieldParents.isEmpty()) {
            this.currStruct.write(", ", 0, 1);
        }
        this.currStruct.write(field.getLevel() + " " + PLIModelWalker.getFieldName(field), 0, 0);
        this.writeArraySpecification(field);
        return state;
    }

    @Override
    public Object endOfCompositeArrayField(PLIElement field, PLIComposedType fieldType, FieldPath fieldPath, List<PLIElement> fieldChildren, Stack<PLIElement> fieldParents, Object state) throws PLIModelWalkerException {
        return state;
    }

    private void writeArraySpecification(PLIElement field) {
        if (PLIModelWalker.isFixedLengthArrayField(field)) {
            Integer upperbound;
            Integer lowerbound = PLIModelWalker.getMinOccursAsInt(field);
            if (!lowerbound.equals(upperbound = Integer.valueOf(PLIModelWalker.getMaxOccursAsInt(field)))) {
                this.currStruct.write(" (" + String.valueOf(lowerbound) + " : " + String.valueOf(upperbound) + ")", 0, 0);
            } else {
                this.currStruct.write(" (" + String.valueOf(upperbound) + ")", 0, 0);
            }
        } else if (PLIModelWalker.isVariableLengthArray(field)) {
            boolean isUnbounded;
            Object lowerbound = PLIModelWalker.getMinOccursObject(field);
            Object upperbound = PLIModelWalker.getMaxOccursObject(field);
            boolean bl = isUnbounded = PLIModelWalker.getMaxOccursAsInt(field) == -1;
            if (isUnbounded) {
                this.currStruct.write(" (" + String.valueOf(lowerbound) + " REFER(" + String.valueOf(upperbound) + "))", 0, 0);
            } else {
                this.currStruct.write(" (" + String.valueOf(lowerbound) + " : " + String.valueOf(upperbound) + ")", 0, 0);
            }
        }
    }

    private void writeSimpleTypeSpecification(PLISimpleType fieldType) {
        if (fieldType instanceof PLIIntegerType) {
            PLIIntegerType integerType = (PLIIntegerType)fieldType;
            int precision = integerType.getPrecision();
            int scale = integerType.getScale();
            if (scale == 0) {
                this.currStruct.write(" FIXED BINARY(" + precision + ")", 0, 0);
            } else {
                this.currStruct.write(" FIXED BINARY(" + precision + "," + scale + ")", 0, 0);
            }
            if (!integerType.isSigned()) {
                this.currStruct.write(" UNSIGNED", 0, 0);
            }
            if (integerType.getMode() == ModeValues.COMPLEX_LITERAL) {
                this.currStruct.write(" COMPLEX", 0, 0);
            }
        } else if (fieldType instanceof PLIPackedType) {
            PLIPackedType packedType = (PLIPackedType)fieldType;
            int orecision = packedType.getPrecision();
            int scale = packedType.getScale();
            if (scale == 0) {
                this.currStruct.write(" FIXED DECIMAL(" + orecision + ")", 0, 0);
            } else {
                this.currStruct.write(" FIXED DECIMAL(" + orecision + "," + scale + ")", 0, 0);
            }
            if (packedType.getMode() == ModeValues.COMPLEX_LITERAL) {
                this.currStruct.write(" COMPLEX", 0, 0);
            }
        } else if (fieldType instanceof PLIFloatType) {
            PLIFloatType floatType = (PLIFloatType)fieldType;
            int precision = floatType.getPrecision();
            BaseValues base = floatType.getBase();
            if (base.equals(BaseValues.BINARY_LITERAL)) {
                this.currStruct.write(" FLOAT BINARY(" + precision + ")", 0, 0);
            } else {
                this.currStruct.write(" FLOAT DECIMAL(" + precision + ")", 0, 0);
            }
            if (floatType.getMode() == ModeValues.COMPLEX_LITERAL) {
                this.currStruct.write(" COMPLEX", 0, 0);
            }
            if (floatType.isIeee()) {
                this.currStruct.write(" FLOAT", 0, 0);
            }
        } else if (fieldType instanceof PLIPictureType) {
            PLIPictureType pictureType = (PLIPictureType)fieldType;
            String picture = pictureType.getPictureString();
            this.currStruct.write(" PICTURE '" + picture + "'", 0, 0);
            if (pictureType.getMode() == ModeValues.COMPLEX_LITERAL) {
                this.currStruct.write(" COMPLEX", 0, 0);
            }
        } else if (fieldType instanceof PLIPictureStringType) {
            PLIPictureStringType pictureStringType = (PLIPictureStringType)fieldType;
            String picture = pictureStringType.getPictureString();
            this.currStruct.write(" PICTURE '" + picture + "'", 0, 0);
        } else if (fieldType instanceof PLIFixedLengthString) {
            PLIFixedLengthString fixedLengthStringType = (PLIFixedLengthString)fieldType;
            int length = fixedLengthStringType.getLength();
            StringTypeValues type = fixedLengthStringType.getType();
            LengthType lengthType = fixedLengthStringType.getVarying();
            if (type.equals(StringTypeValues.BIT_LITERAL)) {
                this.currStruct.write(" BIT(" + length + ")", 0, 0);
            } else if (type.equals(StringTypeValues.CHARACTER_LITERAL)) {
                this.currStruct.write(" CHARACTER(" + length + ")", 0, 0);
            } else if (type.equals(StringTypeValues.GRAPHIC_LITERAL)) {
                this.currStruct.write(" GRAPHIC(" + length + ")", 0, 0);
            } else if (type.equals(StringTypeValues.WIDECHAR_LITERAL)) {
                this.currStruct.write(" WIDECHAR(" + length + ")", 0, 0);
            }
            if (lengthType.equals(LengthType.VARYING_Z_LITERAL)) {
                this.currStruct.write(" VARYINGZ", 0, 0);
            } else if (lengthType.equals(LengthType.VARYING_BIG_ENDIAN_LITERAL) || lengthType.equals(LengthType.VARYING_LITTLE_ENDIAN_LITERAL)) {
                this.currStruct.write(" VARYING", 0, 0);
            }
        } else if (fieldType instanceof PLIVariableLengthString) {
            PLIVariableLengthString variableLengthStringType = (PLIVariableLengthString)fieldType;
            String length = variableLengthStringType.getLengthToAllocate();
            if (length == null) {
                length = "";
            }
            StringTypeValues stringType = variableLengthStringType.getType();
            LengthType lengthType = variableLengthStringType.getVarying();
            String refers = variableLengthStringType.getReferredTo().getName();
            if (refers.length() > 0) {
                refers = PLIModelWalker.generateFieldQualification(variableLengthStringType.getReferredTo());
                if (stringType.equals(StringTypeValues.BIT_LITERAL)) {
                    this.currStruct.write(" BIT(" + length + " REFER(" + refers + "))", 0, 0);
                } else if (stringType.equals(StringTypeValues.CHARACTER_LITERAL)) {
                    this.currStruct.write(" CHARACTER(" + length + " REFER (" + refers + "))", 0, 0);
                } else if (stringType.equals(StringTypeValues.GRAPHIC_LITERAL)) {
                    this.currStruct.write(" GRAPHIC(" + length + " REFER(" + refers + "))", 0, 0);
                } else if (stringType.equals(StringTypeValues.WIDECHAR_LITERAL)) {
                    this.currStruct.write(" WIDECHAR(" + length + " REFER(" + refers + "))", 0, 0);
                }
            } else if (stringType.equals(StringTypeValues.BIT_LITERAL)) {
                this.currStruct.write(" BIT(" + length + ")", 0, 0);
            } else if (stringType.equals(StringTypeValues.CHARACTER_LITERAL)) {
                this.currStruct.write(" CHARACTER(" + length + ")", 0, 0);
            } else if (stringType.equals(StringTypeValues.GRAPHIC_LITERAL)) {
                this.currStruct.write(" GRAPHIC(" + length + ")", 0, 0);
            } else if (stringType.equals(StringTypeValues.WIDECHAR_LITERAL)) {
                this.currStruct.write(" WIDECHAR(" + length + ")", 0, 0);
            }
            if (lengthType.equals(LengthType.VARYING_Z_LITERAL)) {
                this.currStruct.write(" VARYINGZ", 0, 0);
            } else if (lengthType.equals(LengthType.VARYING_BIG_ENDIAN_LITERAL) || lengthType.equals(LengthType.VARYING_LITTLE_ENDIAN_LITERAL)) {
                this.currStruct.write(" VARYING", 0, 1);
            }
        } else if (fieldType instanceof PLIPointerType) {
            this.currStruct.write(" POINTER", 0, 0);
        }
        if (fieldType.isAligned()) {
            this.currStruct.write(" ALIGNED", 0, 0);
        } else {
            this.currStruct.write(" UNALIGNED", 0, 0);
        }
    }

    public List<DataStructureContainer> getAllStructs() {
        return this.allStructs;
    }
}

