/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.j2c.util.walkers.cobol;

import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLFixedLengthArray;
import com.ibm.etools.cobol.COBOLRedefiningElement;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.COBOLVariableLengthArray;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.COBOLModelWalkerException;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.ICOBOLModelVisitor;
import com.ibm.zosconnect.ui.j2c.util.walkers.util.FieldPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class COBOLModelWalker {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object accept(ICOBOLModelVisitor visitor, Resource importResource) throws COBOLModelWalkerException {
        Object state = visitor.startOfImportResource(importResource, null);
        for (EObject node : importResource.getContents()) {
            if (!(node instanceof COBOLElement)) continue;
            this.accept(visitor, (COBOLElement)node, state);
        }
        state = visitor.endOfImportResource(importResource, state);
        return state;
    }

    public Object accept(ICOBOLModelVisitor visitor, Resource importResource, Object state) throws COBOLModelWalkerException {
        state = visitor.startOfImportResource(importResource, state);
        for (EObject node : importResource.getContents()) {
            if (!(node instanceof COBOLElement)) continue;
            this.accept(visitor, (COBOLElement)node, state);
        }
        state = visitor.endOfImportResource(importResource, state);
        return state;
    }

    public void accept(ICOBOLModelVisitor visitor, COBOLElement field) throws COBOLModelWalkerException {
        this.accept(visitor, field, null);
    }

    public Object accept(ICOBOLModelVisitor visitor, COBOLElement field, Object state) throws COBOLModelWalkerException {
        Stack<COBOLElement> fieldParents = new Stack<COBOLElement>();
        FieldPath fieldPath = new FieldPath();
        state = this.walkField(field, visitor, fieldPath, fieldParents, state);
        state = this.emptyFieldParentStack(visitor, fieldPath, fieldParents, state);
        return state;
    }

    private Object walkField(COBOLElement field, ICOBOLModelVisitor visitor, FieldPath fieldPath, Stack<COBOLElement> fieldParents, Object state) throws COBOLModelWalkerException {
        if (!field.getRedefined().booleanValue() || !field.getLevel().equals("01")) {
            while (!fieldParents.isEmpty() && !COBOLModelWalker.getImmediateChildren(fieldParents.peek()).contains(field)) {
                COBOLElement parent = fieldParents.pop();
                state = COBOLModelWalker.isArray(parent) ? visitor.endOfCompositeArrayField(parent, (COBOLComposedType)parent.getSharedType(), fieldPath, COBOLModelWalker.getImmediateChildren(parent), fieldParents, COBOLModelWalker.isRedefiningField(parent), state) : visitor.endOfCompositeField(parent, (COBOLComposedType)parent.getSharedType(), fieldPath, COBOLModelWalker.getImmediateChildren(parent), fieldParents, COBOLModelWalker.isRedefiningField(parent), state);
                fieldPath.pop();
            }
        }
        if (COBOLModelWalker.isCompositeField(field)) {
            if (COBOLModelWalker.isArray(field)) {
                fieldPath.push(field.getName());
                state = visitor.startOfCompositeArrayField(field, (COBOLComposedType)field.getSharedType(), fieldPath, COBOLModelWalker.getImmediateChildren(field), fieldParents, COBOLModelWalker.isRedefiningField(field), state);
                fieldParents.push(field);
                for (COBOLElement cField : COBOLModelWalker.getImmediateChildren(field)) {
                    state = this.walkField(cField, visitor, fieldPath, fieldParents, state);
                }
            } else {
                fieldPath.push(field.getName());
                state = visitor.startOfCompositeField(field, (COBOLComposedType)field.getSharedType(), fieldPath, COBOLModelWalker.getImmediateChildren(field), fieldParents, COBOLModelWalker.isRedefiningField(field), state);
                fieldParents.push(field);
                if (field.getLevel().equals("01") && COBOLModelWalker.isRedefiningField(field)) {
                    COBOLElement redefined = ((COBOLRedefiningElement)field).getRedefines();
                    state = this.walkField(redefined, visitor, fieldPath, fieldParents, state);
                }
                List<Object> redefinedChildren = new ArrayList();
                redefinedChildren = COBOLModelWalker.getImmediateChildren(field);
                if ((field instanceof COBOLRedefiningElement || field.getRedefined().booleanValue()) && (!((COBOLElement)redefinedChildren.get(0)).getName().equals(field.getName()) || redefinedChildren.size() != 1) && field.getLevel().equals("01")) {
                    this.incrementFieldLevel(field);
                    state = visitor.startOfCompositeField(field, (COBOLComposedType)field.getSharedType(), fieldPath, COBOLModelWalker.getImmediateChildren(field), fieldParents, COBOLModelWalker.isRedefiningField(field), state);
                    field.setLevel("01");
                }
                for (COBOLElement cField : COBOLModelWalker.getImmediateChildren(field)) {
                    state = this.walkField(cField, visitor, fieldPath, fieldParents, state);
                }
            }
        } else {
            fieldPath.push(field.getName());
            state = COBOLModelWalker.isArray(field) ? visitor.leafArrayField(field, (COBOLSimpleType)field.getSharedType(), fieldPath, fieldParents, COBOLModelWalker.isRedefiningField(field), state) : visitor.leafField(field, (COBOLSimpleType)field.getSharedType(), fieldPath, fieldParents, COBOLModelWalker.isRedefiningField(field), state);
            fieldPath.pop();
        }
        return state;
    }

    private void incrementFieldLevel(COBOLElement field) {
        int level = Integer.parseInt(field.getLevel());
        String slevel = String.format("%02d", ++level);
        field.setLevel(slevel);
        if (field.getSharedType() instanceof COBOLComposedType) {
            List<Object> children = new ArrayList();
            children = COBOLModelWalker.getImmediateChildren(field);
            for (COBOLElement cOBOLElement : children) {
                this.incrementFieldLevel(cOBOLElement);
            }
        }
    }

    private Object emptyFieldParentStack(ICOBOLModelVisitor visitor, FieldPath fieldPath, Stack<COBOLElement> fieldParents, Object state) throws COBOLModelWalkerException {
        while (!fieldParents.isEmpty()) {
            COBOLElement parent = fieldParents.pop();
            state = COBOLModelWalker.isArray(parent) ? visitor.endOfCompositeArrayField(parent, (COBOLComposedType)parent.getSharedType(), fieldPath, COBOLModelWalker.getImmediateChildren(parent), fieldParents, COBOLModelWalker.isRedefiningField(parent), state) : visitor.endOfCompositeField(parent, (COBOLComposedType)parent.getSharedType(), fieldPath, COBOLModelWalker.getImmediateChildren(parent), fieldParents, COBOLModelWalker.isRedefiningField(parent), state);
            fieldPath.pop();
        }
        return state;
    }

    public static boolean isArray(COBOLElement field) {
        if (COBOLModelWalker.isFixedLengthArrayField(field)) {
            return true;
        }
        return COBOLModelWalker.isVariableLengthArray(field);
    }

    public static boolean isCompositeField(COBOLElement field) {
        return field.getSharedType() instanceof COBOLComposedType;
    }

    public static boolean isFixedLengthArrayField(COBOLElement field) {
        return field.getArray() instanceof COBOLFixedLengthArray && !(field.getArray() instanceof COBOLVariableLengthArray);
    }

    public static boolean isVariableLengthArray(COBOLElement field) {
        return field.getArray() instanceof COBOLVariableLengthArray;
    }

    public static boolean isRedefiningField(COBOLElement field) {
        return field instanceof COBOLRedefiningElement;
    }

    public static List<COBOLElement> getImmediateChildren(COBOLElement element) {
        ArrayList<COBOLElement> children = new ArrayList<COBOLElement>();
        COBOLClassifier type = element.getSharedType();
        if (type instanceof COBOLComposedType) {
            COBOLComposedType composedType = (COBOLComposedType)element.getSharedType();
            for (Object content : composedType.eContents()) {
                if (!(content instanceof COBOLElement)) continue;
                children.add((COBOLElement)content);
            }
        }
        return children;
    }

    public static int getMinOccurs(COBOLElement element) {
        int minOccurs = 1;
        COBOLFixedLengthArray array = element.getArray();
        if (array instanceof COBOLVariableLengthArray) {
            minOccurs = ((COBOLVariableLengthArray)array).getMinUpper();
        } else if (array != null) {
            minOccurs = array.getMaxUpper();
        }
        return minOccurs;
    }

    public static int getMaxOccurs(COBOLElement element) {
        int maxUpper = 1;
        COBOLFixedLengthArray array = element.getArray();
        if (array instanceof COBOLVariableLengthArray) {
            maxUpper = ((COBOLVariableLengthArray)array).getMaxUpper();
        } else if (array != null) {
            maxUpper = array.getMaxUpper();
        }
        return maxUpper;
    }
}

