/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.j2c.util.walkers.cobol;

import com.ibm.etools.cobol.COBOL88Element;
import com.ibm.etools.cobol.COBOL88ElementValue;
import com.ibm.etools.cobol.COBOLAlphaNumericEditedType;
import com.ibm.etools.cobol.COBOLAlphaNumericType;
import com.ibm.etools.cobol.COBOLAlphabeticType;
import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLDBCSType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLExternalFloatType;
import com.ibm.etools.cobol.COBOLFixedLengthArray;
import com.ibm.etools.cobol.COBOLInitialValueKind;
import com.ibm.etools.cobol.COBOLNumericEditedType;
import com.ibm.etools.cobol.COBOLNumericType;
import com.ibm.etools.cobol.COBOLRedefiningElement;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.COBOLUnicodeType;
import com.ibm.etools.cobol.COBOLUsageValues;
import com.ibm.etools.cobol.COBOLVariableLengthArray;
import com.ibm.etools.tdlang.TDLangElement;
import com.ibm.etools.typedescriptor.LanguageType;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.COBOLModelWalkerException;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.ICOBOLModelConstants;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.SimpleCOBOLVisitor;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.util.COBOLStringDeclaration;
import com.ibm.zosconnect.ui.j2c.util.walkers.cobol.util.COBOLValueClauseBuilder;
import com.ibm.zosconnect.ui.j2c.util.walkers.util.DataStructureContainer;
import com.ibm.zosconnect.ui.j2c.util.walkers.util.FieldPath;
import com.ibm.zosconnect.ui.j2c.util.walkers.util.WrappingOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class COBOLModelSerializer
extends SimpleCOBOLVisitor
implements ICOBOLModelConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<DataStructureContainer> allStructs = new ArrayList<DataStructureContainer>();
    private WrappingOutputStream currStruct;

    @Override
    public Object startOfImportResource(Resource importResource, Object state) throws COBOLModelWalkerException {
        return state;
    }

    @Override
    public Object endOfImportResource(Resource importResource, Object state) throws COBOLModelWalkerException {
        return state;
    }

    @Override
    public Object leafField(COBOLElement field, COBOLSimpleType fieldType, FieldPath fieldPath, Stack<COBOLElement> fieldParents, boolean redefines, Object state) throws COBOLModelWalkerException {
        COBOLNumericType numericType;
        String pictureString;
        this.currStruct.updateMargins(AREA_A_BGN_COL, AREA_B_END_COL);
        this.currStruct.write(field.getLevel() + " " + COBOLModelSerializer.getFieldName(field), 1, 0);
        if (redefines) {
            COBOLElement redefined = ((COBOLRedefiningElement)field).getRedefines();
            this.currStruct.write(" REDEFINES " + COBOLModelSerializer.getFieldName(redefined), 0, 0);
        }
        if ((pictureString = fieldType.getPictureString()) != null && !pictureString.isEmpty()) {
            this.currStruct.write(" PICTURE " + pictureString, 0, 0);
        }
        this.currStruct.write(" USAGE " + COBOLModelSerializer.getCOBOLUsageAsString(fieldType), 0, 0);
        if (fieldType instanceof COBOLNumericType && (numericType = (COBOLNumericType)fieldType).getSignSeparate().booleanValue()) {
            if (numericType.getSignLeading().booleanValue()) {
                this.currStruct.write(" SIGN IS LEADING SEPARATE", 0, 0);
            } else {
                this.currStruct.write(" SIGN IS TRAILING SEPARATE", 0, 0);
            }
        }
        if (fieldType.getSynchronized().booleanValue()) {
            this.currStruct.write(" SYNCHRONIZED", 0, 0);
        }
        this.currStruct.write(".", 0, 0);
        if (field.getContains() != null) {
            for (Object content : field.getContains()) {
                if (!(content instanceof COBOL88Element)) continue;
                try {
                    COBOLModelSerializer.writeCOBOL88Element(field, (COBOL88Element)content, this.currStruct);
                }
                catch (Exception e) {
                    throw new COBOLModelWalkerException(e.getMessage(), e);
                }
            }
        }
        return state;
    }

    @Override
    public Object leafArrayField(COBOLElement field, COBOLSimpleType fieldType, FieldPath fieldPath, Stack<COBOLElement> fieldParents, boolean redefines, Object state) throws COBOLModelWalkerException {
        COBOLFixedLengthArray array;
        COBOLNumericType numericType;
        String pictureString;
        this.currStruct.updateMargins(AREA_A_BGN_COL, AREA_B_END_COL);
        this.currStruct.write(field.getLevel() + " " + COBOLModelSerializer.getFieldName(field), 1, 0);
        if (redefines) {
            COBOLElement redefined = ((COBOLRedefiningElement)field).getRedefines();
            this.currStruct.write(" REDEFINES " + COBOLModelSerializer.getFieldName(redefined), 0, 0);
        }
        if ((pictureString = fieldType.getPictureString()) != null && !pictureString.isEmpty()) {
            this.currStruct.write(" PICTURE " + pictureString, 0, 0);
        }
        this.currStruct.write(" USAGE " + COBOLModelSerializer.getCOBOLUsageAsString(fieldType), 0, 0);
        if (fieldType instanceof COBOLNumericType && (numericType = (COBOLNumericType)fieldType).getSignSeparate().booleanValue()) {
            if (numericType.getSignLeading().booleanValue()) {
                this.currStruct.write(" SIGN IS LEADING SEPARATE", 0, 0);
            } else {
                this.currStruct.write(" SIGN IS TRAILING SEPARATE", 0, 0);
            }
        }
        if (fieldType.getSynchronized().booleanValue()) {
            this.currStruct.write(" SYNCHRONIZED", 0, 0);
        }
        if ((array = field.getArray()) instanceof COBOLVariableLengthArray) {
            COBOLVariableLengthArray cvla = (COBOLVariableLengthArray)array;
            this.currStruct.updateMargins(AREA_B_BGN_COL, AREA_B_END_COL);
            this.currStruct.write("OCCURS " + cvla.getMinUpper() + " TO " + cvla.getMaxUpper() + " TIMES", 1, 0);
            this.currStruct.write("DEPENDING ON " + cvla.getDependingOn().getName(), 1, 0);
            COBOLModelSerializer.writeFieldQualification(cvla.getDependingOn(), this.currStruct);
        } else {
            COBOLFixedLengthArray cfla = array;
            this.currStruct.updateMargins(AREA_B_BGN_COL, AREA_B_END_COL);
            this.currStruct.write("OCCURS " + cfla.getMaxUpper() + " TIMES", 1, 0);
        }
        this.currStruct.write(".", 0, 0);
        return state;
    }

    @Override
    public Object startOfCompositeField(COBOLElement field, COBOLComposedType fieldType, FieldPath fieldPath, List<COBOLElement> fieldChildren, Stack<COBOLElement> fieldParents, boolean redefines, Object state) throws COBOLModelWalkerException {
        if (!field.getRedefined().booleanValue() || !field.getLevel().equals("01") || this.currStruct == null) {
            if (fieldParents.isEmpty() && field.getLevel().equals("01")) {
                this.currStruct = new WrappingOutputStream(AREA_A_BGN_COL, AREA_B_END_COL);
                this.currStruct.updateWrappingStyle(WrappingOutputStream.WrappingStyle.COBOL);
            }
            this.currStruct.updateMargins(AREA_A_BGN_COL, AREA_B_END_COL);
            this.currStruct.write(field.getLevel() + " " + COBOLModelSerializer.getFieldName(field), 1, 0);
            if (redefines && !field.getLevel().equals("01")) {
                COBOLElement redefined = ((COBOLRedefiningElement)field).getRedefines();
                this.currStruct.write(" REDEFINES " + COBOLModelSerializer.getFieldName(redefined), 0, 0);
            }
            this.currStruct.write(".", 0, 0);
        }
        return state;
    }

    @Override
    public Object startOfCompositeArrayField(COBOLElement field, COBOLComposedType fieldType, FieldPath fieldPath, List<COBOLElement> fieldChildren, Stack<COBOLElement> fieldParents, boolean redefines, Object state) throws COBOLModelWalkerException {
        this.currStruct.updateMargins(AREA_A_BGN_COL, AREA_B_END_COL);
        this.currStruct.write(field.getLevel() + " " + COBOLModelSerializer.getFieldName(field), 1, 0);
        COBOLFixedLengthArray array = field.getArray();
        if (array instanceof COBOLVariableLengthArray) {
            COBOLVariableLengthArray cvla = (COBOLVariableLengthArray)array;
            this.currStruct.updateMargins(AREA_B_BGN_COL, AREA_B_END_COL);
            this.currStruct.write("OCCURS " + cvla.getMinUpper() + " TO " + cvla.getMaxUpper() + " TIMES", 1, 0);
            this.currStruct.write("DEPENDING ON " + cvla.getDependingOn().getName(), 1, 0);
            COBOLModelSerializer.writeFieldQualification(cvla.getDependingOn(), this.currStruct);
        } else {
            COBOLFixedLengthArray cfla = array;
            this.currStruct.updateMargins(AREA_B_BGN_COL, AREA_B_END_COL);
            this.currStruct.write("OCCURS " + cfla.getMaxUpper() + " TIMES", 1, 0);
        }
        this.currStruct.write(".", 0, 0);
        return state;
    }

    @Override
    public Object endOfCompositeField(COBOLElement field, COBOLComposedType fieldType, FieldPath fieldPath, List<COBOLElement> fieldChildren, Stack<COBOLElement> fieldParents, boolean redefines, Object state) throws COBOLModelWalkerException {
        if (fieldParents.isEmpty()) {
            DataStructureContainer newStruct = new DataStructureContainer();
            newStruct.setName(field.getName());
            newStruct.setSource(this.currStruct.toString());
            newStruct.setModel((TDLangElement)field);
            newStruct.setLanguage(LanguageType.COBOL_LITERAL);
            newStruct.setTopLevel(Integer.valueOf(field.getLevel()) == 1);
            this.allStructs.add(newStruct);
        }
        return state;
    }

    @Override
    public Object endOfCompositeArrayField(COBOLElement field, COBOLComposedType fieldType, FieldPath fieldPath, List<COBOLElement> fieldChildren, Stack<COBOLElement> fieldParents, boolean redefines, Object state) throws COBOLModelWalkerException {
        return state;
    }

    public static String getFieldName(COBOLElement field) {
        return field.getIsFiller() != false ? "FILLER" : field.getName();
    }

    public static String getCOBOLUsageAsString(COBOLSimpleType cst) {
        COBOLUsageValues cuv = cst.getUsage();
        if (cuv.getValue() == 0) {
            if (cst instanceof COBOLNumericType) {
                COBOLNumericType cnt = (COBOLNumericType)cst;
                if (cnt.getTrunc().getValue() == 2) {
                    return "COMP-5";
                }
                return "COMP";
            }
        } else {
            if (cuv.getValue() == 2) {
                return "COMP-2";
            }
            if (cuv.getValue() == 3) {
                if (cst instanceof COBOLDBCSType) {
                    return "DISPLAY-1";
                }
                if (cst instanceof COBOLUnicodeType) {
                    return "NATIONAL";
                }
                return "DISPLAY";
            }
            if (cuv.getValue() == 4) {
                return "COMP-1";
            }
            if (cuv.getValue() == 5) {
                return "INDEX";
            }
            if (cuv.getValue() == 7) {
                return "OBJECT REFERENCE";
            }
            if (cuv.getValue() == 8) {
                return "COMP-3";
            }
            if (cuv.getValue() == 9) {
                return "POINTER";
            }
            if (cuv.getValue() == 10) {
                return "PROCEDURE-POINTER";
            }
            if (cuv.getValue() == 11) {
                return "FUNCTION-POINTER";
            }
            if (cuv.getValue() == 6) {
                return "NATIONAL";
            }
            if (cuv.getValue() == 1) {
                return "DISPLAY-1";
            }
        }
        return "DISPLAY";
    }

    public static String getInitialValueKindString(COBOLInitialValueKind iKind) {
        String sLimit = "";
        if (iKind.getValue() == 2) {
            sLimit = "HIGH-VALUES";
        } else if (iKind.getValue() == 1) {
            sLimit = "LOW-VALUES";
        } else if (iKind.getValue() == 5) {
            sLimit = "NULLS";
        } else if (iKind.getValue() == 4) {
            sLimit = "QUOTES";
        } else if (iKind.getValue() == 7) {
            sLimit = "SPACES";
        } else if (iKind.getValue() == 3) {
            sLimit = "ZEROS";
        }
        return sLimit;
    }

    public static void writeFieldQualification(COBOLElement field, WrappingOutputStream w) {
        COBOLElement childElement = field;
        COBOLElement parentElement = null;
        while (childElement.getGroup() != null) {
            parentElement = (COBOLElement)childElement.getGroup().getTypedElement().get(0);
            if (!parentElement.getIsFiller().booleanValue()) {
                w.write("OF " + parentElement.getName(), 1, 0);
            }
            childElement = parentElement;
        }
    }

    public static void writeCOBOL88Element(COBOLElement field, COBOL88Element cobol88, WrappingOutputStream w) throws Exception {
        EList cobol88Values = cobol88.getHas();
        String level88Name = cobol88.getName();
        w.updateMargins(AREA_A_BGN_COL, AREA_B_END_COL);
        w.write("88 " + level88Name, 1, 0);
        int i = 0;
        while (i < cobol88Values.size()) {
            COBOL88ElementValue cobol88Val = (COBOL88ElementValue)cobol88Values.get(i);
            if (i == 0) {
                w.write(" VALUE", 0, 0);
            } else {
                w.write(",", 0, 0);
            }
            String lowerLimit = cobol88Val.getLowerLimit();
            if (lowerLimit != null) {
                COBOLInitialValueKind llKind = cobol88Val.getLowerValueKind();
                String sLimit = COBOLModelSerializer.getInitialValueKindString(llKind);
                if (sLimit.equals("")) {
                    w.write(" " + COBOLModelSerializer.getValue(field, lowerLimit), 0, 0);
                } else {
                    w.write(" " + sLimit, 0, 0);
                }
            }
            if (cobol88Val.getRange() != null && cobol88Val.getRange().booleanValue()) {
                w.write(" THRU", 0, 0);
            }
            if (cobol88Val.getUpperLimit() != null) {
                String upperLimit = cobol88Val.getUpperLimit();
                if (upperLimit != null) {
                    COBOLInitialValueKind uvKind = cobol88Val.getUpperValueKind();
                    String sLimit = COBOLModelSerializer.getInitialValueKindString(uvKind);
                    if (sLimit.equals("")) {
                        w.write(" " + COBOLModelSerializer.getValue(field, upperLimit), 0, 0);
                    } else {
                        w.write(" " + sLimit, 0, 0);
                    }
                } else {
                    w.write(" " + COBOLModelSerializer.getValue(field, upperLimit), 0, 0);
                }
            }
            ++i;
        }
        w.write(".", 0, 0);
    }

    public static String getValue(COBOLElement item, String modelValue) throws Exception {
        COBOLClassifier classifier = item.getSharedType();
        if (classifier instanceof COBOLAlphabeticType || classifier instanceof COBOLAlphaNumericType || classifier instanceof COBOLNumericEditedType || classifier instanceof COBOLAlphaNumericEditedType || classifier instanceof COBOLDBCSType || classifier instanceof COBOLUnicodeType || classifier instanceof COBOLExternalFloatType) {
            boolean unicode = false;
            boolean dbcs = false;
            if (modelValue.equals("") || modelValue.equals(" ")) {
                return "SPACES";
            }
            modelValue.replaceAll("'", "&apos;");
            modelValue.replaceAll("&apos;", "''");
            modelValue.replaceAll("&quot;", "\"");
            modelValue.replaceAll("&lt;", "<");
            modelValue.replaceAll("&gt;", ">");
            modelValue.replaceAll("&amp;", "&");
            if (classifier instanceof COBOLUnicodeType) {
                unicode = true;
            }
            if (classifier instanceof COBOLDBCSType) {
                dbcs = true;
            }
            COBOLValueClauseBuilder vb = new COBOLValueClauseBuilder();
            modelValue = COBOLStringDeclaration.create(modelValue, 88, modelValue.length(), unicode, dbcs, false, vb, null);
        }
        return modelValue;
    }

    public List<DataStructureContainer> getAllStructs() {
        return this.allStructs;
    }
}

