/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ast.internal.facets.core;

import com.ibm.ws.ast.internal.facets.core.DelegateExtension;
import com.ibm.ws.ast.internal.facets.core.DelegatesExtensionProcessor;
import com.ibm.ws.ast.internal.facets.core.FacetPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class WebSphereFacetDelegate
implements IDelegate {
    public static final String INSTALL_ACTION_NAME = "install";
    public static final String UNINSTALL_ACTION_NAME = "uninstall";
    public static final String VERSION_CHANGE_ACTION_NAME = "version-change";
    public static final String RUNTIME_CHANGED_ACTION_NAME = "runtime-changed";

    protected abstract String getActionName();

    public final void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        DelegateExtension[] delegates = DelegatesExtensionProcessor.getInstance().getDelegates(fv.getProjectFacet().getId(), fv.getVersionString(), this.getActionName());
        monitor.beginTask("WebSphere Facet Delegate Execution: " + this.getActionName(), 100 * delegates.length);
        try {
            int i = 0;
            while (i < delegates.length) {
                try {
                    delegates[i].execute(project, fv, config, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                catch (Throwable t) {
                    Status status = new Status(4, delegates[i].getNamespace(), 4, String.valueOf(t.getClass().getName()) + " in facet delegate execution", t);
                    FacetPlugin.getDefault().log((IStatus)status);
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean shouldEnableJEEAnnotationProcessor(IProject project) throws CoreException {
        Status status = new Status(4, "com.ibm.ws.ast.facets.core", "method no longer supported");
        throw new CoreException((IStatus)status);
    }

    protected void enableJEEAnnotationProcessor(IJavaProject javaProject) throws CoreException {
        Status status = new Status(4, "com.ibm.ws.ast.facets.core", "method no longer supported");
        throw new CoreException((IStatus)status);
    }

    protected void disableJEEAnnotationProcessor(IJavaProject javaProject) throws CoreException {
        Status status = new Status(4, "com.ibm.ws.ast.facets.core", "method no longer supported");
        throw new CoreException((IStatus)status);
    }
}

