/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ast.internal.facets.core;

import com.ibm.ws.ast.facets.core.FacetUtilities;
import com.ibm.ws.ast.internal.facets.core.FacetPlugin;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IPrimaryRuntimeChangedEvent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

public class RuntimeChangedListener
implements IFacetedProjectListener {
    protected static final String RUNTIME_TYPE_ID = "com.ibm.etools.websphere.runtime";
    protected static final String NEW_RUNTIME_TYPE_ID = "com.ibm.ws.ast.st.runtime";

    public void handleEvent(IFacetedProjectEvent e) {
        if (e.getType() == IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED) {
            IPrimaryRuntimeChangedEvent event = (IPrimaryRuntimeChangedEvent)e;
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = event.getNewPrimaryRuntime();
            if (runtime == null) {
                return;
            }
            if (event.getOldPrimaryRuntime() == null) {
                return;
            }
            final IFacetedProject project = event.getProject();
            Job job = new Job("WebSphere Facet Update"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    IFacetedProjectWorkingCopy workingCopy = project.createWorkingCopy();
                    try {
                        Set currentFacetVersions = project.getProjectFacets();
                        Set fixedProjectFacets = project.getFixedProjectFacets();
                        if (fixedProjectFacets.isEmpty()) {
                            IStatus iStatus = status;
                            return iStatus;
                        }
                        if (project.getPrimaryRuntime() == null) {
                            IStatus iStatus = status;
                            return iStatus;
                        }
                        if (workingCopy.getDefaultConfiguration() == null) {
                            IStatus iStatus = status;
                            return iStatus;
                        }
                        try {
                            Set defaultFacetVersions = workingCopy.getDefaultConfiguration().getProjectFacets();
                            HashSet<IProjectFacet> currentFacets = new HashSet<IProjectFacet>(currentFacetVersions.size());
                            for (IProjectFacetVersion facetVersion : currentFacetVersions) {
                                if (!FacetUtilities.isWebSphereFacetId(facetVersion.getProjectFacet().getId())) continue;
                                currentFacets.add(facetVersion.getProjectFacet());
                            }
                            HashSet<IProjectFacetVersion> toRemove = new HashSet<IProjectFacetVersion>();
                            for (IProjectFacetVersion facetVersion : currentFacetVersions) {
                                if (!FacetUtilities.isWebSphereFacetId(facetVersion.getProjectFacet().getId()) || defaultFacetVersions.contains(facetVersion)) continue;
                                toRemove.add(facetVersion);
                            }
                            HashSet<IProjectFacetVersion> toAdd = new HashSet<IProjectFacetVersion>();
                            for (IProjectFacetVersion facetVersion : defaultFacetVersions) {
                                if (!currentFacets.contains(facetVersion.getProjectFacet()) || currentFacetVersions.contains(facetVersion)) continue;
                                toAdd.add(facetVersion);
                            }
                            boolean isWasUtility = false;
                            if (RuntimeChangedListener.isWASRuntime(FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)project.getPrimaryRuntime()))) {
                                for (IProjectFacet facet : fixedProjectFacets) {
                                    if (!facet.getId().equals("jst.utility")) continue;
                                    isWasUtility = true;
                                    break;
                                }
                            }
                            if (!toAdd.isEmpty() || isWasUtility) {
                                if (!toAdd.isEmpty()) {
                                    for (IProjectFacetVersion version : toRemove) {
                                        workingCopy.removeProjectFacet(version);
                                    }
                                    for (IProjectFacetVersion version : toAdd) {
                                        workingCopy.addProjectFacet(version);
                                    }
                                }
                                for (IProjectFacetVersion facetVersion : defaultFacetVersions) {
                                    if (!facetVersion.getProjectFacet().getId().equals("java")) continue;
                                    workingCopy.changeProjectFacetVersion(facetVersion);
                                    break;
                                }
                                workingCopy.commitChanges(null);
                            }
                        }
                        catch (Exception exception) {
                            status = new Status(4, "com.ibm.ws.ast.facets.core", 0, "Error upgrading WebSphere facets to match the runtime.", (Throwable)exception);
                            FacetPlugin.getDefault().getLog().log(status);
                        }
                    }
                    finally {
                        workingCopy.dispose();
                    }
                    return status;
                }
            };
            job.setSystem(true);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
    }

    protected static boolean isWASRuntime(IRuntime runtime) {
        return runtime != null && runtime.getRuntimeType() != null && (runtime.getRuntimeType().getId().startsWith(RUNTIME_TYPE_ID) || runtime.getRuntimeType().getId().startsWith(NEW_RUNTIME_TYPE_ID));
    }
}

