/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.was.descriptors.web;

import com.ibm.jee.was.descriptors.Descriptor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebExtensionsDescriptor
extends Descriptor {
    public static final String WEB_EXTENSIONS_FILE_URI = "WEB-INF/ibm-web-ext.xml";
    private static final String CONTEXT_ROOT = "context-root";

    public WebExtensionsDescriptor(IProject project) {
        super(project, WEB_EXTENSIONS_FILE_URI);
        try {
            org.eclipse.wst.server.core.IRuntime runtime;
            IRuntime projectRuntime = ProjectFacetsManager.create((IProject)project).getPrimaryRuntime();
            org.eclipse.wst.server.core.IRuntime iRuntime = runtime = projectRuntime != null ? FacetUtil.getRuntime((IRuntime)projectRuntime) : null;
            if (runtime != null && (WebExtensionsDescriptor.isWASv80OrLaterRuntime(runtime) || runtime.getRuntimeType().getId().startsWith("com.ibm.ws.st.runtime"))) {
                this.setDataPath("data1/");
            }
        }
        catch (CoreException coreException) {}
    }

    public String getContextRoot() throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            Element item = this.getElement(model.getDocument().getDocumentElement(), "pre:context-root");
            if (item == null) {
                return null;
            }
            Node node = item.getAttributes().getNamedItem("uri");
            if (node == null) {
                return null;
            }
            String string = node.getNodeValue();
            return string;
        }
        finally {
            model.releaseFromRead();
        }
    }

    public void setContextRoot(String uri) throws CoreException {
        if (!this.getFile().exists()) {
            this.createDescriptor();
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                TreeSet<String> names = new TreeSet<String>(Arrays.asList("resource-ref", "servlet-cache-config", "autoload-filters", "auto-encode-requests", "auto-encode-responses", "enable-directory-browsing", "enable-file-serving", "pre-compile-jsps", "enable-reloading", "enable-serving-servlets-by-class-name"));
                boolean created = false;
                Element contextElement = this.getElement(model.getDocument().getDocumentElement(), "pre:context-root");
                if (contextElement == null) {
                    created = true;
                    IDOMDocument document = model.getDocument();
                    contextElement = document.createElement(CONTEXT_ROOT);
                    boolean found = false;
                    NodeList nodes = document.getDocumentElement().getChildNodes();
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Node node = nodes.item(i);
                        if (node instanceof Element && names.contains(node.getNodeName())) {
                            found = true;
                            document.getDocumentElement().insertBefore(contextElement, node);
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        document.getDocumentElement().appendChild(contextElement);
                        Text eol = document.createTextNode(System.getProperty("line.separator"));
                        document.getDocumentElement().appendChild(eol);
                    }
                }
                contextElement.setAttribute("uri", uri);
                if (created) {
                    this.format(contextElement);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }
}

