/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.was.descriptors.web;

import com.ibm.jee.was.descriptors.Descriptor;
import com.ibm.jee.was.internal.descriptors.BundleActivator;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebBindingsDescriptor
extends Descriptor {
    public static final String WEB_BINDINGS_FILE_URI = "WEB-INF/ibm-web-bnd.xml";
    protected static final String AUTHENTICATION_ALIAS = "authentication-alias";
    protected static final String BINDING_NAME = "binding-name";
    protected static final String EJB_REF = "ejb-ref";
    protected static final String NAME = "name";
    protected static final String RESOURCE_ENV_REF = "resource-env-ref";
    protected static final String RESOURCE_REF = "resource-ref";

    public WebBindingsDescriptor(IProject project) {
        super(project, WEB_BINDINGS_FILE_URI);
        try {
            IRuntime runtime;
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime projectRuntime = ProjectFacetsManager.create((IProject)project).getPrimaryRuntime();
            IRuntime iRuntime = runtime = projectRuntime != null ? FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)projectRuntime) : null;
            if (runtime != null && (WebBindingsDescriptor.isWASv80OrLaterRuntime(runtime) || runtime.getRuntimeType().getId().startsWith("com.ibm.ws.st.runtime"))) {
                this.setDataPath("data1/");
            }
        }
        catch (CoreException coreException) {}
    }

    public String getResourceRefBindingsName(String refName) throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            Element item = this.getResourceRefBindingElement(model.getDocument().getDocumentElement(), refName);
            if (item == null) {
                return null;
            }
            Node node = item.getAttributes().getNamedItem(BINDING_NAME);
            if (node == null) {
                return null;
            }
            String string = node.getNodeValue();
            return string;
        }
        finally {
            model.releaseFromRead();
        }
    }

    public String getResourceRefAuthenticationAlias(String refName) throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            Element item = this.getResourceRefBindingElement(model.getDocument().getDocumentElement(), refName);
            if (item == null) {
                return null;
            }
            if ((item = this.getAuthenticationAlias(item)) == null) {
                return null;
            }
            Node node = item.getAttributes().getNamedItem(NAME);
            if (node == null) {
                return null;
            }
            String string = node.getNodeValue();
            return string;
        }
        finally {
            model.releaseFromRead();
        }
    }

    protected Element getResourceRefBindingElement(Element documentElement, String refName) throws CoreException {
        String expression = "pre:resource-ref[@name=\"" + refName + "\"]";
        return this.getElement(documentElement, expression);
    }

    protected Element getAuthenticationAlias(Element refElement) throws CoreException {
        String expression = "pre:authentication-alias";
        return this.getElement(refElement, expression);
    }

    public void setResourceRefBinding(String refName, String bindingName) throws CoreException {
        this.setResourceRefBinding(refName, bindingName, null);
    }

    public void setResourceRefBinding(String refName, String bindingName, String authAliasName) throws CoreException {
        if (!this.getFile().exists()) {
            this.createDescriptor();
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                boolean created = false;
                Element refElement = this.getResourceRefBindingElement(model.getDocument().getDocumentElement(), refName);
                if (refElement == null) {
                    created = true;
                    IDOMDocument document = model.getDocument();
                    refElement = document.createElement(RESOURCE_REF);
                    refElement.setAttribute(NAME, refName);
                    document.getDocumentElement().insertBefore(refElement, null);
                    Text eol = document.createTextNode(System.getProperty("line.separator"));
                    document.getDocumentElement().appendChild(eol);
                }
                refElement.setAttribute(BINDING_NAME, bindingName);
                if (authAliasName != null) {
                    Element authAliasElement = this.getAuthenticationAlias(refElement);
                    if (authAliasElement == null) {
                        created = true;
                        IDOMDocument document = model.getDocument();
                        authAliasElement = document.createElement(AUTHENTICATION_ALIAS);
                        authAliasElement.setAttribute(NAME, refName);
                        refElement.insertBefore(authAliasElement, null);
                    }
                    authAliasElement.setAttribute(NAME, authAliasName);
                }
                if (created) {
                    this.format(refElement);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public void setResourceRefAuthenticationAlias(String refName, String authAliasName) throws CoreException {
        if (!this.getFile().exists()) {
            String msg = MessageFormat.format("Resource reference {0} does not exist", refName);
            throw new CoreException((IStatus)new Status(4, "com.ibm.jee.was.descriptors", msg));
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                Element refElement = this.getResourceRefBindingElement(model.getDocument().getDocumentElement(), refName);
                if (refElement == null) {
                    String msg = MessageFormat.format("Resource reference {0} does not exist", refName);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.jee.was.descriptors", msg));
                }
                boolean created = false;
                Element authAliasElement = this.getAuthenticationAlias(refElement);
                if (authAliasElement == null) {
                    created = true;
                    IDOMDocument document = model.getDocument();
                    authAliasElement = document.createElement(AUTHENTICATION_ALIAS);
                    authAliasElement.setAttribute(NAME, refName);
                    refElement.insertBefore(authAliasElement, null);
                }
                authAliasElement.setAttribute(NAME, authAliasName);
                if (created) {
                    this.format(refElement);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public boolean removeResourceRefBinding(String refName) throws CoreException {
        if (!this.getFile().exists()) {
            return false;
        }
        IDOMModel model = this.getModelForEdit();
        try {
            Element item = this.getResourceRefBindingElement(model.getDocument().getDocumentElement(), refName);
            if (item == null) {
                return false;
            }
            Node parentNode = item.getParentNode();
            parentNode.removeChild(item);
            if (model.isSaveNeeded()) {
                model.save();
            }
            return true;
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error saving file {0}", this.getFile());
            Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public boolean removeResourceRefAuthAlias(String refName) throws CoreException {
        if (!this.getFile().exists()) {
            return false;
        }
        IDOMModel model = this.getModelForEdit();
        try {
            Element item = this.getResourceRefBindingElement(model.getDocument().getDocumentElement(), refName);
            if (item == null) {
                return false;
            }
            Element authAliasElement = this.getAuthenticationAlias(item);
            if (authAliasElement == null) {
                return false;
            }
            item.removeChild(authAliasElement);
            if (model.isSaveNeeded()) {
                model.save();
            }
            return true;
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error saving file {0}", this.getFile());
            Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public void setEjbRefBinding(String refName, String bindingName) throws CoreException {
        this.setRefBinding(EJB_REF, refName, bindingName);
    }

    protected void setRefBinding(String refType, String refName, String bindingName) throws CoreException {
        if (!this.getFile().exists()) {
            this.createDescriptor();
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                boolean created = false;
                IDOMDocument document = model.getDocument();
                Element root = document.getDocumentElement();
                Element ref = this.getElement(root, "pre:" + refType + "[@name=\"" + refName + "\"]");
                if (ref == null) {
                    created = true;
                    ref = this.createRefElement(document, refType, refName);
                    root.appendChild(ref);
                }
                ref.setAttribute(BINDING_NAME, bindingName);
                if (created) {
                    this.format(root);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                BundleActivator.getDefault().getLog().log((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }

    protected Element createRefElement(IDOMDocument document, String refType, String refName) {
        Element ref = document.createElement(refType);
        ref.setAttribute(NAME, refName);
        return ref;
    }

    public String getEjbRefBindingName(String refName) throws CoreException {
        return this.getRefBindingName(EJB_REF, refName);
    }

    protected String getRefBindingName(String refType, String refName) throws CoreException {
        return this.getRefBindings(refType).get(refName);
    }

    protected Map<String, String> getRefBindings(String refType) throws CoreException {
        Map<String, String> result = Collections.emptyMap();
        if (!this.getFile().exists()) {
            return result;
        }
        IDOMModel model = this.getModelForRead();
        try {
            Element root = model.getDocument().getDocumentElement();
            if (root == null) {
                Map<String, String> map = result;
                return map;
            }
            NodeList items = this.getAllElements(root, "pre:" + refType);
            if (items == null) {
                Map<String, String> map = result;
                return map;
            }
            result = new HashMap<String, String>(items.getLength());
            int i = 0;
            while (i < items.getLength()) {
                if (items.item(i) != null) {
                    String name = null;
                    String bindingName = null;
                    Node node = items.item(i).getAttributes().getNamedItem(NAME);
                    if (node != null) {
                        name = node.getNodeValue();
                    }
                    if ((node = items.item(i).getAttributes().getNamedItem(BINDING_NAME)) != null) {
                        bindingName = node.getNodeValue();
                    }
                    if (name != null && bindingName != null) {
                        result.put(name, bindingName);
                    }
                }
                ++i;
            }
            Map<String, String> map = Collections.unmodifiableMap(result);
            return map;
        }
        finally {
            model.releaseFromRead();
        }
    }

    public Map<String, String> getEjbRefBindings() throws CoreException {
        return this.getRefBindings(EJB_REF);
    }

    public boolean removeEjbRefBinding(String refName) throws CoreException {
        return this.removeRefBinding(EJB_REF, refName);
    }

    protected boolean removeRefBinding(String refType, String refName) throws CoreException {
        if (!this.getFile().exists()) {
            return false;
        }
        IDOMModel model = this.getModelForEdit();
        try {
            Element root = model.getDocument().getDocumentElement();
            if (root == null) {
                return false;
            }
            Element refElement = this.getRefElement(root, refType, refName);
            if (refElement == null) {
                return false;
            }
            Node parentNode = refElement.getParentNode();
            parentNode.removeChild(refElement);
            if (model.isSaveNeeded()) {
                model.save();
            }
            return true;
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error saving file {0}", this.getFile());
            Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
            BundleActivator.getDefault().getLog().log((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        finally {
            model.releaseFromEdit();
        }
    }

    protected Element getRefElement(Element parent, String refType, String refName) throws CoreException {
        return this.getElement(parent, "pre:" + refType + "[@name=\"" + refName + "\"]");
    }

    public void setResourceEnvRefBinding(String refName, String bindingName) throws CoreException {
        this.setRefBinding(RESOURCE_ENV_REF, refName, bindingName);
    }

    public String getResourceEnvRefBindingName(String refName) throws CoreException {
        return this.getRefBindingName(RESOURCE_ENV_REF, refName);
    }

    public Map<String, String> getResourceEnvRefBindings() throws CoreException {
        return this.getRefBindings(RESOURCE_ENV_REF);
    }

    public boolean removeResourceEnvRefBinding(String refName) throws CoreException {
        return this.removeRefBinding(RESOURCE_ENV_REF, refName);
    }
}

