/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.was.descriptors.internal.ejb;

import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import com.ibm.jee.was.descriptors.ejb.EjbBindingsDescriptor;
import com.ibm.jee.was.internal.descriptors.BundleActivator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.application.ICommonApplication;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class BindingsHelper {
    private static final String EJBLOCAL = "ejblocal:";
    private final EjbBindingsDescriptor _bindingsDescriptor;
    private ICommonApplication _application;

    public BindingsHelper(ICommonApplication application, EJBJar ejbJar) {
        this._bindingsDescriptor = new EjbBindingsDescriptor(ProjectUtilities.getProject((Object)ejbJar));
        this._application = application;
    }

    public String getBindingName(SessionBean bean, String interfaceName) throws CoreException {
        if (bean.getBusinessLocals().contains(interfaceName)) {
            String name = this._bindingsDescriptor.getBindingName(bean.getEjbName(), interfaceName);
            if (name != null) {
                return name;
            }
            return this.getLocalBindingName(bean, interfaceName);
        }
        if (bean.getBusinessRemotes().contains(interfaceName)) {
            String name = this._bindingsDescriptor.getBindingName(bean.getEjbName(), interfaceName);
            if (name != null) {
                return name;
            }
            return this.getRemoteBindingName(bean, interfaceName);
        }
        if (interfaceName.equals(bean.getLocalHome())) {
            String name = this._bindingsDescriptor.getLocalHomeBindingName(bean.getEjbName());
            if (name != null) {
                return name;
            }
            return this.getLocalBindingName(bean, interfaceName);
        }
        if (interfaceName.equals(bean.getHome())) {
            String name = this._bindingsDescriptor.getRemoteHomeBindingName(bean.getEjbName());
            if (name != null) {
                return name;
            }
            return this.getRemoteBindingName(bean, interfaceName);
        }
        if (interfaceName != null && interfaceName.equals(bean.getEjbClass())) {
            return this.getLocalBindingName(bean, interfaceName);
        }
        return null;
    }

    protected String getLocalBindingName(SessionBean bean, String interfaceName) throws CoreException {
        String name = this._bindingsDescriptor.getSimpleBindingName(bean.getEjbName());
        if (name != null) {
            int count = bean.getBusinessLocals().size();
            if (bean.getLocalHome() != null && bean.getLocalHome().trim().length() > 0) {
                ++count;
            }
            if (count > 1) {
                return EJBLOCAL + name + "#" + interfaceName;
            }
            return EJBLOCAL + name;
        }
        name = this.getDefaultInterfaceBindingName(bean, interfaceName);
        if (name != null) {
            return EJBLOCAL + name;
        }
        return EJBLOCAL + interfaceName;
    }

    protected String getRemoteBindingName(SessionBean bean, String interfaceName) throws CoreException {
        String name = this._bindingsDescriptor.getSimpleBindingName(bean.getEjbName());
        if (name != null) {
            int count = bean.getBusinessRemotes().size();
            if (bean.getHome() != null && bean.getHome().trim().length() > 0) {
                ++count;
            }
            if (count > 1) {
                return String.valueOf(name) + "#" + interfaceName;
            }
            return name;
        }
        name = this.getDefaultInterfaceBindingName(bean, interfaceName);
        if (name != null) {
            return "ejb/" + name;
        }
        return interfaceName;
    }

    protected String getDefaultInterfaceBindingName(SessionBean bean, String interfaceName) throws CoreException {
        String name = this.getDefaultBindingComponentId(bean);
        if (name != null) {
            return String.valueOf(name) + "#" + interfaceName;
        }
        return null;
    }

    protected String getDefaultBindingComponentId(SessionBean bean) throws CoreException {
        String name = this._bindingsDescriptor.getComponentId(bean.getEjbName());
        if (name != null) {
            return name;
        }
        IVirtualComponent earComponent = ComponentUtilities.findComponent((IResource)this.getEarProject());
        IVirtualComponent jarComponent = ComponentUtilities.findComponent((IResource)this.getEjbProject());
        IVirtualReference jarReference = null;
        IVirtualReference[] iVirtualReferenceArray = earComponent.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            if (jarComponent.equals(ref.getReferencedComponent())) {
                jarReference = ref;
                break;
            }
            ++n2;
        }
        if (jarReference != null) {
            name = String.valueOf(this.getApplicationName()) + "/" + jarReference.getArchiveName() + "/" + bean.getEjbName();
        }
        return name;
    }

    protected String getApplicationName() throws CoreException {
        return this.getEarProject().getName();
    }

    protected ICommonApplication getApplication() throws CoreException {
        if (this._application == null) {
            IProject earProject;
            IModelProvider provider;
            IProject[] projects = J2EEProjectUtilities.getReferencingEARProjects((IProject)this.getEjbProject());
            if (projects.length == 0) {
                Status status = new Status(4, "com.ibm.jee.was.descriptors", String.valueOf(this.getClass().getName()) + ": project doesn't belongs to an EAR file: " + this.getEjbProject());
                throw new CoreException((IStatus)status);
            }
            if (projects.length > 1) {
                Status status = new Status(2, "com.ibm.jee.was.descriptors", String.valueOf(this.getClass().getName()) + ": project belongs to multiple EAR files: " + this.getEjbProject());
                BundleActivator.getDefault().getLog().log((IStatus)status);
            }
            if ((provider = ModelProviderManager.getModelProvider((IProject)(earProject = projects[0]))) == null) {
                Status status = new Status(4, "com.ibm.jee.was.descriptors", String.valueOf(this.getClass().getName()) + ": can't get model for project: " + earProject);
                throw new CoreException((IStatus)status);
            }
            ICommonApplication model = (ICommonApplication)provider.getModelObject(IJEE5ModelProvider.EAR_DD_MODEL_MERGED);
            if (model == null) {
                Status status = new Status(4, "com.ibm.jee.was.descriptors", "Can't Application model for project " + earProject);
                throw new CoreException((IStatus)status);
            }
            this._application = model;
        }
        return this._application;
    }

    protected EjbBindingsDescriptor getDescriptor() {
        return this._bindingsDescriptor;
    }

    protected IProject getEjbProject() {
        return this._bindingsDescriptor.getFile().getProject();
    }

    protected IProject getEarProject() throws CoreException {
        return ProjectUtilities.getProject((Object)this.getApplication());
    }
}

