/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.was.descriptors.ejb;

import com.ibm.jee.was.descriptors.Descriptor;
import com.ibm.jee.was.internal.descriptors.BundleActivator;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbBindingsDescriptor
extends Descriptor {
    public static final String EJB_BINDINGS_FILE_URI = "META-INF/ibm-ejb-jar-bnd.xml";
    public static final String EJB_IN_WAR_BINDINGS_FILE_URI = "WEB-INF/ibm-ejb-jar-bnd.xml";
    protected static final String AUTHENTICATION_ALIAS = "authentication-alias";
    protected static final String BINDING_NAME = "binding-name";
    protected static final String COMPONENT_ID = "component-id";
    protected static final String EJB_REF = "ejb-ref";
    protected static final String LOCAL_HOME_BINDING_NAME = "local-home-binding-name";
    protected static final String MESSAGE_DESTINATION_REF = "message-destination-ref";
    protected static final String MESSAGE_DRIVEN = "message-driven";
    protected static final String NAME = "name";
    protected static final String REMOTE_HOME_BINDING_NAME = "remote-home-binding-name";
    protected static final String RESOURCE_ENV_REF = "resource-env-ref";
    protected static final String RESOURCE_REF = "resource-ref";
    protected static final String SESSION = "session";
    protected static final String SIMPLE_BINDING_NAME = "simple-binding-name";

    public EjbBindingsDescriptor(IProject project) {
        super(project, JavaEEProjectUtilities.isDynamicWebProject((IProject)project) ? EJB_IN_WAR_BINDINGS_FILE_URI : EJB_BINDINGS_FILE_URI);
        try {
            IRuntime runtime;
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime projectRuntime = ProjectFacetsManager.create((IProject)project).getPrimaryRuntime();
            IRuntime iRuntime = runtime = projectRuntime != null ? FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)projectRuntime) : null;
            if (runtime != null && (EjbBindingsDescriptor.isWASv80OrLaterRuntime(runtime) || runtime.getRuntimeType().getId().startsWith("com.ibm.ws.st.runtime"))) {
                this.setDataPath("data1/");
            }
        }
        catch (CoreException coreException) {}
    }

    public void setMessageDrivenBindingJcaAdapter(String beanName, String activationSpecBindingName) throws CoreException {
        this.setMessageDrivenBindingJcaAdapter(beanName, activationSpecBindingName, null, null);
    }

    public void setMessageDrivenBindingJcaAdapter(String beanName, String activationSpecBindingName, String activationSpecAuthAlias, String destinationBindingName) throws CoreException {
        if (!this.getFile().exists()) {
            this.createDescriptor();
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                Element jcaAdapter;
                boolean created = false;
                IDOMDocument document = model.getDocument();
                Element beanElement = this.getElement(document.getDocumentElement(), "pre:message-driven[@name=\"" + beanName + "\"]");
                if (beanElement == null) {
                    created = true;
                    beanElement = this.createBeanElement(document, MESSAGE_DRIVEN, beanName);
                }
                if ((jcaAdapter = this.getElement(beanElement, "pre:jca-adapter")) == null) {
                    created = true;
                    Element listenerPort = this.getElement(beanElement, "pre:listener-port");
                    if (listenerPort != null) {
                        beanElement.removeChild(listenerPort);
                    }
                    jcaAdapter = document.createElement("jca-adapter");
                    Node child = beanElement.getFirstChild();
                    beanElement.insertBefore(jcaAdapter, child);
                }
                jcaAdapter.setAttribute("activation-spec-binding-name", activationSpecBindingName);
                if (activationSpecAuthAlias != null) {
                    jcaAdapter.setAttribute("activation-spec-auth-alias", activationSpecAuthAlias);
                }
                if (destinationBindingName != null) {
                    jcaAdapter.setAttribute("destination-binding-name", destinationBindingName);
                }
                if (created) {
                    this.format(beanElement);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                BundleActivator.getDefault().getLog().log((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public void setMessageDrivenBindingListenerPort(String beanName, String listenerPortName) throws CoreException {
        if (!this.getFile().exists()) {
            this.createDescriptor();
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                Element listenerPort;
                boolean created = false;
                IDOMDocument document = model.getDocument();
                Element beanElement = this.getElement(document.getDocumentElement(), "pre:message-driven[@name=\"" + beanName + "\"]");
                if (beanElement == null) {
                    created = true;
                    beanElement = this.createBeanElement(document, MESSAGE_DRIVEN, beanName);
                }
                if ((listenerPort = this.getElement(beanElement, "pre:listener-port")) == null) {
                    created = true;
                    Element jcaAdapter = this.getElement(beanElement, "pre:jca-adapter");
                    if (jcaAdapter != null) {
                        beanElement.removeChild(jcaAdapter);
                    }
                    listenerPort = document.createElement("listener-port");
                    Node child = beanElement.getFirstChild();
                    beanElement.insertBefore(listenerPort, child);
                }
                listenerPort.setAttribute(NAME, listenerPortName);
                if (created) {
                    this.format(beanElement);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                BundleActivator.getDefault().getLog().log((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public boolean removeEjbRefBinding(String beanName, String refName) throws CoreException {
        return this.removeRefBinding(beanName, EJB_REF, refName);
    }

    public Map<String, String> getEjbRefBindings(String beanName) throws CoreException {
        return this.getRefBindings(beanName, EJB_REF);
    }

    public String getEjbRefBindingName(String beanName, String refName) throws CoreException {
        return this.getRefBindingName(beanName, EJB_REF, refName);
    }

    public void setMessageDrivenEjbRefBinding(String beanName, String refName, String bindingName) throws CoreException {
        this.setRefBinding(MESSAGE_DRIVEN, beanName, EJB_REF, refName, bindingName);
    }

    public void setSessionEjbRefBinding(String beanName, String refName, String bindingName) throws CoreException {
        this.setRefBinding(SESSION, beanName, EJB_REF, refName, bindingName);
    }

    public boolean removeResourceRefBinding(String beanName, String refName) throws CoreException {
        return this.removeRefBinding(beanName, RESOURCE_REF, refName);
    }

    public boolean removeResourceRefAuthAlias(String beanName, String refName) throws CoreException {
        if (!this.getFile().exists()) {
            return false;
        }
        IDOMModel model = this.getModelForEdit();
        try {
            Element beanElement = this.getBeanElement(model.getDocument().getDocumentElement(), beanName);
            if (beanElement == null) {
                return false;
            }
            Element refElement = this.getRefElement(beanElement, RESOURCE_REF, refName);
            if (refElement == null) {
                return false;
            }
            Element authAliasElement = this.getAuthenticationAliasElement(refElement);
            if (authAliasElement == null) {
                return false;
            }
            refElement.removeChild(authAliasElement);
            if (model.isSaveNeeded()) {
                model.save();
            }
            return true;
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error saving file {0}", this.getFile());
            Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
            BundleActivator.getDefault().getLog().log((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public Map<String, String> getResourceRefBindings(String beanName) throws CoreException {
        return this.getRefBindings(beanName, RESOURCE_REF);
    }

    public String getResourceRefBindingName(String beanName, String refName) throws CoreException {
        return this.getRefBindingName(beanName, RESOURCE_REF, refName);
    }

    public String getResourceRefBindingAuthenticationAlias(String beanName, String refName) throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            Element beanElement = this.getBeanElement(model.getDocument().getDocumentElement(), beanName);
            if (beanElement == null) {
                return null;
            }
            Element refElement = this.getRefElement(beanElement, RESOURCE_REF, refName);
            if (refElement == null) {
                return null;
            }
            Element authElement = this.getAuthenticationAliasElement(refElement);
            if (authElement == null) {
                return null;
            }
            Node node = authElement.getAttributes().getNamedItem(NAME);
            if (node == null) {
                return null;
            }
            String string = node.getNodeValue();
            return string;
        }
        finally {
            model.releaseFromRead();
        }
    }

    public void setMessageDrivenResourceRefBinding(String beanName, String refName, String bindingName) throws CoreException {
        this.setRefBinding(MESSAGE_DRIVEN, beanName, RESOURCE_REF, refName, bindingName);
    }

    public void setResourceRefBindingAuthenticationAlias(String beanName, String refName, String authAliasName) throws CoreException {
        if (!this.getFile().exists()) {
            String msg = MessageFormat.format("Resource reference {0} is not defined for bean {1}", refName, beanName);
            throw new CoreException((IStatus)new Status(4, "com.ibm.jee.was.descriptors", msg));
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                Element beanElement = this.getBeanElement(model.getDocument().getDocumentElement(), beanName);
                if (beanElement == null) {
                    String msg = MessageFormat.format("Resource reference {0} is not defined for bean {1}", refName, beanName);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.jee.was.descriptors", msg));
                }
                Element refElement = this.getRefElement(beanElement, RESOURCE_REF, refName);
                if (refElement == null) {
                    String msg = MessageFormat.format("Resource reference {0} is not defined for bean {1}", refName, beanName);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.jee.was.descriptors", msg));
                }
                boolean created = false;
                Element authAliasElement = this.getAuthenticationAliasElement(refElement);
                if (authAliasElement == null) {
                    created = true;
                    IDOMDocument document = model.getDocument();
                    authAliasElement = document.createElement(AUTHENTICATION_ALIAS);
                    authAliasElement.setAttribute(NAME, refName);
                    refElement.insertBefore(authAliasElement, null);
                }
                authAliasElement.setAttribute(NAME, authAliasName);
                if (created) {
                    this.format(refElement);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                BundleActivator.getDefault().getLog().log((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public void setSessionResourceRefBinding(String beanName, String refName, String bindingName) throws CoreException {
        this.setRefBinding(SESSION, beanName, RESOURCE_REF, refName, bindingName);
    }

    public boolean removeResourceEnvRefBinding(String beanName, String refName) throws CoreException {
        return this.removeRefBinding(beanName, RESOURCE_ENV_REF, refName);
    }

    public Map<String, String> getResourceEnvRefBindings(String beanName) throws CoreException {
        return this.getRefBindings(beanName, RESOURCE_ENV_REF);
    }

    public String getResourceEnvRefBindingName(String beanName, String refName) throws CoreException {
        return this.getRefBindingName(beanName, RESOURCE_ENV_REF, refName);
    }

    public void setMessageDrivenResourceEnvRefBinding(String beanName, String refName, String bindingName) throws CoreException {
        this.setRefBinding(MESSAGE_DRIVEN, beanName, RESOURCE_ENV_REF, refName, bindingName);
    }

    public void setSessionResourceEnvRefBinding(String beanName, String refName, String bindingName) throws CoreException {
        this.setRefBinding(SESSION, beanName, RESOURCE_ENV_REF, refName, bindingName);
    }

    public boolean removeMessageDestinationRefBinding(String beanName, String refName) throws CoreException {
        return this.removeRefBinding(beanName, MESSAGE_DESTINATION_REF, refName);
    }

    public Map<String, String> getMessageDestinationRefBindings(String beanName) throws CoreException {
        return this.getRefBindings(beanName, MESSAGE_DESTINATION_REF);
    }

    public String getMessageDestinationRefBindingName(String beanName, String refName) throws CoreException {
        return this.getRefBindingName(beanName, MESSAGE_DESTINATION_REF, refName);
    }

    public void setMessageDrivenMessageDestinationRefBinding(String beanName, String refName, String bindingName) throws CoreException {
        this.setRefBinding(MESSAGE_DRIVEN, beanName, MESSAGE_DESTINATION_REF, refName, bindingName);
    }

    public void setSessionMessageDestinationRefBinding(String beanName, String refName, String bindingName) throws CoreException {
        this.setRefBinding(SESSION, beanName, MESSAGE_DESTINATION_REF, refName, bindingName);
    }

    protected Map<String, String> getRefBindings(String beanName, String refType) throws CoreException {
        Map<String, String> result = Collections.emptyMap();
        if (!this.getFile().exists()) {
            return result;
        }
        IDOMModel model = this.getModelForRead();
        try {
            Element beanElement = this.getBeanElement(model.getDocument().getDocumentElement(), beanName);
            if (beanElement == null) {
                Map<String, String> map = result;
                return map;
            }
            NodeList items = this.getAllElements(beanElement, "pre:" + refType);
            if (items == null) {
                Map<String, String> map = result;
                return map;
            }
            result = new HashMap<String, String>(items.getLength());
            int i = 0;
            while (i < items.getLength()) {
                if (items.item(i) != null) {
                    String name = null;
                    String bindingName = null;
                    Node node = items.item(i).getAttributes().getNamedItem(NAME);
                    if (node != null) {
                        name = node.getNodeValue();
                    }
                    if ((node = items.item(i).getAttributes().getNamedItem(BINDING_NAME)) != null) {
                        bindingName = node.getNodeValue();
                    }
                    if (name != null && bindingName != null) {
                        result.put(name, bindingName);
                    }
                }
                ++i;
            }
            Map<String, String> map = Collections.unmodifiableMap(result);
            return map;
        }
        finally {
            model.releaseFromRead();
        }
    }

    protected boolean removeRefBinding(String beanName, String refType, String refName) throws CoreException {
        if (!this.getFile().exists()) {
            return false;
        }
        IDOMModel model = this.getModelForEdit();
        try {
            Element beanElement = this.getBeanElement(model.getDocument().getDocumentElement(), beanName);
            if (beanElement == null) {
                return false;
            }
            Element refElement = this.getRefElement(beanElement, refType, refName);
            if (refElement == null) {
                return false;
            }
            Node parentNode = refElement.getParentNode();
            parentNode.removeChild(refElement);
            if (model.isSaveNeeded()) {
                model.save();
            }
            return true;
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error saving file {0}", this.getFile());
            Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
            BundleActivator.getDefault().getLog().log((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        finally {
            model.releaseFromEdit();
        }
    }

    protected String getRefBindingName(String beanName, String refType, String refName) throws CoreException {
        return this.getRefBindings(beanName, refType).get(refName);
    }

    protected Element getBeanElement(Element parent, String beanName) throws CoreException {
        Element beanElement = this.getElement(parent, "pre:session[@name=\"" + beanName + "\"]");
        if (beanElement == null) {
            beanElement = this.getElement(parent, "pre:message-driven[@name=\"" + beanName + "\"]");
        }
        return beanElement;
    }

    protected Element getRefElement(Element parent, String refType, String refName) throws CoreException {
        return this.getElement(parent, "pre:" + refType + "[@name=\"" + refName + "\"]");
    }

    protected Element getAuthenticationAliasElement(Element refElement) throws CoreException {
        return this.getElement(refElement, "pre:authentication-alias");
    }

    protected void setRefBinding(String beanType, String beanName, String refType, String refName, String bindingName) throws CoreException {
        if (!this.getFile().exists()) {
            this.createDescriptor();
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                Element ref;
                boolean created = false;
                IDOMDocument document = model.getDocument();
                Element beanElement = this.getElement(document.getDocumentElement(), "pre:" + beanType + "[@name=\"" + beanName + "\"]");
                if (beanElement == null) {
                    created = true;
                    beanElement = this.createBeanElement(document, beanType, beanName);
                }
                if ((ref = this.getElement(beanElement, "pre:" + refType + "[@name=\"" + refName + "\"]")) == null) {
                    created = true;
                    ref = this.createRefElement(document, beanElement, refType, refName);
                    beanElement.appendChild(ref);
                }
                ref.setAttribute(BINDING_NAME, bindingName);
                if (created) {
                    this.format(beanElement);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                BundleActivator.getDefault().getLog().log((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }

    protected void setSessionAttribute(String beanName, String attribute, String value) throws CoreException {
        if (!this.getFile().exists()) {
            this.createDescriptor();
        }
        IDOMModel model = this.getModelForEdit();
        try {
            try {
                boolean created = false;
                IDOMDocument document = model.getDocument();
                Element beanElement = this.getElement(document.getDocumentElement(), "pre:session[@name=\"" + beanName + "\"]");
                if (beanElement == null) {
                    created = true;
                    beanElement = this.createBeanElement(document, SESSION, beanName);
                }
                if (attribute != null) {
                    beanElement.setAttribute(attribute, value);
                }
                if (created) {
                    this.format(beanElement);
                }
                if (model.isSaveNeeded()) {
                    model.save();
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Error saving file {0}", this.getFile());
                Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
                BundleActivator.getDefault().getLog().log((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            model.releaseFromEdit();
        }
    }

    protected boolean removeSessionAttribute(String beanName, String attribute) throws CoreException {
        if (!this.getFile().exists()) {
            return false;
        }
        IDOMModel model = this.getModelForEdit();
        try {
            Element beanElement = this.getBeanElement(model.getDocument().getDocumentElement(), beanName);
            if (beanElement == null) {
                return false;
            }
            beanElement.removeAttribute(attribute);
            if (model.isSaveNeeded()) {
                model.save();
            }
            return true;
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error saving file {0}", this.getFile());
            Status status = new Status(4, "com.ibm.jee.was.descriptors", msg, (Throwable)e);
            BundleActivator.getDefault().getLog().log((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        finally {
            model.releaseFromEdit();
        }
    }

    public void setSimpleBindingName(String beanName, String bindingName) throws CoreException {
        this.setSessionAttribute(beanName, SIMPLE_BINDING_NAME, bindingName);
    }

    public boolean removeSimpleBindingName(String beanName) throws CoreException {
        return this.removeSessionAttribute(beanName, SIMPLE_BINDING_NAME);
    }

    public void setComponentId(String beanName, String id) throws CoreException {
        this.setSessionAttribute(beanName, COMPONENT_ID, id);
    }

    public boolean removeComponentId(String beanName) throws CoreException {
        return this.removeSessionAttribute(beanName, COMPONENT_ID);
    }

    public void setRemoteHomeBindingName(String beanName, String bindingName) throws CoreException {
        this.setSessionAttribute(beanName, REMOTE_HOME_BINDING_NAME, bindingName);
    }

    public boolean removeRemoteHomeBindingName(String beanName) throws CoreException {
        return this.removeSessionAttribute(beanName, REMOTE_HOME_BINDING_NAME);
    }

    public void setLocalHomeBindingName(String beanName, String bindingName) throws CoreException {
        this.setSessionAttribute(beanName, LOCAL_HOME_BINDING_NAME, bindingName);
    }

    public boolean removeLocalHomeBindingName(String beanName) throws CoreException {
        return this.removeSessionAttribute(beanName, LOCAL_HOME_BINDING_NAME);
    }

    protected Element createRefElement(IDOMDocument document, Element beanElement, String refType, String refName) {
        Element ref = document.createElement(refType);
        ref.setAttribute(NAME, refName);
        return ref;
    }

    protected Element createBeanElement(IDOMDocument document, String beanType, String beanName) {
        Element beanElement = document.createElement(beanType);
        beanElement.setAttribute(NAME, beanName);
        document.getDocumentElement().appendChild(beanElement);
        document.getDocumentElement().appendChild(document.createTextNode(System.getProperty("line.separator")));
        return beanElement;
    }

    public String getBindingName(String sessionName, String interfaceName) throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            IDOMDocument document = model.getDocument();
            Element element = this.getElement(document.getDocumentElement(), "pre:session[@name=\"" + sessionName + "\"]/pre:interface[@class=\"" + interfaceName + "\"]");
            if (element == null) {
                return null;
            }
            Node node = element.getAttributes().getNamedItem(BINDING_NAME);
            if (node == null) {
                return null;
            }
            String string = node.getNodeValue();
            return string;
        }
        finally {
            model.releaseFromRead();
        }
    }

    public String getSimpleBindingName(String sessionName) throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            IDOMDocument document = model.getDocument();
            NodeList list = this.getAllElements(document.getDocumentElement(), "pre:session[@name=\"" + sessionName + "\"]");
            int i = 0;
            while (i < list.getLength()) {
                Element element = (Element)list.item(i);
                Node node = element.getAttributes().getNamedItem(SIMPLE_BINDING_NAME);
                if (node != null) {
                    String string = node.getNodeValue();
                    return string;
                }
                ++i;
            }
            return null;
        }
        finally {
            model.releaseFromRead();
        }
    }

    public String getComponentId(String sessionName) throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            IDOMDocument document = model.getDocument();
            NodeList list = this.getAllElements(document.getDocumentElement(), "pre:session[@name=\"" + sessionName + "\"]");
            int i = 0;
            while (i < list.getLength()) {
                Element element = (Element)list.item(i);
                Node node = element.getAttributes().getNamedItem(COMPONENT_ID);
                if (node != null) {
                    String string = node.getNodeValue();
                    return string;
                }
                ++i;
            }
            return null;
        }
        finally {
            model.releaseFromRead();
        }
    }

    @Deprecated
    public String getLocalHomeBindingName(String sessionName, String interfaceName) throws CoreException {
        return this.getLocalHomeBindingName(sessionName);
    }

    public String getLocalHomeBindingName(String sessionName) throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            IDOMDocument document = model.getDocument();
            NodeList list = this.getAllElements(document.getDocumentElement(), "pre:session[@name=\"" + sessionName + "\"]");
            int i = 0;
            while (i < list.getLength()) {
                Element element = (Element)list.item(i);
                Node node = element.getAttributes().getNamedItem(LOCAL_HOME_BINDING_NAME);
                if (node != null) {
                    String string = node.getNodeValue();
                    return string;
                }
                ++i;
            }
            return null;
        }
        finally {
            model.releaseFromRead();
        }
    }

    @Deprecated
    public String getRemoteHomeBindingName(String sessionName, String interfaceName) throws CoreException {
        return this.getRemoteHomeBindingName(sessionName);
    }

    public String getRemoteHomeBindingName(String sessionName) throws CoreException {
        if (!this.getFile().exists()) {
            return null;
        }
        IDOMModel model = this.getModelForRead();
        try {
            IDOMDocument document = model.getDocument();
            NodeList list = this.getAllElements(document.getDocumentElement(), "pre:session[@name=\"" + sessionName + "\"]");
            int i = 0;
            while (i < list.getLength()) {
                Element element = (Element)list.item(i);
                Node node = element.getAttributes().getNamedItem(REMOTE_HOME_BINDING_NAME);
                if (node != null) {
                    String string = node.getNodeValue();
                    return string;
                }
                ++i;
            }
            return null;
        }
        finally {
            model.releaseFromRead();
        }
    }

    public boolean isSessionBeanBound(String sessionName) throws CoreException {
        if (!this.getFile().exists()) {
            return false;
        }
        IDOMModel model = this.getModelForRead();
        try {
            IDOMDocument document = model.getDocument();
            NodeList list = this.getAllElements(document.getDocumentElement(), "pre:session[@name=\"" + sessionName + "\"]");
            boolean bl = list.getLength() > 0;
            return bl;
        }
        finally {
            model.releaseFromRead();
        }
    }

    public void createSessionBeanBinding(String beanName) throws CoreException {
        this.setSessionAttribute(beanName, null, null);
    }
}

