/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.was.descriptors;

import com.ibm.jee.was.internal.descriptors.BundleActivator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Descriptor {
    public static final String LIBERTY_RUNTIME_ID = "com.ibm.ws.st.runtime";
    public static final String WAS_RUNTIME_ID = "com.ibm.ws.ast.st.runtime";
    private final IFile _descriptorFile;
    private String _dataPath = "data/";

    public void setDataPath(String _dataPath) {
        this._dataPath = _dataPath;
    }

    public Descriptor(IProject project, String uri) {
        IContainer contentFolder = this.getContentFolder(project);
        if (contentFolder == null) {
            throw new IllegalArgumentException(project.toString());
        }
        this._descriptorFile = contentFolder.getFile((IPath)new Path(uri));
    }

    public void createDescriptor() throws CoreException {
        try (BufferedInputStream stream = new BufferedInputStream(BundleActivator.getDefault().getBundle().getEntry(String.valueOf(this._dataPath) + this.getFile().getName()).openStream());){
            this.ensureParentExists((IResource)this.getFile());
            this.getFile().create((InputStream)stream, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            Status status = new Status(4, "com.ibm.jee.was.descriptors", "Unable to  create file " + this.getFile(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected void ensureParentExists(IResource resource) throws CoreException {
        IContainer parent = resource.getParent();
        if (!parent.exists()) {
            this.ensureParentExists((IResource)parent);
            ((IFolder)parent).create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public final IFile getFile() {
        return this._descriptorFile;
    }

    protected IDOMModel getModelForRead() throws CoreException {
        try {
            IModelManager manager = StructuredModelManager.getModelManager();
            IDOMModel model = (IDOMModel)manager.getModelForRead(this.getFile());
            return model;
        }
        catch (IOException e) {
            Status status = new Status(4, "com.ibm.jee.was.descriptors", "Error reading file" + this.getFile(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected IDOMModel getModelForEdit() throws CoreException {
        try {
            IModelManager manager = StructuredModelManager.getModelManager();
            IDOMModel model = (IDOMModel)manager.getModelForEdit(this.getFile());
            return model;
        }
        catch (IOException e) {
            Status status = new Status(4, "com.ibm.jee.was.descriptors", "Error reading file" + this.getFile(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected IContainer getContentFolder(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component.getRootFolder() == null) {
            return null;
        }
        return component.getRootFolder().getUnderlyingFolder();
    }

    protected void format(Node node) {
        try {
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode(node);
        }
        catch (Exception exception) {}
    }

    protected Element getElement(Element root, String expression) throws CoreException {
        NodeList list;
        block3: {
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                xpath.setNamespaceContext(new WebSphereNamespaceContext());
                list = (NodeList)xpath.evaluate(expression, root, XPathConstants.NODESET);
                if (list.getLength() != 0) break block3;
                return null;
            }
            catch (XPathExpressionException e) {
                Status status = new Status(4, "com.ibm.jee.was.descriptors", "Internal Error constructiong XPATH from " + expression + " for " + this.getFile(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        return (Element)list.item(0);
    }

    protected NodeList getAllElements(Element root, String expression) throws CoreException {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new WebSphereNamespaceContext());
            NodeList list = (NodeList)xpath.evaluate(expression, root, XPathConstants.NODESET);
            return list;
        }
        catch (XPathExpressionException e) {
            Status status = new Status(4, "com.ibm.jee.was.descriptors", "Internal Error constructiong XPATH from " + expression + " for " + this.getFile(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected static boolean isWASv80OrLaterRuntime(IRuntime runtime) {
        int nextDigit;
        String remainder;
        char nextChar;
        String runtimeTypeId;
        IRuntimeType runtimeType;
        boolean retVal = false;
        if (runtime != null && (runtimeType = runtime.getRuntimeType()) != null && (runtimeTypeId = runtimeType.getId()).startsWith(WAS_RUNTIME_ID) && !(retVal = runtimeTypeId.startsWith("com.ibm.ws.ast.st.runtime.v8")) && Character.isDigit(nextChar = (remainder = runtimeTypeId.substring(WAS_RUNTIME_ID.length() + 2)).charAt(0)) && ((nextDigit = Character.getNumericValue(nextChar)) >= 8 || nextDigit < 4)) {
            retVal = true;
        }
        return retVal;
    }

    protected static final class WebSphereNamespaceContext
    implements NamespaceContext {
        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException();
            }
            if ("pre".equals(prefix)) {
                return "http://websphere.ibm.com/xml/ns/javaee";
            }
            return "";
        }
    }
}

