/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.ui.pages.template;

import com.ibm.faceted.project.wizard.core.datamodel.wtpextensions.FacetedProjectWizardWorkingCopy;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.internal.management.ProjectConfigurationManager;
import com.ibm.faceted.project.wizard.internal.nls.Messages;
import com.ibm.faceted.project.wizard.internal.ui.pages.AbstractWebWizardDataModelWizardPage;
import com.ibm.faceted.project.wizard.internal.ui.pages.template.ProjectTemplateUiManager;
import com.ibm.faceted.project.wizard.internal.ui.pages.template.TemplateContentProvider;
import com.ibm.faceted.project.wizard.internal.ui.pages.template.TemplateLabelProvider;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizard;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;

public class TemplateSelectionPage
extends AbstractWebWizardDataModelWizardPage
implements ISelectionChangedListener,
SelectionListener {
    private TemplateContentProvider templateContentProvider;
    private TableViewer templateTableViewer;
    private Text projectNameText;
    private FacetedProjectWizard wizard;
    private ProjectTemplateUiManager uiManager;
    private Composite stackComposite;
    private StackLayout stackLayout;
    private Label nameLabel;
    private ProjectConfigurationManager projectConfigurationManager;
    private static final String TEMPLATE_SELECTION_PAGE_HELP = "com.ibm.adapter.j2c.codegen.templateSelectionPageHelp";

    public TemplateSelectionPage(IDataModel model, String pageName, IFacetedProjectWorkingCopy projectFacetWorkingCopy) {
        super(model, pageName, projectFacetWorkingCopy);
    }

    private void createNameControls(Composite baseComposite) {
        this.templateContentProvider = new TemplateContentProvider(this.wizard);
        this.nameLabel = new Label(baseComposite, 0);
        this.nameLabel.setText(Messages.TemplateSelectionPage_ProjectName);
        this.projectNameText = new Text(baseComposite, 2048);
        GridData gData = new GridData(768);
        this.projectNameText.setLayoutData((Object)gData);
        this.synchHelper.synchText(this.projectNameText, "IFacetDataModelProperties.FACET_PROJECT_NAME", null);
    }

    private void createTemplateControls(Composite baseComposite) {
        Label templateLabel = new Label(baseComposite, 0);
        GridData gData = new GridData(4);
        gData.horizontalSpan = 2;
        gData.verticalIndent = 10;
        templateLabel.setLayoutData((Object)gData);
        templateLabel.setText(Messages.TemplateSelectionPage_ProjectTemplates);
        SashForm templateComposite = new SashForm(baseComposite, 256);
        gData = new GridData(1808);
        gData.horizontalSpan = 2;
        gData.horizontalIndent = this.nameLabel.computeSize((int)-1, (int)-1).x + 5;
        gData.widthHint = 550;
        gData.heightHint = 380;
        templateComposite.setLayoutData((Object)gData);
        GridLayout templatesLayout = new GridLayout(2, false);
        templatesLayout.marginHeight = 0;
        templatesLayout.marginWidth = 0;
        templateComposite.setLayout((Layout)templatesLayout);
        this.templateTableViewer = new TableViewer(new Table((Composite)templateComposite, 67584));
        TableColumn tc1 = new TableColumn(this.templateTableViewer.getTable(), 0);
        tc1.setResizable(true);
        gData = new GridData(1040);
        gData.widthHint = 200;
        this.templateTableViewer.getControl().setLayoutData((Object)gData);
        this.templateTableViewer.setContentProvider((IContentProvider)this.templateContentProvider);
        this.templateTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider(this.wizard));
        this.templateTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.templateTableViewer.setInput((Object)this.projectFacetWorkingCopy);
        this.templateTableViewer.refresh();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.templateTableViewer.getTable().setLayout((Layout)tlayout);
        this.stackComposite = new Composite((Composite)templateComposite, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.stackComposite.setLayout((Layout)this.stackLayout);
        gData = new GridData(1808);
        gData.horizontalIndent = 0;
        gData.verticalIndent = 0;
        this.stackComposite.setLayoutData((Object)gData);
        templateComposite.setWeights(new int[]{35, 65});
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.wizard = (FacetedProjectWizard)this.getWizard();
        this.uiManager = new ProjectTemplateUiManager(this.wizard, this);
        this.setTitle(this.wizard.getTemplateSelectionPageTitle());
        this.setDescription(this.wizard.getTemplateSelectionPageDescription());
        this.projectConfigurationManager = ProjectConfigurationManager.getInstance(this.wizard);
        Composite baseComposite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)baseComposite, TEMPLATE_SELECTION_PAGE_HELP);
        baseComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(1808);
        baseComposite.setLayoutData((Object)gData);
        this.createNameControls(baseComposite);
        this.createTemplateControls(baseComposite);
        this.projectNameText.setFocus();
        this.setImageDescriptor(this.wizard.getWizardBannerImageDescriptor());
        return baseComposite;
    }

    public void dispose() {
        super.dispose();
        this.templateContentProvider.dispose();
    }

    protected void enter() {
        FacetedProjectWizardWorkingCopy enhancedWorkingCopy = (FacetedProjectWizardWorkingCopy)this.projectFacetWorkingCopy;
        enhancedWorkingCopy.setCalculateAvailableFacetsLazyMode(true);
        if (this.isFirstTimeToPage()) {
            Shell shell = this.getShell();
            if (shell != null) {
                Composite shellParent = shell.getParent();
                Point currentWizardSize = new Point(600, 600);
                if (shellParent != null) {
                    Point parentLocation = shellParent.getLocation();
                    Point parentSize = shellParent.getSize();
                    if (parentLocation != null && parentSize != null) {
                        Point location = new Point(parentLocation.x + (parentSize.x - currentWizardSize.x) / 2, parentLocation.y + (parentSize.y - currentWizardSize.y) / 2);
                        shell.setLocation(location);
                    }
                }
                shell.setSize(currentWizardSize);
            }
            this.wizard.refreshConfigurationDelegatesValidation();
        }
        super.enter();
    }

    protected void exit() {
        FacetedProjectWizardWorkingCopy enhancedWorkingCopy = (FacetedProjectWizardWorkingCopy)this.projectFacetWorkingCopy;
        enhancedWorkingCopy.getAvailableFacets();
        enhancedWorkingCopy.setCalculateAvailableFacetsLazyMode(false);
        super.exit();
    }

    @Override
    public String[] getValidationPropertyNames() {
        return new String[]{"IFacetDataModelProperties.FACET_PROJECT_NAME"};
    }

    public void initializeFirstSelection() {
        IProjectTemplate projectTemplate = this.projectConfigurationManager.getProjectTemplate();
        if (projectTemplate != null) {
            this.templateTableViewer.setSelection((ISelection)new StructuredSelection((Object)projectTemplate));
        } else {
            this.templateTableViewer.setSelection((ISelection)new StructuredSelection(this.templateTableViewer.getElementAt(0)));
            IStructuredSelection selection = (IStructuredSelection)this.templateTableViewer.getSelection();
            if (!selection.isEmpty()) {
                projectTemplate = (IProjectTemplate)selection.getFirstElement();
            }
        }
        this.wizard.changeProjectTemplate(projectTemplate);
        this.updateTemplateUI(projectTemplate, this.projectConfigurationManager.getCoreFacetSet());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IProjectTemplate oldTemplate;
        IProjectTemplate newTemplate;
        IStructuredSelection selection = (IStructuredSelection)this.templateTableViewer.getSelection();
        if (!selection.isEmpty() && !(newTemplate = (IProjectTemplate)selection.getFirstElement()).equals(oldTemplate = this.projectConfigurationManager.getProjectTemplate())) {
            this.wizard.changeProjectTemplate(newTemplate);
            this.updateTemplateUI(newTemplate, this.projectConfigurationManager.getCoreFacetSet());
        }
    }

    private void updateTemplateUI(IProjectTemplate newTemplate, ICoreFacetSet newModel) {
        Composite currentTemplateComposite = this.uiManager.switchProjectTemplate(this.stackComposite, newTemplate, newModel);
        this.stackLayout.topControl = currentTemplateComposite;
        this.stackComposite.getParent().layout(true, true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.wizard.changeCoreFacetSet(this.uiManager.getCoreFacetSet((Button)e.widget));
    }
}

