/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.ui.categorylist;

import com.ibm.faceted.project.wizard.internal.ui.categorylist.DefaultCategorizedElementFormatProvider;
import com.ibm.faceted.project.wizard.internal.ui.categorylist.ICategorizedElementFormatProvider;
import com.ibm.faceted.project.wizard.internal.ui.categorylist.ICategorizedFilterProvider;
import com.ibm.faceted.project.wizard.internal.ui.categorylist.ICategorizedSelectorProvider;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class StyledCategorizedListViewer
extends Composite
implements MouseListener,
KeyListener,
FocusListener,
ISelectionProvider {
    public static final int SHOW_CATEGORIES_ALWAYS = 0x10000000;
    public static final int SHOW_CATEGORIES_NEVER = 0x20000000;
    public static final int SHOW_CATEGORIES_IF_NEEDED = 0x40000000;
    public int showCategoryItems = 0x10000000;
    private Object input;
    protected Vector<CLabel> visualElements;
    protected Vector<Object> modelElements;
    protected Vector<Object> selectedElements = new Vector();
    private LabelProvider labelProvider;
    private ICategorizedElementFormatProvider formatProvider;
    private IStructuredContentProvider contentProvider;
    private ICategorizedSelectorProvider selectorProvider;
    private ICategorizedFilterProvider filterProvider;
    private DefaultCategorizedElementFormatProvider defaultFormatProvider;
    private ListenerList selectionChangedListeners = new ListenerList();
    private final Composite mainComposite;
    private final ScrolledComposite scrollComposite;

    public StyledCategorizedListViewer(Composite parent, int style) {
        super(parent, style | 4);
        if ((style & 0x10000000) != 0) {
            this.showCategoryItems = 0x10000000;
        } else if ((style & 0x20000000) != 0) {
            this.showCategoryItems = 0x20000000;
        } else if ((style & 0x40000000) != 0) {
            this.showCategoryItems = 0x40000000;
        }
        this.setLayout((Layout)new FillLayout());
        this.scrollComposite = new ScrolledComposite((Composite)this, 512);
        this.mainComposite = new Composite((Composite)this.scrollComposite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
        this.mainComposite.setBackground(parent.getDisplay().getSystemColor(25));
        this.mainComposite.addKeyListener((KeyListener)this);
        this.mainComposite.addFocusListener((FocusListener)this);
        this.mainComposite.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        e.doit = true;
                    }
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StyledCategorizedListViewer.this.widgetDisposed(e);
            }
        });
        this.defaultFormatProvider = new DefaultCategorizedElementFormatProvider();
        this.setFormatProvider(this.defaultFormatProvider);
        this.scrollComposite.setContent((Control)this.mainComposite);
        this.scrollComposite.setExpandHorizontal(true);
        this.scrollComposite.setExpandVertical(true);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    private void applySelectedAndFocusedStyle(CLabel visualElement, Object modelElement) {
        if (this.formatProvider != null) {
            visualElement.setBackground(new Color[]{this.formatProvider.getSelectedAndFocusedFirstBackgroundColor(modelElement), this.formatProvider.getSelectedAndFocusedSecondBackgroundColor(modelElement)}, new int[]{100}, this.formatProvider.useVerticalGradientForSelectedBackground(modelElement));
            visualElement.setForeground(this.formatProvider.getSelectedAndFocusedForegroundColor(modelElement));
        }
    }

    private void applySelectedAndUnfocusedStyle(CLabel visualElement, Object modelElement) {
        if (this.formatProvider != null) {
            visualElement.setBackground(new Color[]{this.formatProvider.getSelectedAndUnfocusedFirstBackgroundColor(modelElement), this.formatProvider.getSelectedAndUnfocusedSecondBackgroundColor(modelElement)}, new int[]{100}, this.formatProvider.useVerticalGradientForSelectedBackground(modelElement));
            visualElement.setForeground(this.formatProvider.getSelectedAndUnfocusedForegroundColor(modelElement));
        }
    }

    private void applyStandardStyle(CLabel visualElement, Object modelElement) {
        if (this.formatProvider != null) {
            visualElement.setBackground(new Color[]{this.formatProvider.getStandardFirstBackgroundColor(modelElement), this.formatProvider.getStandardSecondBackgroundColor(modelElement)}, new int[]{100}, this.formatProvider.useVerticalGradientForStandardBackground(modelElement));
            visualElement.setForeground(this.formatProvider.getStandardForegroundColor(modelElement));
        }
    }

    public void clearListContents() {
        if (this.visualElements != null) {
            this.clearSelection();
            for (Widget widget : this.visualElements) {
                widget.dispose();
                Object var1_2 = null;
            }
            this.visualElements.clear();
            this.modelElements.clear();
        }
    }

    private void clearSelection() {
        if (this.selectedElements == null || this.selectedElements.size() == 0) {
            return;
        }
        for (Object selectedElement : this.selectedElements) {
            this.deselectVisualElement(selectedElement);
        }
        this.selectedElements.clear();
    }

    private int countNonSelectableDrawableItems(Object[] elements) {
        int drawableItems = 0;
        if (this.selectorProvider != null) {
            int i = 0;
            while (i < elements.length) {
                if (!this.selectorProvider.isSelectable(elements[i]) && (this.filterProvider == null || this.filterProvider.isIncluded(elements[i]))) {
                    ++drawableItems;
                }
                ++i;
            }
        }
        return drawableItems;
    }

    private void deselectVisualElement(Object modelElementToDeselect) {
        if (modelElementToDeselect == null) {
            return;
        }
        int index = this.modelElements.indexOf(modelElementToDeselect);
        if (index == -1) {
            return;
        }
        CLabel visualElement = this.visualElements.get(index);
        this.applyStandardStyle(visualElement, modelElementToDeselect);
    }

    private void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void focusGained(FocusEvent arg0) {
        for (Object selectedElement : this.selectedElements) {
            if (selectedElement == null) continue;
            int index = this.modelElements.indexOf(selectedElement);
            CLabel visualElement = this.visualElements.get(index);
            this.applySelectedAndFocusedStyle(visualElement, selectedElement);
        }
    }

    public void focusLost(FocusEvent arg0) {
        for (Object selectedElement : this.selectedElements) {
            if (selectedElement == null) continue;
            int index = this.modelElements.indexOf(selectedElement);
            CLabel visualElement = this.visualElements.get(index);
            this.applySelectedAndUnfocusedStyle(visualElement, selectedElement);
        }
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public ICategorizedFilterProvider getFilterProvider() {
        return this.filterProvider;
    }

    private Object getFirstSelectableElement() {
        if (this.modelElements == null || this.modelElements.isEmpty() || this.selectorProvider == null) {
            return null;
        }
        for (Object nextItem : this.modelElements) {
            if (!this.selectorProvider.isSelectable(nextItem)) continue;
            return nextItem;
        }
        return null;
    }

    public ICategorizedElementFormatProvider getFormatProvider() {
        return this.formatProvider;
    }

    public Object getInput() {
        return this.input;
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    private Object getLastSelectableElement() {
        if (this.modelElements == null || this.modelElements.isEmpty() || this.selectorProvider == null) {
            return null;
        }
        int i = this.modelElements.size() - 1;
        while (i >= 0) {
            Object nextItem = this.modelElements.get(i);
            if (this.selectorProvider.isSelectable(nextItem)) {
                return nextItem;
            }
            --i;
        }
        return null;
    }

    private Object getNextSelectableElement(Object currentElement) {
        if (this.modelElements == null || this.modelElements.isEmpty() || this.selectorProvider == null) {
            return null;
        }
        int index = this.modelElements.indexOf(currentElement);
        if (index == -1) {
            return this.getFirstSelectableElement();
        }
        ++index;
        while (index < this.modelElements.size()) {
            Object next = this.modelElements.get(index);
            if (this.selectorProvider.isSelectable(next)) {
                return next;
            }
            ++index;
        }
        return null;
    }

    private Object getPreviousSelectableElement(Object currentElement) {
        if (this.modelElements == null || this.modelElements.isEmpty() || this.selectorProvider == null) {
            return null;
        }
        int index = this.modelElements.indexOf(currentElement);
        if (index == -1) {
            return this.getLastSelectableElement();
        }
        --index;
        while (index >= 0) {
            Object previous = this.modelElements.get(index);
            if (this.selectorProvider.isSelectable(previous)) {
                return previous;
            }
            --index;
        }
        return null;
    }

    public ISelection getSelection() {
        if (this.selectedElements == null || this.selectedElements.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(Arrays.asList(this.selectedElements.toArray()), null);
    }

    public ICategorizedSelectorProvider getSelectorProvider() {
        return this.selectorProvider;
    }

    public void keyPressed(KeyEvent e) {
        if (this.modelElements == null || this.modelElements.isEmpty()) {
            return;
        }
        Object nextItemToSelect = null;
        switch (e.keyCode) {
            case 0x1000007: {
                nextItemToSelect = this.getFirstSelectableElement();
                break;
            }
            case 0x1000008: {
                nextItemToSelect = this.getLastSelectableElement();
                break;
            }
            case 0x1000002: 
            case 0x1000006: {
                Object firstSelectedItem = ((StructuredSelection)this.getSelection()).getFirstElement();
                if (firstSelectedItem == null) {
                    nextItemToSelect = this.getFirstSelectableElement();
                    break;
                }
                nextItemToSelect = this.getNextSelectableElement(firstSelectedItem);
                break;
            }
            case 0x1000001: 
            case 0x1000005: {
                Object firstSelectedItem = ((StructuredSelection)this.getSelection()).getFirstElement();
                nextItemToSelect = firstSelectedItem == null ? this.getLastSelectableElement() : this.getPreviousSelectableElement(firstSelectedItem);
            }
        }
        if (nextItemToSelect != null) {
            this.clearSelection();
            CLabel selectedVisualElement = this.selectVisualElement(nextItemToSelect, true);
            this.reveal(selectedVisualElement);
            this.selectedElements.add(nextItemToSelect);
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.mainComposite.setFocus();
        CLabel currentVisualElement = (CLabel)e.getSource();
        int index = this.visualElements.indexOf(currentVisualElement);
        if (index == -1) {
            return;
        }
        this.clearSelection();
        Object element = this.modelElements.elementAt(index);
        CLabel selectedVisualElement = this.selectVisualElement(element, true);
        this.reveal(selectedVisualElement);
        this.selectedElements.add(element);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public void mouseUp(MouseEvent e) {
    }

    public void refresh() {
        this.clearSelection();
        this.clearListContents();
        if (this.contentProvider == null) {
            return;
        }
        Object[] elements = this.contentProvider.getElements(this.input);
        if (elements != null) {
            int drawableItems;
            boolean drawNonSelectableItems = true;
            if (this.showCategoryItems == 0x20000000) {
                drawNonSelectableItems = false;
            } else if (this.showCategoryItems == 0x40000000 && (drawableItems = this.countNonSelectableDrawableItems(elements)) <= 1) {
                drawNonSelectableItems = false;
            }
            if (this.selectorProvider == null && !drawNonSelectableItems) {
                return;
            }
            this.modelElements = new Vector();
            this.visualElements = new Vector();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object modelElement = objectArray[n2];
                if ((this.filterProvider == null || this.filterProvider.isIncluded(modelElement)) && (this.selectorProvider == null || this.selectorProvider.isSelectable(modelElement) || drawNonSelectableItems)) {
                    this.modelElements.add(modelElement);
                    CLabel label = null;
                    if (this.selectorProvider != null && this.selectorProvider.isSelectable(modelElement)) {
                        label = new CLabel(this.mainComposite, 0);
                        label.addMouseListener((MouseListener)this);
                    } else {
                        label = new CLabel(this.mainComposite, 8);
                    }
                    if (this.labelProvider != null) {
                        label.setImage(this.labelProvider.getImage(modelElement));
                        label.setText(this.labelProvider.getText(modelElement));
                    } else {
                        label.setText(modelElement.toString());
                    }
                    this.applyStandardStyle(label, modelElement);
                    if (this.formatProvider != null) {
                        label.setFont(this.formatProvider.getFont(modelElement));
                    }
                    GridData gridData = new GridData();
                    gridData.horizontalAlignment = 4;
                    gridData.grabExcessHorizontalSpace = true;
                    label.setLayoutData((Object)gridData);
                    label.setLeftMargin(10);
                    this.visualElements.add(label);
                }
                ++n2;
            }
            Point minSize = this.computeSize(-1, -1);
            this.scrollComposite.setMinSize(minSize.x, minSize.y);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    private void reveal(CLabel visualElement) {
        Rectangle containerBounds = visualElement.getParent().getBounds();
        Rectangle elementBounds = visualElement.getBounds();
        if (containerBounds.y + elementBounds.y < 0) {
            this.scrollComposite.setOrigin(containerBounds.x, elementBounds.y);
        } else {
            Rectangle scrollAreaBounds = this.scrollComposite.getBounds();
            int exceededPixels = containerBounds.y + elementBounds.y + elementBounds.height - (scrollAreaBounds.y + scrollAreaBounds.height);
            if (exceededPixels > 0) {
                this.scrollComposite.setOrigin(scrollAreaBounds.x, -containerBounds.y + exceededPixels);
            }
        }
    }

    public void selectFirstSelectableItem() {
        Object firstItem = this.getFirstSelectableElement();
        if (firstItem != null) {
            this.clearSelection();
            CLabel selectedVisualElement = this.selectVisualElement(firstItem, false);
            this.reveal(selectedVisualElement);
            this.selectedElements.add(firstItem);
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    private CLabel selectVisualElement(Object modelElementToSelect, boolean hasFocus) {
        if (modelElementToSelect == null) {
            return null;
        }
        int index = this.modelElements.indexOf(modelElementToSelect);
        if (index == -1) {
            return null;
        }
        CLabel visualElement = this.visualElements.get(index);
        if (hasFocus) {
            this.applySelectedAndFocusedStyle(visualElement, modelElementToSelect);
        } else {
            this.applySelectedAndUnfocusedStyle(visualElement, modelElementToSelect);
        }
        return visualElement;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setFilterProvider(ICategorizedFilterProvider filterProvider) {
        this.filterProvider = filterProvider;
    }

    public void setFormatProvider(ICategorizedElementFormatProvider formatProvider) {
        this.formatProvider = formatProvider;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setSelection(ISelection selection) {
        this.clearSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        StructuredSelection sel = (StructuredSelection)selection;
        boolean firstElementSelected = false;
        for (Object modelElementToSelect : sel) {
            if (modelElementToSelect == null) continue;
            CLabel selectedElement = this.selectVisualElement(modelElementToSelect, false);
            if (!firstElementSelected) {
                this.reveal(selectedElement);
                firstElementSelected = true;
            }
            this.selectedElements.add(modelElementToSelect);
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)sel));
    }

    public void setSelectorProvider(ICategorizedSelectorProvider selectorProvider) {
        this.selectorProvider = selectorProvider;
        this.defaultFormatProvider.setSelectorProvider(selectorProvider);
    }

    void widgetDisposed(DisposeEvent e) {
        this.clearListContents();
        this.clearSelection();
        this.selectionChangedListeners.clear();
        this.selectionChangedListeners = null;
        this.visualElements = null;
        this.modelElements = null;
        this.selectedElements = null;
        this.formatProvider.dispose();
        if (this.formatProvider != this.defaultFormatProvider) {
            this.defaultFormatProvider.dispose();
        }
        this.formatProvider = null;
        this.defaultFormatProvider = null;
    }
}

