/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.propertytester;

import com.ibm.faceted.project.wizard.internal.management.ProjectConfigurationManager;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizard;
import org.eclipse.core.expressions.PropertyTester;

public class NewProjectPropertyTester
extends PropertyTester {
    private static final String SELECTED_PROGRAMMING_MODEL = "selectedProgrammingModel";
    private static final String SELECTED_PROJECT_TEMPLATE = "selectedProjectTemplate";
    private static final String HAS_FACET = "hasFacet";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof FacetedProjectWizard) {
            FacetedProjectWizard wizard = (FacetedProjectWizard)receiver;
            if (expectedValue != null) {
                if (property.equals(HAS_FACET)) {
                    String facetId = (String)expectedValue;
                    String facetVersionExpress = null;
                    String[] pieces = facetId.split(":");
                    if (pieces.length == 2) {
                        facetId = pieces[0];
                        facetVersionExpress = pieces[1];
                    }
                    return ProjectConfigurationManager.getInstance(wizard).isFacetSet(facetId, facetVersionExpress);
                }
                if (property.equals(SELECTED_PROJECT_TEMPLATE)) {
                    return expectedValue.equals(ProjectConfigurationManager.getInstance(wizard).getProjectTemplate().getId());
                }
                if (property.equals(SELECTED_PROGRAMMING_MODEL)) {
                    return expectedValue.equals(ProjectConfigurationManager.getInstance(wizard).getCoreFacetSet().getId());
                }
            }
        }
        return false;
    }
}

