/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.management;

import com.ibm.faceted.project.wizard.ui.IImageManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class WizardImageManager
implements IImageManager {
    private static final String SLASH = "/";
    private static final String PLUGIN_PREFIX = "platform:/plugin/";
    private Map<String, Image> cachedImages = new HashMap<String, Image>();

    public synchronized void dispose() {
        if (this.cachedImages != null) {
            for (Image image : this.cachedImages.values()) {
                image.dispose();
            }
            this.cachedImages = null;
        }
    }

    @Override
    public synchronized Image getImage(String pluginId, String imagePath) throws MalformedURLException {
        if (pluginId == null || imagePath == null || pluginId.isEmpty() || imagePath.isEmpty()) {
            return null;
        }
        boolean isRelative = !imagePath.startsWith(PLUGIN_PREFIX);
        String relativePath = imagePath;
        String actualPluginId = pluginId;
        if (!isRelative) {
            relativePath = relativePath.substring(PLUGIN_PREFIX.length()).trim();
            String[] parts = relativePath.split(SLASH);
            actualPluginId = parts[0];
            relativePath = relativePath.substring(actualPluginId.length());
        }
        relativePath = relativePath.startsWith(SLASH) ? relativePath : SLASH + relativePath;
        String actualImagePath = PLUGIN_PREFIX + actualPluginId + relativePath;
        Image image = this.cachedImages.get(actualImagePath);
        if (image == null) {
            URL url = new URL(actualImagePath);
            image = ImageDescriptor.createFromURL((URL)url).createImage();
            this.cachedImages.put(actualImagePath, image);
        }
        return image;
    }
}

