/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.management;

import com.ibm.faceted.project.wizard.contributions.template.AbstractProjectTemplateDelegate;
import com.ibm.faceted.project.wizard.core.management.FacetCompatiblityCalculator;
import com.ibm.faceted.project.wizard.core.management.FacetSetUtil;
import com.ibm.faceted.project.wizard.core.management.IExtensionPointManager;
import com.ibm.faceted.project.wizard.core.management.ProjectConfiguration;
import com.ibm.faceted.project.wizard.core.management.RuntimeComparator;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IFacetRange;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.core.serviceability.Debugger;
import com.ibm.faceted.project.wizard.core.serviceability.Logger;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceabilityManager;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceablilityUtil;
import com.ibm.faceted.project.wizard.core.serviceability.Tracer;
import com.ibm.faceted.project.wizard.internal.management.extensionpts.DelegateUtil;
import com.ibm.faceted.project.wizard.internal.nls.Messages;
import com.ibm.faceted.project.wizard.management.IProjectConfigurationManager;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class ProjectConfigurationManager
implements IProjectConfigurationManager {
    private ProjectConfiguration projectConfiguration;
    private IProjectTemplate currentProjectTemplate;
    private ICoreFacetSet currentProgrammingModel;
    private IDataModel dataModel;
    private IFacetedProjectWorkingCopy workingCopy;
    private volatile boolean initComplete = false;
    private static Map<FacetedProjectWizard, ProjectConfigurationManager> wizardToConfigurationManagerMap = new HashMap<FacetedProjectWizard, ProjectConfigurationManager>();
    private IExtensionPointManager wizardLevelExtPtMgr;
    private FacetedProjectWizard wizard;
    private AbstractProjectTemplateDelegate currentProjectTemplateDelegate;
    private Tracer tracer;
    private Logger logger;
    private Debugger debugger;

    private ProjectConfigurationManager(FacetedProjectWizard wizard) {
        this.wizard = wizard;
        this.projectConfiguration = new ProjectConfiguration();
        ServiceabilityManager serviceabilityManager = ServiceablilityUtil.getServiceabilityManager();
        this.tracer = serviceabilityManager.getTracer();
        this.logger = serviceabilityManager.getLogger();
        this.debugger = serviceabilityManager.getDebugger();
    }

    public static synchronized ProjectConfigurationManager getInstance(FacetedProjectWizard wizard) {
        ProjectConfigurationManager result = wizardToConfigurationManagerMap.get(wizard);
        if (result == null) {
            result = new ProjectConfigurationManager(wizard);
            wizardToConfigurationManagerMap.put(wizard, result);
        }
        return result;
    }

    @Override
    public synchronized IStatus addFacetVersion(IProjectFacetVersion facetVersion) {
        if (!this.initComplete) {
            String message = "Attempt to add facet was performed before " + this.getClass().getCanonicalName() + " was fully initialized.";
            return new Status(4, "com.ibm.adapter.j2c.codegen", message);
        }
        IStatus status = this.projectConfiguration.addFacetVersion(facetVersion, this.currentProjectTemplate, this.currentProgrammingModel);
        return status;
    }

    @Override
    public synchronized void applyFacetChangesToWorkingCopy(boolean programmingModelChanged) throws Exception {
        this.debugger.debug(Debugger.DebugType.CONFIGURATION, "Begin applyFacetChangesToWorkingCopy()");
        if (this.projectConfiguration.isDirty()) {
            if (!this.initComplete) {
                return;
            }
            try {
                String message;
                if (this.projectConfiguration.isFixedFacetsDirty()) {
                    this.workingCopy.setFixedProjectFacets(new HashSet());
                }
                if (this.projectConfiguration.isRuntimeDirty()) {
                    this.workingCopy.setTargetedRuntimes(Collections.emptySet());
                }
                if (this.projectConfiguration.isProjectFacetVersionsDirty()) {
                    this.workingCopy.setProjectFacets(this.projectConfiguration.getProjectFacetVersions());
                    if (programmingModelChanged) {
                        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                        map.clear();
                        Set<IProjectFacet> programmingModelFacets = this.buildProjectFacet(this.currentProgrammingModel.getFacets());
                        this.dataModel.setProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION", programmingModelFacets);
                    }
                    if (this.tracer.isEnabled()) {
                        message = "Project Facet Versions Updated: [";
                        for (IProjectFacetVersion projectFacetVersion : this.projectConfiguration.getProjectFacetVersions()) {
                            message = String.valueOf(message) + projectFacetVersion.getProjectFacet().getLabel() + " " + projectFacetVersion.getVersionString() + ", ";
                        }
                        message = String.valueOf(message.substring(0, message.length() - 2)) + "]";
                        this.tracer.trace(Tracer.TraceType.CONFIGURATION, message);
                    }
                }
                if (this.projectConfiguration.isFixedFacetsDirty()) {
                    this.workingCopy.setFixedProjectFacets(this.projectConfiguration.getFixedProjectFacets());
                    if (this.tracer.isEnabled()) {
                        message = "Fixed Facets Updated: [";
                        for (IProjectFacet fixedFacet : this.projectConfiguration.getFixedProjectFacets()) {
                            message = String.valueOf(message) + fixedFacet.getLabel() + ", ";
                        }
                        message = String.valueOf(message.substring(0, message.length() - 2)) + "]";
                        this.tracer.trace(Tracer.TraceType.CONFIGURATION, message);
                    }
                }
                if (this.projectConfiguration.isRuntimeDirty()) {
                    IRuntime runtime = this.projectConfiguration.getRuntime();
                    this.dataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
                    this.workingCopy.setTargetedRuntimes(runtime != null ? Collections.singleton(runtime) : Collections.emptySet());
                    this.tracer.trace(Tracer.TraceType.CONFIGURATION, runtime != null ? runtime.getLocalizedName() : "<NONE>");
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
            this.projectConfiguration.clean();
        }
        this.debugger.debug(Debugger.DebugType.CONFIGURATION, "End applyFacetChangesToWorkingCopy()");
    }

    private void applyProjectDefaultsToConfiguration(ProjectDefaults projectDefaults) {
        if (projectDefaults.changeRuntime) {
            this.projectConfiguration.setRuntime(projectDefaults.newRuntime);
        }
        this.projectConfiguration.setProjectFacetVersions(projectDefaults.newProjectFacetVersions, this.currentProjectTemplate, this.currentProgrammingModel);
    }

    private Set<IProjectFacet> buildProjectFacet(Set<IFacetRange> ... facetSets) {
        HashSet<IProjectFacet> result = new HashSet<IProjectFacet>();
        Set<IFacetRange>[] setArray = facetSets;
        int n = facetSets.length;
        int n2 = 0;
        while (n2 < n) {
            Set<IFacetRange> facetSet = setArray[n2];
            for (IFacetRange facet : facetSet) {
                IProjectFacet projectFacet = facet.getProjectFacet();
                if (result.contains(projectFacet)) continue;
                result.add(projectFacet);
            }
            ++n2;
        }
        return result;
    }

    private ProjectDefaults calculateProjectDefaults(IProjectTemplate projectTemplate, ICoreFacetSet programmingModel, Set<IProjectFacetVersion> oldProjectVersions, IRuntime defaultRuntime) throws CoreException {
        IRuntime[] applicableTargetRuntimes;
        FacetCompatiblityCalculator calculator;
        IRuntime[] targetedRuntimes;
        FacetCompatiblityCalculator calculator2;
        FacetCompatiblityCalculator calculator3;
        this.debugger.debug(Debugger.DebugType.CONFIGURATION, "Begin calculateProjectDefaults()");
        if (projectTemplate == null || programmingModel == null) {
            if (this.currentProjectTemplate == null) {
                Status status = new Status(4, "com.ibm.adapter.j2c.codegen", "Cannot calculate project defaults because project template was null.");
                throw new CoreException((IStatus)status);
            }
            if (this.currentProgrammingModel == null) {
                Status status = new Status(4, "com.ibm.adapter.j2c.codegen", "Cannot calculate project defaults because programming model was null.");
                throw new CoreException((IStatus)status);
            }
        }
        IRuntime newRuntime = null;
        boolean changeRuntime = false;
        ProjectDefaults result = null;
        FacetCompatiblityCalculator successCalculator = null;
        Set<IProjectFacet> requiredFacets = FacetSetUtil.buildRequiredFacets(projectTemplate, programmingModel);
        Map<IProjectFacet, IProjectFacetVersion> defaultVersionMap = FacetSetUtil.buildDefaultVersionSet(projectTemplate, programmingModel, oldProjectVersions == null ? new HashSet() : oldProjectVersions);
        Map<IProjectFacet, Set<IProjectFacetVersion>> unionOfTemplateAndProgrammingModel = FacetSetUtil.mergeOfTemplateAndCoreFacetSet(projectTemplate, programmingModel);
        if (this.runtimeSupportsRequiredFacets(requiredFacets, defaultRuntime) && (calculator3 = new FacetCompatiblityCalculator(requiredFacets, unionOfTemplateAndProgrammingModel, defaultVersionMap, new IRuntime[]{defaultRuntime})).isValid()) {
            successCalculator = calculator3;
            if (!this.equal(defaultRuntime, this.workingCopy.getPrimaryRuntime())) {
                changeRuntime = true;
                newRuntime = defaultRuntime;
            }
        }
        IRuntime primaryRuntime = this.workingCopy.getPrimaryRuntime();
        if (successCalculator == null && !this.equal(primaryRuntime, defaultRuntime) && this.runtimeSupportsRequiredFacets(requiredFacets, primaryRuntime) && (calculator2 = new FacetCompatiblityCalculator(requiredFacets, unionOfTemplateAndProgrammingModel, defaultVersionMap, new IRuntime[]{primaryRuntime})).isValid()) {
            successCalculator = calculator2;
        }
        if (successCalculator == null && (targetedRuntimes = this.filterAndSortTargetRuntimes(requiredFacets, this.workingCopy.getTargetedRuntimes(), defaultRuntime, primaryRuntime)) != null && targetedRuntimes.length > 1 && (calculator = new FacetCompatiblityCalculator(requiredFacets, unionOfTemplateAndProgrammingModel, defaultVersionMap, targetedRuntimes)).isValid()) {
            successCalculator = calculator;
        }
        if (successCalculator == null && (applicableTargetRuntimes = this.filterAndSortTargetRuntimes(requiredFacets, RuntimeManager.getRuntimes(), defaultRuntime, primaryRuntime)) != null) {
            IRuntime[] iRuntimeArray = applicableTargetRuntimes;
            int n = applicableTargetRuntimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                FacetCompatiblityCalculator calculator4 = new FacetCompatiblityCalculator(requiredFacets, unionOfTemplateAndProgrammingModel, defaultVersionMap, new IRuntime[]{runtime});
                if (calculator4.isValid()) {
                    successCalculator = calculator4;
                    newRuntime = runtime;
                    changeRuntime = true;
                    break;
                }
                ++n2;
            }
        }
        if (successCalculator == null) {
            newRuntime = null;
            calculator2 = new FacetCompatiblityCalculator(requiredFacets, unionOfTemplateAndProgrammingModel, defaultVersionMap, null);
            if (calculator2.isValid()) {
                successCalculator = calculator2;
                changeRuntime = true;
            }
        }
        if (successCalculator != null) {
            result = new ProjectDefaults();
            result.newProjectFacetVersions = successCalculator.getProjectFacetVersions();
            result.newRuntime = newRuntime;
            result.changeRuntime = changeRuntime;
        }
        this.debugger.debug(Debugger.DebugType.CONFIGURATION, "End calculateProjectDefaults(). Project defaults: " + result.getClass().getCanonicalName());
        return result;
    }

    @Override
    public synchronized void changeCoreFacetSet(ICoreFacetSet newModel) throws CoreException {
        this.tracer.trace(Tracer.TraceType.CONFIGURATION, "Changing the Core Facet to " + newModel.getId() + " " + newModel.getDescription());
        if (!this.initComplete) {
            return;
        }
        if (this.projectConfiguration.isDirty()) {
            throw new RuntimeException("You must apply the changes of the last call to changeProgrammingModel by calling applyTemplateChangeToWorkingCopy");
        }
        this.currentProgrammingModel = newModel;
        ProjectDefaults calculateProjectDefaults = this.calculateProjectDefaults(this.currentProjectTemplate, this.currentProgrammingModel, this.projectConfiguration.getProjectFacetVersions(), this.projectConfiguration.getDefaultRuntime(this.currentProgrammingModel));
        this.applyProjectDefaultsToConfiguration(calculateProjectDefaults);
    }

    @Override
    public synchronized IStatus changeFacetVersion(IProjectFacetVersion facetVersion) {
        this.tracer.trace(Tracer.TraceType.CONFIGURATION, "Changing the Facet Version to: " + facetVersion.getVersionString());
        if (!this.initComplete) {
            String message = "Attempt to change facet was performed before " + this.getClass().getCanonicalName() + " was fully initialized.";
            return new Status(4, "com.ibm.adapter.j2c.codegen", message);
        }
        IStatus status = this.projectConfiguration.changeFacetVersion(facetVersion, this.currentProjectTemplate, this.currentProgrammingModel);
        return status;
    }

    @Override
    public synchronized boolean changeProjectTemplate(IProjectTemplate newTemplate, Set<IProjectFacetVersion> oldProjectVersions) throws CoreException {
        this.tracer.trace(Tracer.TraceType.CONFIGURATION, "Changing the Project Template to " + newTemplate.getId() + " " + newTemplate.getDescription());
        if (!this.initComplete) {
            return false;
        }
        boolean programmingModelChanged = false;
        if (this.projectConfiguration.isDirty()) {
            throw new RuntimeException("You must apply the changes of the last call to changeProjectTemplate by calling applyTemplateChangeToWorkingCopy");
        }
        if (this.currentProjectTemplateDelegate != null) {
            this.currentProjectTemplateDelegate.dispose();
        }
        this.currentProjectTemplate = newTemplate;
        this.currentProjectTemplateDelegate = null;
        this.currentProjectTemplateDelegate = DelegateUtil.createProjectTemplateDelegate(this.currentProjectTemplate);
        boolean bl = programmingModelChanged = !this.wizardLevelExtPtMgr.getCoreFacetSetsForTemplate(this.currentProjectTemplate).contains(this.currentProgrammingModel);
        if (programmingModelChanged) {
            this.currentProgrammingModel = this.wizard.getDefaultCoreFacetSetForProjectTemplate(this.currentProjectTemplate);
        }
        ProjectDefaults calculateProjectDefaults = this.calculateProjectDefaults(this.currentProjectTemplate, this.currentProgrammingModel, oldProjectVersions, this.projectConfiguration.getDefaultRuntime(this.currentProgrammingModel));
        this.applyProjectDefaultsToConfiguration(calculateProjectDefaults);
        if (this.currentProjectTemplateDelegate != null) {
            this.currentProjectTemplateDelegate.setProjectManager(this.wizard);
            this.currentProjectTemplateDelegate.projectTemplateSelected();
        }
        this.tracer.trace(Tracer.TraceType.CONFIGURATION, "The project template was changed: " + programmingModelChanged);
        return programmingModelChanged;
    }

    @Override
    public synchronized IStatus changeRuntime(IRuntime runtime, Set<IProjectFacetVersion> oldProjectVersions) throws CoreException {
        ProjectDefaults newProjectDefaults;
        IStatus result = Status.OK_STATUS;
        if (this.projectConfiguration.isDirty()) {
            throw new RuntimeException("You must apply the changes of the last call to changeDefaultRuntime by calling applyTemplateChangeToWorkingCopy");
        }
        if (!this.equal(this.workingCopy.getPrimaryRuntime(), runtime) && (result = this.validateRuntimeChange(runtime, oldProjectVersions)).getSeverity() != 4 && (newProjectDefaults = this.calculateProjectDefaults(this.currentProjectTemplate, this.currentProgrammingModel, oldProjectVersions, runtime)) != null) {
            Set<IProjectFacetVersion> userAddedFacets = this.getUserFacetSet(runtime, newProjectDefaults.newProjectFacetVersions, true);
            newProjectDefaults.changeRuntime = true;
            newProjectDefaults.newRuntime = runtime;
            newProjectDefaults.newProjectFacetVersions.addAll(userAddedFacets);
            this.projectConfiguration.setDefaultRuntime(this.currentProgrammingModel, runtime);
            this.applyProjectDefaultsToConfiguration(newProjectDefaults);
        }
        return result;
    }

    public synchronized void dispose() {
        this.initComplete = false;
        wizardToConfigurationManagerMap.remove(this.wizard);
        this.projectConfiguration = null;
        this.currentProjectTemplate = null;
        this.currentProgrammingModel = null;
        this.dataModel = null;
        this.workingCopy = null;
        this.wizardLevelExtPtMgr = null;
    }

    private boolean equal(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    private IRuntime[] filterAndSortTargetRuntimes(Set<IProjectFacet> requiredFacets, Set<IRuntime> allRuntimes, IRuntime ... runtimesToExclude) {
        HashSet<IRuntime> baseRuntimes = new HashSet<IRuntime>(allRuntimes);
        IRuntime[] iRuntimeArray = runtimesToExclude;
        int n = runtimesToExclude.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime != null) {
                baseRuntimes.remove(runtime);
            }
            ++n2;
        }
        HashSet<IRuntime> unsortedResult = new HashSet<IRuntime>();
        for (IRuntime runtime : baseRuntimes) {
            if (!this.runtimeSupportsRequiredFacets(requiredFacets, runtime)) continue;
            unsortedResult.add(runtime);
        }
        ArrayList sortedResult = new ArrayList(unsortedResult);
        Collections.sort(sortedResult, new RuntimeComparator());
        return sortedResult.toArray(new IRuntime[0]);
    }

    @Override
    public synchronized ICoreFacetSet getCoreFacetSet() {
        if (!this.initComplete) {
            return null;
        }
        return this.currentProgrammingModel;
    }

    @Override
    public synchronized Set<IProjectFacet> getFixedProjectFacets() {
        if (!this.initComplete) {
            return null;
        }
        return this.projectConfiguration.getFixedProjectFacets();
    }

    @Override
    public synchronized Set<IProjectFacetVersion> getIncompatibleFacets(IRuntime newRuntime, Set<IProjectFacetVersion> oldFacetVersions) {
        Set<IProjectFacetVersion> result = new HashSet<IProjectFacetVersion>();
        try {
            ProjectDefaults newProjectDefaults = this.calculateProjectDefaults(this.currentProjectTemplate, this.currentProgrammingModel, oldFacetVersions, newRuntime);
            result = this.getUserFacetSet(newRuntime, newProjectDefaults.newProjectFacetVersions, false);
        }
        catch (CoreException e) {
            this.logger.logException((Exception)((Object)e));
        }
        return result;
    }

    @Override
    public synchronized Set<IProjectFacetVersion> getProjectFacetVersions() {
        if (!this.initComplete) {
            return null;
        }
        return this.projectConfiguration.getProjectFacetVersions();
    }

    @Override
    public synchronized IProjectTemplate getProjectTemplate() {
        if (!this.initComplete) {
            return null;
        }
        return this.currentProjectTemplate;
    }

    private Set<IProjectFacetVersion> getUserFacetSet(IRuntime newRuntime, Set<IProjectFacetVersion> newBaseFacetVersions, boolean returnCompatible) {
        HashSet<IProjectFacetVersion> userAddedFacets = new HashSet<IProjectFacetVersion>(this.projectConfiguration.getUserAddedFacets());
        HashSet<IProjectFacetVersion> facetsToRemove = new HashSet<IProjectFacetVersion>();
        if (!userAddedFacets.isEmpty()) {
            if (newRuntime != null) {
                for (IProjectFacetVersion projectFacetVersion : userAddedFacets) {
                    if (newRuntime.supports(projectFacetVersion)) continue;
                    facetsToRemove.add(projectFacetVersion);
                }
            }
            userAddedFacets.removeAll(facetsToRemove);
            HashSet<IFacetedProject.Action> completeActionSet = new HashSet<IFacetedProject.Action>();
            for (IProjectFacetVersion projectFacetVersion : userAddedFacets) {
                completeActionSet.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, projectFacetVersion, null));
            }
            if (!completeActionSet.isEmpty() && ProjectFacetsManager.check(newBaseFacetVersions, completeActionSet).getSeverity() == 4) {
                ArrayList actionList = new ArrayList(completeActionSet);
                ProjectFacetsManager.sort(newBaseFacetVersions, actionList);
                HashSet<IFacetedProject.Action> iterativeActionSet = new HashSet<IFacetedProject.Action>();
                for (IFacetedProject.Action action : actionList) {
                    iterativeActionSet.add(action);
                    if (ProjectFacetsManager.check(newBaseFacetVersions, iterativeActionSet).getSeverity() != 4) continue;
                    facetsToRemove.add(action.getProjectFacetVersion());
                    iterativeActionSet.remove(action);
                }
                userAddedFacets.removeAll(facetsToRemove);
            }
        }
        return returnCompatible ? userAddedFacets : facetsToRemove;
    }

    @Override
    public synchronized boolean hasFacet(String facetId) {
        return this.projectConfiguration.hasFacet(facetId);
    }

    @Override
    public synchronized boolean hasFacetVersion(IProjectFacetVersion facetVersion) {
        return this.projectConfiguration.hasFacetVersion(facetVersion);
    }

    public synchronized void init(IProjectTemplate initialTemplate, ICoreFacetSet initialProgrammingModel, Map<ICoreFacetSet, IRuntime> initialRuntimeMap, Set<IProjectFacetVersion> initialProjectFacetVersions) throws CoreException {
        this.dataModel = this.wizard.getDataModel();
        this.wizardLevelExtPtMgr = this.wizard.getExtensionPointManager();
        this.workingCopy = (IFacetedProjectWorkingCopy)this.dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        if (this.validateInitialValues(initialProjectFacetVersions, initialTemplate, initialProgrammingModel)) {
            this.currentProjectTemplate = initialTemplate;
            this.currentProgrammingModel = initialProgrammingModel;
        } else {
            this.currentProjectTemplate = this.wizard.getDefaultProjectTemplate();
            if (this.currentProjectTemplate == null) {
                Status status = new Status(4, "com.ibm.adapter.j2c.codegen", "No default template was available.");
                throw new CoreException((IStatus)status);
            }
            this.currentProgrammingModel = this.wizard.getDefaultCoreFacetSetForProjectTemplate(this.currentProjectTemplate);
        }
        Set<ICoreFacetSet> programmingModels = this.wizardLevelExtPtMgr.getCoreFacetSets();
        for (ICoreFacetSet programmingModel : programmingModels) {
            IRuntime defaultRuntime;
            IRuntime iRuntime = defaultRuntime = programmingModel != null ? initialRuntimeMap.get(programmingModel) : null;
            if (defaultRuntime == null) {
                Set<IProjectFacet> requiredFacets = FacetSetUtil.buildRequiredFacets(programmingModel.getFacets());
                IRuntime[] applicableRuntimes = this.filterAndSortTargetRuntimes(requiredFacets, RuntimeManager.getRuntimes(), new IRuntime[0]);
                IRuntime iRuntime2 = defaultRuntime = applicableRuntimes.length > 0 ? applicableRuntimes[0] : null;
            }
            if (defaultRuntime == null) continue;
            this.projectConfiguration.setDefaultRuntime(programmingModel, defaultRuntime);
        }
        if (this.currentProjectTemplate != null && this.currentProgrammingModel != null) {
            ProjectDefaults projectDefaults = this.calculateProjectDefaults(this.currentProjectTemplate, this.currentProgrammingModel, initialProjectFacetVersions, this.projectConfiguration.getDefaultRuntime(this.currentProgrammingModel));
            this.applyProjectDefaultsToConfiguration(projectDefaults);
            this.initComplete = true;
        } else {
            Status status;
            if (this.currentProjectTemplate == null) {
                status = new Status(4, "com.ibm.adapter.j2c.codegen", "Initial project template was null.  This occurs if there is no default project template was provided by the wizard.");
                throw new CoreException((IStatus)status);
            }
            if (this.currentProgrammingModel == null) {
                status = new Status(4, "com.ibm.adapter.j2c.codegen", "Initial programming model was null.  This occurs if there is no default programming model was provided by the wizard.");
                throw new CoreException((IStatus)status);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isFacetSet(String facetId, String facetVersionExpress) {
        if (!this.initComplete) {
            return false;
        }
        IProjectFacet projectFacet = this.projectConfiguration.getProjectFacetById(facetId);
        if (projectFacet == null) return false;
        if (facetVersionExpress == null) return true;
        try {
            IProjectFacetVersion requestVersion;
            Set requestedVersions = projectFacet.getVersions(facetVersionExpress);
            Set<IProjectFacetVersion> pfvs = this.projectConfiguration.getProjectFacetVersions();
            Iterator iterator = requestedVersions.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!pfvs.contains(requestVersion = (IProjectFacetVersion)iterator.next()));
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public synchronized IStatus removeFacet(String facetId) {
        if (!this.initComplete) {
            String message = "Attempt to remove facet was performed before " + this.getClass().getCanonicalName() + " was fully initialized.";
            return new Status(4, "com.ibm.adapter.j2c.codegen", message);
        }
        IStatus status = this.projectConfiguration.removeFacet(facetId);
        return status;
    }

    private boolean runtimeSupportsRequiredFacets(Set<IProjectFacet> requiredFacets, IRuntime runtime) {
        boolean result = true;
        if (runtime == null) {
            return true;
        }
        for (IProjectFacet projectFacet : requiredFacets) {
            if (runtime.supports(projectFacet)) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean setsEqual(Set<?> oldSet, Set<?> newSet) {
        if (!this.initComplete) {
            return false;
        }
        boolean equal = false;
        if (oldSet.size() == newSet.size()) {
            equal = oldSet.containsAll(newSet) && newSet.containsAll(oldSet);
        }
        return equal;
    }

    @Override
    public synchronized boolean updateCurrentProjectTemplateFacets(Set<IProjectFacetVersion> newProjectFacetVersions, Set<IProjectFacet> newFixedProjectFacets) throws Exception {
        if (!this.initComplete) {
            return false;
        }
        boolean changed = false;
        final IStatus status = this.validateUpdateOfCurrentProjectTemplateFacets(newProjectFacetVersions, newFixedProjectFacets);
        if (status.getSeverity() != 4) {
            if (this.currentProjectTemplate != null) {
                if (!this.setsEqual(this.projectConfiguration.getProjectFacetVersions(), newProjectFacetVersions)) {
                    changed = true;
                    this.projectConfiguration.setProjectFacetVersions(newProjectFacetVersions, this.currentProjectTemplate, this.currentProgrammingModel);
                }
                if (!this.setsEqual(this.projectConfiguration.getFixedProjectFacets(), newFixedProjectFacets)) {
                    this.projectConfiguration.setFixedFacets(newFixedProjectFacets);
                }
            }
            this.applyFacetChangesToWorkingCopy(false);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)ProjectConfigurationManager.this.wizard.getShell(), (String)Messages.ProjectConfigurationManager_InvalidConfig, (String)Messages.ProjectConfigurationManager_InvalidConfigMessage, (IStatus)status);
                }
            });
            Set<IProjectFacetVersion> projectFacetVersionsToRevertTo = this.projectConfiguration.getProjectFacetVersions();
            Set<IProjectFacet> fixedProjectFacetsToRevertTo = this.projectConfiguration.getFixedProjectFacets();
            this.projectConfiguration.setProjectFacetVersions(newProjectFacetVersions, this.currentProjectTemplate, this.currentProgrammingModel);
            this.projectConfiguration.setFixedFacets(newFixedProjectFacets);
            this.projectConfiguration.setProjectFacetVersions(projectFacetVersionsToRevertTo, this.currentProjectTemplate, this.currentProgrammingModel);
            this.projectConfiguration.setFixedFacets(fixedProjectFacetsToRevertTo);
            this.applyFacetChangesToWorkingCopy(false);
        }
        return changed;
    }

    private IStatus validateUpdateOfCurrentProjectTemplateFacets(Set<IProjectFacetVersion> newProjectFacetVersions, Set<IProjectFacet> newFixedProjectFacets) {
        HashMap<IProjectFacet, IFacetRange> rangeMap;
        HashSet<IProjectFacet> newFacets = new HashSet<IProjectFacet>();
        for (IProjectFacetVersion pfv : newProjectFacetVersions) {
            newFacets.add(pfv.getProjectFacet());
        }
        HashSet<IProjectFacet> newFixedFacets = new HashSet<IProjectFacet>();
        for (IProjectFacet pf : newFixedProjectFacets) {
            newFixedFacets.add(pf);
        }
        if (this.currentProjectTemplate != null) {
            rangeMap = new HashMap<IProjectFacet, IFacetRange>();
            for (IFacetRange range : this.currentProjectTemplate.getTemplateFacetPresets()) {
                rangeMap.put(range.getProjectFacet(), range);
            }
            for (IProjectFacet templateFacet : rangeMap.keySet()) {
                if (newFacets.contains(templateFacet)) continue;
                return new Status(4, "com.ibm.adapter.j2c.codegen", Messages.ProjectConfigurationManager_ProjectTemplateFacetRemoved);
            }
            for (IProjectFacet fixedFacet : rangeMap.keySet()) {
                if (newFixedFacets.contains(fixedFacet)) continue;
                return new Status(4, "com.ibm.adapter.j2c.codegen", Messages.ProjectConfigurationManager_ProjectTempateFacetUnlocked);
            }
        }
        if (this.currentProgrammingModel != null) {
            rangeMap = new HashMap();
            for (IFacetRange range : this.currentProgrammingModel.getFacets()) {
                rangeMap.put(range.getProjectFacet(), range);
            }
            for (IProjectFacet templateFacet : rangeMap.keySet()) {
                if (newFacets.contains(templateFacet)) continue;
                return new Status(4, "com.ibm.adapter.j2c.codegen", Messages.ProjectConfigurationManager_CoreFacetRemoved);
            }
            for (IProjectFacet fixedFacet : rangeMap.keySet()) {
                if (newFixedFacets.contains(fixedFacet)) continue;
                return new Status(4, "com.ibm.adapter.j2c.codegen", Messages.ProjectConfigurationManager_CoreFacetUnlocked);
            }
        }
        if (this.workingCopy != null) {
            IStatus status = this.workingCopy.validate();
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    public synchronized IStatus validateAddFacetVersion(IProjectFacetVersion facetVersion) {
        if (!this.initComplete) {
            String message = "Attempt to validate add facet was performed before " + this.getClass().getCanonicalName() + " was fully initialized.";
            return new Status(4, "com.ibm.adapter.j2c.codegen", message);
        }
        return this.projectConfiguration.validateAddFacetVersion(facetVersion);
    }

    @Override
    public synchronized IStatus validateChangeFacetVersion(IProjectFacetVersion facetVersion) {
        if (!this.initComplete) {
            String message = "Attempt to validate change facet was performed before " + this.getClass().getCanonicalName() + " was fully initialized.";
            return new Status(4, "com.ibm.adapter.j2c.codegen", message);
        }
        return this.projectConfiguration.validateChangeFacetVersion(facetVersion);
    }

    private boolean validateInitialValues(Set<IProjectFacetVersion> initialProjectFacetVersions, IProjectTemplate initialProjectTemplate, ICoreFacetSet initialProgrammingModel) {
        return initialProjectTemplate != null && initialProgrammingModel != null && initialProjectFacetVersions != null && !initialProjectFacetVersions.isEmpty();
    }

    @Override
    public synchronized IStatus validateRemoveFacet(String facetId) {
        if (!this.initComplete) {
            String message = "Attempt to validate remove facet was performed before " + this.getClass().getCanonicalName() + " was fully initialized.";
            return new Status(4, "com.ibm.adapter.j2c.codegen", message);
        }
        return this.projectConfiguration.validateRemoveFacet(facetId);
    }

    @Override
    public synchronized IStatus validateRuntimeChange(IRuntime runtime, Set<IProjectFacetVersion> oldProjectVersions) {
        IStatus result = Status.OK_STATUS;
        try {
            if (this.equal(this.workingCopy.getPrimaryRuntime(), runtime)) {
                return result;
            }
            ProjectDefaults newProjectDefaults = this.calculateProjectDefaults(this.currentProjectTemplate, this.currentProgrammingModel, oldProjectVersions, runtime);
            if (newProjectDefaults != null) {
                Set<IProjectFacetVersion> facetsToRemove = this.getUserFacetSet(runtime, newProjectDefaults.newProjectFacetVersions, false);
                if (!facetsToRemove.isEmpty()) {
                    StringBuilder builder = new StringBuilder(Messages.ProjectConfigurationManager_FeatureConfictWithRuntimeError);
                    for (IProjectFacetVersion projectFacetVersion : facetsToRemove) {
                        builder.append(projectFacetVersion.getProjectFacet().getLabel());
                        builder.append(" ");
                        builder.append(projectFacetVersion.getVersionString());
                        builder.append("\n");
                    }
                    String message = builder.toString();
                    message = message.substring(0, message.length() - 1);
                    result = new Status(2, "com.ibm.adapter.j2c.codegen", message);
                }
            } else {
                result = new Status(4, "com.ibm.adapter.j2c.codegen", Messages.ProjectConfigurationManager_RuntimeAndFacetsAreNotCompatible);
            }
        }
        catch (CoreException e) {
            result = e.getStatus();
            this.logger.logError(result);
        }
        return result;
    }

    private static class ProjectDefaults {
        public Set<IProjectFacetVersion> newProjectFacetVersions;
        public boolean changeRuntime;
        public IRuntime newRuntime;

        private ProjectDefaults() {
        }
    }
}

