/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.serviceability;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectWizardContribution;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptions;

public class Logger {
    private final ILog LOG = CodegenPlugin.getDefault().getLog();
    private String pluginId;

    public Logger(String pluginId) {
        this.pluginId = pluginId;
    }

    public boolean isEnabled() {
        return LogType.LOG.isEnabled();
    }

    public void logContributorError(IProjectWizardContribution contribution, String message) {
        if (!this.isEnabled()) {
            return;
        }
        this.logContributorError(contribution, message, null);
    }

    public void logContributorError(IProjectWizardContribution contribution, String message, Exception e) {
        if (!this.isEnabled()) {
            return;
        }
        String errorMessage = "An invalid contribution to the " + contribution.getExtensionPointId() + " extension point was made by the plugin: " + contribution.getContributingPluginId() + "\n\tError Message: " + message;
        this.logError(errorMessage, e);
    }

    public void logContributorError(String extensionPoint, IConfigurationElement element, String message, Exception e) {
        if (!this.isEnabled()) {
            return;
        }
        String errorMessage = "An invalid contribution to the " + extensionPoint + " extension point was made by the plugin: " + (element != null ? element.getNamespaceIdentifier() : "") + "\n\tError Message: " + message;
        this.logError(errorMessage, e);
    }

    public void logError(IStatus status) {
        if (!this.isEnabled()) {
            return;
        }
        this.LOG.log(status);
    }

    public void logError(String message) {
        if (!this.isEnabled()) {
            return;
        }
        this.logError(message, null);
    }

    public void logError(String message, Exception e) {
        if (!this.isEnabled()) {
            return;
        }
        Status status = new Status(4, "com.ibm.adapter.j2c.codegen", message, (Throwable)e);
        this.LOG.log((IStatus)status);
    }

    public void logException(Exception e) {
        if (!this.isEnabled()) {
            return;
        }
        Status status = new Status(4, "com.ibm.adapter.j2c.codegen", e.getLocalizedMessage(), (Throwable)e);
        this.LOG.log((IStatus)status);
    }

    void optionsChanged(DebugOptions options) {
        LogType[] logTypeArray = LogType.values();
        int n = logTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogType type = logTypeArray[n2];
            boolean enabled = options.getBooleanOption(String.valueOf(this.pluginId) + type.getTypeId(), false);
            type.setEnabled(enabled);
            ++n2;
        }
    }

    public static enum LogType {
        LOG("/log");

        private String typeId;
        private boolean enabled;

        private LogType(String typeId) {
            this.typeId = typeId;
            this.enabled = false;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

