/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.serviceability;

import org.eclipse.osgi.internal.debug.FrameworkDebugTraceEntry;
import org.eclipse.osgi.service.debug.DebugOptions;

public class Debugger {
    private final String pluginId;

    Debugger(String pluginId) {
        this.pluginId = pluginId;
    }

    public void debug(DebugType type, String message) {
        if (!this.isEnabled()) {
            return;
        }
        FrameworkDebugTraceEntry entry = new FrameworkDebugTraceEntry(this.pluginId, type.getTypeId(), message, null, this.getClass().getCanonicalName());
        System.out.println(entry.toString());
    }

    public boolean isEnabled() {
        return DebugType.DEBUG.isEnabled();
    }

    void optionsChanged(DebugOptions options) {
        DebugType[] debugTypeArray = DebugType.values();
        int n = debugTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugType type = debugTypeArray[n2];
            boolean enabled = options.getBooleanOption(String.valueOf(this.pluginId) + type.getTypeId(), false);
            type.setEnabled(enabled);
            ++n2;
        }
    }

    public static enum DebugType {
        DEBUG("/debug"),
        WIZARD("/debug/wizard"),
        CONFIGURATION("/debug/wizard/configuration");

        private String typeId;
        private boolean enabled;

        private DebugType(String typeId) {
            this.typeId = typeId;
            this.enabled = false;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

