/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.management;

import com.ibm.faceted.project.wizard.core.management.FacetCompatiblityCalculator;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IFacetRange;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class FacetSetUtil {
    public static Map<IProjectFacet, IProjectFacetVersion> buildDefaultVersionSet(IProjectTemplate projectTemplate, ICoreFacetSet programmingModel, Set<IProjectFacetVersion> currentFacetsParam) {
        IProjectFacetVersion defaultVersion;
        IProjectFacet projectFacet;
        HashSet currentFacets = currentFacetsParam == null ? new HashSet() : currentFacetsParam;
        HashMap<IProjectFacet, IProjectFacetVersion> result = new HashMap<IProjectFacet, IProjectFacetVersion>();
        for (IProjectFacetVersion projectFacetVersion : currentFacets) {
            projectFacet = projectFacetVersion.getProjectFacet();
            if (result.containsKey(projectFacet)) continue;
            result.put(projectFacet, projectFacetVersion);
        }
        for (IFacetRange facet : projectTemplate.getTemplateFacetPresets()) {
            projectFacet = facet.getProjectFacet();
            if (result.containsKey(projectFacet) || (defaultVersion = facet.getDefaultVersion()) == null) continue;
            result.put(projectFacet, defaultVersion);
        }
        for (IFacetRange facet : projectTemplate.getCoreFacetSetFacetPresets()) {
            projectFacet = facet.getProjectFacet();
            if (result.containsKey(projectFacet) || (defaultVersion = facet.getDefaultVersion()) == null) continue;
            result.put(projectFacet, defaultVersion);
        }
        for (IFacetRange facet : programmingModel.getFacets()) {
            projectFacet = facet.getProjectFacet();
            if (result.containsKey(projectFacet) || (defaultVersion = facet.getDefaultVersion()) == null) continue;
            result.put(projectFacet, defaultVersion);
        }
        return result;
    }

    public static Set<IProjectFacet> buildRequiredFacets(IProjectTemplate projectTemplate, ICoreFacetSet programmingModel) {
        return FacetSetUtil.buildRequiredFacets(projectTemplate.getTemplateFacetPresets(), programmingModel.getFacets());
    }

    public static Set<IProjectFacet> buildRequiredFacets(Set<IFacetRange> ... facetSets) {
        HashSet<IProjectFacet> result = new HashSet<IProjectFacet>();
        Set<IFacetRange>[] setArray = facetSets;
        int n = facetSets.length;
        int n2 = 0;
        while (n2 < n) {
            Set<IFacetRange> facetSet = setArray[n2];
            for (IFacetRange facet : facetSet) {
                IProjectFacet projectFacet = facet.getProjectFacet();
                if (result.contains(projectFacet)) continue;
                result.add(projectFacet);
            }
            ++n2;
        }
        return result;
    }

    private static boolean isFacetSetCompatible(Map<IProjectFacet, Set<IProjectFacetVersion>> unionOfTemplateAndProgrammingModel, Set<IProjectFacet> requiredFacets, Map<IProjectFacet, IProjectFacetVersion> defaultVersionMap) {
        FacetCompatiblityCalculator calculator = new FacetCompatiblityCalculator(requiredFacets, unionOfTemplateAndProgrammingModel, defaultVersionMap, null);
        return calculator.isValid();
    }

    private static boolean isFacetSetComplete(Map<IProjectFacet, Set<IProjectFacetVersion>> filteredVersionMap, Set<IProjectFacet> requiredFacets) {
        return requiredFacets.size() == filteredVersionMap.size() && filteredVersionMap.keySet().containsAll(requiredFacets);
    }

    public static Map<IProjectFacet, Set<IProjectFacetVersion>> mergeOfTemplateAndCoreFacetSet(IProjectTemplate projectTemplate, ICoreFacetSet programmingModel) {
        Map<IProjectFacet, IProjectFacetVersion> defaultVersionMap;
        Set<IProjectFacet> requiredFacets = FacetSetUtil.buildRequiredFacets(projectTemplate.getTemplateFacetPresets(), programmingModel.getFacets());
        HashMap<Object, Set<Object>> result = new HashMap<IProjectFacet, Set<IProjectFacetVersion>>();
        for (IFacetRange templateFacet : projectTemplate.getTemplateFacetPresets()) {
            result.put(templateFacet.getProjectFacet(), new HashSet<IProjectFacetVersion>(templateFacet.getSupportedVersions()));
        }
        for (IFacetRange templateFacet : projectTemplate.getCoreFacetSetFacetPresets()) {
            if (!requiredFacets.contains(templateFacet.getProjectFacet())) continue;
            result.put(templateFacet.getProjectFacet(), new HashSet<IProjectFacetVersion>(templateFacet.getSupportedVersions()));
        }
        for (IFacetRange programmingModelFacet : programmingModel.getFacets()) {
            IProjectFacet projectFacet = programmingModelFacet.getProjectFacet();
            if (result.containsKey(projectFacet)) {
                Set firstProjectFacetVersionSet = (Set)result.get(projectFacet);
                Set<IProjectFacetVersion> lastProjectFacetVersionSet = programmingModelFacet.getSupportedVersions();
                HashSet<IProjectFacetVersion> facetVersionsToRemove = new HashSet<IProjectFacetVersion>();
                for (IProjectFacetVersion firstFacet : firstProjectFacetVersionSet) {
                    if (lastProjectFacetVersionSet.contains(firstFacet)) continue;
                    facetVersionsToRemove.add(firstFacet);
                }
                for (IProjectFacetVersion facetToRemove : facetVersionsToRemove) {
                    firstProjectFacetVersionSet.remove(facetToRemove);
                }
                if (!firstProjectFacetVersionSet.isEmpty()) continue;
                result.remove(projectFacet);
                continue;
            }
            result.put(projectFacet, new HashSet<IProjectFacetVersion>(programmingModelFacet.getSupportedVersions()));
        }
        if (!FacetSetUtil.isFacetSetComplete(result, requiredFacets)) {
            result = new HashMap();
        }
        if (!FacetSetUtil.isFacetSetCompatible(result, requiredFacets, defaultVersionMap = FacetSetUtil.buildDefaultVersionSet(projectTemplate, programmingModel, null))) {
            result = new HashMap();
        }
        return result;
    }
}

