/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class FacetCompatiblityCalculator {
    private final Map<IProjectFacet, IProjectFacetVersion> defaultFacetVersionMap;
    private final IRuntime[] runtimes;
    private Set<IProjectFacetVersion> projectFacetVersions;
    private final Set<IProjectFacet> requiredFacets;
    private boolean isValid = false;
    private final Map<IProjectFacet, Set<IProjectFacetVersion>> unionOfTemplateAndProgrammingModel;

    public FacetCompatiblityCalculator(Set<IProjectFacet> requiredFacets, Map<IProjectFacet, Set<IProjectFacetVersion>> unionOfTemplateAndProgrammingModel, Map<IProjectFacet, IProjectFacetVersion> defaultFacetVersionMap, IRuntime[] targetedRuntimes) {
        this.runtimes = targetedRuntimes;
        this.defaultFacetVersionMap = defaultFacetVersionMap;
        this.requiredFacets = requiredFacets;
        this.unionOfTemplateAndProgrammingModel = new HashMap<IProjectFacet, Set<IProjectFacetVersion>>(unionOfTemplateAndProgrammingModel);
    }

    private boolean allRequiredFacetsFound(Set<IFacetedProject.Action> actions) {
        boolean result = false;
        if (actions.size() == this.requiredFacets.size()) {
            HashSet<IProjectFacet> baseFacets = new HashSet<IProjectFacet>();
            for (IFacetedProject.Action action : actions) {
                baseFacets.add(action.getProjectFacetVersion().getProjectFacet());
            }
            if (this.requiredFacets.containsAll(baseFacets)) {
                result = true;
            }
        }
        return result;
    }

    private void calculateCompatibleVersions() {
        if (this.unionOfTemplateAndProgrammingModel.isEmpty()) {
            this.projectFacetVersions = new HashSet<IProjectFacetVersion>();
            this.isValid = true;
        } else {
            this.isValid = this.filterByRuntimes(this.unionOfTemplateAndProgrammingModel);
            if (this.isValid) {
                this.projectFacetVersions = this.findValidFacetVersionCombination(this.unionOfTemplateAndProgrammingModel);
                if (this.projectFacetVersions == null) {
                    this.isValid = false;
                }
            }
        }
    }

    private boolean filterByRuntimes(Map<IProjectFacet, Set<IProjectFacetVersion>> filteredVersionMap) {
        boolean valid = true;
        if (this.runtimes != null) {
            for (Map.Entry<IProjectFacet, Set<IProjectFacetVersion>> entry : filteredVersionMap.entrySet()) {
                Set<IProjectFacetVersion> projectFacetVersionSet = entry.getValue();
                HashSet<IProjectFacetVersion> facetVersionsToRemove = new HashSet<IProjectFacetVersion>();
                for (IProjectFacetVersion projectFacetVersion : projectFacetVersionSet) {
                    boolean foundSupportOnARuntime = false;
                    IRuntime[] iRuntimeArray = this.runtimes;
                    int n = this.runtimes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRuntime runtime = iRuntimeArray[n2];
                        if (runtime == null || runtime.supports(projectFacetVersion)) {
                            foundSupportOnARuntime = true;
                            break;
                        }
                        ++n2;
                    }
                    if (foundSupportOnARuntime) continue;
                    facetVersionsToRemove.add(projectFacetVersion);
                }
                for (IProjectFacetVersion projectFacetVersion : facetVersionsToRemove) {
                    projectFacetVersionSet.remove(projectFacetVersion);
                }
                if (!projectFacetVersionSet.isEmpty()) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    private Set<IProjectFacetVersion> findValidFacetVersionCombination(Map<IProjectFacet, Set<IProjectFacetVersion>> filteredVersionMap) {
        Set<IProjectFacetVersion> result = null;
        ArrayList<FilterVersionList> sortedFacetVersionLists = new ArrayList<FilterVersionList>();
        for (Map.Entry<IProjectFacet, Set<IProjectFacetVersion>> entry : filteredVersionMap.entrySet()) {
            Set<IProjectFacetVersion> facetVersionSet = entry.getValue();
            FilterVersionList filterVersionList = new FilterVersionList(facetVersionSet, this.defaultFacetVersionMap.get(entry.getKey()));
            sortedFacetVersionLists.add(filterVersionList);
        }
        Collections.sort(sortedFacetVersionLists);
        FilterVersionList last = null;
        for (FilterVersionList filterVersionList : sortedFacetVersionLists) {
            if (last != null) {
                last.setNext(filterVersionList);
            }
            last = filterVersionList;
        }
        if (sortedFacetVersionLists.size() > 0) {
            result = this.recursiveBuildCompleteSet((FilterVersionList)sortedFacetVersionLists.get(0), new HashSet<IFacetedProject.Action>());
        }
        return result;
    }

    public Set<IProjectFacetVersion> getProjectFacetVersions() {
        if (this.projectFacetVersions == null) {
            this.calculateCompatibleVersions();
        }
        return this.projectFacetVersions;
    }

    public boolean isValid() {
        if (this.projectFacetVersions == null) {
            this.calculateCompatibleVersions();
        }
        return this.isValid;
    }

    private Set<IProjectFacetVersion> recursiveBuildCompleteSet(FilterVersionList currentVersionList, Set<IFacetedProject.Action> actions) {
        Set<IProjectFacetVersion> result;
        block3: {
            block4: {
                result = null;
                HashSet base = new HashSet();
                if (currentVersionList != null) break block4;
                if (!this.allRequiredFacetsFound(actions) || !ProjectFacetsManager.check(base, actions).isOK()) break block3;
                result = new HashSet<IProjectFacetVersion>();
                for (IFacetedProject.Action action : actions) {
                    result.add(action.getProjectFacetVersion());
                }
                break block3;
            }
            HashSet<IFacetedProject.Action> newActions = new HashSet<IFacetedProject.Action>(actions);
            for (IProjectFacetVersion projectFacetVersion : currentVersionList.getFacetVersions()) {
                IFacetedProject.Action newAction = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, projectFacetVersion, null);
                newActions.add(newAction);
                result = this.recursiveBuildCompleteSet(currentVersionList.getNext(), newActions);
                if (result == null) {
                    newActions.remove(newAction);
                    continue;
                }
                break;
            }
        }
        return result;
    }

    private static class FilterVersionList
    implements Comparable<FilterVersionList> {
        private final List<IProjectFacetVersion> facetVersions;
        private FilterVersionList next;

        public FilterVersionList(Set<IProjectFacetVersion> versions, IProjectFacetVersion defaultVersion) {
            boolean removed;
            this.facetVersions = new ArrayList<IProjectFacetVersion>(versions);
            Collections.sort(this.facetVersions);
            Collections.reverse(this.facetVersions);
            if (defaultVersion != null && versions.contains(defaultVersion) && (removed = this.facetVersions.remove(defaultVersion))) {
                this.facetVersions.add(0, defaultVersion);
            }
        }

        @Override
        public int compareTo(FilterVersionList o) {
            return this.size().compareTo(o.size());
        }

        public boolean equals(Object o) {
            if (o instanceof FilterVersionList) {
                this.facetVersions.equals(((FilterVersionList)o).getFacetVersions());
            }
            return false;
        }

        public List<IProjectFacetVersion> getFacetVersions() {
            return this.facetVersions;
        }

        public FilterVersionList getNext() {
            return this.next;
        }

        public int hashCode() {
            return this.facetVersions.hashCode();
        }

        public void setNext(FilterVersionList next) {
            this.next = next;
        }

        public Integer size() {
            return this.facetVersions.size();
        }
    }
}

