/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.internal.management.extensionpts;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.GlobalExtensionPointManager;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.IExtensionPointConstants;
import com.ibm.faceted.project.wizard.core.management.IExtensionPointManager;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IConfigurationDelegate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSetApprover;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ITemplateCategory;
import com.ibm.faceted.project.wizard.core.serviceability.Tracer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WizardLevelExtensionPointManager
implements IExtensionPointConstants,
IExtensionPointManager {
    private String wizardId;
    private Set<ICoreFacetSet> coreFacetSets;
    private Map<IProjectTemplate, Set<ICoreFacetSet>> templateToCoreFacetSetMap;
    private Map<IProjectTemplate, Map<ICoreFacetSet, IConfigurationDelegate>> templateToCoreFacetSetToDefaultConfigurationMap;
    private Set<IConfigurationDelegate> configurationDelegates;
    private Set<IProjectTemplate> projectTemplates;
    private Map<String, IProjectTemplate> projectTemplateIdMap;
    private Map<String, ICoreFacetSet> coreFacetSetIdMap;
    private Set<ITemplateCategory> templateCategories;
    private ICoreFacetSetApprover coreFacetSetApprover;
    private GlobalExtensionPointManager globalExtensionPointMgr = GlobalExtensionPointManager.getInstance();
    private Tracer tracer = CodegenPlugin.getDefault().getServiceabilityManager().getTracer();

    public WizardLevelExtensionPointManager(String wizardId) {
        this.wizardId = wizardId;
        this.templateToCoreFacetSetMap = new HashMap<IProjectTemplate, Set<ICoreFacetSet>>();
        this.templateToCoreFacetSetToDefaultConfigurationMap = new HashMap<IProjectTemplate, Map<ICoreFacetSet, IConfigurationDelegate>>();
    }

    private IStatus buildErrorStatus(String message) {
        String fullMessage = String.valueOf(message) + "\nInvalid wizard class: " + this.getClass().getCanonicalName() + "\nInvalid wizard id:" + this.wizardId;
        Status status = new Status(4, "com.ibm.adapter.j2c.codegen", fullMessage);
        return status;
    }

    @Override
    public void dispose() {
        this.wizardId = null;
        this.coreFacetSetIdMap = null;
        this.coreFacetSets = null;
        this.projectTemplateIdMap = null;
        this.projectTemplates = null;
        this.templateCategories = null;
        this.configurationDelegates = null;
        this.templateToCoreFacetSetMap = null;
    }

    @Override
    public Set<IConfigurationDelegate> getConfigurationDelegates() {
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "Getting configuration delegates.");
        if (this.configurationDelegates == null) {
            this.configurationDelegates = new HashSet<IConfigurationDelegate>();
            Set<String> configurationIdsForWizard = this.globalExtensionPointMgr.getConfigurationIdsForWizard(this.wizardId);
            if (configurationIdsForWizard != null) {
                for (String configurationId : configurationIdsForWizard) {
                    IConfigurationDelegate configurationDefinition = this.globalExtensionPointMgr.getConfigurationById(configurationId);
                    if (configurationDefinition == null || !configurationDefinition.isValid()) continue;
                    this.configurationDelegates.add(configurationDefinition);
                }
                this.configurationDelegates = Collections.unmodifiableSet(this.configurationDelegates);
            }
        }
        Iterator<IConfigurationDelegate> it = this.configurationDelegates.iterator();
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "The configuration delegates are: ");
        while (it.hasNext()) {
            this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, String.valueOf(it.next().getId()) + " configuration delegate.");
        }
        return this.configurationDelegates;
    }

    @Override
    public ICoreFacetSet getCoreFacetSetById(String programmingModelId) {
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "Getting Core Facet Set for the programming model: " + programmingModelId);
        if (this.coreFacetSetIdMap == null) {
            Set<ICoreFacetSet> programmingModelsForWizard = this.getCoreFacetSets();
            this.coreFacetSetIdMap = new HashMap<String, ICoreFacetSet>();
            for (ICoreFacetSet programmingModel : programmingModelsForWizard) {
                this.coreFacetSetIdMap.put(programmingModel.getId(), programmingModel);
            }
        }
        return this.coreFacetSetIdMap.get(programmingModelId);
    }

    @Override
    public Set<ICoreFacetSet> getCoreFacetSets() {
        if (this.coreFacetSets == null) {
            this.coreFacetSets = new HashSet<ICoreFacetSet>();
            Set<String> programmingModelIdsForWizard = this.globalExtensionPointMgr.getCoreFacetSetIdsForWizard(this.wizardId);
            if (programmingModelIdsForWizard == null || programmingModelIdsForWizard.isEmpty()) {
                ICoreFacetSet programmingModel = this.globalExtensionPointMgr.getCoreFacetSetById(ICoreFacetSet.EMPTY_CORE_FACETS_ID);
                if (programmingModel != null) {
                    this.coreFacetSets.add(programmingModel);
                }
            } else {
                for (String pmId : programmingModelIdsForWizard) {
                    ICoreFacetSet programmingModel = this.globalExtensionPointMgr.getCoreFacetSetById(pmId);
                    if (programmingModel == null) continue;
                    this.coreFacetSets.add(programmingModel);
                }
            }
            this.coreFacetSets = Collections.unmodifiableSet(this.coreFacetSets);
        }
        return this.coreFacetSets;
    }

    @Override
    public Set<ICoreFacetSet> getCoreFacetSetsForTemplate(IProjectTemplate template) {
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "Getting Core Facet Sets for " + template.getId() + " template");
        Set<ICoreFacetSet> result = this.templateToCoreFacetSetMap.get(template);
        if (result == null) {
            if (this.coreFacetSetApprover == null) {
                return result;
            }
            result = new HashSet<ICoreFacetSet>();
            boolean wizardSupportsNullPM = false;
            Set<ICoreFacetSet> programmingModelsForWizard = this.getCoreFacetSets();
            wizardSupportsNullPM = programmingModelsForWizard.contains(this.globalExtensionPointMgr.getCoreFacetSetById(ICoreFacetSet.EMPTY_CORE_FACETS_ID));
            Set<String> programmingModelIdsForProjectTemplateId = this.globalExtensionPointMgr.getCoreFacetSetIdsForProjectTemplateId(template.getId());
            if ((programmingModelIdsForProjectTemplateId == null || programmingModelIdsForProjectTemplateId.isEmpty()) && wizardSupportsNullPM) {
                programmingModelIdsForProjectTemplateId = new HashSet<String>();
                programmingModelIdsForProjectTemplateId.add(ICoreFacetSet.EMPTY_CORE_FACETS_ID);
            }
            if (programmingModelIdsForProjectTemplateId != null) {
                for (String programmingModelId : programmingModelIdsForProjectTemplateId) {
                    ICoreFacetSet programmingModel = this.globalExtensionPointMgr.getCoreFacetSetById(programmingModelId);
                    if (programmingModel == null || !programmingModelsForWizard.contains(programmingModel) || !this.coreFacetSetApprover.approveCoreFacetSetForTemplate(template, programmingModel)) continue;
                    result.add(programmingModel);
                }
            }
            result = Collections.unmodifiableSet(result);
            this.templateToCoreFacetSetMap.put(template, result);
        }
        Iterator<ICoreFacetSet> coreFacetSetIter = result.iterator();
        String message = "The core facet sets for " + template.getId() + " are: ";
        while (coreFacetSetIter.hasNext()) {
            message = String.valueOf(message) + coreFacetSetIter.next().getId() + ",";
        }
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, message);
        return result;
    }

    public IConfigurationDelegate getDefaultConfiguration(IProjectTemplate projectTemplate, ICoreFacetSet coreFacets) {
        IConfigurationDelegate result = null;
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "Getting default configuration for: " + projectTemplate.getId() + " template.");
        Map<ICoreFacetSet, IConfigurationDelegate> templateSpecificMap = this.templateToCoreFacetSetToDefaultConfigurationMap.get(projectTemplate);
        if (templateSpecificMap != null) {
            result = templateSpecificMap.get(coreFacets);
        }
        if (result == null) {
            boolean usingTemplateValue = false;
            String configurationId = this.globalExtensionPointMgr.getDefaultConfiguration(projectTemplate.getId(), coreFacets.getId());
            if (configurationId == null) {
                configurationId = projectTemplate.getDefaultConfigurationId();
                usingTemplateValue = true;
            }
            if (configurationId != null) {
                IConfigurationDelegate configurationDelegate = this.globalExtensionPointMgr.getConfigurationById(configurationId);
                if (configurationDelegate == null && !usingTemplateValue) {
                    configurationId = projectTemplate.getDefaultConfigurationId();
                    configurationDelegate = this.globalExtensionPointMgr.getConfigurationById(configurationId);
                    usingTemplateValue = true;
                }
                if (configurationDelegate != null) {
                    Set<IConfigurationDelegate> configurationDefinitionsForWizard = this.getConfigurationDelegates();
                    boolean wizardAlsoContainsDelegate = configurationDefinitionsForWizard.contains(configurationDelegate);
                    if (!wizardAlsoContainsDelegate && !usingTemplateValue) {
                        configurationId = projectTemplate.getDefaultConfigurationId();
                        configurationDelegate = this.globalExtensionPointMgr.getConfigurationById(configurationId);
                        usingTemplateValue = true;
                        wizardAlsoContainsDelegate = configurationDefinitionsForWizard.contains(configurationDelegate);
                    }
                    if (wizardAlsoContainsDelegate) {
                        if (templateSpecificMap == null) {
                            templateSpecificMap = new HashMap<ICoreFacetSet, IConfigurationDelegate>();
                            this.templateToCoreFacetSetToDefaultConfigurationMap.put(projectTemplate, templateSpecificMap);
                        }
                        templateSpecificMap.put(coreFacets, configurationDelegate);
                        result = configurationDelegate;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public IProjectTemplate getProjectTemplateById(String templateId) {
        Set<ICoreFacetSet> programmingModelsForTemplate;
        IProjectTemplate result;
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "Getting project templates for the template: " + templateId);
        if (this.projectTemplateIdMap == null) {
            this.projectTemplateIdMap = new HashMap<String, IProjectTemplate>();
            Set<IProjectTemplate> projectTemplatesForWizard = this.getProjectTemplates();
            for (IProjectTemplate projectTemplate : projectTemplatesForWizard) {
                this.projectTemplateIdMap.put(projectTemplate.getId(), projectTemplate);
            }
        }
        if ((result = this.projectTemplateIdMap.get(templateId)) != null && ((programmingModelsForTemplate = this.getCoreFacetSetsForTemplate(result)) == null || programmingModelsForTemplate.isEmpty())) {
            result = null;
        }
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "The project template for the template id " + templateId + " is: " + result.getTitle());
        return result;
    }

    @Override
    public Set<IProjectTemplate> getProjectTemplates() {
        this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "Getting project templates.");
        if (this.projectTemplates == null) {
            this.projectTemplates = new HashSet<IProjectTemplate>();
            Set<String> projectTemplateIdsForWizard = this.globalExtensionPointMgr.getProjectTemplateIdsForWizard(this.wizardId);
            if (projectTemplateIdsForWizard != null) {
                for (String projectTemplateId : projectTemplateIdsForWizard) {
                    IProjectTemplate projectTemplate = this.globalExtensionPointMgr.getProjectTemplateById(projectTemplateId);
                    if (projectTemplate == null) continue;
                    this.tracer.trace(Tracer.TraceType.WIZARD_EXTENSION_POINT, "Getting project templates.");
                    this.projectTemplates.add(projectTemplate);
                }
            }
            this.projectTemplates = Collections.unmodifiableSet(this.projectTemplates);
        }
        return this.projectTemplates;
    }

    @Override
    public Set<ITemplateCategory> getTemplateCategories() {
        if (this.templateCategories == null) {
            this.templateCategories = new HashSet<ITemplateCategory>();
            Map<String, ITemplateCategory> categoryMap = this.globalExtensionPointMgr.getTemplateCategoryIdMapForWizard(this.wizardId);
            if (categoryMap == null || categoryMap.isEmpty()) {
                categoryMap = new HashMap<String, ITemplateCategory>();
            }
            this.templateCategories.addAll(categoryMap.values());
        }
        return this.templateCategories;
    }

    public IStatus validateWizardExtensionPoints() {
        Set<IProjectTemplate> projectTemplates = this.getProjectTemplates();
        if (projectTemplates == null || projectTemplates.isEmpty()) {
            String message = "Invalid wizard definition.  No templates are defined.";
            IStatus status = this.buildErrorStatus(message);
            return status;
        }
        return Status.OK_STATUS;
    }

    public void setCoreFacetSetApprover(ICoreFacetSetApprover coreFacetSetApprover) {
        this.coreFacetSetApprover = coreFacetSetApprover;
    }
}

