/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.internal.management.extensionpts;

import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.ConfigurationDelegateDefinition;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.CoreFacetSetDefinition;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.ExtensionPointUtil;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.FacetRangeDefinition;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.IExtensionPointConstants;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.ProjectTemplateDefinition;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.PropertyValidatorDescriptor;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.TemplateCategoryDefinition;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IConfigurationDelegate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IFacetRange;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectWizardContribution;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ITemplateCategory;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceabilityManager;
import com.ibm.faceted.project.wizard.core.serviceability.Tracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class GlobalExtensionPointManager
implements IExtensionPointConstants {
    private static final String NULL_CATEGORY_WIZARD_ID = String.valueOf(GlobalExtensionPointManager.class.getCanonicalName()) + "NULL_CATEGORY_WIZARD_ID";
    private static GlobalExtensionPointManager instance;
    private Map<String, IConfigurationDelegate> idToConfigurationDelegateMap;
    private Map<String, ICoreFacetSet> idToCoreFacetSetMap;
    private Map<String, IProjectTemplate> idToProjectTemplateMap;
    private Map<String, Set<String>> wizardIdToConfigurationDelegateIdsMap;
    private Map<String, Set<String>> wizardIdToCoreFacetSetIdsMap;
    private Map<String, Set<String>> wizardIdToProjectTemplateIdsMap;
    private Map<String, Map<String, ITemplateCategory>> wizardIdToTemplateCategoryMap;
    private Map<String, Set<String>> projectTemplateIdToCoreFacetSetIdsMap;
    private Map<String, Map<String, String>> projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate;
    private List<PropertyValidatorDescriptor> projectNameValidators;
    private Tracer tracer;

    private GlobalExtensionPointManager() {
        ServiceabilityManager serviceabilityManager = ExtensionPointUtil.getServiceabilityManager();
        this.tracer = serviceabilityManager.getTracer();
        this.init();
    }

    public static synchronized GlobalExtensionPointManager getInstance() {
        if (instance == null) {
            instance = new GlobalExtensionPointManager();
        }
        return instance;
    }

    public List<PropertyValidatorDescriptor> getPropertyValidators() {
        return this.projectNameValidators;
    }

    private void borrowWizardAssociations(String wizardId, String otherWizardId, IConfigurationElement wizardAssociationElement, ExtensionPointObjectType type) {
        IConfigurationElement[] childElements = wizardAssociationElement.getChildren("otherWizardContent");
        if (childElements != null && childElements.length > 0) {
            Map<String, Set<String>> wizardObjectMap = this.getWizardToObjectsMap(type);
            Set<String> existingWizardObjectSet = wizardObjectMap.get(wizardId);
            Set<String> otherWizardObjects = wizardObjectMap.get(otherWizardId);
            HashSet<String> mergedWizardObjects = new HashSet<String>();
            if (otherWizardObjects != null && !otherWizardObjects.isEmpty()) {
                mergedWizardObjects.addAll(otherWizardObjects);
                if (existingWizardObjectSet != null && !existingWizardObjectSet.isEmpty()) {
                    mergedWizardObjects.addAll(existingWizardObjectSet);
                }
                if (!mergedWizardObjects.isEmpty()) {
                    wizardObjectMap.put(wizardId, mergedWizardObjects);
                }
            }
        }
    }

    private Object createNewExtensionPointObject(ExtensionPointObjectType type, IConfigurationElement element) {
        this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, "Creating new extension point object. Type: " + type.toString() + " to element " + element.getName());
        IProjectWizardContribution result = null;
        switch (type) {
            case CUSTOM_CONFIGURATION: 
            case WIZARD_PAGE_CONFIGURATION: {
                result = new ConfigurationDelegateDefinition(element);
                break;
            }
            case PROJECT_TEMPLATE: {
                result = new ProjectTemplateDefinition(this, element);
                break;
            }
            case CORE_FACET_SET: {
                result = new CoreFacetSetDefinition(element);
            }
        }
        return result;
    }

    private void freezeDataStructures() {
        this.idToConfigurationDelegateMap = Collections.unmodifiableMap(this.idToConfigurationDelegateMap);
        this.idToCoreFacetSetMap = Collections.unmodifiableMap(this.idToCoreFacetSetMap);
        this.idToProjectTemplateMap = Collections.unmodifiableMap(this.idToProjectTemplateMap);
        for (String wizardId : this.wizardIdToConfigurationDelegateIdsMap.keySet()) {
            this.wizardIdToConfigurationDelegateIdsMap.put(wizardId, Collections.unmodifiableSet(this.wizardIdToConfigurationDelegateIdsMap.get(wizardId)));
        }
        for (String wizardId : this.wizardIdToCoreFacetSetIdsMap.keySet()) {
            this.wizardIdToCoreFacetSetIdsMap.put(wizardId, Collections.unmodifiableSet(this.wizardIdToCoreFacetSetIdsMap.get(wizardId)));
        }
        for (String wizardId : this.wizardIdToProjectTemplateIdsMap.keySet()) {
            this.wizardIdToProjectTemplateIdsMap.put(wizardId, Collections.unmodifiableSet(this.wizardIdToProjectTemplateIdsMap.get(wizardId)));
        }
        for (String wizardId : this.wizardIdToTemplateCategoryMap.keySet()) {
            this.wizardIdToTemplateCategoryMap.put(wizardId, Collections.unmodifiableMap(this.wizardIdToTemplateCategoryMap.get(wizardId)));
        }
        for (String templateId : this.projectTemplateIdToCoreFacetSetIdsMap.keySet()) {
            this.projectTemplateIdToCoreFacetSetIdsMap.put(templateId, Collections.unmodifiableSet(this.projectTemplateIdToCoreFacetSetIdsMap.get(templateId)));
        }
        this.wizardIdToConfigurationDelegateIdsMap = Collections.unmodifiableMap(this.wizardIdToConfigurationDelegateIdsMap);
        this.wizardIdToCoreFacetSetIdsMap = Collections.unmodifiableMap(this.wizardIdToCoreFacetSetIdsMap);
        this.wizardIdToProjectTemplateIdsMap = Collections.unmodifiableMap(this.wizardIdToProjectTemplateIdsMap);
        this.wizardIdToTemplateCategoryMap = Collections.unmodifiableMap(this.wizardIdToTemplateCategoryMap);
        this.projectTemplateIdToCoreFacetSetIdsMap = Collections.unmodifiableMap(this.projectTemplateIdToCoreFacetSetIdsMap);
        for (String projectTemplateId : this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate.keySet()) {
            this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate.put(projectTemplateId, Collections.unmodifiableMap(this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate.get(projectTemplateId)));
        }
        this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate = Collections.unmodifiableMap(this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate);
    }

    private boolean getBoolean(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    IConfigurationDelegate getConfigurationById(String id) {
        return this.idToConfigurationDelegateMap.get(id);
    }

    Set<String> getConfigurationIdsForWizard(String wizardId) {
        return this.wizardIdToConfigurationDelegateIdsMap.get(wizardId);
    }

    ICoreFacetSet getCoreFacetSetById(String id) {
        return this.idToCoreFacetSetMap.get(id);
    }

    Set<String> getCoreFacetSetIdsForProjectTemplateId(String projectTemplateId) {
        return this.projectTemplateIdToCoreFacetSetIdsMap.get(projectTemplateId);
    }

    Set<String> getCoreFacetSetIdsForWizard(String wizardId) {
        return this.wizardIdToCoreFacetSetIdsMap.get(wizardId);
    }

    String getDefaultConfiguration(String projectTemplateId, String coreFacetSetId) {
        Map<String, String> templateSpecificMap = this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate.get(projectTemplateId);
        if (templateSpecificMap != null) {
            return templateSpecificMap.get(coreFacetSetId);
        }
        return null;
    }

    private String getElementName(ExtensionPointObjectType type) {
        String result = null;
        switch (type) {
            case CUSTOM_CONFIGURATION: {
                result = "customConfiguration";
                break;
            }
            case WIZARD_PAGE_CONFIGURATION: {
                result = "wizardPageConfiguration";
                break;
            }
            case PROJECT_TEMPLATE: {
                result = "projectTemplate";
                break;
            }
            case CORE_FACET_SET: {
                result = "coreFacetSet";
            }
        }
        return result;
    }

    private String getExtensionPointId(ExtensionPointObjectType type) {
        String result = null;
        switch (type) {
            case CUSTOM_CONFIGURATION: 
            case WIZARD_PAGE_CONFIGURATION: {
                result = "com.ibm.adapter.j2c.codegen.configurationDelegate";
                break;
            }
            case PROJECT_TEMPLATE: {
                result = "com.ibm.adapter.j2c.codegen.projectTemplate";
                break;
            }
            case CORE_FACET_SET: {
                result = "com.ibm.adapter.j2c.codegen.coreFacetSet";
            }
        }
        return result;
    }

    private Map getObjectIdToObjectMap(ExtensionPointObjectType type) {
        Map<String, IProjectWizardContribution> result = null;
        switch (type) {
            case CUSTOM_CONFIGURATION: 
            case WIZARD_PAGE_CONFIGURATION: {
                result = this.idToConfigurationDelegateMap;
                break;
            }
            case PROJECT_TEMPLATE: {
                result = this.idToProjectTemplateMap;
                break;
            }
            case CORE_FACET_SET: {
                result = this.idToCoreFacetSetMap;
            }
        }
        return result;
    }

    IProjectTemplate getProjectTemplateById(String id) {
        return this.idToProjectTemplateMap.get(id);
    }

    Set<String> getProjectTemplateIdsForWizard(String wizardId) {
        return this.wizardIdToProjectTemplateIdsMap.get(wizardId);
    }

    Map<String, ITemplateCategory> getTemplateCategoryIdMapForWizard(String wizardId) {
        return this.wizardIdToTemplateCategoryMap.containsKey(wizardId) ? this.wizardIdToTemplateCategoryMap.get(wizardId) : this.wizardIdToTemplateCategoryMap.get(NULL_CATEGORY_WIZARD_ID);
    }

    private Map<String, Set<String>> getWizardToObjectsMap(ExtensionPointObjectType type) {
        Map<String, Set<String>> result = null;
        switch (type) {
            case CUSTOM_CONFIGURATION: 
            case WIZARD_PAGE_CONFIGURATION: {
                result = this.wizardIdToConfigurationDelegateIdsMap;
                break;
            }
            case PROJECT_TEMPLATE: {
                result = this.wizardIdToProjectTemplateIdsMap;
                break;
            }
            case CORE_FACET_SET: {
                result = this.wizardIdToCoreFacetSetIdsMap;
            }
        }
        return result;
    }

    private void init() {
        this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, "Initializing Global Extension Point Manager");
        this.idToConfigurationDelegateMap = new HashMap<String, IConfigurationDelegate>();
        this.idToCoreFacetSetMap = new HashMap<String, ICoreFacetSet>();
        this.idToProjectTemplateMap = new HashMap<String, IProjectTemplate>();
        this.projectNameValidators = new ArrayList<PropertyValidatorDescriptor>();
        this.initWizardExtension(ExtensionPointObjectType.CUSTOM_CONFIGURATION);
        this.initWizardExtension(ExtensionPointObjectType.WIZARD_PAGE_CONFIGURATION);
        this.initWizardExtension(ExtensionPointObjectType.CORE_FACET_SET);
        this.initWizardExtension(ExtensionPointObjectType.PROJECT_TEMPLATE);
        this.idToCoreFacetSetMap.put(ICoreFacetSet.EMPTY_CORE_FACETS_ID, new ICoreFacetSet(){

            @Override
            public String getContributingPluginId() {
                return "com.ibm.adapter.j2c.codegen";
            }

            @Override
            public String getDescription() {
                return ICoreFacetSet.EMPTY_CORE_FACETS_ID;
            }

            @Override
            public String getExtensionPointId() {
                return "com.ibm.adapter.j2c.codegen.coreFacetSet";
            }

            @Override
            public Set<IFacetRange> getFacets() {
                return new HashSet<IFacetRange>();
            }

            @Override
            public String getId() {
                return ICoreFacetSet.EMPTY_CORE_FACETS_ID;
            }

            public String toString() {
                return this.getDescription();
            }
        });
        IExtension[] wizardAssociationExtensions = ExtensionPointUtil.getExtensions("com.ibm.adapter.j2c.codegen.wizardAssociation");
        this.wizardIdToConfigurationDelegateIdsMap = new HashMap<String, Set<String>>();
        this.wizardIdToCoreFacetSetIdsMap = new HashMap<String, Set<String>>();
        this.wizardIdToProjectTemplateIdsMap = new HashMap<String, Set<String>>();
        this.initializeWizardAssociations(wizardAssociationExtensions);
        this.projectTemplateIdToCoreFacetSetIdsMap = new HashMap<String, Set<String>>();
        this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate = new HashMap<String, Map<String, String>>();
        this.initializeTemplateToCoreFacetSetAssociation();
        this.pruneInvalidProjectTemplates();
        this.pruneInvalidCoreFacetSets();
        this.pruneInvalidConfigurations();
        this.wizardIdToTemplateCategoryMap = new HashMap<String, Map<String, ITemplateCategory>>();
        this.initializeTemplateCategories();
        this.freezeDataStructures();
    }

    private void initializeTemplateCategories() {
        IExtension[] wizardAssociationExtensions = ExtensionPointUtil.getExtensions("com.ibm.adapter.j2c.codegen.wizardAssociation");
        if (wizardAssociationExtensions != null) {
            int n;
            String wizardId;
            IConfigurationElement wizardAssociationElement;
            int n2;
            int n3;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] wizardAssociationElements;
            IExtension wizardAssociationExtension;
            IExtension[] iExtensionArray = wizardAssociationExtensions;
            int n4 = wizardAssociationExtensions.length;
            int n5 = 0;
            while (n5 < n4) {
                wizardAssociationExtension = iExtensionArray[n5];
                this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, "Initializing template categories. Extension: " + wizardAssociationExtension.getSimpleIdentifier());
                iConfigurationElementArray = wizardAssociationElements = wizardAssociationExtension.getConfigurationElements();
                n3 = wizardAssociationElements.length;
                n2 = 0;
                while (n2 < n3) {
                    IConfigurationElement[] templateCategoryElements;
                    wizardAssociationElement = iConfigurationElementArray[n2];
                    if ("wizardAssociation".equals(wizardAssociationElement.getName()) && (wizardId = wizardAssociationElement.getAttribute("wizardId")) != null && !wizardId.isEmpty() && (templateCategoryElements = wizardAssociationElement.getChildren("templateCategory")) != null && templateCategoryElements.length > 0) {
                        Map<String, ITemplateCategory> wizardTemplateCategoriesIdToObjectMap = this.wizardIdToTemplateCategoryMap.get(wizardId);
                        if (wizardTemplateCategoriesIdToObjectMap == null) {
                            wizardTemplateCategoriesIdToObjectMap = new HashMap<String, ITemplateCategory>();
                            this.wizardIdToTemplateCategoryMap.put(wizardId, wizardTemplateCategoriesIdToObjectMap);
                        }
                        IConfigurationElement[] iConfigurationElementArray2 = templateCategoryElements;
                        n = templateCategoryElements.length;
                        int n6 = 0;
                        while (n6 < n) {
                            IConfigurationElement templateCategoryElement = iConfigurationElementArray2[n6];
                            TemplateCategoryDefinition templateCategory = new TemplateCategoryDefinition(templateCategoryElement);
                            wizardTemplateCategoriesIdToObjectMap.put(templateCategory.getId(), templateCategory);
                            ++n6;
                        }
                        if (wizardTemplateCategoriesIdToObjectMap.isEmpty()) {
                            this.wizardIdToTemplateCategoryMap.remove(wizardId);
                        }
                    }
                    ++n2;
                }
                ++n5;
            }
            iExtensionArray = wizardAssociationExtensions;
            n4 = wizardAssociationExtensions.length;
            n5 = 0;
            while (n5 < n4) {
                wizardAssociationExtension = iExtensionArray[n5];
                iConfigurationElementArray = wizardAssociationElements = wizardAssociationExtension.getConfigurationElements();
                n3 = wizardAssociationElements.length;
                n2 = 0;
                while (n2 < n3) {
                    IConfigurationElement[] templateCategoryAssociationElements;
                    Set<String> wizardProjectTemplateIds;
                    Map<String, ITemplateCategory> wizardTemplateCategoriesIdToObjectMap;
                    wizardAssociationElement = iConfigurationElementArray[n2];
                    if ("wizardAssociation".equals(wizardAssociationElement.getName()) && (wizardId = wizardAssociationElement.getAttribute("wizardId")) != null && !wizardId.isEmpty() && (wizardTemplateCategoriesIdToObjectMap = this.wizardIdToTemplateCategoryMap.get(wizardId)) != null && !wizardTemplateCategoriesIdToObjectMap.isEmpty() && (wizardProjectTemplateIds = this.wizardIdToProjectTemplateIdsMap.get(wizardId)) != null && !wizardProjectTemplateIds.isEmpty() && (templateCategoryAssociationElements = wizardAssociationElement.getChildren("templateCategoryAssociation")) != null) {
                        IConfigurationElement[] iConfigurationElementArray3 = templateCategoryAssociationElements;
                        int n7 = templateCategoryAssociationElements.length;
                        n = 0;
                        while (n < n7) {
                            ITemplateCategory templateCategory;
                            Set<String> existingTemplates;
                            String templateId;
                            IConfigurationElement templateCategoryAssociationElement = iConfigurationElementArray3[n];
                            String categoryId = templateCategoryAssociationElement.getAttribute("templateCategoryId");
                            if (categoryId != null && !categoryId.isEmpty() && wizardTemplateCategoriesIdToObjectMap.containsKey(categoryId) && (templateId = templateCategoryAssociationElement.getAttribute("projectTemplateId")) != null && !templateId.isEmpty() && wizardProjectTemplateIds.contains(templateId) && !(existingTemplates = (templateCategory = wizardTemplateCategoriesIdToObjectMap.get(categoryId)).getProjectTemplates()).contains(templateId)) {
                                existingTemplates.add(templateId);
                            }
                            ++n;
                        }
                    }
                    ++n2;
                }
                ++n5;
            }
            HashSet<String> wizardIdOfEmptyCategorySets = new HashSet<String>();
            for (Map.Entry<String, Map<String, ITemplateCategory>> wizardIdCategoryEntry : this.wizardIdToTemplateCategoryMap.entrySet()) {
                Map<String, ITemplateCategory> categoryIdSet = wizardIdCategoryEntry.getValue();
                HashSet<String> invalidIds = new HashSet<String>();
                for (Map.Entry<String, ITemplateCategory> categoryEntry : categoryIdSet.entrySet()) {
                    TemplateCategoryDefinition templateCategoryDefinition = (TemplateCategoryDefinition)categoryEntry.getValue();
                    if (!templateCategoryDefinition.isValid()) {
                        invalidIds.add(categoryEntry.getKey());
                        continue;
                    }
                    templateCategoryDefinition.freezeDataStructures();
                }
                for (String id : invalidIds) {
                    categoryIdSet.remove(id);
                    if (!categoryIdSet.isEmpty()) continue;
                    wizardIdOfEmptyCategorySets.add(wizardIdCategoryEntry.getKey());
                }
            }
            for (String wizardId2 : wizardIdOfEmptyCategorySets) {
                this.wizardIdToTemplateCategoryMap.remove(wizardId2);
            }
        }
    }

    private void initializeTemplateToCoreFacetSetAssociation() {
        IExtension[] templateAssociationExtensions = ExtensionPointUtil.getExtensions("com.ibm.adapter.j2c.codegen.templateAssociation");
        if (templateAssociationExtensions != null) {
            IExtension[] iExtensionArray = templateAssociationExtensions;
            int n = templateAssociationExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension templateAssociationExtension = iExtensionArray[n2];
                this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, "Initialize template to Core Facet Set Association. Extension: " + templateAssociationExtension.getSimpleIdentifier());
                IConfigurationElement[] templateAssociationElements = templateAssociationExtension.getConfigurationElements();
                if (templateAssociationElements != null) {
                    IConfigurationElement[] iConfigurationElementArray = templateAssociationElements;
                    int n3 = templateAssociationElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement[] templateProgrammingModelElements;
                        String templateId;
                        IConfigurationElement templateAssociationElement = iConfigurationElementArray[n4];
                        if ("templateAssociation".equals(templateAssociationElement.getName()) && (templateId = templateAssociationElement.getAttribute("projectTemplateId")) != null && !templateId.isEmpty() && this.idToProjectTemplateMap.containsKey(templateId) && (templateProgrammingModelElements = templateAssociationElement.getChildren("coreFacetSet")) != null) {
                            Set<String> templateProgrammingModelIds = this.projectTemplateIdToCoreFacetSetIdsMap.get(templateId);
                            if (templateProgrammingModelIds == null) {
                                templateProgrammingModelIds = new HashSet<String>();
                                this.projectTemplateIdToCoreFacetSetIdsMap.put(templateId, templateProgrammingModelIds);
                            }
                            IConfigurationElement[] iConfigurationElementArray2 = templateProgrammingModelElements;
                            int n5 = templateProgrammingModelElements.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement templateProgrammingModelElement = iConfigurationElementArray2[n6];
                                String programmingModelId = templateProgrammingModelElement.getAttribute("id");
                                String programmingModelLevelDefaultConfiguration = templateAssociationElement.getAttribute("defaultConfiguration");
                                String string = programmingModelLevelDefaultConfiguration = programmingModelLevelDefaultConfiguration != null && programmingModelLevelDefaultConfiguration.isEmpty() ? null : programmingModelLevelDefaultConfiguration;
                                if (programmingModelId != null && !programmingModelId.isEmpty() && this.idToCoreFacetSetMap.containsKey(programmingModelId)) {
                                    templateProgrammingModelIds.add(programmingModelId);
                                    if (programmingModelLevelDefaultConfiguration != null) {
                                        Map<String, String> coreFacetToConfigurationMap = this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate.get(templateId);
                                        if (coreFacetToConfigurationMap == null) {
                                            coreFacetToConfigurationMap = new HashMap<String, String>();
                                            this.projectTemplateToCoreFacetSetSpecificDefaultConfigurationDelegate.put(templateId, coreFacetToConfigurationMap);
                                        }
                                        coreFacetToConfigurationMap.put(programmingModelId, programmingModelLevelDefaultConfiguration);
                                    }
                                }
                                ++n6;
                            }
                            if (templateProgrammingModelIds.isEmpty()) {
                                this.projectTemplateIdToCoreFacetSetIdsMap.remove(templateId);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        for (IProjectTemplate ipt : this.idToProjectTemplateMap.values()) {
            ProjectTemplateDefinition pt = (ProjectTemplateDefinition)ipt;
            Set<String> projectTemplateProgrammingModels = this.projectTemplateIdToCoreFacetSetIdsMap.get(ipt.getId());
            if (projectTemplateProgrammingModels == null || projectTemplateProgrammingModels.isEmpty()) {
                projectTemplateProgrammingModels = new HashSet<String>();
                projectTemplateProgrammingModels.add(ICoreFacetSet.EMPTY_CORE_FACETS_ID);
                this.projectTemplateIdToCoreFacetSetIdsMap.put(ipt.getId(), projectTemplateProgrammingModels);
            }
            pt.initializeFacetPresets();
        }
    }

    private void initializeWizardAssociations(IExtension[] wizardAssociationExtensions) {
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        String wizardId;
        IConfigurationElement wizardAssociationElement;
        int n3;
        int n4;
        IConfigurationElement[] iConfigurationElementArray2;
        IConfigurationElement[] wizardAssociationElements;
        IExtension wizardAssociationExtension;
        IExtension[] iExtensionArray = wizardAssociationExtensions;
        int n5 = wizardAssociationExtensions.length;
        int n6 = 0;
        while (n6 < n5) {
            wizardAssociationExtension = iExtensionArray[n6];
            this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, "Initializing Wizard Associations. Extension: " + wizardAssociationExtension.getSimpleIdentifier());
            iConfigurationElementArray2 = wizardAssociationElements = wizardAssociationExtension.getConfigurationElements();
            n4 = wizardAssociationElements.length;
            n3 = 0;
            while (n3 < n4) {
                wizardAssociationElement = iConfigurationElementArray2[n3];
                if ("wizardAssociation".equals(wizardAssociationElement.getName()) && (wizardId = wizardAssociationElement.getAttribute("wizardId")) != null && !wizardId.isEmpty()) {
                    IConfigurationElement[] nameValidators;
                    this.initWizardAssociations(wizardId, wizardAssociationElement, ExtensionPointObjectType.CUSTOM_CONFIGURATION);
                    this.initWizardAssociations(wizardId, wizardAssociationElement, ExtensionPointObjectType.WIZARD_PAGE_CONFIGURATION);
                    this.initWizardAssociations(wizardId, wizardAssociationElement, ExtensionPointObjectType.PROJECT_TEMPLATE);
                    this.initWizardAssociations(wizardId, wizardAssociationElement, ExtensionPointObjectType.CORE_FACET_SET);
                    iConfigurationElementArray = nameValidators = wizardAssociationElement.getChildren("projectNameValidator");
                    n2 = nameValidators.length;
                    n = 0;
                    while (n < n2) {
                        IConfigurationElement currentElement = iConfigurationElementArray[n];
                        this.projectNameValidators.add(new PropertyValidatorDescriptor(currentElement, wizardId));
                        ++n;
                    }
                }
                ++n3;
            }
            ++n6;
        }
        iExtensionArray = wizardAssociationExtensions;
        n5 = wizardAssociationExtensions.length;
        n6 = 0;
        while (n6 < n5) {
            wizardAssociationExtension = iExtensionArray[n6];
            iConfigurationElementArray2 = wizardAssociationElements = wizardAssociationExtension.getConfigurationElements();
            n4 = wizardAssociationElements.length;
            n3 = 0;
            while (n3 < n4) {
                IConfigurationElement[] otherWizardContentElements;
                wizardAssociationElement = iConfigurationElementArray2[n3];
                if ("wizardAssociation".equals(wizardAssociationElement.getName()) && (wizardId = wizardAssociationElement.getAttribute("wizardId")) != null && !wizardId.isEmpty() && (otherWizardContentElements = wizardAssociationElement.getChildren("otherWizardContent")) != null && otherWizardContentElements.length > 0) {
                    iConfigurationElementArray = otherWizardContentElements;
                    n2 = otherWizardContentElements.length;
                    n = 0;
                    while (n < n2) {
                        IConfigurationElement otherWizardContentElement = iConfigurationElementArray[n];
                        String otherWizardId = otherWizardContentElement.getAttribute("otherWizardId");
                        if (otherWizardId != null && !otherWizardId.isEmpty()) {
                            if (this.getBoolean(otherWizardContentElement.getAttribute("reuseCoreFacetSets"))) {
                                this.borrowWizardAssociations(wizardId, otherWizardId, wizardAssociationElement, ExtensionPointObjectType.CORE_FACET_SET);
                            }
                            if (this.getBoolean(otherWizardContentElement.getAttribute("reuseProjectTemplates"))) {
                                this.borrowWizardAssociations(wizardId, otherWizardId, wizardAssociationElement, ExtensionPointObjectType.PROJECT_TEMPLATE);
                            }
                            if (this.getBoolean(otherWizardContentElement.getAttribute("reuseConfigurationDelegates"))) {
                                this.borrowWizardAssociations(wizardId, otherWizardId, wizardAssociationElement, ExtensionPointObjectType.CUSTOM_CONFIGURATION);
                            }
                        }
                        ++n;
                    }
                }
                ++n3;
            }
            ++n6;
        }
    }

    private void initWizardAssociations(String wizardId, IConfigurationElement wizardAssociationElement, ExtensionPointObjectType type) {
        this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, "Associating the element " + wizardAssociationElement.getName() + " to the wizard: " + wizardId + ". Extension type: " + type.toString());
        IConfigurationElement[] childElements = wizardAssociationElement.getChildren(this.getElementName(type));
        if (childElements != null && childElements.length > 0) {
            Map<String, Set<String>> wizardObjectMap = this.getWizardToObjectsMap(type);
            Set<String> wizardObjectSet = wizardObjectMap.get(wizardId);
            if (wizardObjectSet == null) {
                wizardObjectSet = new HashSet<String>();
                wizardObjectMap.put(wizardId, wizardObjectSet);
            }
            IConfigurationElement[] iConfigurationElementArray = childElements;
            int n = childElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement childElement = iConfigurationElementArray[n2];
                String id = childElement.getAttribute("id");
                if (id != null && !id.isEmpty() && this.getObjectIdToObjectMap(type).containsKey(id)) {
                    wizardObjectSet.add(id);
                }
                ++n2;
            }
            if (wizardObjectSet.isEmpty()) {
                wizardObjectMap.remove(wizardId);
            }
        }
    }

    private void initWizardExtension(ExtensionPointObjectType type) {
        this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, "Initializing wizard extensions for the Extension Point Object Type: " + type.toString());
        IExtension[] extensions = ExtensionPointUtil.getExtensions(this.getExtensionPointId(type));
        Map idToObjectMap = this.getObjectIdToObjectMap(type);
        if (extensions != null && extensions.length > 0) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, "Initializing Wizard Extensions. Extension: " + extension.getSimpleIdentifier());
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                if (configElements != null && configElements.length > 0) {
                    IConfigurationElement[] iConfigurationElementArray = configElements;
                    int n3 = configElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object;
                        String id;
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        String elementName = this.getElementName(type);
                        if (elementName != null && elementName.equals(element.getName()) && (id = element.getAttribute("id")) != null && !id.isEmpty() && (object = idToObjectMap.get(id)) == null) {
                            object = this.createNewExtensionPointObject(type, element);
                            idToObjectMap.put(id, object);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    boolean isFacetInProjectTemplateCoreFacetSet(String templateId, FacetRangeDefinition facet) {
        Set<String> allTemplateModelIds;
        if (this.projectTemplateIdToCoreFacetSetIdsMap != null && (allTemplateModelIds = this.projectTemplateIdToCoreFacetSetIdsMap.get(templateId)) != null) {
            for (String programmingModelId : allTemplateModelIds) {
                ICoreFacetSet programmingModel = this.idToCoreFacetSetMap.get(programmingModelId);
                if (programmingModel == null) continue;
                Set<IFacetRange> modelFacets = programmingModel.getFacets();
                for (IFacetRange modelFacet : modelFacets) {
                    if (!modelFacet.getId().equals(facet.getId())) continue;
                    this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, String.valueOf(facet.getId()) + " facet is in " + templateId + " project template");
                    return true;
                }
            }
        }
        this.tracer.trace(Tracer.TraceType.GLOBAL_EXTENSION_POINT, String.valueOf(facet.getId()) + " facet is not in " + templateId + " project template");
        return false;
    }

    private void pruneInvalidConfigurations() {
        HashSet<String> invalidIds = new HashSet<String>();
        for (IConfigurationDelegate cdi : this.idToConfigurationDelegateMap.values()) {
            ConfigurationDelegateDefinition cd = (ConfigurationDelegateDefinition)cdi;
            if (cd.isValid()) continue;
            invalidIds.add(cd.getId());
        }
        for (String id : invalidIds) {
            this.idToConfigurationDelegateMap.remove(id);
            HashSet<String> emptyWizardSets = new HashSet<String>();
            for (String wizardId : this.wizardIdToConfigurationDelegateIdsMap.keySet()) {
                Set<String> ids = this.wizardIdToConfigurationDelegateIdsMap.get(wizardId);
                ids.remove(id);
                if (!ids.isEmpty()) continue;
                emptyWizardSets.add(wizardId);
            }
            for (String wizardId : emptyWizardSets) {
                this.wizardIdToConfigurationDelegateIdsMap.remove(wizardId);
            }
        }
    }

    private void pruneInvalidCoreFacetSets() {
        HashSet<String> invalidIds = new HashSet<String>();
        for (ICoreFacetSet pmi : this.idToCoreFacetSetMap.values()) {
            CoreFacetSetDefinition pm;
            if (ICoreFacetSet.EMPTY_CORE_FACETS_ID.equals(pmi.getId()) || (pm = (CoreFacetSetDefinition)pmi).isValid() && pm.areAllFacetsDefined()) continue;
            invalidIds.add(pm.getId());
        }
        for (String id : invalidIds) {
            Set<String> ids;
            this.idToCoreFacetSetMap.remove(id);
            HashSet<String> emptyWizardSets = new HashSet<String>();
            for (String wizardId : this.wizardIdToCoreFacetSetIdsMap.keySet()) {
                ids = this.wizardIdToCoreFacetSetIdsMap.get(wizardId);
                ids.remove(id);
                if (!ids.isEmpty()) continue;
                emptyWizardSets.add(wizardId);
            }
            for (String wizardId : emptyWizardSets) {
                this.wizardIdToCoreFacetSetIdsMap.remove(wizardId);
            }
            emptyWizardSets = new HashSet();
            for (String templateId : this.projectTemplateIdToCoreFacetSetIdsMap.keySet()) {
                ids = this.projectTemplateIdToCoreFacetSetIdsMap.get(templateId);
                ids.remove(id);
                if (!ids.isEmpty()) continue;
                emptyWizardSets.add(templateId);
            }
            for (String templateId : emptyWizardSets) {
                this.projectTemplateIdToCoreFacetSetIdsMap.remove(templateId);
            }
        }
    }

    private void pruneInvalidProjectTemplates() {
        HashSet<String> invalidIds = new HashSet<String>();
        for (IProjectTemplate pti : this.idToProjectTemplateMap.values()) {
            ProjectTemplateDefinition pt = (ProjectTemplateDefinition)pti;
            if (pt.isValid()) continue;
            invalidIds.add(pt.getId());
        }
        for (String id : invalidIds) {
            this.idToProjectTemplateMap.remove(id);
            HashSet<String> emptyWizardSets = new HashSet<String>();
            for (String wizardId : this.wizardIdToProjectTemplateIdsMap.keySet()) {
                Set<String> ids = this.wizardIdToProjectTemplateIdsMap.get(wizardId);
                ids.remove(id);
                if (!ids.isEmpty()) continue;
                emptyWizardSets.add(wizardId);
            }
            for (String wizardId : emptyWizardSets) {
                this.wizardIdToProjectTemplateIdsMap.remove(wizardId);
            }
            this.projectTemplateIdToCoreFacetSetIdsMap.remove(id);
        }
    }

    private static enum ExtensionPointObjectType {
        CORE_FACET_SET,
        CUSTOM_CONFIGURATION,
        PROJECT_TEMPLATE,
        WIZARD_PAGE_CONFIGURATION;

    }
}

