/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.internal.management.extensionpts;

import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.ExtensionPointUtil;
import com.ibm.faceted.project.wizard.core.internal.util.WebProjectFacetUtil;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IFacetRange;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

final class FacetRangeDefinition
implements IFacetRange {
    private static final String ID_ATTRIBUTE = "id";
    private static final String VERSION_RANGE_ATTRIBUTE = "versionRange";
    private static final String DEFAULT_VERSION_ATTRIBUTE = "defaultVersion";
    private String facetId;
    private boolean isValid = true;
    private IProjectFacet projectFacet;
    private Set<IProjectFacetVersion> supportedVersions;
    private IProjectFacetVersion defaultVersion;
    private boolean isDefined;

    FacetRangeDefinition(IConfigurationElement facetConfigurationElement) {
        String facetId = facetConfigurationElement.getAttribute(ID_ATTRIBUTE);
        String versionRange = facetConfigurationElement.getAttribute(VERSION_RANGE_ATTRIBUTE);
        String defaultVersionString = facetConfigurationElement.getAttribute(DEFAULT_VERSION_ATTRIBUTE);
        try {
            this.initFacet(facetId, versionRange, defaultVersionString);
        }
        catch (CoreException e) {
            ExtensionPointUtil.getServiceabilityManager().getLogger().logContributorError("com.ibm.adapter.j2c.codegen.coreFacetSet", facetConfigurationElement, "Invalid facet version range.", (Exception)((Object)e));
            this.isValid = false;
        }
    }

    @Override
    public IProjectFacetVersion getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public String getId() {
        return this.facetId;
    }

    @Override
    public IProjectFacet getProjectFacet() {
        return this.projectFacet;
    }

    @Override
    public Set<IProjectFacetVersion> getSupportedVersions() {
        return this.supportedVersions;
    }

    private void initFacet(String facetId, String versionRange, String defaultVersionString) throws CoreException {
        this.facetId = facetId;
        boolean bl = this.isValid = facetId != null && !facetId.isEmpty();
        if (this.isValid) {
            this.projectFacet = WebProjectFacetUtil.getProjectFacet(facetId);
            this.isValid = this.isDefined = this.projectFacet != null;
            if (this.isValid) {
                this.supportedVersions = versionRange != null && !versionRange.isEmpty() ? this.projectFacet.getVersions(versionRange) : this.projectFacet.getVersions();
                this.supportedVersions = Collections.unmodifiableSet(this.supportedVersions);
                if (defaultVersionString != null && !defaultVersionString.isEmpty()) {
                    this.defaultVersion = this.projectFacet.getVersion(defaultVersionString);
                }
            }
        }
    }

    boolean isDefined() {
        return this.isDefined;
    }

    boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isVersionSupported(IProjectFacetVersion version) {
        return this.supportedVersions.contains(version);
    }

    public String toString() {
        return this.facetId;
    }
}

