/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.internal.management.extensionpts;

import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.FacetRangeDefinition;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IFacetRange;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

final class CoreFacetSetDefinition
implements ICoreFacetSet {
    private final IConfigurationElement configurationElement;
    private boolean isValid = true;
    private Set<IFacetRange> facets;
    private final String id;
    private boolean areAllFacetsDefined = true;
    private final String description;

    CoreFacetSetDefinition(IConfigurationElement element) {
        IConfigurationElement[] presets;
        this.configurationElement = element;
        this.id = this.configurationElement.getAttribute("id");
        if (this.id == null || this.id.isEmpty()) {
            this.isValid = false;
        }
        this.description = this.configurationElement.getAttribute("description");
        if (this.description == null || this.description.isEmpty()) {
            this.isValid = false;
        }
        this.facets = new HashSet<IFacetRange>();
        if (this.isValid && (presets = this.configurationElement.getChildren("presets")) != null) {
            IConfigurationElement[] iConfigurationElementArray = presets;
            int n = presets.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement presetElement = iConfigurationElementArray[n2];
                IConfigurationElement[] facetConfigurationElements = presetElement.getChildren("facet");
                if (facetConfigurationElements != null && facetConfigurationElements.length > 0) {
                    IConfigurationElement[] iConfigurationElementArray2 = facetConfigurationElements;
                    int n3 = facetConfigurationElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement facetConfigurationElement = iConfigurationElementArray2[n4];
                        FacetRangeDefinition facet = new FacetRangeDefinition(facetConfigurationElement);
                        if (facet.isValid()) {
                            this.facets.add(facet);
                        } else {
                            this.isValid = false;
                            if (!facet.isDefined()) {
                                this.areAllFacetsDefined = false;
                            }
                        }
                        ++n4;
                    }
                } else {
                    this.isValid = false;
                }
                ++n2;
            }
        }
        if (this.isValid) {
            this.facets = Collections.unmodifiableSet(this.facets);
        }
    }

    boolean areAllFacetsDefined() {
        return this.areAllFacetsDefined;
    }

    @Override
    public String getContributingPluginId() {
        return this.configurationElement.getNamespaceIdentifier();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getExtensionPointId() {
        return "com.ibm.adapter.j2c.codegen.coreFacetSet";
    }

    @Override
    public Set<IFacetRange> getFacets() {
        return this.facets;
    }

    @Override
    public String getId() {
        return this.id;
    }

    boolean isValid() {
        return this.isValid;
    }

    public String toString() {
        return this.getDescription();
    }
}

