/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import com.ibm.etools.webtools.flatui.TableViewerImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class SnappyTableViewer
extends StructuredViewer {
    public TableViewerImpl fTableViewerImpl;
    public Table fTable;
    public TableEditor fTableEditor;

    public SnappyTableViewer(Composite parent) {
        this(parent, 2818);
    }

    public SnappyTableViewer(Composite parent, int style) {
        this(new Table(parent, style));
    }

    public SnappyTableViewer(Table table) {
        this.fTable = table;
        this.addKeyListener();
        this.hookControl((Control)table);
        this.fTableEditor = new TableEditor(table);
        this.initTableViewerImpl();
    }

    public void add(Object[] elements) {
        Object[] filtered = this.filter(elements);
        int i = 0;
        while (i < filtered.length) {
            Object element = filtered[i];
            int index = this.indexForElement(element);
            this.updateItem((Widget)new TableItem(this.getTable(), 0, index), element);
            ++i;
        }
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    private void addKeyListener() {
        if (this.fTable != null && !this.fTable.isDisposed()) {
            this.fTable.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    TableItem[] selectedItems;
                    if ((e.character == '\r' || e.character == ' ') && (selectedItems = SnappyTableViewer.this.fTable.getSelection()) != null && selectedItems.length == 1) {
                        SnappyTableViewer.this.fTableViewerImpl.setTableItem((Item)selectedItems[0]);
                        SnappyTableViewer.this.fTableViewerImpl.activateFirstCellEditor();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
    }

    public void cancelEditing() {
        this.fTableViewerImpl.cancelEditing();
    }

    public void finishEditing() {
        this.fTableViewerImpl.applyEditorValue();
    }

    protected Widget doFindInputItem(Object element) {
        if (element.equals(this.getRoot())) {
            return this.getTable();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        TableItem[] children = this.fTable.getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            Object data = item.getData();
            if (data != null && data.equals(element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (fullMap) {
                this.associate(element, (Item)item);
            } else {
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IBaseLabelProvider prov = this.getLabelProvider();
            ITableLabelProvider tprov = null;
            ILabelProvider lprov = null;
            if (prov instanceof ITableLabelProvider) {
                tprov = (ITableLabelProvider)prov;
            } else {
                lprov = (ILabelProvider)prov;
            }
            int columnCount = this.fTable.getColumnCount();
            int column = 0;
            while (column < columnCount || column == 0) {
                TableItem ti = item;
                String text = "";
                Image image = null;
                if (tprov != null) {
                    text = tprov.getColumnText(element, column);
                    image = tprov.getColumnImage(element, column);
                } else if (lprov != null && column == 0) {
                    text = lprov.getText(element);
                    image = lprov.getImage(element);
                }
                if (text == null) {
                    text = "";
                }
                ti.setText(column, text);
                if (ti.getImage(column) != image) {
                    ti.setImage(column, image);
                }
                ++column;
            }
        }
    }

    public void editElement(Object element, int column) {
        this.fTableViewerImpl.editElement(element, column);
    }

    public CellEditor[] getCellEditors() {
        return this.fTableViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.fTableViewerImpl.getCellModifier();
    }

    public Object[] getColumnProperties() {
        return this.fTableViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.fTable;
    }

    public Object getElementAt(int index) {
        TableItem i;
        if (index >= 0 && index < this.fTable.getItemCount() && (i = this.fTable.getItem(index)) != null) {
            return i.getData();
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        TableItem[] items = this.fTable.getSelection();
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object e = item.getData();
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    public Table getTable() {
        return this.fTable;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Table tableControl = (Table)control;
        tableControl.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SnappyTableViewer.this.handleSelect(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SnappyTableViewer.this.handleDoubleSelect(e);
            }
        });
        tableControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SnappyTableViewer.this.fTableViewerImpl.handleMouseDown(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
                SnappyTableViewer.this.fTableViewerImpl.handleMouseDoubleClick(e);
            }
        });
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this.fTable.getItemCount();
        }
        int count = this.fTable.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.fTable.getItem(mid).getData();
            int compare = sorter.compare((Viewer)this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.fTable.getItem(mid).getData();
                    compare = sorter.compare((Viewer)this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void initTableViewerImpl() {
        this.fTableViewerImpl = new TableViewerImpl(){

            @Override
            protected Rectangle getBounds(Item item, int columnNumber) {
                return ((TableItem)item).getBounds(columnNumber);
            }

            @Override
            protected int getColumnCount() {
                return SnappyTableViewer.this.getTable().getColumnCount();
            }

            @Override
            protected Item[] getSelection() {
                return SnappyTableViewer.this.getTable().getSelection();
            }

            @Override
            protected void setEditor(Control w, Item item, int columnNumber) {
                SnappyTableViewer.this.fTableEditor.setEditor(w, (TableItem)item, columnNumber);
            }

            @Override
            protected void setSelection(StructuredSelection selection, boolean b) {
                SnappyTableViewer.this.setSelection((ISelection)selection, b);
            }

            @Override
            protected void showSelection() {
                SnappyTableViewer.this.getTable().showSelection();
            }

            @Override
            protected void setLayoutData(CellEditor.LayoutData layoutData) {
                SnappyTableViewer.this.fTableEditor.grabHorizontal = layoutData.grabHorizontal;
                SnappyTableViewer.this.fTableEditor.horizontalAlignment = layoutData.horizontalAlignment;
                SnappyTableViewer.this.fTableEditor.minimumWidth = layoutData.minimumWidth;
            }
        };
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.getControl().setRedraw(false);
        try {
            this.refresh();
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public void insert(Object element, int position) {
        this.fTableViewerImpl.applyEditorValue();
        if (this.getSorter() != null || this.hasFilters()) {
            this.add(element);
            return;
        }
        this.updateItem((Widget)new TableItem(this.fTable, 0, position != -1 ? position : this.fTable.getItemCount()), element);
    }

    protected void internalRefresh(Object element) {
        this.internalRefresh(element, true);
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        this.fTableViewerImpl.applyEditorValue();
        if (element == null || element.equals(this.getRoot())) {
            Object[] children = this.getSortedChildren(this.getRoot());
            TableItem[] items = this.fTable.getItems();
            int min = Math.min(children.length, items.length);
            int i = 0;
            while (i < min) {
                if (children[i] != null && items[i] != null) {
                    if (children[i].equals(items[i].getData())) {
                        if (updateLabels) {
                            this.updateItem((Widget)items[i], children[i]);
                        }
                    } else {
                        this.disassociate((Item)items[i]);
                    }
                }
                ++i;
            }
            if (min < items.length) {
                i = items.length;
                while (--i >= min) {
                    this.disassociate((Item)items[i]);
                }
                this.fTable.remove(min, items.length - 1);
            }
            if (this.fTable.getItemCount() == 0) {
                this.fTable.removeAll();
            }
            i = 0;
            while (i < min) {
                if (items[i].getData() == null) {
                    this.updateItem((Widget)items[i], children[i]);
                }
                ++i;
            }
            i = min;
            while (i < children.length) {
                this.updateItem((Widget)new TableItem(this.fTable, 0, i), children[i]);
                ++i;
            }
        } else {
            Widget w = this.findItem(element);
            if (w != null) {
                this.updateItem(w, element);
            }
        }
    }

    protected final void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(input)) {
                this.setInput(null);
                return;
            }
            ++i;
        }
        int[] indices = new int[elements.length];
        int count = 0;
        int i2 = 0;
        while (i2 < elements.length) {
            Widget w = this.findItem(elements[i2]);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                this.disassociate((Item)item);
                indices[count++] = this.fTable.indexOf(item);
            }
            ++i2;
        }
        if (count < indices.length) {
            int[] nArray = indices;
            indices = new int[count];
            System.arraycopy(nArray, 0, indices, 0, count);
        }
        this.fTable.remove(indices);
        if (this.fTable.getItemCount() == 0) {
            this.fTable.removeAll();
        }
    }

    public boolean isCellEditorActive() {
        return this.fTableViewerImpl.isCellEditorActive();
    }

    public void remove(final Object[] elements) {
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                SnappyTableViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void reveal(Object element) {
        Widget w = this.findItem(element);
        if (w instanceof TableItem) {
            this.getTable().showItem((TableItem)w);
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.fTableViewerImpl.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.fTableViewerImpl.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.fTableViewerImpl.setColumnProperties(columnProperties);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider ? 1 : 0) != 0);
        super.setLabelProvider(labelProvider);
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list == null) {
            this.fTable.deselectAll();
            return;
        }
        int size = list.size();
        TableItem[] items = new TableItem[size];
        TableItem firstItem = null;
        int count = 0;
        int i = 0;
        while (i < size) {
            Object o = list.get(i);
            Widget w = this.findItem(o);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                items[count++] = item;
                if (firstItem == null) {
                    firstItem = item;
                }
            }
            ++i;
        }
        if (count < size) {
            TableItem[] tableItemArray = items;
            items = new TableItem[count];
            System.arraycopy(tableItemArray, 0, items, 0, count);
        }
        this.fTable.setSelection(items);
        if (reveal && firstItem != null) {
            this.fTable.showItem(firstItem);
        }
    }

    public void setSingleClickCellSelect(boolean b) {
        this.fTableViewerImpl.setSingleClickCellSelect(b);
    }

    protected void handleDoubleSelect(SelectionEvent event) {
        super.handleDoubleSelect(event);
    }

    protected void handleSelect(SelectionEvent event) {
        super.handleSelect(event);
    }
}

